/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.rule.builder.ConstraintBuilder;
import org.drools.core.BaseConfiguration;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.kie.api.conf.ConfigurationKey;
import org.kie.api.conf.OptionKey;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.conf.DefaultDialectOption;
import org.kie.internal.builder.conf.DefaultPackageNameOption;
import org.kie.internal.builder.conf.DumpDirOption;
import org.kie.internal.builder.conf.KBuilderSeverityOption;
import org.kie.internal.builder.conf.KnowledgeBuilderOption;
import org.kie.internal.builder.conf.MultiValueKieBuilderOption;
import org.kie.internal.builder.conf.SingleValueKieBuilderOption;
import org.kie.internal.conf.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBuilderConfigurationImpl
extends BaseConfiguration<KnowledgeBuilderOption, SingleValueKieBuilderOption, MultiValueKieBuilderOption>
implements KnowledgeBuilderConfiguration {
    public static final String DEFAULT_PACKAGE = "defaultpkg";
    public static final ConfigurationKey<KnowledgeBuilderConfigurationImpl> KEY = new ConfigurationKey("Base");
    private final Map<String, DialectConfiguration> dialectConfigurations = new HashMap<String, DialectConfiguration>();
    private DefaultDialectOption defaultDialect = DefaultDialectOption.get((String)"java");
    private File dumpDirectory;
    private String defaultPackageName;
    private Map<String, ResultSeverity> severityMap;
    private InternalKieModule.CompilationCache compilationCache = null;
    private static final Logger log = LoggerFactory.getLogger(KnowledgeBuilderConfigurationImpl.class);

    public KnowledgeBuilderConfigurationImpl(CompositeConfiguration<KnowledgeBuilderOption, SingleValueKieBuilderOption, MultiValueKieBuilderOption> compConfig) {
        super(compConfig);
        this.init();
    }

    private void init() {
        this.buildDialectConfigurationMap();
        this.buildDumpDirectory();
        this.buildSeverityMap();
        this.setProperty("drools.defaultPackageName", this.getProperties().getProperty("drools.defaultPackageName", DEFAULT_PACKAGE));
    }

    protected ClassLoader getFunctionFactoryClassLoader() {
        return this.getClassLoader();
    }

    private void buildSeverityMap() {
        this.severityMap = new HashMap<String, ResultSeverity>();
        HashMap temp = new HashMap();
        this.getProperties().mapStartsWith(temp, "drools.kbuilder.severity.", true);
        int index = "drools.kbuilder.severity.".length();
        for (Map.Entry entry : temp.entrySet()) {
            String identifier = ((String)entry.getKey()).trim().substring(index);
            this.severityMap.put(identifier, KBuilderSeverityOption.get((String)identifier, (String)((String)entry.getValue())).getSeverity());
        }
    }

    public boolean setInternalProperty(String name, String value) {
        switch (name) {
            case "drools.dialect.default": {
                this.setDefaultDialect(value);
                break;
            }
            case "drools.dump.dir": {
                this.buildDumpDirectory(value);
                break;
            }
            case "drools.defaultPackageName": {
                this.setDefaultPackageName(value);
                break;
            }
            default: {
                if (name.startsWith("drools.kbuilder.severity.")) {
                    String key = name.substring(name.lastIndexOf(46) + 1);
                    this.severityMap.put(key, KBuilderSeverityOption.get((String)key, (String)value).getSeverity());
                    break;
                }
                return false;
            }
        }
        return true;
    }

    public String getInternalProperty(String name) {
        switch (name) {
            case "drools.dialect.default": {
                return this.getDefaultDialect();
            }
            case "drools.defaultPackageName": {
                return this.getDefaultPackageName();
            }
            case "drools.dump.dir": {
                return this.dumpDirectory != null ? this.dumpDirectory.toString() : null;
            }
        }
        if (name.startsWith("drools.kbuilder.severity.")) {
            String key = name.substring(name.lastIndexOf(46) + 1);
            ResultSeverity severity = this.severityMap.get(key);
            return severity.toString();
        }
        return null;
    }

    private void buildDialectConfigurationMap() {
        DialectConfiguration mvel = ConstraintBuilder.get().createMVELDialectConfiguration(this);
        if (mvel != null) {
            mvel.init(this);
            this.dialectConfigurations.put("mvel", mvel);
        }
        DialectConfiguration java = ConstraintBuilder.get().createJavaDialectConfiguration(this);
        java.init(this);
        this.dialectConfigurations.put("java", java);
        HashMap dialectProperties = new HashMap();
        this.getProperties().mapStartsWith(dialectProperties, "drools.dialect", false);
        this.setDefaultDialect((String)dialectProperties.get("drools.dialect.default"));
    }

    public void addDialect(String dialectName, DialectConfiguration dialectConf) {
        this.dialectConfigurations.put(dialectName, dialectConf);
    }

    public DialectCompiletimeRegistry buildDialectRegistry(ClassLoader rootClassLoader, KnowledgeBuilderConfigurationImpl pkgConf, PackageRegistry pkgRegistry, InternalKnowledgePackage pkg) {
        DialectCompiletimeRegistry registry = new DialectCompiletimeRegistry();
        for (DialectConfiguration conf : this.dialectConfigurations.values()) {
            Dialect dialect = conf.newDialect(rootClassLoader, pkgConf, pkgRegistry, pkg);
            registry.addDialect(dialect.getId(), dialect);
        }
        return registry;
    }

    public String getDefaultDialect() {
        return this.defaultDialect.dialectName();
    }

    public void setDefaultDialect(String defaultDialect) {
        this.defaultDialect = DefaultDialectOption.get((String)defaultDialect);
    }

    public DialectConfiguration getDialectConfiguration(String name) {
        return this.dialectConfigurations.get(name);
    }

    public void setDialectConfiguration(String name, DialectConfiguration configuration) {
        this.dialectConfigurations.put(name, configuration);
    }

    private void buildDumpDirectory() {
        String dumpStr = this.getProperties().getProperty("drools.dump.dir", null);
        this.buildDumpDirectory(dumpStr);
    }

    private void buildDumpDirectory(String dumpStr) {
        if (dumpStr != null) {
            this.setDumpDir(new File(dumpStr));
        }
    }

    public File getDumpDir() {
        return this.dumpDirectory;
    }

    public void setDumpDir(File dumpDir) {
        if (!(dumpDir.isDirectory() && dumpDir.canWrite() && dumpDir.canRead())) {
            throw new RuntimeException("Drools dump directory is not accessible: " + dumpDir.toString());
        }
        this.dumpDirectory = dumpDir;
    }

    public String getDefaultPackageName() {
        return this.defaultPackageName;
    }

    public void setDefaultPackageName(String defaultPackageName) {
        this.defaultPackageName = defaultPackageName;
    }

    public <T extends SingleValueKieBuilderOption> T getOption(OptionKey<T> option) {
        switch (option.name()) {
            case "drools.dialect.default": {
                return (T)this.defaultDialect;
            }
            case "drools.dump.dir": {
                return (T)DumpDirOption.get((File)this.dumpDirectory);
            }
            case "drools.defaultPackageName": {
                return (T)DefaultPackageNameOption.get((String)this.defaultPackageName);
            }
        }
        return (T)((SingleValueKieBuilderOption)this.compConfig.getOption(option));
    }

    public <T extends MultiValueKieBuilderOption> T getOption(OptionKey<T> option, String subKey) {
        switch (option.name()) {
            case "drools.kbuilder.severity.": {
                return (T)KBuilderSeverityOption.get((String)subKey, (ResultSeverity)this.severityMap.get(subKey));
            }
        }
        return (T)((MultiValueKieBuilderOption)this.compConfig.getOption(option, subKey));
    }

    public <T extends MultiValueKieBuilderOption> Set<String> getOptionSubKeys(OptionKey<T> option) {
        switch (option.name()) {
            case "drools.kbuilder.severity.": {
                return this.severityMap.keySet();
            }
        }
        return this.compConfig.getOptionSubKeys(option);
    }

    public <T extends KnowledgeBuilderOption> void setOption(T option) {
        switch (option.propertyName()) {
            case "drools.dialect.default": {
                this.defaultDialect = (DefaultDialectOption)option;
                break;
            }
            case "drools.dump.dir": {
                this.dumpDirectory = ((DumpDirOption)option).getDirectory();
                break;
            }
            case "drools.defaultPackageName": {
                this.setDefaultPackageName(((DefaultPackageNameOption)option).getPackageName());
                break;
            }
            case "drools.kbuilder.severity.": {
                this.severityMap.put(((KBuilderSeverityOption)option).getName(), ((KBuilderSeverityOption)option).getSeverity());
                break;
            }
            default: {
                this.compConfig.setOption(option);
            }
        }
    }

    public InternalKieModule.CompilationCache getCompilationCache() {
        return this.compilationCache;
    }

    public void setCompilationCache(InternalKieModule.CompilationCache cache) {
        this.compilationCache = cache;
    }

    public boolean isPreCompiled() {
        return this.compilationCache != null;
    }
}

