/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class BigDecimalMinAccumulateFunction
extends AbstractAccumulateFunction<MinData> {
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public MinData createContext() {
        return new MinData();
    }

    public void init(MinData data) {
        data.min = null;
    }

    public void accumulate(MinData data, Object value) {
        if (value != null) {
            BigDecimal bdValue = (BigDecimal)value;
            data.min = data.min == null || data.min.compareTo(bdValue) > 0 ? bdValue : data.min;
        }
    }

    public boolean tryReverse(MinData data, Object value) {
        if (value != null) {
            return data.min.compareTo((BigDecimal)value) < 0;
        }
        return true;
    }

    public void reverse(MinData data, Object value) {
    }

    public Object getResult(MinData data) {
        return data.min;
    }

    public boolean supportsReverse() {
        return false;
    }

    public Class<?> getResultType() {
        return BigDecimal.class;
    }

    protected static class MinData
    implements Externalizable {
        public BigDecimal min = null;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.min = (BigDecimal)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.min);
        }

        public String toString() {
            return "min";
        }
    }
}

