/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.base.ObjectType;
import org.drools.base.prototype.PrototypeObjectType;
import org.drools.base.rule.EntryPointId;
import org.drools.base.rule.TypeDeclaration;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.kie.api.prototype.Prototype;
import org.kie.api.prototype.PrototypeEventInstance;
import org.kie.api.prototype.PrototypeFactInstance;

public class PrototypeTypeConf
implements ObjectTypeConf,
Externalizable {
    private static final long serialVersionUID = 510L;
    private transient InternalRuleBase ruleBase;
    private ObjectType objectType;
    private Prototype prototype;
    private ObjectTypeNode concreteObjectTypeNode;
    private ObjectTypeNode[] cache;
    private boolean tmsEnabled;
    EntryPointId entryPoint;

    public PrototypeTypeConf() {
    }

    public PrototypeTypeConf(EntryPointId entryPoint, Prototype prototype, InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.prototype = prototype;
        this.entryPoint = entryPoint;
        this.objectType = new PrototypeObjectType(prototype);
        this.concreteObjectTypeNode = ruleBase.getRete().getObjectTypeNodes(entryPoint).get(this.objectType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ruleBase = (InternalRuleBase)in.readObject();
        this.prototype = (Prototype)in.readObject();
        this.concreteObjectTypeNode = (ObjectTypeNode)in.readObject();
        this.cache = (ObjectTypeNode[])in.readObject();
        this.objectType = (ObjectType)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ruleBase);
        out.writeObject(this.prototype);
        out.writeObject(this.concreteObjectTypeNode);
        out.writeObject(this.cache);
        out.writeObject(this.objectType);
    }

    @Override
    public ObjectTypeNode getConcreteObjectTypeNode() {
        if (this.concreteObjectTypeNode == null) {
            this.concreteObjectTypeNode = this.ruleBase.getRete().getObjectTypeNodes(this.entryPoint).get(this.objectType);
        }
        return this.concreteObjectTypeNode;
    }

    @Override
    public ObjectTypeNode[] getObjectTypeNodes() {
        if (this.cache == null) {
            ObjectTypeNode[] objectTypeNodeArray;
            if (this.concreteObjectTypeNode != null) {
                ObjectTypeNode[] objectTypeNodeArray2 = new ObjectTypeNode[1];
                objectTypeNodeArray = objectTypeNodeArray2;
                objectTypeNodeArray2[0] = this.concreteObjectTypeNode;
            } else {
                objectTypeNodeArray = new ObjectTypeNode[]{};
            }
            this.cache = objectTypeNodeArray;
        }
        return this.cache;
    }

    @Override
    public boolean isAssignableFrom(Object object) {
        return this.prototype.equals(object);
    }

    @Override
    public void resetCache() {
        this.cache = null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isEvent() {
        return false;
    }

    public boolean isTrait() {
        return false;
    }

    @Override
    public TypeDeclaration getTypeDeclaration() {
        return null;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isPrototype() {
        return true;
    }

    @Override
    public boolean isTMSEnabled() {
        return this.tmsEnabled;
    }

    @Override
    public void enableTMS() {
        this.tmsEnabled = true;
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public String getTypeName() {
        return this.prototype.getFullName();
    }

    @Override
    public InternalFactHandle createFactHandle(FactHandleFactory factHandleFactory, long id, Object object, long recency, ReteEvaluator reteEvaluator, WorkingMemoryEntryPoint entryPoint) {
        PrototypeFactInstance fact = (PrototypeFactInstance)object;
        if (fact.isEvent()) {
            PrototypeEventInstance event = (PrototypeEventInstance)fact;
            long timestamp = event.getTimestamp() >= 0L ? event.getTimestamp() : reteEvaluator.getTimerService().getCurrentTime();
            return factHandleFactory.createEventFactHandle(id, object, recency, entryPoint, timestamp, 0L);
        }
        return factHandleFactory.createDefaultFactHandle(id, object, recency, entryPoint);
    }
}

