/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.PriorityQueue;
import org.drools.base.rule.Behavior;
import org.drools.base.time.JobHandle;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PhreakPropagationContextFactory;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.MarshallerReaderContext;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.BehaviorContext;
import org.drools.core.rule.BehaviorRuntime;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.PointInTimeTrigger;
import org.kie.api.runtime.rule.FactHandle;

public class SlidingTimeWindow
implements Externalizable,
BehaviorRuntime {
    protected long size;
    private static final BehaviorJob job = new BehaviorJob();
    protected int nodeId;

    public SlidingTimeWindow() {
        this(0L);
    }

    public SlidingTimeWindow(long size) {
        this.size = size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readLong();
        this.nodeId = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.size);
        out.writeInt(this.nodeId);
    }

    @Override
    public Behavior.BehaviorType getType() {
        return Behavior.BehaviorType.TIME_WINDOW;
    }

    public void setWindowNode(WindowNode windowNode) {
        this.nodeId = windowNode.getId();
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public BehaviorContext createContext() {
        return new SlidingTimeWindowContext();
    }

    @Override
    public boolean assertFact(Object context, FactHandle fact, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        DefaultEventHandle handle = (DefaultEventHandle)fact;
        long currentTime = reteEvaluator.getTimerService().getCurrentTime();
        if (this.isExpired(currentTime, handle)) {
            return false;
        }
        queue.add(handle);
        if (handle.equals(queue.peek())) {
            this.updateNextExpiration(handle, reteEvaluator, queue, this.nodeId);
        }
        return true;
    }

    @Override
    public void retractFact(Object context, FactHandle fact, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        DefaultEventHandle handle = (DefaultEventHandle)fact;
        DefaultEventHandle peekEvent = queue.peek();
        if (peekEvent != null) {
            if (handle.equals(peekEvent)) {
                queue.poll();
                this.updateNextExpiration(queue.peek(), reteEvaluator, queue, this.nodeId);
            } else if (handle.compareTo(peekEvent) >= 0) {
                queue.remove(handle);
            }
        }
        if (queue.isEmpty() && queue.getJobHandle() != null) {
            reteEvaluator.getTimerService().removeJob(queue.getJobHandle());
        }
    }

    @Override
    public void expireFacts(Object context, PropagationContext pctx, ReteEvaluator reteEvaluator) {
        TimerService clock = reteEvaluator.getTimerService();
        long currentTime = clock.getCurrentTime();
        SlidingTimeWindowContext queue = (SlidingTimeWindowContext)context;
        DefaultEventHandle handle = queue.peek();
        while (handle != null && this.isExpired(currentTime, handle)) {
            queue.remove();
            if (handle.isValid()) {
                PropagationContext expiresPctx = PhreakPropagationContextFactory.createPropagationContextForFact(reteEvaluator, handle, PropagationContext.Type.EXPIRATION);
                ObjectTypeNode.doRetractObject(handle, expiresPctx, reteEvaluator);
            }
            handle = queue.peek();
        }
        this.updateNextExpiration(handle, reteEvaluator, queue, this.nodeId);
    }

    protected boolean isExpired(long currentTime, DefaultEventHandle handle) {
        return handle.getStartTimestamp() + this.size <= currentTime;
    }

    protected void updateNextExpiration(InternalFactHandle fact, ReteEvaluator reteEvaluator, BehaviorContext context, int nodeId) {
        TimerService clock = reteEvaluator.getTimerService();
        if (fact != null) {
            long nextTimestamp = ((DefaultEventHandle)fact).getStartTimestamp() + this.getSize();
            if (nextTimestamp < clock.getCurrentTime()) {
                reteEvaluator.addPropagation(new BehaviorExpireWMAction(nodeId, this, context));
            } else {
                if (context.getJobHandle() != null) {
                    reteEvaluator.getTimerService().removeJob(context.getJobHandle());
                }
                BehaviorJobContext jobctx = new BehaviorJobContext(nodeId, reteEvaluator, this, context);
                JobHandle handle = clock.scheduleJob(job, jobctx, PointInTimeTrigger.createPointInTimeTrigger(nextTimestamp, null));
                jobctx.setJobHandle(handle);
            }
        }
    }

    @Override
    public long getExpirationOffset() {
        return this.size;
    }

    public String toString() {
        return "SlidingTimeWindow( size=" + this.size + " )";
    }

    public static class SlidingTimeWindowContext
    implements BehaviorContext,
    Externalizable {
        private PriorityQueue<DefaultEventHandle> queue = new PriorityQueue(16);
        private JobHandle jobHandle;

        @Override
        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.queue = (PriorityQueue)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.queue);
        }

        public void add(DefaultEventHandle handle) {
            this.queue.add(handle);
        }

        public void remove(DefaultEventHandle handle) {
            this.queue.remove(handle);
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public DefaultEventHandle peek() {
            return this.queue.peek();
        }

        public DefaultEventHandle poll() {
            return this.queue.poll();
        }

        public DefaultEventHandle remove() {
            return (DefaultEventHandle)this.queue.remove();
        }

        @Override
        public Collection<DefaultEventHandle> getFactHandles() {
            return this.queue;
        }
    }

    public static class BehaviorExpireWMAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        protected BehaviorRuntime behavior;
        protected BehaviorContext context;
        protected int nodeId;

        protected BehaviorExpireWMAction() {
        }

        public BehaviorExpireWMAction(int nodeId, BehaviorRuntime behavior, BehaviorContext context) {
            this.nodeId = nodeId;
            this.behavior = behavior;
            this.context = context;
        }

        public BehaviorExpireWMAction(MarshallerReaderContext inCtx) throws IOException {
            this.nodeId = inCtx.readInt();
            WindowNode windowNode = (WindowNode)inCtx.getSinks().get(this.nodeId);
            WindowNode.WindowMemory memory = inCtx.getWorkingMemory().getNodeMemory(windowNode);
            BehaviorContext[] behaviorContext = memory.behaviorContext;
            int i = inCtx.readInt();
            this.behavior = windowNode.getBehaviors()[i];
            this.context = behaviorContext[i];
        }

        @Override
        public void internalExecute(ReteEvaluator reteEvaluator) {
            this.behavior.expireFacts(this.context, null, reteEvaluator);
        }
    }

    public static class BehaviorJobContext
    implements JobContext,
    Externalizable {
        public ReteEvaluator reteEvaluator;
        public int nodeId;
        public BehaviorRuntime behavior;
        public BehaviorContext behaviorContext;

        public BehaviorJobContext(int nodeId, ReteEvaluator reteEvaluator, BehaviorRuntime behavior, BehaviorContext behaviorContext) {
            this.nodeId = nodeId;
            this.reteEvaluator = reteEvaluator;
            this.behavior = behavior;
            this.behaviorContext = behaviorContext;
        }

        public BehaviorJobContext() {
        }

        @Override
        public JobHandle getJobHandle() {
            return this.behaviorContext.getJobHandle();
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.behaviorContext.setJobHandle(jobHandle);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public ReteEvaluator getReteEvaluator() {
            return this.reteEvaluator;
        }
    }

    public static class BehaviorJob
    implements Job {
        @Override
        public void execute(JobContext ctx) {
            BehaviorJobContext context = (BehaviorJobContext)ctx;
            context.reteEvaluator.addPropagation(new BehaviorExpireWMAction(context.nodeId, context.behavior, context.behaviorContext));
        }
    }
}

