/*
 * Decompiled with CFR 0.152.
 */
package org.drools.marshalling.impl;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.marshalling.impl.PersisterKey;

public class Placeholders
extends AbstractHashTable {
    private List<Object> ids = new ArrayList<Object>();

    public PlaceholderEntry lookupPlaceholder(Object object, PersisterKey key) {
        int hashCode = key.hashCode(object);
        int index = Placeholders.indexOf(hashCode, this.table.length);
        for (PlaceholderEntry current = (PlaceholderEntry)this.table[index]; current != null; current = (PlaceholderEntry)current.getNext()) {
            if (hashCode != current.hashCode || current.key != key || !key.equal(object, current.object)) continue;
            return current;
        }
        return null;
    }

    public PlaceholderEntry assignPlaceholder(Object object, PersisterKey key) {
        int hashCode = key.hashCode(object);
        int index = Placeholders.indexOf(hashCode, this.table.length);
        int id = this.ids.size();
        this.ids.add(object);
        PlaceholderEntry entry = new PlaceholderEntry(object, id, key);
        entry.next = this.table[index];
        this.table[index] = entry;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return entry;
    }

    public Object lookupObject(int id) {
        return this.ids.get(id);
    }

    public Entry getBucket(Object object) {
        return null;
    }

    public static class PlaceholderEntry
    implements Entry {
        private static final long serialVersionUID = 510L;
        public Object object;
        public int id;
        public PersisterKey key;
        public int hashCode;
        public Entry next;

        public PlaceholderEntry(Object object, int id, PersisterKey key) {
            this.object = object;
            this.id = id;
            this.key = key;
            this.hashCode = key.hashCode(object);
        }

        public Entry getNext() {
            return this.next;
        }

        public void setNext(Entry next) {
            this.next = next;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "Placeholder( object=" + this.object + " id = " + this.id + " hashcode=" + this.hashCode + " next=" + this.next + " )";
        }

        public Object getObject() {
            return this.object;
        }

        public int getId() {
            return this.id;
        }

        public PersisterKey getKey() {
            return this.key;
        }
    }
}

