/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.FactException;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.EqualityKey;
import org.drools.common.EqualityKeyComparator;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LogicalDependency;
import org.drools.common.WorkingMemoryAction;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.ObjectHashMap;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.PersisterHelper;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;

public class TruthMaintenanceSystem {
    private AbstractWorkingMemory workingMemory;
    private ObjectHashMap justifiedMap;
    private ObjectHashMap assertMap;

    public TruthMaintenanceSystem() {
    }

    public TruthMaintenanceSystem(AbstractWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.justifiedMap = new ObjectHashMap();
        this.assertMap = new ObjectHashMap();
        this.assertMap.setComparator(EqualityKeyComparator.getInstance());
    }

    public ObjectHashMap getJustifiedMap() {
        return this.justifiedMap;
    }

    public ObjectHashMap getAssertMap() {
        return this.assertMap;
    }

    public Object put(EqualityKey key) {
        return this.assertMap.put(key, key, false);
    }

    public EqualityKey get(EqualityKey key) {
        return (EqualityKey)this.assertMap.get(key);
    }

    public EqualityKey get(Object object) {
        return (EqualityKey)this.assertMap.get(object);
    }

    public EqualityKey remove(EqualityKey key) {
        return (EqualityKey)this.assertMap.remove(key);
    }

    public void removeLogicalDependencies(Activation activation, PropagationContext context, Rule rule) throws FactException {
        LinkedList list = activation.getLogicalDependencies();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (LogicalDependency node = (LogicalDependency)list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
            this.removeLogicalDependency(activation, node, context);
        }
    }

    public void removeLogicalDependency(Activation activation, LogicalDependency node, PropagationContext context) {
        InternalFactHandle handle = (InternalFactHandle)node.getJustified();
        LinkedList list = (LinkedList)this.justifiedMap.get(handle.getId());
        if (list != null) {
            list.remove(node.getJustifierEntry());
            LogicalRetractCallback action = new LogicalRetractCallback(this, node, list, handle, context, activation);
            this.workingMemory.queueWorkingMemoryAction(action);
        }
    }

    public void removeLogicalDependencies(InternalFactHandle handle) throws FactException {
        LinkedList list = (LinkedList)this.justifiedMap.remove(handle.getId());
        if (list != null && !list.isEmpty()) {
            for (LinkedListEntry entry = (LinkedListEntry)list.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
                LogicalDependency node = (LogicalDependency)entry.getObject();
                node.getJustifier().getLogicalDependencies().remove(node);
            }
        }
    }

    public void addLogicalDependency(InternalFactHandle handle, Activation activation, PropagationContext context, Rule rule) throws FactException {
        LogicalDependency node = new LogicalDependency(activation, handle);
        activation.getRule().setHasLogicalDependency(true);
        activation.addLogicalDependency(node);
        LinkedList list = (LinkedList)this.justifiedMap.get(handle.getId());
        if (list == null) {
            if (context.getType() == 2) {
                // empty if block
            }
            list = new LinkedList();
            this.justifiedMap.put(handle.getId(), list);
        }
        list.add(node.getJustifierEntry());
    }

    public void clear() {
        this.justifiedMap.clear();
        this.assertMap.clear();
    }

    public static class LogicalRetractCallback
    implements WorkingMemoryAction {
        private TruthMaintenanceSystem tms;
        private LogicalDependency node;
        private LinkedList list;
        private InternalFactHandle handle;
        private PropagationContext context;
        private Activation activation;

        public LogicalRetractCallback() {
        }

        public LogicalRetractCallback(TruthMaintenanceSystem tms, LogicalDependency node, LinkedList list, InternalFactHandle handle, PropagationContext context, Activation activation) {
            this.tms = tms;
            this.node = node;
            this.list = list;
            this.handle = handle;
            this.context = context;
        }

        public LogicalRetractCallback(MarshallerReaderContext context) throws IOException {
            this.tms = context.wm.getTruthMaintenanceSystem();
            this.handle = context.handles.get(context.readInt());
            this.context = context.propagationContexts.get(context.readLong());
            this.activation = (Activation)context.terminalTupleMap.get(context.readInt()).getObject();
            this.list = (LinkedList)this.tms.getJustifiedMap().get(this.handle.getId());
            for (LinkedListEntry entry = (LinkedListEntry)this.list.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
                LogicalDependency node = (LogicalDependency)entry.getObject();
                if (node.getJustifier() != this.activation) continue;
                this.node = node;
                break;
            }
        }

        public LogicalRetractCallback(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            ProtobufMessages.ActionQueue.LogicalRetract _retract = _action.getLogicalRetract();
            this.tms = context.wm.getTruthMaintenanceSystem();
            this.handle = context.handles.get(_retract.getHandleId());
            this.activation = (Activation)context.filter.getTuplesCache().get(PersisterHelper.createActivationKey(_retract.getActivation().getPackageName(), _retract.getActivation().getRuleName(), _retract.getActivation().getTuple())).getObject();
            this.context = this.activation.getPropagationContext();
            this.list = (LinkedList)this.tms.getJustifiedMap().get(this.handle.getId());
            for (LinkedListEntry entry = (LinkedListEntry)this.list.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
                LogicalDependency node = (LogicalDependency)entry.getObject();
                if (node.getJustifier() != this.activation) continue;
                this.node = node;
                break;
            }
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeShort(4);
            context.writeInt(this.handle.getId());
            context.writeLong(this.context.getPropagationNumber());
            context.writeInt(context.terminalTupleMap.get(this.activation.getTuple()));
        }

        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            ProtobufMessages.ActionQueue.LogicalRetract _retract = ProtobufMessages.ActionQueue.LogicalRetract.newBuilder().setHandleId(this.handle.getId()).setActivation(PersisterHelper.createActivation(this.activation.getRule().getPackageName(), this.activation.getRule().getName(), this.activation.getTuple())).build();
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.LOGICAL_RETRACT).setLogicalRetract(_retract).build();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.tms = (TruthMaintenanceSystem)in.readObject();
            this.node = (LogicalDependency)in.readObject();
            this.list = (LinkedList)in.readObject();
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
            this.activation = (Activation)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.tms);
            out.writeObject(this.node);
            out.writeObject(this.list);
            out.writeObject(this.handle);
            out.writeObject(this.context);
            out.writeObject(this.activation);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            if (this.list.isEmpty()) {
                this.tms.getJustifiedMap().remove(this.handle.getId());
                workingMemory.retract(this.handle, false, true, this.context.getRuleOrigin(), this.activation);
            }
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }
}

