/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtils {
    private static Map classes = Collections.synchronizedMap(new HashMap());
    private static final String STAR = "*";

    public static boolean areNullSafeEquals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static String convertResourceToClassName(String pResourceName) {
        return ClassUtils.stripExtension(pResourceName).replace('/', '.');
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }

    public static String stripExtension(String pResourceName) {
        int i = pResourceName.lastIndexOf(46);
        return pResourceName.substring(0, i);
    }

    public static String toJavaCasing(String pName) {
        char[] name = pName.toLowerCase().toCharArray();
        name[0] = Character.toUpperCase(name[0]);
        return new String(name);
    }

    public static String clazzName(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        int p = absFileName.lastIndexOf(46);
        String relFileName = absFileName.substring(rootLength + 1, p);
        return relFileName.replace(File.separatorChar, '.');
    }

    public static String relative(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        return absFileName.substring(rootLength + 1);
    }

    public static String canonicalName(Class clazz) {
        StringBuilder name = new StringBuilder();
        if (clazz.isArray()) {
            name.append(ClassUtils.canonicalName(clazz.getComponentType()));
            name.append("[]");
        } else if (clazz.getDeclaringClass() == null) {
            name.append(clazz.getName());
        } else {
            name.append(ClassUtils.canonicalName(clazz.getDeclaringClass()));
            name.append(".");
            name.append(clazz.getName().substring(clazz.getDeclaringClass().getName().length() + 1));
        }
        return name.toString();
    }

    public static Object instantiateObject(String className) {
        return ClassUtils.instantiateObject(className, null);
    }

    public static Object instantiateObject(String className, ClassLoader classLoader) {
        Object object;
        Class<?> cls = (Class<?>)classes.get(className);
        if (cls == null) {
            try {
                cls = Class.forName(className);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (cls == null && classLoader != null) {
                try {
                    cls = classLoader.loadClass(className);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cls == null) {
                try {
                    cls = ClassUtils.class.getClassLoader().loadClass(className);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cls == null) {
                try {
                    cls = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cls == null) {
                try {
                    cls = ClassLoader.getSystemClassLoader().loadClass(className);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cls != null) {
                classes.put(className, cls);
            } else {
                throw new RuntimeException("Unable to load class '" + className + "'");
            }
        }
        try {
            object = cls.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to instantiate object for class '" + className + "'", e);
        }
        return object;
    }

    public static void addImportStylePatterns(Map<String, Object> patterns, String str) {
        String[] items;
        if (str == null || "".equals(str.trim())) {
            return;
        }
        for (String item : items = str.split(" ")) {
            ArrayList<String> list;
            String qualifiedNamespace = item.substring(0, item.lastIndexOf(46)).trim();
            String name = item.substring(item.lastIndexOf(46) + 1).trim();
            Object object = patterns.get(qualifiedNamespace);
            if (object == null) {
                if (STAR.equals(name)) {
                    patterns.put(qualifiedNamespace, STAR);
                    continue;
                }
                list = new ArrayList<String>();
                list.add(name);
                patterns.put(qualifiedNamespace, list);
                continue;
            }
            if (name.equals(STAR)) {
                patterns.put(qualifiedNamespace, STAR);
                continue;
            }
            list = (ArrayList<String>)object;
            if (list.contains(name)) continue;
            list.add(name);
        }
    }

    public static boolean isMatched(Map<String, Object> patterns, String className) {
        String qualifiedNamespace = className;
        String name = className;
        if (className.indexOf(46) > 0) {
            qualifiedNamespace = className.substring(0, className.lastIndexOf(46)).trim();
            name = className.substring(className.lastIndexOf(46) + 1).trim();
        } else if (className.indexOf(91) == 0) {
            qualifiedNamespace = className.substring(0, className.lastIndexOf(91));
        }
        Object object = patterns.get(qualifiedNamespace);
        if (object == null) {
            return true;
        }
        if (STAR.equals(object)) {
            return false;
        }
        if (patterns.containsKey(STAR)) {
            return true;
        }
        List list = (List)object;
        return !list.contains(name);
    }

    public static String getPackage(Class<?> cls) {
        Package pkg;
        Package package_ = pkg = cls.isArray() ? cls.getComponentType().getPackage() : cls.getPackage();
        if (pkg == null) {
            int dolPos = cls.getName().indexOf(36);
            int dotPos = dolPos > 0 ? cls.getName().substring(0, dolPos).lastIndexOf(46) : cls.getName().lastIndexOf(46);
            if (dotPos > 0) {
                return cls.getName().substring(0, dotPos);
            }
            return "";
        }
        return pkg.getName();
    }

    public static List<String> getSettableProperties(Class<?> clazz) {
        ArrayList<String> settableProperties = new ArrayList<String>();
        for (Method method : clazz.getMethods()) {
            String propName;
            if (method.getParameterTypes().length != 1 || (propName = ClassUtils.setter2property(method.getName())) == null) continue;
            settableProperties.add(propName);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            String fieldName = ((Field)accessibleObject).getName();
            if (settableProperties.contains(fieldName)) continue;
            settableProperties.add(fieldName);
        }
        Collections.sort(settableProperties);
        return settableProperties;
    }

    public static String getter2property(String methodName) {
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        return null;
    }

    public static String setter2property(String methodName) {
        if (!methodName.startsWith("set") || methodName.length() < 4) {
            return null;
        }
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }

    public static <T extends Externalizable> T deepClone(T origin) {
        return origin == null ? null : (T)ClassUtils.deepClone(origin, origin.getClass().getClassLoader());
    }

    public static <T extends Externalizable> T deepClone(T origin, ClassLoader classLoader) {
        if (origin == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream(baos);
            oos.writeObject(origin);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DroolsObjectInputStream ois = new DroolsObjectInputStream(bais, classLoader);
            Object deepCopy = ois.readObject();
            return (T)((Externalizable)deepCopy);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    public static final Class<?> convertFromPrimitiveType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new RuntimeException("Class not convertible from primitive: " + type.getName());
    }

    public static Class<?> convertToPrimitiveType(Class<?> type) {
        if (type.isPrimitive()) {
            return type;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == BigInteger.class) {
            return Long.TYPE;
        }
        if (type == BigDecimal.class) {
            return Double.TYPE;
        }
        if (type == Number.class) {
            return Double.TYPE;
        }
        throw new RuntimeException("Class not convertible to primitive: " + type.getName());
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toUpperCase().contains("WINDOWS");
    }

    public static boolean isOSX() {
        String os = System.getProperty("os.name");
        return os.toUpperCase().contains("MAC OS X");
    }
}

