/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.concurrent.ExternalExecutorService;
import org.drools.reteoo.PartitionTaskManager;

public class PartitionManager {
    private Map<RuleBasePartitionId, PartitionTaskManager> partitionManagers;
    private InternalWorkingMemory workingMemory;
    private AtomicReference<ExternalExecutorService> executorService;
    private PriorityBlockingQueue<PartitionTaskManager.PartitionTask> queue;
    private AtomicBoolean onHold;

    public PartitionManager(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
        this.executorService = new AtomicReference();
        this.partitionManagers = new ConcurrentHashMap<RuleBasePartitionId, PartitionTaskManager>();
        this.queue = new PriorityBlockingQueue();
        this.onHold = new AtomicBoolean(false);
    }

    public void manage(RuleBasePartitionId partitionId) {
        if (!this.partitionManagers.containsKey(partitionId)) {
            this.partitionManagers.put(partitionId, new PartitionTaskManager(this, this.workingMemory));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPool(ExternalExecutorService executorService) {
        AtomicBoolean atomicBoolean = this.onHold;
        synchronized (atomicBoolean) {
            this.executorService.set(executorService);
            while (this.executorService.get() != null && !this.queue.isEmpty()) {
                PartitionTaskManager.PartitionTask task = this.queue.poll();
                this.executorService.get().execute(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PartitionTaskManager.PartitionTask task) {
        AtomicBoolean atomicBoolean = this.onHold;
        synchronized (atomicBoolean) {
            if (task.getPriority() < 10 && this.onHold.get() || this.executorService.get() == null) {
                this.queue.add(task);
            } else {
                this.executorService.get().execute(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void holdTasks() {
        AtomicBoolean atomicBoolean = this.onHold;
        synchronized (atomicBoolean) {
            this.onHold.set(true);
        }
    }

    public void waitForPendingTasks() {
        this.executorService.get().waitUntilEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTasks() {
        AtomicBoolean atomicBoolean = this.onHold;
        synchronized (atomicBoolean) {
            ExecutorService service = this.executorService.get();
            if (service != null) {
                for (PartitionTaskManager.PartitionTask task : this.queue) {
                    service.execute(task);
                }
            }
            this.onHold.set(false);
        }
    }

    public void shutdown() {
        this.setPool(null);
    }

    public PartitionTaskManager getPartitionTaskManager(RuleBasePartitionId partitionId) {
        return this.partitionManagers.get(partitionId);
    }

    public boolean isOnHold() {
        return this.onHold.get();
    }
}

