/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.Behavior;
import org.drools.core.spi.PropagationContext;

public class BehaviorManager
implements Externalizable {
    public static final Behavior[] NO_BEHAVIORS = new Behavior[0];
    private Behavior[] behaviors;

    public BehaviorManager() {
        this(NO_BEHAVIORS);
    }

    public BehaviorManager(List<Behavior> behaviors) {
        this.behaviors = behaviors.toArray(new Behavior[behaviors.size()]);
    }

    public BehaviorManager(Behavior[] behaviors) {
        this.behaviors = behaviors;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.behaviors = (Behavior[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.behaviors);
    }

    public Object createBehaviorContext() {
        Object[] behaviorCtx = new Object[this.behaviors.length];
        for (int i = 0; i < this.behaviors.length; ++i) {
            behaviorCtx[i] = this.behaviors[i].createContext();
        }
        return behaviorCtx;
    }

    public boolean assertFact(Object behaviorContext, InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        boolean result = true;
        for (int i = 0; i < this.behaviors.length; ++i) {
            result = result && this.behaviors[i].assertFact(((Object[])behaviorContext)[i], factHandle, pctx, workingMemory);
        }
        return result;
    }

    public void retractFact(Object behaviorContext, InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        for (int i = 0; i < this.behaviors.length; ++i) {
            this.behaviors[i].retractFact(((Object[])behaviorContext)[i], factHandle, pctx, workingMemory);
        }
    }

    public Behavior[] getBehaviors() {
        return this.behaviors;
    }
}

