/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.base.common.NetworkNode;
import org.drools.core.common.ActivationsManager;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.phreak.PhreakRuleTerminalNode;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleExecutor;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.consequence.InternalMatch;

public class AlphaTerminalNode
extends LeftInputAdapterNode {
    public AlphaTerminalNode() {
    }

    public AlphaTerminalNode(int id, ObjectSource source, BuildContext context) {
        super(id, source, context);
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext propagationContext, ReteEvaluator reteEvaluator) {
        ActivationsManager activationsManager = reteEvaluator.getActivationsManager();
        NetworkNode[] sinks = this.getSinks();
        for (int i = 0; i < sinks.length; ++i) {
            TerminalNode rtn = (TerminalNode)sinks[i];
            RuleAgendaItem agendaItem = AlphaTerminalNode.getRuleAgendaItem(reteEvaluator, activationsManager, rtn, true);
            RuleTerminalNodeLeftTuple leftTuple = (RuleTerminalNodeLeftTuple)rtn.createLeftTuple(factHandle, true);
            leftTuple.setPropagationContext(propagationContext);
            if (rtn.getRule().getAutoFocus() && !agendaItem.getAgendaGroup().isActive()) {
                activationsManager.getAgendaGroupsManager().setFocus(agendaItem.getAgendaGroup());
            }
            PhreakRuleTerminalNode.doLeftTupleInsert(rtn, agendaItem.getRuleExecutor(), activationsManager, agendaItem, leftTuple);
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, ReteEvaluator reteEvaluator) {
        ActivationsManager activationsManager = reteEvaluator.getActivationsManager();
        NetworkNode[] sinks = this.getSinks();
        for (int i = 0; i < sinks.length; ++i) {
            TerminalNode rtn = (TerminalNode)sinks[i];
            ObjectTypeNode.Id otnId = rtn.getLeftInputOtnId();
            LeftTuple leftTuple = this.processDeletesFromModify(modifyPreviousTuples, context, reteEvaluator, otnId);
            RuleAgendaItem agendaItem = AlphaTerminalNode.getRuleAgendaItem(reteEvaluator, activationsManager, rtn, true);
            RuleExecutor executor = agendaItem.getRuleExecutor();
            if (leftTuple != null && leftTuple.getInputOtnId().equals(otnId)) {
                modifyPreviousTuples.removeLeftTuple(this.partitionId);
                leftTuple.reAdd();
                if (!context.getModificationMask().intersects(rtn.getLeftInferredMask())) continue;
                leftTuple.setPropagationContext(context);
                PhreakRuleTerminalNode.doLeftTupleUpdate(rtn, executor, activationsManager, (RuleTerminalNodeLeftTuple)leftTuple);
                if (!(leftTuple instanceof InternalMatch)) continue;
                ((InternalMatch)((Object)leftTuple)).setActive(true);
                continue;
            }
            if (!context.getModificationMask().intersects(rtn.getLeftInferredMask())) continue;
            leftTuple = rtn.createLeftTuple(factHandle, true);
            leftTuple.setPropagationContext(context);
            PhreakRuleTerminalNode.doLeftTupleInsert(rtn, executor, activationsManager, agendaItem, (RuleTerminalNodeLeftTuple)leftTuple);
        }
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, ReteEvaluator reteEvaluator) {
        ActivationsManager activationsManager = reteEvaluator.getActivationsManager();
        leftTuple.setPropagationContext(context);
        TerminalNode rtn = (TerminalNode)leftTuple.getTupleSink();
        PhreakRuleTerminalNode.doLeftDelete(activationsManager, AlphaTerminalNode.getRuleAgendaItem(reteEvaluator, activationsManager, rtn, false).getRuleExecutor(), (RuleTerminalNodeLeftTuple)leftTuple);
    }

    public static RuleAgendaItem getRuleAgendaItem(ReteEvaluator reteEvaluator, ActivationsManager activationsManager, TerminalNode rtn, boolean linkPmem) {
        PathMemory pathMemory = reteEvaluator.getNodeMemory(rtn);
        if (linkPmem) {
            pathMemory.doLinkRule(activationsManager);
        }
        return pathMemory.getRuleAgendaItem();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object.getClass() != AlphaTerminalNode.class || this.hashCode() != object.hashCode()) {
            return false;
        }
        return this.getObjectSource().getId() == ((AlphaTerminalNode)object).getObjectSource().getId() && this.sinkMask.equals(((AlphaTerminalNode)object).sinkMask);
    }

    @Override
    public boolean isTerminal() {
        return true;
    }
}

