/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.DefaultRuleSheetListener;
import org.drools.decisiontable.parser.RuleSheetListener;
import org.drools.decisiontable.parser.xls.ExcelParser;
import org.drools.io.FileSystemResource;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.Package;
import org.drools.template.parser.DataListener;
import org.kie.api.io.Resource;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetCompiler {
    protected static final transient Logger logger = LoggerFactory.getLogger(SpreadsheetCompiler.class);
    private final boolean trimCell;

    public SpreadsheetCompiler() {
        this(true);
    }

    public SpreadsheetCompiler(boolean trimCell) {
        this.trimCell = trimCell;
    }

    public String compile(boolean showPackage, InputStream xlsStream, InputType type) {
        return this.compile(xlsStream, type, (RuleSheetListener)new DefaultRuleSheetListener(showPackage, this.trimCell));
    }

    public String compile(InputStream xlsStream, InputType type) {
        return this.compile(xlsStream, type, (RuleSheetListener)new DefaultRuleSheetListener(true, this.trimCell));
    }

    public String compile(Resource resource, InputType type) {
        return this.compile(resource, type, (RuleSheetListener)new DefaultRuleSheetListener(true, this.trimCell));
    }

    public String compile(InputStream xlsStream, InputType type, RuleSheetListener listener) {
        type.createParser(listener).parseFile(xlsStream);
        return this.listenerToString(listener);
    }

    public String compile(Resource resource, InputType type, RuleSheetListener listener) {
        this.parseResource(type.createParser(listener), resource);
        return this.listenerToString(listener);
    }

    public String listenerToString(RuleSheetListener listener) {
        Package rulePackage = listener.getRuleSet();
        DRLOutput out = new DRLOutput();
        rulePackage.renderDRL(out);
        return out.getDRL();
    }

    private void parseResource(DecisionTableParser parser, Resource resource) {
        if (resource instanceof FileSystemResource) {
            parser.parseFile(((FileSystemResource)resource).getFile());
        } else {
            try {
                parser.parseFile(resource.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compile(String classPathResource, InputType inputType) {
        InputStream stream = this.getClass().getResourceAsStream(classPathResource);
        try {
            String drl;
            String string = drl = this.compile(stream, inputType);
            return string;
        }
        finally {
            this.closeStream(stream);
        }
    }

    public String compile(InputStream stream, String worksheetName) {
        return this.compile(ResourceFactory.newInputStreamResource((InputStream)stream), worksheetName);
    }

    public String compile(Resource resource, String worksheetName) {
        RuleSheetListener listener = this.getRuleSheetListener(resource, worksheetName);
        return this.listenerToString(listener);
    }

    private RuleSheetListener getRuleSheetListener(Resource resource, String worksheetName) {
        DefaultRuleSheetListener listener = new DefaultRuleSheetListener();
        listener.setWorksheetName(worksheetName);
        HashMap<String, List<DataListener>> sheetListeners = new HashMap<String, List<DataListener>>();
        ArrayList<DefaultRuleSheetListener> listeners = new ArrayList<DefaultRuleSheetListener>();
        listeners.add(listener);
        sheetListeners.put(worksheetName, listeners);
        this.parseResource(new ExcelParser(sheetListeners), resource);
        return listener;
    }

    private void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            logger.warn("WARNING: Wasn't able to correctly close stream for decision table. " + e.getMessage());
        }
    }
}

