/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.parser.antlr4;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import org.antlr.v4.runtime.FailedPredicateException;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.drools.drl.parser.DRLFactory;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.lang.DroolsParaphraseTypes;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class DroolsParserExceptionFactory {
    public static final String TRAILING_SEMI_COLON_NOT_ALLOWED_MESSAGE = "Line %1$d:%2$d trailing semi-colon not allowed%3$s";
    public static final String PARSER_LOCATION_MESSAGE_COMPLETE = " in %1$s %2$s";
    public static final String PARSER_LOCATION_MESSAGE_PART = " in %1$s";
    public static final String UNEXPECTED_EXCEPTION = "Line %1$d:%2$d unexpected exception at input '%3$s'. Exception: %4$s. Stack trace:\n %5$s";
    private final Collection<Map<DroolsParaphraseTypes, String>> paraphrases;
    private String[] tokenNames = null;
    private final LanguageLevelOption languageLevel;

    public DroolsParserExceptionFactory(Collection<Map<DroolsParaphraseTypes, String>> paraphrases, LanguageLevelOption languageLevel) {
        this.paraphrases = paraphrases;
        this.languageLevel = languageLevel;
    }

    public DroolsParserException createTrailingSemicolonException(int line, int column, int offset) {
        String message = String.format(TRAILING_SEMI_COLON_NOT_ALLOWED_MESSAGE, line, column, this.formatParserLocation());
        return new DroolsParserException("ERR 104", message, line, column, offset, null);
    }

    public DroolsParserException createDroolsException(Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
        return new DroolsParserException(this.determineErrorCode(e), String.format("Line %d:%d %s", line, charPositionInLine, message), line, charPositionInLine, this.determineStartingIndex(offendingSymbol), e);
    }

    private int determineStartingIndex(Object offendingSymbol) {
        if (offendingSymbol instanceof Token) {
            return ((Token)offendingSymbol).getStartIndex();
        }
        return -1;
    }

    private String determineErrorCode(RecognitionException e) {
        if (e == null) {
            return "ERR 109";
        }
        if (e instanceof InputMismatchException) {
            return "ERR 102";
        }
        if (e instanceof NoViableAltException) {
            return "ERR 101";
        }
        if (e instanceof FailedPredicateException) {
            return "ERR 103";
        }
        throw new IllegalArgumentException("Unexpected exception type: " + e);
    }

    public DroolsParserException createDroolsException(Exception e, Token token) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return new DroolsParserException(String.format(UNEXPECTED_EXCEPTION, token.getLine(), token.getCharPositionInLine(), this.getBetterToken(token), e.toString(), sw.toString()), e);
    }

    private String formatParserLocation() {
        StringBuilder sb = new StringBuilder();
        if (this.paraphrases != null) {
            for (Map<DroolsParaphraseTypes, String> map : this.paraphrases) {
                for (Map.Entry<DroolsParaphraseTypes, String> activeEntry : map.entrySet()) {
                    if (activeEntry.getValue().length() == 0) {
                        String kStr = this.getLocationName(activeEntry.getKey());
                        if (kStr.length() <= 0) continue;
                        sb.append(String.format(PARSER_LOCATION_MESSAGE_PART, kStr));
                        continue;
                    }
                    sb.append(String.format(PARSER_LOCATION_MESSAGE_COMPLETE, this.getLocationName(activeEntry.getKey()), activeEntry.getValue()));
                }
            }
        }
        return sb.toString();
    }

    private String getLocationName(DroolsParaphraseTypes type) {
        switch (type) {
            case PACKAGE: {
                return "package";
            }
            case IMPORT: {
                return "import";
            }
            case FUNCTION_IMPORT: {
                return "function import";
            }
            case ACCUMULATE_IMPORT: {
                return "accumulate import";
            }
            case GLOBAL: {
                return "global";
            }
            case FUNCTION: {
                return "function";
            }
            case QUERY: {
                return "query";
            }
            case TEMPLATE: {
                return "template";
            }
            case RULE: {
                return "rule";
            }
            case RULE_ATTRIBUTE: {
                return "rule attribute";
            }
            case PATTERN: {
                return "pattern";
            }
            case EVAL: {
                return "eval";
            }
        }
        return "";
    }

    private String getBetterToken(Token token) {
        if (token == null) {
            return "";
        }
        return DRLFactory.getBetterToken(token.getType(), token.getText(), this.languageLevel);
    }
}

