/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.nodes;

import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.reteoo.nodes.ReteRightInputAdapterNode;

public class ReteBetaNodeUtils {
    public static void assertObject(BetaNode betaNode, InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory wm) {
        RightTuple rightTuple = betaNode.createRightTuple(factHandle, (RightTupleSink)betaNode, pctx);
        betaNode.assertRightTuple(rightTuple, pctx, wm);
    }

    public static void attach(BetaNode betaNode, BuildContext context) {
        betaNode.getRawConstraints().init(context, betaNode.getType());
        betaNode.setUnificationJoin();
        betaNode.getRightInput().addObjectSink((ObjectSink)betaNode);
        betaNode.getLeftTupleSource().addTupleSink((LeftTupleSink)betaNode, context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextFactory pctxFactory = workingMemory.getKnowledgeBase().getConfiguration().getComponentFactory().getPropagationContextFactory();
            PropagationContext propagationContext = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            betaNode.getRightInput().updateSink((ObjectSink)betaNode, propagationContext, workingMemory);
            betaNode.getLeftTupleSource().updateSink((LeftTupleSink)betaNode, propagationContext, workingMemory);
        }
    }

    public static void doRemove(BetaNode betaNode, RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!betaNode.isInUse() || context.getCleanupAdapter() != null) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                LeftTuple tmp;
                ReteRightInputAdapterNode rian;
                Memory object = workingMemory.getNodeMemory((MemoryFactory)betaNode);
                BetaMemory memory = object instanceof AccumulateNode.AccumulateMemory ? ((AccumulateNode.AccumulateMemory)object).betaMemory : (BetaMemory)object;
                if (betaNode.isRightInputIsRiaNode() && (rian = (ReteRightInputAdapterNode)betaNode.getRightInput()).getSinkPropagator().size() == 1) {
                    rian.removeMemory(workingMemory);
                }
                FastIterator it = memory.getLeftTupleMemory().fullFastIterator();
                LeftTuple leftTuple = BetaNode.getFirstLeftTuple((LeftTupleMemory)memory.getLeftTupleMemory(), (FastIterator)it);
                while (leftTuple != null) {
                    tmp = (LeftTuple)it.next((Entry)leftTuple);
                    if (context.getCleanupAdapter() != null) {
                        LeftTuple child;
                        while ((child = leftTuple.getFirstChild()) != null) {
                            if (child.getLeftTupleSink() == betaNode) {
                                child.unlinkFromLeftParent();
                                child.unlinkFromRightParent();
                                continue;
                            }
                            context.getCleanupAdapter().cleanUp(child, workingMemory);
                        }
                    }
                    memory.getLeftTupleMemory().remove(leftTuple);
                    leftTuple.unlinkFromLeftParent();
                    leftTuple.unlinkFromRightParent();
                    leftTuple = tmp;
                }
                if (object instanceof AccumulateNode.AccumulateMemory) {
                    ((AccumulateNode)betaNode).doRemove(workingMemory, (AccumulateNode.AccumulateMemory)object);
                }
                if (betaNode.isInUse()) continue;
                it = memory.getRightTupleMemory().fullFastIterator();
                RightTuple rightTuple = BetaNode.getFirstRightTuple((RightTupleMemory)memory.getRightTupleMemory(), (FastIterator)it);
                while (rightTuple != null) {
                    tmp = (RightTuple)it.next((Entry)rightTuple);
                    if (rightTuple.getBlocked() != null) {
                        LeftTuple leftTuple2 = rightTuple.getBlocked();
                        while (leftTuple2 != null) {
                            LeftTuple temp = leftTuple2.getBlockedNext();
                            leftTuple2.setBlocker(null);
                            leftTuple2.setBlockedPrevious(null);
                            leftTuple2.setBlockedNext(null);
                            leftTuple2.unlinkFromLeftParent();
                            leftTuple2 = temp;
                        }
                    }
                    memory.getRightTupleMemory().remove(rightTuple);
                    rightTuple.unlinkFromRightParent();
                    rightTuple = tmp;
                }
                workingMemory.clearNodeMemory((MemoryFactory)betaNode);
            }
            context.setCleanupAdapter(null);
        }
        if (!betaNode.isInUse()) {
            betaNode.getLeftTupleSource().removeTupleSink((LeftTupleSink)betaNode);
            betaNode.getRightInput().removeObjectSink((ObjectSink)betaNode);
        }
    }

    public static void modifyObject(BetaNode betaNode, InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory wm) {
        RightTuple rightTuple = modifyPreviousTuples.peekRightTuple();
        while (rightTuple != null && ((BetaNode)rightTuple.getRightTupleSink()).getRightInputOtnId().before(betaNode.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple();
            rightTuple.setPropagationContext(context);
            rightTuple.getRightTupleSink().retractRightTuple(rightTuple, context, wm);
            rightTuple = modifyPreviousTuples.peekRightTuple();
        }
        if (rightTuple != null && ((BetaNode)rightTuple.getRightTupleSink()).getRightInputOtnId().equals((Object)betaNode.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple();
            rightTuple.reAdd();
            if (rightTuple.getStagedType() != 1) {
                rightTuple.setPropagationContext(context);
            }
            if (BitMaskUtil.intersect((long)context.getModificationMask(), (long)betaNode.getRightInferredMask())) {
                betaNode.modifyRightTuple(rightTuple, context, wm);
            }
        } else if (BitMaskUtil.intersect((long)context.getModificationMask(), (long)betaNode.getRightInferredMask())) {
            betaNode.assertObject(factHandle, context, wm);
        }
    }
}

