/*
 * Decompiled with CFR 0.152.
 */
package org.drools.wiring.statics;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.drools.wiring.api.ResourceProvider;
import org.drools.wiring.api.classloader.ProjectClassLoader;

public class StaticProjectClassLoader
extends ProjectClassLoader {
    private static boolean isIBM_JVM = System.getProperty("java.vendor").toLowerCase().contains("ibm");

    protected StaticProjectClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
        super(parent, resourceProvider);
    }

    public boolean isDynamic() {
        return false;
    }

    public static StaticProjectClassLoader create(ClassLoader parent, ResourceProvider resourceProvider) {
        return isIBM_JVM ? new IBMStaticClassLoader(parent, resourceProvider) : new StaticProjectClassLoader(parent, resourceProvider);
    }

    public ProjectClassLoader.InternalTypesClassLoader makeClassLoader() {
        return new DummyInternalTypesClassLoader(this);
    }

    public static class IBMStaticClassLoader
    extends StaticProjectClassLoader {
        private final boolean parentImplementsFindResources;
        private static final Enumeration<URL> EMPTY_RESOURCE_ENUM = new Vector().elements();

        private IBMStaticClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
            super(parent, resourceProvider);
            Method m = null;
            try {
                m = parent.getClass().getMethod("findResources", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.parentImplementsFindResources = m != null && m.getDeclaringClass() == parent.getClass();
        }

        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.parentImplementsFindResources ? EMPTY_RESOURCE_ENUM : this.getParent().getResources(name);
        }
    }

    private static class DummyInternalTypesClassLoader
    extends ClassLoader
    implements ProjectClassLoader.InternalTypesClassLoader {
        private final ProjectClassLoader projectClassLoader;

        private DummyInternalTypesClassLoader(ProjectClassLoader projectClassLoader) {
            super(projectClassLoader.getParent());
            this.projectClassLoader = projectClassLoader;
        }

        public Class<?> defineClass(String name, byte[] bytecode) {
            throw new UnsupportedOperationException("You're trying to dynamically define a class, please add the module org.drools:drools-wiring-dynamic to your classpath.");
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            try {
                return this.loadType(name, resolve);
            }
            catch (ClassNotFoundException cnfe) {
                return this.projectClassLoader.internalLoadClass(name, resolve);
            }
        }

        public Class<?> loadType(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }

        @Override
        public URL getResource(String name) {
            return this.projectClassLoader.getResource(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return this.projectClassLoader.getResourceAsStream(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.projectClassLoader.getResources(name);
        }
    }
}

