/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util.metrics;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.duracloud.common.util.metrics.MetricException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metric {
    private final Logger log = LoggerFactory.getLogger(Metric.class);
    private final String header;
    private final LinkedList<MetricElement> elements;
    private final Stack<MetricElement> timerStack;

    public String toString() {
        StringBuilder sb = new StringBuilder("Metric: " + this.header);
        sb.append(" [");
        Iterator<MetricElement> elems = this.getElements();
        while (elems.hasNext()) {
            sb.append(elems.next().getSubHeader() + ", ");
        }
        int len = sb.length();
        if (sb.charAt(len - 1) != '[') {
            sb.replace(len - 2, len, "]");
        }
        sb.append("\n");
        return sb.toString();
    }

    public Metric(String header, String subHeader) {
        this.header = header;
        this.elements = new LinkedList();
        this.timerStack = new Stack();
        MetricElement elem = new MetricElement(subHeader);
        this.elements.add(elem);
        this.timerStack.push(elem);
    }

    public void start(String name) {
        MetricElement elem = this.timerStack.peek();
        if (!name.equals(elem.getSubHeader())) {
            String msg = "Element to start does not match top of stack: " + name + ", " + elem.getSubHeader();
            throw new RuntimeException(new MetricException(msg));
        }
        elem.start();
    }

    public void stop(String name) {
        MetricElement elem = this.timerStack.pop();
        while (elem != null && !name.equals(elem.getSubHeader())) {
            elem.stop();
            elem = this.timerStack.pop();
        }
        if (elem == null) {
            String msg = "Element to stop not found on stack: " + name;
            throw new RuntimeException(new MetricException(msg));
        }
        elem.stop();
    }

    public void addElement(String subHeader) {
        MetricElement elem = new MetricElement(subHeader);
        this.elements.add(elem);
        this.timerStack.push(elem);
    }

    public String getHeader() {
        return this.header;
    }

    public String getSubHeader() {
        return this.currentElement().getSubHeader();
    }

    public Iterator<MetricElement> getElements() {
        return this.elements.iterator();
    }

    protected MetricElement currentElement() {
        return this.elements.getLast();
    }

    public class MetricElement {
        private final String subHeader;
        private volatile long startTime;
        private volatile long stopTime;

        private MetricElement(String subHeader) {
            this.subHeader = subHeader;
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public void stop() {
            this.stopTime = System.currentTimeMillis();
        }

        public float elapsedSecs() {
            return (float)(this.stopTime - this.startTime) / 1000.0f;
        }

        public String getSubHeader() {
            return this.subHeader;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MetricElement: " + this.subHeader);
            sb.append("[" + this.startTime + " to " + this.stopTime + "]");
            return sb.toString();
        }
    }
}

