/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.classextension.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.core.CollectionUtils;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.core.VisibilityPredicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.easymock.classextension.ConstructorArgs;
import org.easymock.classextension.internal.ClassExtensionHelper;
import org.easymock.classextension.internal.ClassInstantiatorFactory;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.ObjectMethodsFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassProxyFactory<T>
implements IProxyFactory<T> {
    public T createProxy(Class<T> toMock, final InvocationHandler handler) {
        Factory mock;
        try {
            this.updateMethod(handler, toMock.getMethod("equals", Object.class));
            this.updateMethod(handler, toMock.getMethod("hashCode", new Class[0]));
            this.updateMethod(handler, toMock.getMethod("toString", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("We strangly failed to retrieve methods that always exist on an object...");
        }
        MockMethodInterceptor interceptor = new MockMethodInterceptor(){
            private Set<Method> mockedMethods;

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                if (method.isBridge()) {
                    return proxy.invokeSuper(obj, args);
                }
                if (Modifier.isAbstract(method.getModifiers())) {
                    return handler.invoke(obj, method, args);
                }
                if (this.mockedMethods != null && !this.mockedMethods.contains(method)) {
                    return proxy.invokeSuper(obj, args);
                }
                return handler.invoke(obj, method, args);
            }

            public InvocationHandler getHandler() {
                return handler;
            }

            public void setMockedMethods(Method ... mockedMethods) {
                this.mockedMethods = new HashSet<Method>(Arrays.asList(mockedMethods));
            }
        };
        Enhancer enhancer = new Enhancer(){

            protected void filterConstructors(Class sc, List constructors) {
                CollectionUtils.filter((Collection)constructors, (Predicate)new VisibilityPredicate(sc, true));
            }
        };
        enhancer.setSuperclass(toMock);
        enhancer.setCallbackType(interceptor.getClass());
        Class mockClass = enhancer.createClass();
        Enhancer.registerCallbacks((Class)mockClass, (Callback[])new Callback[]{interceptor});
        if (ClassExtensionHelper.getCurrentConstructorArgs() != null) {
            Object mock2;
            Constructor cstr;
            ConstructorArgs args = ClassExtensionHelper.getCurrentConstructorArgs();
            try {
                cstr = mockClass.getDeclaredConstructor(args.getConstructor().getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Fail to find constructor for param types", e);
            }
            try {
                cstr.setAccessible(true);
                mock2 = cstr.newInstance(args.getInitArgs());
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to instantiate mock calling constructor", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to instantiate mock calling constructor", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Failed to instantiate mock calling constructor: Exception in constructor", e);
            }
            return mock2;
        }
        try {
            mock = (Factory)ClassInstantiatorFactory.getInstantiator().newInstance(mockClass);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Fail to instantiate mock for " + toMock + " on " + ClassInstantiatorFactory.getJVM() + " JVM");
        }
        mock.getCallback(0);
        return (T)mock;
    }

    private void updateMethod(InvocationHandler objectMethodsFilter, Method correctMethod) {
        Field methodField = this.retrieveField(ObjectMethodsFilter.class, correctMethod.getName() + "Method");
        this.updateField(objectMethodsFilter, correctMethod, methodField);
    }

    private Field retrieveField(Class<?> clazz, String field) {
        try {
            return clazz.getDeclaredField(field);
        }
        catch (NoSuchFieldException e) {
            throw new InternalError("There must be some refactoring because the " + field + " field was there...");
        }
    }

    private void updateField(Object instance, Object value, Field field) {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new InternalError("Should be accessible since we set it ourselves");
        }
        field.setAccessible(accessible);
    }

    public static interface MockMethodInterceptor
    extends MethodInterceptor {
        public InvocationHandler getHandler();

        public void setMockedMethods(Method ... var1);
    }
}

