/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FolderArchiveEntry;
import org.eclipse.birt.core.archive.IArchiveLockManager;
import org.eclipse.birt.core.archive.RAFolderInputStream;
import org.eclipse.birt.core.archive.RAFolderOutputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.i18n.CoreMessages;
import org.eclipse.birt.core.util.IOUtil;

public class FolderArchiveFile
implements IArchiveFile {
    public static final String METEDATA = ".metedata";
    static Logger logger = Logger.getLogger(FolderArchiveFile.class.getName());
    protected String folderName;
    protected String systemId;
    protected String dependId;
    private HashSet<RAFolderInputStream> inputStreams = new HashSet();
    private HashSet<RAFolderOutputStream> outputStreams = new HashSet();
    protected String fileName;
    protected Map properties = new HashMap();

    public FolderArchiveFile(String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException(CoreMessages.getString("error.FolderNameIsNull"));
        }
        this.folderName = this.fileName = new File(name).getCanonicalPath();
    }

    @Override
    public String getName() {
        return this.folderName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RAFolderOutputStream outputStream = null;
        FilterOutputStream data = null;
        try {
            String meta = ArchiveUtil.generateFullContentPath(this.folderName, METEDATA);
            File file = new File(meta);
            outputStream = new RAFolderOutputStream(null, file);
            data = new DataOutputStream(outputStream);
            IOUtil.writeMap((DataOutputStream)data, this.properties);
        }
        finally {
            if (data != null) {
                data.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        IOException exception = null;
        HashSet<Closeable> hashSet = this.outputStreams;
        synchronized (hashSet) {
            ArrayList<RAFolderOutputStream> outputs = new ArrayList<RAFolderOutputStream>(this.outputStreams);
            for (RAFolderOutputStream output : outputs) {
                try {
                    output.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (exception == null) continue;
                    exception = ex;
                }
            }
            this.outputStreams.clear();
        }
        hashSet = this.inputStreams;
        synchronized (hashSet) {
            ArrayList<RAFolderInputStream> inputs = new ArrayList<RAFolderInputStream>(this.inputStreams);
            for (RAFolderInputStream input : inputs) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (exception == null) continue;
                    exception = ex;
                }
            }
            this.inputStreams.clear();
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        IOException ioex = null;
        HashSet<RAFolderOutputStream> hashSet = this.outputStreams;
        synchronized (hashSet) {
            for (RAOutputStream rAOutputStream : this.outputStreams) {
                try {
                    rAOutputStream.flush();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (ioex == null) continue;
                    ioex = ex;
                }
            }
        }
        if (ioex != null) {
            throw ioex;
        }
    }

    @Override
    public void refresh() throws IOException {
    }

    @Override
    public boolean exists(String name) {
        String path = ArchiveUtil.generateFullContentPath(this.folderName, name);
        File fd = new File(path);
        return fd.exists();
    }

    @Override
    public void setCacheSize(long cacheSize) {
    }

    @Override
    public long getUsedCache() {
        return 0L;
    }

    @Override
    public ArchiveEntry openEntry(String name) throws IOException {
        String fullPath = ArchiveUtil.generateFullContentPath(this.folderName, name);
        File fd = new File(fullPath);
        if (fd.exists()) {
            return new FolderArchiveEntry(fullPath, fd, this.inputStreams, this.outputStreams);
        }
        throw new FileNotFoundException(fullPath);
    }

    @Override
    public List<String> listEntries(String namePattern) {
        File[] files;
        ArrayList<String> streamList = new ArrayList<String>();
        String storagePath = ArchiveUtil.generateFullPath(this.folderName, namePattern);
        File dir = new File(storagePath);
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                String relativePath;
                File file = files[i];
                if (file.isFile() && !ArchiveUtil.needSkip(relativePath = ArchiveUtil.generateRelativeContentPath(this.folderName, file.getPath()))) {
                    streamList.add(relativePath);
                }
                ++i;
            }
        }
        return streamList;
    }

    @Override
    public ArchiveEntry createEntry(String name) throws IOException {
        String path = ArchiveUtil.generateFullContentPath(this.folderName, name);
        File fd = new File(path);
        ArchiveUtil.createParentFolder(fd);
        FolderArchiveEntry out = new FolderArchiveEntry(path, fd, this.inputStreams, this.outputStreams);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntry(String name) throws IOException {
        HashSet<RAFolderOutputStream> hashSet;
        boolean bl;
        String path = ArchiveUtil.generateFullContentPath(this.folderName, name);
        try {
            File fd = new File(path);
            bl = ArchiveUtil.removeFileAndFolder(fd);
            hashSet = this.outputStreams;
        }
        catch (Throwable throwable) {
            HashSet<RAFolderOutputStream> hashSet2 = this.outputStreams;
            synchronized (hashSet2) {
                ArrayList<RAFolderOutputStream> outputs = new ArrayList<RAFolderOutputStream>(this.outputStreams);
                for (RAFolderOutputStream output : outputs) {
                    try {
                        if (!path.equals(output.getName())) continue;
                        output.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                        throw ex;
                    }
                }
            }
        }
        synchronized (hashSet) {
            ArrayList<RAFolderOutputStream> outputs = new ArrayList<RAFolderOutputStream>(this.outputStreams);
            for (RAFolderOutputStream output : outputs) {
                try {
                    if (!path.equals(output.getName())) continue;
                    output.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    throw ex;
                }
            }
        }
        return bl;
        throw throwable;
    }

    @Override
    public Object lockEntry(String entry) throws IOException {
        String path = String.valueOf(ArchiveUtil.generateFullContentPath(this.folderName, entry)) + ".lck";
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        return lockManager.lock(path);
    }

    @Override
    public void unlockEntry(Object locker) throws IOException {
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        lockManager.unlock(locker);
    }

    @Override
    public String getSystemId() {
        if (this.properties.containsKey("archive.system-id")) {
            return this.properties.get("archive.system-id").toString();
        }
        return null;
    }

    @Override
    public String getDependId() {
        if (this.properties.containsKey("archive.depened-id")) {
            return this.properties.get("archive.depened-id").toString();
        }
        return null;
    }

    public void setSystemId(String systemId) {
        if (systemId != null) {
            this.properties.put("archive.system-id", systemId);
        }
    }

    public void setDependId(String dependId) {
        if (dependId != null) {
            this.properties.put("archive.depened-id", dependId);
        }
    }

    @Override
    public void save() throws IOException {
        this.flush();
    }
}

