/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.index;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;

public class SerializableBirtHash
extends HashMap
implements IIndexSerializer {
    public static int NULL_VALUE_OFFSET = -2;
    public static int NOT_HASH_VALUE_OFFSET = -3;
    private boolean closed = false;
    private HashSet valueSet = new HashSet();
    private StreamManager manager;
    private String indexName;
    private String valueName;

    public SerializableBirtHash(String indexName, String valueName, StreamManager manager) {
        this.indexName = indexName;
        this.valueName = valueName;
        this.manager = manager;
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null) {
            this.valueSet.add(null);
        } else {
            int hash = key.hashCode();
            if (this.valueSet.contains(hash)) {
                this.valueSet.add(key);
            } else {
                this.valueSet.add(key.hashCode());
            }
        }
        return super.put(key, value);
    }

    public Object getKeyValue(Object key) {
        if (key == null) {
            return null;
        }
        if (this.valueSet.contains(key)) {
            return key;
        }
        return key.hashCode();
    }

    @Override
    public void close() throws DataException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.doSave();
    }

    private void doSave() throws DataException {
        try {
            if (this.keySet().size() == 0) {
                return;
            }
            RAOutputStream indexStream = this.manager.getOutStream(this.indexName);
            RAOutputStream valueStream = this.manager.getOutStream(this.valueName);
            DataOutputStream dis = new DataOutputStream(indexStream);
            DataOutputStream dvs = new DataOutputStream(valueStream);
            IOUtil.writeInt(dis, this.keySet().size());
            for (Map.Entry entry : this.entrySet()) {
                int hash;
                if (entry.getKey() == null) {
                    IOUtil.writeLong(dis, NULL_VALUE_OFFSET);
                    IOUtil.writeIntList(dis, (List)entry.getValue());
                    continue;
                }
                int n = hash = entry.getKey() == null ? 0 : entry.getKey().hashCode();
                if (!this.valueSet.contains(entry.getKey())) {
                    IOUtil.writeLong(dis, valueStream.getOffset());
                    IOUtil.writeInt(dis, hash);
                    IOUtil.writeIntList(dis, (List)entry.getValue());
                    IOUtil.writeString(dvs, entry.getKey().toString());
                    continue;
                }
                IOUtil.writeLong(dis, NOT_HASH_VALUE_OFFSET);
                IOUtil.writeString(dis, entry.getKey().toString());
                IOUtil.writeIntList(dis, (List)entry.getValue());
            }
            indexStream.close();
            valueStream.close();
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage(), e);
        }
    }
}

