/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.writer;

import java.io.OutputStream;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.odf.pkg.PackageEntry;

public class ManifestWriter {
    protected XMLWriter writer = new XMLWriter();

    public ManifestWriter(OutputStream out) {
        this.writer.open(out);
    }

    public void start(String rootMime) {
        this.writer.startWriter();
        this.writer.openTag("manifest:manifest");
        this.writer.attribute("xmlns:manifest", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
        this.writeRootEntry(rootMime);
    }

    private void writeRootEntry(String rootMime) {
        this.writer.openTag("manifest:file-entry");
        this.writer.attribute("manifest:media-type", rootMime);
        this.writer.attribute("manifest:version", "1.2");
        this.writer.attribute("manifest:full-path", "/");
        this.writer.closeTag("manifest:file-entry");
    }

    public void writeEntry(PackageEntry entry) {
        String mediaType = entry.getContentType();
        if (mediaType == null) {
            mediaType = "";
        }
        this.writer.openTag("manifest:file-entry");
        this.writer.attribute("manifest:media-type", mediaType);
        this.writer.attribute("manifest:full-path", entry.getFullPath());
        this.writer.closeTag("manifest:file-entry");
    }

    public void end() {
        this.writer.closeTag("manifest:manifest");
        this.writer.close();
    }
}

