/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Object3D;
import org.eclipse.birt.chart.computation.PlotComputation;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.Grid;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWith2DAxes;
import org.eclipse.birt.chart.computation.withaxes.PlotWith3DAxes;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.BlockGenerationEvent;
import org.eclipse.birt.chart.event.ClipRenderEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.I3DRenderEvent;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.internal.model.FittingCalculator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.JavaDateFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.StringFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.CurveFitting;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.BigNumberDataElement;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataElement;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.render.AxesRenderHelper;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.CurveRenderer;
import org.eclipse.birt.chart.render.IAxesDecorator;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;

public abstract class AxesRenderer
extends BaseRenderer {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/render");
    private Axis ax;
    private boolean leftWallFill = false;
    private boolean rightWallFill = false;
    private boolean floorFill = false;
    private Object3D o3dLeftWall = null;
    private Object3D o3dRightWall = null;
    private Object3D o3dFloor = null;
    private Object o3dLeftWallEvent;
    private Object o3dRightWallEvent;
    private Object o3dFloorEvent;

    public Object3D getLeftWall() {
        return this.o3dLeftWall;
    }

    public Object getLeftWallEvent() {
        return this.o3dLeftWallEvent;
    }

    public Object3D getRightWall() {
        return this.o3dRightWall;
    }

    public Object getRightWallEvent() {
        return this.o3dRightWallEvent;
    }

    public Object3D getFloor() {
        return this.o3dFloor;
    }

    public Object getFloorEvent() {
        return this.o3dFloorEvent;
    }

    @Override
    public final void render(Map<Series, LegendItemRenderingHints> htRenderers, Bounds bo) throws ChartException {
        PlotComputation obj;
        Enumeration<Block> e;
        Block bl;
        boolean bFirstInSequence = this.iSeriesIndex == 0;
        boolean bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        Chart cm = this.getModel();
        IDeviceRenderer idr = this.getDevice();
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        if (bFirstInSequence) {
            bl = cm.getBlock();
            e = bl.children(true);
            BlockGenerationEvent bge = new BlockGenerationEvent(bl);
            ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
            bge.updateBlock(bl);
            this.renderChartBlock(idr, bl, StructureSource.createChartBlock(bl));
            ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
            while (e.hasMoreElements()) {
                bl = e.nextElement();
                bge.updateBlock(bl);
                if (bl instanceof Plot) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderPlot(idr, (Plot)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    if (bLastInSequence) continue;
                    break;
                }
                if (bl instanceof TitleBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderTitle(idr, (TitleBlock)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof LabelBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLabel(idr, bl, StructureSource.createUnknown(bl));
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof Legend) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLegend(idr, (Legend)bl, htRenderers);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderBlock(idr, bl, StructureSource.createUnknown(bl));
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
            }
        } else if (bLastInSequence) {
            bl = cm.getBlock();
            e = bl.children(true);
            BlockGenerationEvent bge = new BlockGenerationEvent(this);
            boolean bStarted = false;
            while (e.hasMoreElements()) {
                bl = e.nextElement();
                if (!bStarted && !bl.isPlot()) continue;
                bStarted = true;
                bge.updateBlock(bl);
                if (bl instanceof Plot) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderPlot(idr, (Plot)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof TitleBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderTitle(idr, (TitleBlock)bl);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof LabelBlock) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLabel(idr, bl, StructureSource.createUnknown(bl));
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                if (bl instanceof Legend) {
                    ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                    this.renderLegend(idr, (Legend)bl, htRenderers);
                    ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
                    continue;
                }
                ScriptHandler.callFunction(sh, "beforeDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", bl);
                this.renderBlock(idr, bl, StructureSource.createUnknown(bl));
                ScriptHandler.callFunction(sh, "afterDrawBlock", bl, this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawBlock", bl);
            }
        } else {
            BlockGenerationEvent bge = new BlockGenerationEvent(this);
            Plot p = cm.getPlot();
            bge.updateBlock(p);
            ScriptHandler.callFunction(sh, "beforeDrawBlock", p, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawBlock", p);
            this.renderPlot(idr, p);
            ScriptHandler.callFunction(sh, "afterDrawBlock", p, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawBlock", p);
        }
        if (bLastInSequence && (obj = this.getComputations()) instanceof PlotWith2DAxes) {
            PlotWith2DAxes pw2da = (PlotWith2DAxes)this.getComputations();
            pw2da.getStackedSeriesLookup().resetSubUnits();
        }
    }

    private final int compare(DataElement de1, DataElement de2) throws ChartException {
        Class<?> c2;
        if (de1 == null && de2 == null) {
            return 0;
        }
        if (de1 == null || de2 == null) {
            return -2;
        }
        Class<?> c1 = de1.getClass();
        if (c1.equals(c2 = de2.getClass())) {
            if (de1 instanceof BigNumberDataElement) {
                return ((BigNumberDataElement)de1).getValue().compareTo(((BigNumberDataElement)de2).getValue());
            }
            if (de1 instanceof NumberDataElement) {
                return Double.compare(((NumberDataElement)de1).getValue(), ((NumberDataElement)de2).getValue());
            }
            if (de1 instanceof DateTimeDataElement) {
                long l2;
                long l1 = ((DateTimeDataElement)de1).getValue();
                return l1 < (l2 = ((DateTimeDataElement)de1).getValue()) ? -1 : (l1 == l2 ? 0 : 1);
            }
            if (de1 instanceof TextDataElement) {
                throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.unsupported.compare.text", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.unsupported.compare.unknown.objects", new Object[]{de1, de2}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.unsupported.compare.different.objects", new Object[]{de1, de2}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
    }

    private static final TextAlignment anchorToAlignment(Anchor anc) {
        TextAlignment ta = TextAlignmentImpl.create();
        if (anc == null) {
            return ta;
        }
        switch (anc.getValue()) {
            case 0: 
            case 1: 
            case 7: {
                ta.setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                ta.setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
                break;
            }
            default: {
                ta.setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            }
        }
        switch (anc.getValue()) {
            case 1: 
            case 2: 
            case 3: {
                ta.setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                ta.setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
                break;
            }
            default: {
                ta.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            }
        }
        return ta;
    }

    protected final void renderFittingCurve(IPrimitiveRenderer ipr, Location[] points, CurveFitting curve, boolean bShowAsTape, boolean bDeferred) throws ChartException {
        boolean isTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        if (curve.getLineAttributes().isVisible()) {
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "beforeDrawFittingCurve", curve, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawFittingCurve", curve);
            double[] xArray = new double[points.length];
            double[] yArray = new double[points.length];
            int i = 0;
            while (i < xArray.length) {
                xArray[i] = points[i].getX();
                yArray[i] = points[i].getY();
                ++i;
            }
            FittingCurveHelper fch = FittingCurveHelper.instance(xArray, yArray, isTransposed);
            double[] baseArray = fch.getBaseArray();
            double[] orthogonalArray = fch.getOrthogonalArray();
            FittingCalculator fc = new FittingCalculator(baseArray, orthogonalArray, 0.33);
            double[] fitYarray = fc.getFittedValue();
            orthogonalArray = fitYarray;
            if (isTransposed) {
                orthogonalArray = baseArray;
                baseArray = fitYarray;
            }
            if (curve.getLineAttributes().getColor() != null) {
                CurveRenderer crdr = new CurveRenderer((ChartWithAxes)this.getModel(), this, curve.getLineAttributes(), goFactory.createLocations(baseArray, orthogonalArray), bShowAsTape, -1.0, bDeferred, false, null, false, true);
                crdr.draw(ipr);
            }
            if (curve.getLabel().isVisible()) {
                double xs;
                double ys;
                Label lb = goFactory.copyOf(curve.getLabel());
                String sPreviousValue = lb.getCaption().getValue();
                lb.getCaption().setValue(this.getRunTimeContext().externalizedMessage(sPreviousValue));
                BoundingBox bb = this.cComp.computeBox(this.getXServer(), 1, lb, 0.0, 0.0);
                Anchor lbAnchor = curve.getLabelAnchor();
                if (lbAnchor == null) {
                    lbAnchor = Anchor.NORTH_LITERAL;
                }
                int horizontal = 3;
                int vertical = 4;
                switch (lbAnchor.getValue()) {
                    case 5: 
                    case 6: 
                    case 7: {
                        horizontal = 1;
                        break;
                    }
                    case 0: 
                    case 4: {
                        horizontal = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        horizontal = 2;
                    }
                }
                switch (lbAnchor.getValue()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        vertical = 4;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        vertical = 8;
                    }
                }
                if (isTransposed) {
                    if (horizontal == 1) {
                        ys = orthogonalArray[orthogonalArray.length - 1] - bb.getHeight();
                        horizontal = 2;
                    } else if (horizontal == 2) {
                        ys = orthogonalArray[0];
                        horizontal = 1;
                    } else {
                        ys = orthogonalArray[0] + (orthogonalArray[orthogonalArray.length - 1] - orthogonalArray[0]) / 2.0 - bb.getHeight() / 2.0;
                    }
                    xs = this.getFitYPosition(orthogonalArray, baseArray, horizontal, bb.getHeight(), bb.getWidth(), vertical == 8);
                } else {
                    xs = horizontal == 1 ? xArray[0] : (horizontal == 2 ? xArray[xArray.length - 1] - bb.getWidth() : xArray[0] + (xArray[xArray.length - 1] - xArray[0]) / 2.0 - bb.getWidth() / 2.0);
                    ys = this.getFitYPosition(xArray, fitYarray, horizontal, bb.getWidth(), bb.getHeight(), vertical == 4);
                }
                bb.setLeft(xs);
                bb.setTop(ys);
                this.renderLabel(StructureSource.createSeries(this.getSeries()), 3, lb, Position.RIGHT_LITERAL, goFactory.createLocation(bb.getLeft(), bb.getTop()), goFactory.createBounds(bb.getLeft(), bb.getTop(), bb.getWidth(), bb.getHeight()), this.fDeferredCacheManager.getLastDeferredCache());
            }
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "afterDrawFittingCurve", curve, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawFittingCurve", curve);
        }
    }

    private double getFitYPosition(double[] xa, double[] ya, int align, double width, double height, boolean above) {
        int gap = 10;
        double rt = 0.0;
        if (align == 1) {
            rt = ya[0];
        } else if (align == 2) {
            rt = ya[ya.length - 1];
        } else if (ya.length % 2 == 1) {
            rt = ya[ya.length / 2];
        } else {
            int x = ya.length / 2;
            rt = (ya[x] + ya[x - 1]) / 2.0;
        }
        return above ? rt - height - (double)gap : rt + (double)gap;
    }

    private final void renderMarkerRanges(OneAxis[] oaxa, Bounds boPlotClientArea) throws ChartException {
        int iAxisCount = oaxa.length;
        double dMin = 0.0;
        double dMax = 0.0;
        int iCompare = 0;
        Bounds bo = goFactory.createBounds(0.0, 0.0, 0.0, 0.0);
        IDeviceRenderer idr = this.getDevice();
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        boolean bTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        StringBuffer sb = new StringBuffer();
        Bounds boText = goFactory.createBounds(0.0, 0.0, 0.0, 0.0);
        Anchor anc = null;
        Label la = null;
        double dOriginalAngle = 0.0;
        int i = 0;
        while (i < iAxisCount) {
            Axis ax = oaxa[i].getModelAxis();
            int iOrientation = ax.getOrientation().getValue();
            if (bTransposed) {
                iOrientation = iOrientation == 0 ? 1 : 0;
            }
            AutoScale asc = oaxa[i].getScale();
            EList<MarkerRange> el = ax.getMarkerRanges();
            int iRangeCount = el.size();
            int j = 0;
            while (j < iRangeCount) {
                block30: {
                    EList<Trigger> elTriggers;
                    MarkerRange mr = (MarkerRange)el.get(j);
                    ScriptHandler.callFunction(sh, "beforeDrawMarkerRange", ax, mr, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawMarkerRange", mr);
                    DataElement deStart = mr.getStartValue();
                    DataElement deEnd = mr.getEndValue();
                    try {
                        iCompare = this.compare(deStart, deEnd);
                    }
                    catch (ChartException dfex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)dfex);
                    }
                    if (iCompare == 1) {
                        DataElement deTemp = deStart;
                        deStart = deEnd;
                        deEnd = deTemp;
                    }
                    if (this.isDimension3D()) {
                        return;
                    }
                    try {
                        dMin = deStart == null ? (iOrientation == 0 ? boPlotClientArea.getLeft() : boPlotClientArea.getTop() + boPlotClientArea.getHeight()) : Methods.getLocation(asc, deStart);
                    }
                    catch (Exception exception) {
                        logger.log(2, Messages.getString("exception.cannot.locate.start.marker.range", new Object[]{deStart, mr}, this.getRunTimeContext().getULocale()));
                        break block30;
                    }
                    try {
                        dMax = deEnd == null ? (iOrientation == 0 ? boPlotClientArea.getLeft() + boPlotClientArea.getWidth() : boPlotClientArea.getTop()) : Methods.getLocation(asc, deEnd);
                    }
                    catch (Exception exception) {
                        logger.log(2, Messages.getString("exception.cannot.locate.end.marker.range", new Object[]{deEnd, mr}, this.getRunTimeContext().getULocale()));
                        break block30;
                    }
                    RectangleRenderEvent rre = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerRange(mr), RectangleRenderEvent.class);
                    if (iOrientation == 0) {
                        double maxLimit = boPlotClientArea.getLeft() + boPlotClientArea.getWidth();
                        double minLimit = boPlotClientArea.getLeft();
                        if (pwa.getDimension() == 1) {
                            maxLimit -= pwa.getSeriesThickness();
                            minLimit -= pwa.getSeriesThickness();
                        }
                        dMax = Math.min(dMax, maxLimit);
                        dMin = Math.min(dMin, maxLimit);
                        dMax = Math.max(dMax, minLimit);
                        dMin = Math.max(dMin, minLimit);
                        bo.set(dMin, boPlotClientArea.getTop(), dMax - dMin, boPlotClientArea.getHeight());
                    } else {
                        double minLimit = boPlotClientArea.getTop();
                        double maxLimit = boPlotClientArea.getTop() + boPlotClientArea.getHeight();
                        if (pwa.getDimension() == 1) {
                            maxLimit += pwa.getSeriesThickness();
                            minLimit += pwa.getSeriesThickness();
                        }
                        dMax = Math.min(dMax, maxLimit);
                        dMin = Math.min(dMin, maxLimit);
                        dMax = Math.max(dMax, minLimit);
                        dMin = Math.max(dMin, minLimit);
                        bo.set(boPlotClientArea.getLeft(), dMax, boPlotClientArea.getWidth(), dMin - dMax);
                    }
                    if (pwa.getDimension() == 1) {
                        if (iOrientation == 0) {
                            bo.translate(pwa.getSeriesThickness(), 0.0);
                        } else {
                            bo.translate(0.0, -pwa.getSeriesThickness());
                        }
                    }
                    rre.setBounds(bo);
                    rre.setOutline(mr.getOutline());
                    rre.setBackground(mr.getFill());
                    idr.fillRectangle(rre);
                    idr.drawRectangle(rre);
                    la = goFactory.copyOf(mr.getLabel());
                    if (la.isVisible()) {
                        if (la.getCaption().getValue() != null && !"".equals(la.getCaption().getValue()) && la.getCaption().getValue().length() > 0) {
                            la.getCaption().setValue(oaxa[i].getRunTimeContext().externalizedMessage(la.getCaption().getValue()));
                        } else {
                            try {
                                sb.delete(0, sb.length());
                                sb.append(Messages.getString("prefix.marker.range.caption", this.getRunTimeContext().getULocale()));
                                sb.append(ValueFormatter.format(deStart, mr.getFormatSpecifier(), oaxa[i].getRunTimeContext().getULocale(), this.getDataElementDefaultFormat(deStart, asc)));
                                sb.append(Messages.getString("separator.marker.range.caption", this.getRunTimeContext().getULocale()));
                                sb.append(ValueFormatter.format(deEnd, mr.getFormatSpecifier(), oaxa[i].getRunTimeContext().getULocale(), this.getDataElementDefaultFormat(deEnd, asc)));
                                sb.append(Messages.getString("suffix.marker.range.caption", this.getRunTimeContext().getULocale()));
                                la.getCaption().setValue(sb.toString());
                            }
                            catch (ChartException dfex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)dfex);
                            }
                        }
                        anc = this.switchAnchor(mr.getLabelAnchor());
                        if (bTransposed) {
                            dOriginalAngle = la.getCaption().getFont().getRotation();
                            try {
                                la.getCaption().getFont().setRotation(pwa.getTransposedAngle(dOriginalAngle));
                                anc = ChartUtil.transposeAnchor(anc);
                            }
                            catch (IllegalArgumentException uiex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)uiex);
                            }
                        }
                        BoundingBox bb = null;
                        try {
                            bb = this.cComp.computeBox(idr.getDisplayServer(), 1, la, 0.0, 0.0);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)uiex);
                        }
                        boText.set(0.0, 0.0, bb.getWidth(), bb.getHeight());
                        TextRenderEvent tre = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerRange(mr), TextRenderEvent.class);
                        tre.setBlockBounds(bo);
                        tre.setBlockAlignment(AxesRenderer.anchorToAlignment(anc));
                        tre.setLabel(la);
                        tre.setAction(3);
                        this.getDeferredCache().addLabel(tre);
                    }
                    if (this.isInteractivityEnabled() && !(elTriggers = mr.getTriggers()).isEmpty()) {
                        InteractionEvent iev = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerRange(mr), InteractionEvent.class);
                        iev.setCursor(mr.getCursor());
                        int t = 0;
                        while (t < elTriggers.size()) {
                            Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                            this.processTrigger(tg, StructureSource.createMarkerRange(mr));
                            iev.addTrigger(tg);
                            ++t;
                        }
                        iev.setHotSpot(rre);
                        idr.enableInteraction(iev);
                    }
                    ScriptHandler.callFunction(sh, "afterDrawMarkerRange", ax, mr, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawMarkerRange", mr);
                }
                ++j;
            }
            ++i;
        }
    }

    private OneAxis[] getAllOneAxes() {
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        AllAxes aax = pwa.getAxes();
        OneAxis[] oaxa = new OneAxis[2 + aax.getOverlayCount() + (aax.getAncillaryBase() != null ? 1 : 0)];
        oaxa[0] = aax.getPrimaryBase();
        oaxa[1] = aax.getPrimaryOrthogonal();
        int i = 0;
        while (i < aax.getOverlayCount()) {
            oaxa[2 + i] = aax.getOverlay(i);
            ++i;
        }
        if (aax.getAncillaryBase() != null) {
            oaxa[2 + aax.getOverlayCount()] = aax.getAncillaryBase();
        }
        return oaxa;
    }

    @Override
    protected void renderBackground(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        LineRenderEvent lre;
        int j;
        AxisTickCoordinates da;
        LineAttributes lia;
        PolygonRenderEvent pre;
        Location[] loa;
        super.renderBackground(ipr, p);
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        ClientArea ca = p.getClientArea();
        if (!ca.isVisible()) {
            return;
        }
        Bounds bo = pwa.getPlotBounds();
        RectangleRenderEvent rre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), RectangleRenderEvent.class);
        if (!this.isDimension3D()) {
            if (ca.getShadowColor() != null) {
                rre.setBounds(goFactory.translateBounds(bo, 3.0, 3.0));
                rre.setBackground(ca.getShadowColor());
                ipr.fillRectangle(rre);
            }
            rre.setBounds(bo);
            rre.setOutline(ca.getOutline());
            rre.setBackground(ca.getBackground());
            ipr.fillRectangle(rre);
        }
        double dSeriesThickness = pwa.getSeriesThickness();
        double[] daX = new double[]{bo.getLeft() - dSeriesThickness, bo.getLeft() + bo.getWidth() - dSeriesThickness};
        double[] daY = new double[]{bo.getTop() + bo.getHeight() + dSeriesThickness, bo.getTop() + dSeriesThickness};
        AllAxes aax = pwa.getAxes();
        AutoScale scPrimaryBase = null;
        AutoScale scPrimaryOrthogonal = null;
        AutoScale scAncillaryBase = null;
        double dXStart = 0.0;
        double dYStart = 0.0;
        double dZStart = 0.0;
        double dXEnd = 0.0;
        double dYEnd = 0.0;
        double dZEnd = 0.0;
        int baseTickCount = 0;
        int ancillaryTickCount = 0;
        int orthogonalTickCount = 0;
        double xStep = 0.0;
        double yStep = 0.0;
        double zStep = 0.0;
        if (this.isDimension3D()) {
            scPrimaryBase = aax.getPrimaryBase().getScale();
            scPrimaryOrthogonal = aax.getPrimaryOrthogonal().getScale();
            scAncillaryBase = aax.getAncillaryBase().getScale();
            dXStart = scPrimaryBase.getStart();
            dYStart = scPrimaryOrthogonal.getStart();
            dZStart = scAncillaryBase.getStart();
            dXEnd = scPrimaryBase.getEnd();
            dYEnd = scPrimaryOrthogonal.getEnd();
            dZEnd = scAncillaryBase.getEnd();
            baseTickCount = scPrimaryBase.getTickCordinates().size();
            ancillaryTickCount = scAncillaryBase.getTickCordinates().size();
            orthogonalTickCount = scPrimaryOrthogonal.getTickCordinates().size();
            xStep = scPrimaryBase.getUnitSize();
            yStep = scPrimaryOrthogonal.getUnitSize();
            zStep = scAncillaryBase.getUnitSize();
        }
        if (pwa.getDimension() == 1) {
            loa = null;
            if (cwa.getWallFill() == null) {
                this.renderPlane(ipr, StructureSource.createPlot(p), new Location[]{goFactory.createLocation(daX[0], daY[0]), goFactory.createLocation(daX[0], daY[1])}, ca.getBackground(), ca.getOutline(), cwa.getDimension(), dSeriesThickness, false);
            } else {
                loa = new Location[]{goFactory.createLocation(daX[0], daY[0]), goFactory.createLocation(daX[0], daY[1]), goFactory.createLocation(daX[0] + dSeriesThickness, daY[1] - dSeriesThickness), goFactory.createLocation(daX[0] + dSeriesThickness, daY[0] - dSeriesThickness)};
                pre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), PolygonRenderEvent.class);
                pre.setPoints(loa);
                pre.setBackground(cwa.getWallFill());
                pre.setOutline(ca.getOutline());
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
            if (cwa.getFloorFill() == null) {
                this.renderPlane(ipr, StructureSource.createPlot(p), new Location[]{goFactory.createLocation(daX[0], daY[0]), goFactory.createLocation(daX[1], daY[0])}, ca.getBackground(), ca.getOutline(), cwa.getDimension(), dSeriesThickness, false);
            } else {
                if (loa == null) {
                    loa = new Location[]{goFactory.createLocation(daX[0], daY[0]), goFactory.createLocation(daX[1], daY[0]), goFactory.createLocation(daX[1] + dSeriesThickness, daY[0] - dSeriesThickness), goFactory.createLocation(daX[0] + dSeriesThickness, daY[0] - dSeriesThickness)};
                }
                pre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), PolygonRenderEvent.class);
                pre.setPoints(loa);
                pre.setBackground(cwa.getFloorFill());
                pre.setOutline(ca.getOutline());
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
        } else if (pwa.getDimension() == 2) {
            loa = null;
            pre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), Polygon3DRenderEvent.class);
            ((Polygon3DRenderEvent)pre).setDoubleSided(true);
            loa = new Location3D[]{goFactory.createLocation3D(dXStart, dYStart, dZStart), goFactory.createLocation3D(dXStart, dYEnd, dZStart), goFactory.createLocation3D(dXStart, dYEnd, dZEnd), goFactory.createLocation3D(dXStart, dYStart, dZEnd)};
            ((Polygon3DRenderEvent)pre).setPoints3D((Location3D[])loa);
            ((Polygon3DRenderEvent)pre).setBackground(cwa.getWallFill());
            ((Polygon3DRenderEvent)pre).setDoubleSided(true);
            pre.setOutline(ca.getOutline());
            Object event_new = this.getDeferredCache().addPlane(pre, 3);
            this.o3dLeftWall = Engine3D.getObjectFromEvent(event_new);
            this.o3dLeftWallEvent = event_new;
            loa[0] = goFactory.createLocation3D(dXStart, dYStart, dZStart);
            loa[1] = goFactory.createLocation3D(dXEnd, dYStart, dZStart);
            loa[2] = goFactory.createLocation3D(dXEnd, dYEnd, dZStart);
            loa[3] = goFactory.createLocation3D(dXStart, dYEnd, dZStart);
            ((Polygon3DRenderEvent)pre).setPoints3D((Location3D[])loa);
            ((Polygon3DRenderEvent)pre).setBackground(cwa.getWallFill());
            ((Polygon3DRenderEvent)pre).setDoubleSided(true);
            pre.setOutline(ca.getOutline());
            event_new = this.getDeferredCache().addPlane(pre, 3);
            this.o3dRightWall = Engine3D.getObjectFromEvent(event_new);
            this.o3dRightWallEvent = event_new;
            if (cwa.getWallFill() instanceof ColorDefinition && ((ColorDefinition)cwa.getWallFill()).getTransparency() > 0 || !(cwa.getWallFill() instanceof ColorDefinition) && cwa.getWallFill() != null) {
                this.leftWallFill = true;
                this.rightWallFill = true;
            }
            loa[0] = goFactory.createLocation3D(dXStart, dYStart, dZStart);
            loa[1] = goFactory.createLocation3D(dXStart, dYStart, dZEnd);
            loa[2] = goFactory.createLocation3D(dXEnd, dYStart, dZEnd);
            loa[3] = goFactory.createLocation3D(dXEnd, dYStart, dZStart);
            ((Polygon3DRenderEvent)pre).setPoints3D((Location3D[])loa);
            ((Polygon3DRenderEvent)pre).setBackground(cwa.getFloorFill());
            ((Polygon3DRenderEvent)pre).setDoubleSided(true);
            pre.setOutline(ca.getOutline());
            event_new = this.getDeferredCache().addPlane(pre, 3);
            this.o3dFloor = Engine3D.getObjectFromEvent(event_new);
            this.o3dFloorEvent = event_new;
            if (cwa.getFloorFill() instanceof ColorDefinition && ((ColorDefinition)cwa.getFloorFill()).getTransparency() > 0 || !(cwa.getFloorFill() instanceof ColorDefinition) && cwa.getFloorFill() != null) {
                this.floorFill = true;
            }
        }
        OneAxis[] oaxa = this.getAllOneAxes();
        this.renderMarkerRanges(oaxa, bo);
        double x = 0.0;
        double y = 0.0;
        double vnext = 0.0;
        double[] doaMinor = null;
        int i = 0;
        while (i < oaxa.length) {
            block102: {
                int k;
                AutoScale sc;
                block103: {
                    Grid g = oaxa[i].getGrid();
                    int iCount = g.getMinorCountPerMajor();
                    lia = oaxa[i].getGrid().getLineAttributes(1);
                    if (lia == null || !lia.isVisible()) break block102;
                    if (iCount <= 0) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.cannot.split.major", new Object[]{iCount}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                    }
                    sc = oaxa[i].getScale();
                    doaMinor = sc.getMinorCoordinates(iCount);
                    if (!this.isDimension3D()) break block103;
                    Line3DRenderEvent lre3d = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), Line3DRenderEvent.class);
                    lre3d.setLineAttributes(lia);
                    switch (oaxa[i].getAxisType()) {
                        case 5: {
                            int j2;
                            int k2;
                            AxisTickCoordinates xa = scPrimaryBase.getTickCordinates();
                            if (this.floorFill) {
                                k2 = 0;
                                while (k2 < xa.size() - 1) {
                                    j2 = 0;
                                    while (j2 < doaMinor.length - 1) {
                                        if (!ChartUtil.mathGE(xa.getCoordinate(k2) + doaMinor[j2], xa.getCoordinate(k2 + 1))) {
                                            lre3d.setStart3D(goFactory.createLocation3D(xa.getCoordinate(k2) + doaMinor[j2], dYStart, dZStart));
                                            lre3d.setEnd3D(goFactory.createLocation3D(xa.getCoordinate(k2) + doaMinor[j2], dYStart, dZStart + (double)(ancillaryTickCount - 1) * zStep));
                                            AxesRenderHelper.addLine3DEvent(lre3d, this.o3dFloorEvent, this.getDeferredCache());
                                        }
                                        ++j2;
                                    }
                                    ++k2;
                                }
                            }
                            if (this.rightWallFill) {
                                k2 = 0;
                                while (k2 < xa.size() - 1) {
                                    j2 = 0;
                                    while (j2 < doaMinor.length - 1) {
                                        if (!ChartUtil.mathGE(xa.getCoordinate(k2) + doaMinor[j2], xa.getCoordinate(k2 + 1))) {
                                            lre3d.setStart3D(goFactory.createLocation3D(xa.getCoordinate(k2) + doaMinor[j2], dYStart, dZStart));
                                            lre3d.setEnd3D(goFactory.createLocation3D(xa.getCoordinate(k2) + doaMinor[j2], dYStart + (double)(orthogonalTickCount - 1) * yStep, dZStart));
                                            AxesRenderHelper.addLine3DEvent(lre3d, this.o3dRightWallEvent, this.getDeferredCache());
                                        }
                                        ++j2;
                                    }
                                    ++k2;
                                }
                            }
                            break block102;
                        }
                        case 9: {
                            int j3;
                            AxisTickCoordinates ya = scPrimaryOrthogonal.getTickCordinates();
                            if (this.leftWallFill) {
                                int k3 = 0;
                                while (k3 < ya.size() - 1) {
                                    j3 = 0;
                                    while (j3 < doaMinor.length - 1) {
                                        if (!ChartUtil.mathGE(ya.getCoordinate(k3) + doaMinor[j3], ya.getCoordinate(k3 + 1))) {
                                            lre3d.setStart3D(goFactory.createLocation3D(dXStart, ya.getCoordinate(k3) + doaMinor[j3], dZStart));
                                            lre3d.setEnd3D(goFactory.createLocation3D(dXStart, ya.getCoordinate(k3) + doaMinor[j3], dZStart + (double)(ancillaryTickCount - 1) * zStep));
                                            AxesRenderHelper.addLine3DEvent(lre3d, this.o3dLeftWallEvent, this.getDeferredCache());
                                        }
                                        ++j3;
                                    }
                                    ++k3;
                                }
                            }
                            if (this.rightWallFill) {
                                int k4 = 0;
                                while (k4 < ya.size() - 1) {
                                    j3 = 0;
                                    while (j3 < doaMinor.length - 1) {
                                        if (!ChartUtil.mathGE(ya.getCoordinate(k4) + doaMinor[j3], ya.getCoordinate(k4 + 1))) {
                                            lre3d.setStart3D(goFactory.createLocation3D(dXStart, ya.getCoordinate(k4) + doaMinor[j3], dZStart));
                                            lre3d.setEnd3D(goFactory.createLocation3D(dXStart + (double)(baseTickCount - 1) * xStep, ya.getCoordinate(k4) + doaMinor[j3], dZStart));
                                            AxesRenderHelper.addLine3DEvent(lre3d, this.o3dRightWallEvent, this.getDeferredCache());
                                        }
                                        ++j3;
                                    }
                                    ++k4;
                                }
                            }
                            break block102;
                        }
                        case 17: {
                            int j4;
                            AxisTickCoordinates za = scAncillaryBase.getTickCordinates();
                            if (this.leftWallFill) {
                                int k5 = 0;
                                while (k5 < za.size() - 1) {
                                    j4 = 0;
                                    while (j4 < doaMinor.length - 1) {
                                        if (!ChartUtil.mathGE(za.getCoordinate(k5) + doaMinor[j4], za.getCoordinate(k5 + 1))) {
                                            lre3d.setStart3D(goFactory.createLocation3D(dXStart, dYStart, za.getCoordinate(k5) + doaMinor[j4]));
                                            lre3d.setEnd3D(goFactory.createLocation3D(dXStart, dYStart + (double)(orthogonalTickCount - 1) * yStep, za.getCoordinate(k5) + doaMinor[j4]));
                                            AxesRenderHelper.addLine3DEvent(lre3d, this.o3dLeftWallEvent, this.getDeferredCache());
                                        }
                                        ++j4;
                                    }
                                    ++k5;
                                }
                            }
                            if (this.floorFill) {
                                int k6 = 0;
                                while (k6 < za.size() - 1) {
                                    j4 = 0;
                                    while (j4 < doaMinor.length - 1) {
                                        if (!ChartUtil.mathGE(za.getCoordinate(k6) + doaMinor[j4], za.getCoordinate(k6 + 1))) {
                                            lre3d.setStart3D(goFactory.createLocation3D(dXStart, dYStart, za.getCoordinate(k6) + doaMinor[j4]));
                                            lre3d.setEnd3D(goFactory.createLocation3D(dXStart + (double)(baseTickCount - 1) * xStep, dYStart, za.getCoordinate(k6) + doaMinor[j4]));
                                            AxesRenderHelper.addLine3DEvent(lre3d, this.o3dFloorEvent, this.getDeferredCache());
                                        }
                                        ++j4;
                                    }
                                    ++k6;
                                }
                            }
                            break block102;
                        }
                    }
                    break block102;
                }
                if (oaxa[i].getOrientation() == 0) {
                    int iDirection = sc.getDirection() == -1 ? -1 : 1;
                    da = sc.getTickCordinates();
                    double dY2 = bo.getTop() + 1.0;
                    double dY1 = bo.getTop() + bo.getHeight() - 2.0;
                    if (pwa.getDimension() == 1) {
                        j = 0;
                        while (j < da.size() - 1) {
                            if (j != 0 && j != da.size() - 2 || !sc.isCategoryScale() || sc.isTickBetweenCategories()) {
                                x = da.getCoordinate(j);
                                k = 0;
                                while (k < doaMinor.length) {
                                    if (!(iDirection == 1 && ChartUtil.mathGE(x + doaMinor[k], da.getCoordinate(j + 1)) || iDirection == -1 && ChartUtil.mathLE(x - doaMinor[k], da.getCoordinate(j + 1)))) {
                                        lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), LineRenderEvent.class);
                                        lre.setLineAttributes(lia);
                                        lre.setStart(goFactory.createLocation(x + (double)iDirection * doaMinor[k], dY1 + pwa.getSeriesThickness()));
                                        lre.setEnd(goFactory.createLocation(x + (double)iDirection * doaMinor[k] + pwa.getSeriesThickness(), dY1));
                                        ipr.drawLine(lre);
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    j = 0;
                    while (j < da.size() - 1) {
                        if (j != 0 && j != da.size() - 2 || !sc.isCategoryScale() || sc.isTickBetweenCategories()) {
                            x = da.getCoordinate(j);
                            vnext = da.getCoordinate(j + 1);
                            if (pwa.getDimension() == 1) {
                                x += pwa.getSeriesThickness();
                                vnext += pwa.getSeriesThickness();
                            }
                            k = 0;
                            while (k < doaMinor.length) {
                                if (!(iDirection == 1 && ChartUtil.mathGE(x + doaMinor[k], vnext) || iDirection == -1 && ChartUtil.mathLE(x - doaMinor[k], vnext))) {
                                    lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), LineRenderEvent.class);
                                    lre.setLineAttributes(lia);
                                    lre.setStart(goFactory.createLocation(x + (double)iDirection * doaMinor[k], dY1));
                                    lre.setEnd(goFactory.createLocation(x + (double)iDirection * doaMinor[k], dY2));
                                    ipr.drawLine(lre);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                } else if (oaxa[i].getOrientation() == 1) {
                    int iDirection = sc.getDirection() != 1 ? -1 : 1;
                    da = sc.getTickCordinates();
                    double dX1 = bo.getLeft() + 1.0;
                    double dX2 = bo.getLeft() + bo.getWidth() - 2.0;
                    if (pwa.getDimension() == 1) {
                        j = 0;
                        while (j < da.size() - 1) {
                            if (j != 0 && j != da.size() - 2 || !sc.isCategoryScale() || sc.isTickBetweenCategories()) {
                                y = da.getCoordinate(j) - pwa.getSeriesThickness();
                                vnext = da.getCoordinate(j + 1) - pwa.getSeriesThickness();
                                k = 0;
                                while (k < doaMinor.length) {
                                    if (!(iDirection == 1 && ChartUtil.mathGE(y + doaMinor[k], vnext) || iDirection == -1 && ChartUtil.mathLE(y - doaMinor[k], vnext))) {
                                        lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), LineRenderEvent.class);
                                        lre.setLineAttributes(lia);
                                        lre.setStart(goFactory.createLocation(dX1, y + (double)iDirection * doaMinor[k]));
                                        lre.setEnd(goFactory.createLocation(dX1 - pwa.getSeriesThickness(), y + (double)iDirection * doaMinor[k] + pwa.getSeriesThickness()));
                                        ipr.drawLine(lre);
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                    j = 0;
                    while (j < da.size() - 1) {
                        if (j != 0 && j != da.size() - 2 || !sc.isCategoryScale() || sc.isTickBetweenCategories()) {
                            y = da.getCoordinate(j);
                            vnext = da.getCoordinate(j + 1);
                            if (pwa.getDimension() == 1) {
                                y -= pwa.getSeriesThickness();
                                vnext -= pwa.getSeriesThickness();
                            }
                            k = 0;
                            while (k < doaMinor.length) {
                                if (!(iDirection == 1 && ChartUtil.mathGE(y + doaMinor[k], vnext) || iDirection == -1 && ChartUtil.mathLE(y - doaMinor[k], vnext))) {
                                    lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), LineRenderEvent.class);
                                    lre.setLineAttributes(lia);
                                    lre.setStart(goFactory.createLocation(dX1, y + (double)iDirection * doaMinor[k]));
                                    lre.setEnd(goFactory.createLocation(dX2, y + (double)iDirection * doaMinor[k]));
                                    ipr.drawLine(lre);
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < oaxa.length) {
            block104: {
                AutoScale sc;
                int STEP_NUMBER;
                block105: {
                    STEP_NUMBER = oaxa[i].getModelAxis().getScale().getMajorGridsStepNumber();
                    lia = oaxa[i].getGrid().getLineAttributes(0);
                    if (lia == null || !lia.isVisible()) break block104;
                    sc = oaxa[i].getScale();
                    if (!this.isDimension3D()) break block105;
                    Line3DRenderEvent lre3d = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), Line3DRenderEvent.class);
                    lre3d.setLineAttributes(lia);
                    switch (oaxa[i].getAxisType()) {
                        case 5: {
                            AxisTickCoordinates xa = scPrimaryBase.getTickCordinates();
                            if (this.floorFill) {
                                int k = 0;
                                while (k < xa.size()) {
                                    lre3d.setStart3D(goFactory.createLocation3D(xa.getCoordinate(k), dYStart, dZStart));
                                    lre3d.setEnd3D(goFactory.createLocation3D(xa.getCoordinate(k), dYStart, dZStart + (double)(ancillaryTickCount - 1) * zStep));
                                    AxesRenderHelper.addLine3DEvent(lre3d, this.o3dFloorEvent, this.getDeferredCache());
                                    k += STEP_NUMBER;
                                }
                            }
                            if (this.rightWallFill) {
                                int k = 0;
                                while (k < xa.size()) {
                                    lre3d.setStart3D(goFactory.createLocation3D(xa.getCoordinate(k), dYStart, dZStart));
                                    lre3d.setEnd3D(goFactory.createLocation3D(xa.getCoordinate(k), dYStart + (double)(orthogonalTickCount - 1) * yStep, dZStart));
                                    AxesRenderHelper.addLine3DEvent(lre3d, this.o3dRightWallEvent, this.getDeferredCache());
                                    k += STEP_NUMBER;
                                }
                            }
                            break block104;
                        }
                        case 9: {
                            AxisTickCoordinates ya = scPrimaryOrthogonal.getTickCordinates();
                            if (this.leftWallFill) {
                                int k = 0;
                                while (k < ya.size()) {
                                    lre3d.setStart3D(goFactory.createLocation3D(dXStart, ya.getCoordinate(k), dZStart));
                                    lre3d.setEnd3D(goFactory.createLocation3D(dXStart, ya.getCoordinate(k), dZStart + (double)(ancillaryTickCount - 1) * zStep));
                                    AxesRenderHelper.addLine3DEvent(lre3d, this.o3dLeftWallEvent, this.getDeferredCache());
                                    k += STEP_NUMBER;
                                }
                            }
                            if (this.rightWallFill) {
                                int k = 0;
                                while (k < ya.size()) {
                                    lre3d.setStart3D(goFactory.createLocation3D(dXStart, ya.getCoordinate(k), dZStart));
                                    lre3d.setEnd3D(goFactory.createLocation3D(dXStart + (double)(baseTickCount - 1) * xStep, ya.getCoordinate(k), dZStart));
                                    AxesRenderHelper.addLine3DEvent(lre3d, this.o3dRightWallEvent, this.getDeferredCache());
                                    k += STEP_NUMBER;
                                }
                            }
                            break block104;
                        }
                        case 17: {
                            int k;
                            AxisTickCoordinates za = scAncillaryBase.getTickCordinates();
                            if (this.leftWallFill) {
                                k = 0;
                                while (k < za.size()) {
                                    lre3d.setStart3D(goFactory.createLocation3D(dXStart, dYStart, za.getCoordinate(k)));
                                    lre3d.setEnd3D(goFactory.createLocation3D(dXStart, dYStart + (double)(orthogonalTickCount - 1) * yStep, za.getCoordinate(k)));
                                    AxesRenderHelper.addLine3DEvent(lre3d, this.o3dLeftWallEvent, this.getDeferredCache());
                                    k += STEP_NUMBER;
                                }
                            }
                            if (this.floorFill) {
                                k = 0;
                                while (k < za.size()) {
                                    lre3d.setStart3D(goFactory.createLocation3D(dXStart, dYStart, za.getCoordinate(k)));
                                    lre3d.setEnd3D(goFactory.createLocation3D(dXStart + (double)(baseTickCount - 1) * xStep, dYStart, za.getCoordinate(k)));
                                    AxesRenderHelper.addLine3DEvent(lre3d, this.o3dFloorEvent, this.getDeferredCache());
                                    k += STEP_NUMBER;
                                }
                            }
                            break block104;
                        }
                    }
                    break block104;
                }
                if (oaxa[i].getOrientation() == 0) {
                    da = sc.getTickCordinates();
                    double dY2 = bo.getTop() + 1.0;
                    double dY1 = bo.getTop() + bo.getHeight() - 2.0;
                    if (pwa.getDimension() == 1) {
                        j = 0;
                        while (j < da.size()) {
                            if (!(j == 0 && !this.needDrawingFirstMajorGridLine(oaxa[i], oaxa) || j == da.size() - 1 && sc.isCategoryScale() && !sc.isTickBetweenCategories())) {
                                x = da.getCoordinate(j);
                                lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), LineRenderEvent.class);
                                lre.setLineAttributes(lia);
                                lre.setStart(goFactory.createLocation(x, dY1 + pwa.getSeriesThickness()));
                                lre.setEnd(goFactory.createLocation(x + pwa.getSeriesThickness(), dY1));
                                ipr.drawLine(lre);
                            }
                            ++j;
                        }
                    }
                    j = 0;
                    while (j < da.size()) {
                        if (!(j == 0 && !this.needDrawingFirstMajorGridLine(oaxa[i], oaxa) || j == da.size() - 1 && sc.isCategoryScale() && !sc.isTickBetweenCategories())) {
                            x = da.getCoordinate(j);
                            if (pwa.getDimension() == 1) {
                                x += pwa.getSeriesThickness();
                            }
                            lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), LineRenderEvent.class);
                            lre.setLineAttributes(lia);
                            lre.setStart(goFactory.createLocation(x, dY1));
                            lre.setEnd(goFactory.createLocation(x, dY2));
                            ipr.drawLine(lre);
                        }
                        j += STEP_NUMBER;
                    }
                } else if (oaxa[i].getOrientation() == 1) {
                    da = sc.getTickCordinates();
                    double dX1 = bo.getLeft() + 1.0;
                    double dX2 = bo.getLeft() + bo.getWidth() - 2.0;
                    if (pwa.getDimension() == 1) {
                        j = 0;
                        while (j < da.size()) {
                            if (!(j == 0 && !this.needDrawingFirstMajorGridLine(oaxa[i], oaxa) || j == da.size() - 1 && sc.isCategoryScale() && !sc.isTickBetweenCategories())) {
                                y = da.getCoordinate(j) - pwa.getSeriesThickness();
                                lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), LineRenderEvent.class);
                                lre.setLineAttributes(lia);
                                lre.setStart(goFactory.createLocation(dX1, y));
                                lre.setEnd(goFactory.createLocation(dX1 - pwa.getSeriesThickness(), y + pwa.getSeriesThickness()));
                                ipr.drawLine(lre);
                            }
                            ++j;
                        }
                    }
                    j = 0;
                    while (j < da.size()) {
                        if (!(j == 0 && !this.needDrawingFirstMajorGridLine(oaxa[i], oaxa) || j == da.size() - 1 && sc.isCategoryScale() && !sc.isTickBetweenCategories())) {
                            y = da.getCoordinate(j);
                            if (pwa.getDimension() == 1) {
                                y -= pwa.getSeriesThickness();
                            }
                            lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createPlot(p), LineRenderEvent.class);
                            lre.setLineAttributes(lia);
                            lre.setStart(goFactory.createLocation(dX1, y));
                            lre.setEnd(goFactory.createLocation(dX2, y));
                            ipr.drawLine(lre);
                        }
                        j += STEP_NUMBER;
                    }
                }
            }
            ++i;
        }
        if (!this.isDimension3D() && p.getClientArea().getOutline().isVisible()) {
            rre.setBounds(bo);
            rre.setOutline(ca.getOutline());
            ipr.drawRectangle(rre);
        }
    }

    private boolean needDrawingFirstMajorGridLine(OneAxis axis, OneAxis[] refAxes) {
        int orientation = axis.getOrientation();
        OneAxis[] oneAxisArray = refAxes;
        int n = refAxes.length;
        int n2 = 0;
        while (n2 < n) {
            OneAxis ax = oneAxisArray[n2];
            if (ax != axis && ax.getOrientation() != orientation && (ax.getIntersectionValue().getType() == 3 || ax.getIntersectionValue().getType() == 1)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private final void renderAxesStructure(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        AllAxes aax = pwa.getAxes();
        if (pwa.getDimension() == 2) {
            this.renderEachAxis(ipr, p, aax.getPrimaryBase(), 5);
            this.renderEachAxis(ipr, p, aax.getAncillaryBase(), 17);
            this.renderEachAxis(ipr, p, aax.getPrimaryOrthogonal(), 9);
        } else {
            int iCount = aax.getOverlayCount() + 2;
            OneAxis[] oaxa = new OneAxis[iCount];
            oaxa[0] = aax.getPrimaryBase();
            oaxa[1] = aax.getPrimaryOrthogonal();
            int i = 0;
            while (i < iCount - 2) {
                oaxa[i + 2] = aax.getOverlay(i);
                IntersectionValue iv = oaxa[i + 2].getIntersectionValue();
                if (iv.getType() == 3) {
                    double dOrigin = Methods.getLocation(aax.getPrimaryBase().getScale(), iv.getValue());
                    if (!ChartUtil.isStudyLayout(this.cm)) {
                        oaxa[i + 2].setAxisCoordinate(dOrigin);
                        oaxa[i + 2].setTitleCoordinate(dOrigin + oaxa[i + 2].getTitleCoordinate());
                    }
                }
                ++i;
            }
            i = 0;
            while (i < iCount) {
                this.renderEachAxis(ipr, p, oaxa[i], 1);
                ++i;
            }
        }
    }

    private final void renderAxesLabels(IPrimitiveRenderer ipr, Plot p, OneAxis[] oaxa) throws ChartException {
        int i = 0;
        while (i < oaxa.length) {
            this.renderEachAxis(ipr, p, oaxa[i], 2);
            ++i;
        }
    }

    @Override
    public void renderPlot(IPrimitiveRenderer ipr, Plot p) throws ChartException {
        if (!p.isVisible()) {
            return;
        }
        boolean bFirstInSequence = this.iSeriesIndex == 0;
        boolean bLastInSequence = this.iSeriesIndex == this.iSeriesCount - 1;
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        if (bFirstInSequence) {
            this.renderBackground(ipr, p);
            this.renderAxesStructure(ipr, p);
        }
        if (this.getSeries() != null || ChartUtil.isDataEmpty(this.rtc)) {
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "beforeDrawSeries", this.getSeries(), this, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawSeries", this.getSeries());
            if (p.getClientArea().isVisible()) {
                this.renderSeries(ipr, p, this.srh);
            }
            ScriptHandler.callFunction(this.getRunTimeContext().getScriptHandler(), "afterDrawSeries", this.getSeries(), this, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawSeries", this.getSeries());
            this.renderAxesDecoration(ipr, this.srh);
        }
        if (bLastInSequence) {
            this.renderMarkerLines();
            Location panningOffset = this.getPanningOffset();
            try {
                if (this.isDimension3D()) {
                    this.fDeferredCacheManager.process3DEvent(null, this.get3DEngine(), panningOffset.getX(), panningOffset.getY());
                }
                this.fDeferredCacheManager.flushAll();
            }
            catch (ChartException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)ex);
            }
            AllAxes aax = pwa.getAxes();
            OneAxis[] oaxa = new OneAxis[2 + aax.getOverlayCount() + (aax.getAncillaryBase() != null ? 1 : 0)];
            oaxa[0] = aax.getPrimaryBase();
            oaxa[1] = aax.getPrimaryOrthogonal();
            int i = 0;
            while (i < aax.getOverlayCount()) {
                oaxa[2 + i] = aax.getOverlay(i);
                ++i;
            }
            if (aax.getAncillaryBase() != null) {
                oaxa[2 + aax.getOverlayCount()] = aax.getAncillaryBase();
            }
            this.renderAxesLabels(ipr, p, oaxa);
            try {
                if (this.isDimension3D()) {
                    this.getDeferredCache().process3DEvent(this.get3DEngine(), panningOffset.getX(), panningOffset.getY());
                }
                this.getDeferredCache().flush();
            }
            catch (ChartException ex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)ex);
            }
        }
    }

    protected void renderAxesDecoration(IPrimitiveRenderer ipr, ISeriesRenderingHints srh) throws ChartException {
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        AllAxes aax = pwa.getAxes();
        if (pwa.getDimension() != 2) {
            int iCount = aax.getOverlayCount() + 2;
            OneAxis[] oaxa = new OneAxis[iCount];
            oaxa[0] = aax.getPrimaryBase();
            oaxa[1] = aax.getPrimaryOrthogonal();
            int i = 0;
            while (i < iCount - 2) {
                oaxa[i + 2] = aax.getOverlay(i);
                ++i;
            }
            i = 0;
            while (i < iCount) {
                IAxesDecorator iad = this.getAxesDecorator(oaxa[i]);
                if (iad != null) {
                    iad.decorateAxes(ipr, srh, oaxa[i]);
                }
                ++i;
            }
        }
    }

    @Override
    public IAxesDecorator getAxesDecorator(OneAxis ax) {
        return null;
    }

    private static FormatSpecifier getValidMarkerLineFormat(MarkerLine mkl) {
        boolean bValid;
        DataElement de = mkl.getValue();
        FormatSpecifier fs = mkl.getFormatSpecifier();
        boolean bl = bValid = de instanceof DateTimeDataElement && (fs instanceof DateFormatSpecifier || fs instanceof JavaDateFormatSpecifier) || de instanceof NumberDataElement && (fs instanceof FractionNumberFormatSpecifier || fs instanceof JavaNumberFormatSpecifier || fs instanceof NumberFormatSpecifier) || de instanceof TextDataElement && fs instanceof StringFormatSpecifier;
        if (bValid) {
            return fs;
        }
        return null;
    }

    private Object getDataElementDefaultFormat(DataElement de, AutoScale as) {
        if (de instanceof BigNumberDataElement) {
            return as.computeDefaultDecimalFormat(((BigNumberDataElement)de).getValue());
        }
        return null;
    }

    private final void renderMarkerLines() throws ChartException {
        PlotWithAxes pwa = (PlotWithAxes)this.getComputations();
        Bounds boPlotClientArea = pwa.getPlotBounds();
        OneAxis[] oaxa = this.getAllOneAxes();
        int iAxisCount = oaxa.length;
        double dCoordinate = 0.0;
        IDeviceRenderer idr = this.getDevice();
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        Location loStart = goFactory.createLocation(0.0, 0.0);
        Location loEnd = goFactory.createLocation(0.0, 0.0);
        TextRenderEvent tre = null;
        Label la = null;
        double dOriginalAngle = 0.0;
        boolean bTransposed = ((ChartWithAxes)this.getModel()).isTransposed();
        Bounds boText = goFactory.createBounds(0.0, 0.0, 0.0, 0.0);
        int i = 0;
        while (i < iAxisCount) {
            Axis ax = oaxa[i].getModelAxis();
            int iOrientation = ax.getOrientation().getValue();
            if (bTransposed) {
                iOrientation = iOrientation == 0 ? 1 : 0;
            }
            AutoScale asc = oaxa[i].getScale();
            EList<MarkerLine> el = ax.getMarkerLines();
            int iLineCount = el.size();
            int j = 0;
            while (j < iLineCount) {
                block51: {
                    EList<Trigger> elTriggers;
                    MarkerLine ml = (MarkerLine)el.get(j);
                    ScriptHandler.callFunction(sh, "beforeDrawMarkerLine", ax, ml, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawMarkerLine", ml);
                    DataElement deValue = ml.getValue();
                    la = goFactory.copyOf(ml.getLabel());
                    if (la.getCaption().getValue() != null && !"".equals(la.getCaption().getValue()) && la.getCaption().getValue().length() > 0) {
                        la.getCaption().setValue(oaxa[i].getRunTimeContext().externalizedMessage(la.getCaption().getValue()));
                    } else {
                        try {
                            la.getCaption().setValue(ValueFormatter.format(deValue, AxesRenderer.getValidMarkerLineFormat(ml), oaxa[i].getRunTimeContext().getULocale(), this.getDataElementDefaultFormat(ml.getValue(), asc)));
                        }
                        catch (ChartException dfex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)dfex);
                        }
                    }
                    if (this.isDimension3D()) {
                        return;
                    }
                    try {
                        dCoordinate = deValue == null ? (iOrientation == 0 ? boPlotClientArea.getLeft() : boPlotClientArea.getTop() + boPlotClientArea.getHeight()) : Methods.getLocation(asc, deValue);
                    }
                    catch (Exception exception) {
                        logger.log(2, Messages.getString("exception.cannot.locate.value.marker.line", new Object[]{deValue, ml}, this.getRunTimeContext().getULocale()));
                        break block51;
                    }
                    LineRenderEvent lre = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerLine(ml), LineRenderEvent.class);
                    if (iOrientation == 0) {
                        double dLeft;
                        double d = dLeft = pwa.getDimension() == 1 ? boPlotClientArea.getLeft() - pwa.getSeriesThickness() : boPlotClientArea.getLeft();
                        if (dCoordinate > dLeft + boPlotClientArea.getWidth()) {
                            dCoordinate = dLeft + boPlotClientArea.getWidth();
                        }
                        if (dCoordinate < dLeft) {
                            dCoordinate = dLeft;
                        }
                        loStart.set(dCoordinate, boPlotClientArea.getTop());
                        loEnd.set(dCoordinate, boPlotClientArea.getTop() + boPlotClientArea.getHeight());
                    } else {
                        double dTop;
                        double d = dTop = pwa.getDimension() == 1 ? boPlotClientArea.getTop() + pwa.getSeriesThickness() : boPlotClientArea.getTop();
                        if (dCoordinate < dTop) {
                            dCoordinate = dTop;
                        }
                        if (dCoordinate > dTop + boPlotClientArea.getHeight()) {
                            dCoordinate = dTop + boPlotClientArea.getHeight();
                        }
                        loStart.set(boPlotClientArea.getLeft(), dCoordinate);
                        loEnd.set(boPlotClientArea.getLeft() + boPlotClientArea.getWidth(), dCoordinate);
                    }
                    if (pwa.getDimension() == 1) {
                        if (iOrientation == 0) {
                            loStart.translate(0.0, pwa.getSeriesThickness());
                            loEnd.translate(0.0, pwa.getSeriesThickness());
                        } else {
                            loStart.translate(-pwa.getSeriesThickness(), 0.0);
                            loEnd.translate(-pwa.getSeriesThickness(), 0.0);
                        }
                    }
                    lre.setStart(loStart);
                    lre.setEnd(loEnd);
                    lre.setLineAttributes(ml.getLineAttributes());
                    idr.drawLine(lre);
                    if (la.isVisible()) {
                        Anchor anc = this.switchAnchor(ml.getLabelAnchor());
                        if (bTransposed) {
                            dOriginalAngle = la.getCaption().getFont().getRotation();
                            try {
                                la.getCaption().getFont().setRotation(pwa.getTransposedAngle(dOriginalAngle));
                                anc = ChartUtil.transposeAnchor(anc);
                            }
                            catch (IllegalArgumentException uiex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)uiex);
                            }
                        }
                        BoundingBox bb = null;
                        try {
                            bb = this.cComp.computeBox(idr.getDisplayServer(), 1, la, 0.0, 0.0);
                        }
                        catch (IllegalArgumentException uiex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 11, (Throwable)uiex);
                        }
                        boText.set(0.0, 0.0, bb.getWidth(), bb.getHeight());
                        if (iOrientation == 1) {
                            if (anc != null) {
                                switch (anc.getValue()) {
                                    case 0: 
                                    case 1: 
                                    case 7: {
                                        boText.setTop(loStart.getY() - boText.getHeight());
                                        break;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 5: {
                                        boText.setTop(loStart.getY());
                                        break;
                                    }
                                    default: {
                                        boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                                    }
                                }
                                switch (anc.getValue()) {
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        boText.setLeft(loEnd.getX() - boText.getWidth());
                                        break;
                                    }
                                    case 5: 
                                    case 6: 
                                    case 7: {
                                        boText.setLeft(loStart.getX());
                                        break;
                                    }
                                    default: {
                                        boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                                        break;
                                    }
                                }
                            } else {
                                boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                                boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                            }
                        } else if (anc != null) {
                            switch (anc.getValue()) {
                                case 0: 
                                case 1: 
                                case 7: {
                                    boText.setTop(loStart.getY());
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: {
                                    boText.setTop(loEnd.getY() - boText.getHeight());
                                    break;
                                }
                                default: {
                                    boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                                }
                            }
                            switch (anc.getValue()) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    boText.setLeft(loStart.getX());
                                    break;
                                }
                                case 5: 
                                case 6: 
                                case 7: {
                                    boText.setLeft(loEnd.getX() - boText.getWidth());
                                    break;
                                }
                                default: {
                                    boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                                    break;
                                }
                            }
                        } else {
                            boText.setLeft(loStart.getX() + (loEnd.getX() - loStart.getX() - boText.getWidth()) / 2.0);
                            boText.setTop(loStart.getY() + (loEnd.getY() - loStart.getY() - boText.getHeight()) / 2.0);
                        }
                        tre = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerLine(ml), TextRenderEvent.class);
                        tre.setBlockBounds(boText);
                        tre.setBlockAlignment(null);
                        tre.setLabel(la);
                        tre.setAction(3);
                        this.getDeferredCache().addLabel(tre);
                    }
                    if (this.isInteractivityEnabled() && !(elTriggers = ml.getTriggers()).isEmpty()) {
                        InteractionEvent iev = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerLine(ml), InteractionEvent.class);
                        iev.setCursor(ml.getCursor());
                        int t = 0;
                        while (t < elTriggers.size()) {
                            Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                            this.processTrigger(tg, StructureSource.createMarkerLine(ml));
                            iev.addTrigger(tg);
                            ++t;
                        }
                        Location[] loaHotspot = new Location[4];
                        if (iOrientation == 0) {
                            loaHotspot[0] = goFactory.createLocation(loStart.getX() - 2.0, loStart.getY());
                            loaHotspot[1] = goFactory.createLocation(loStart.getX() + 2.0, loStart.getY());
                            loaHotspot[2] = goFactory.createLocation(loEnd.getX() + 2.0, loEnd.getY());
                            loaHotspot[3] = goFactory.createLocation(loEnd.getX() - 2.0, loEnd.getY());
                        } else {
                            loaHotspot[0] = goFactory.createLocation(loStart.getX(), loStart.getY() - 2.0);
                            loaHotspot[1] = goFactory.createLocation(loEnd.getX(), loEnd.getY() - 2.0);
                            loaHotspot[2] = goFactory.createLocation(loEnd.getX(), loEnd.getY() + 2.0);
                            loaHotspot[3] = goFactory.createLocation(loStart.getX(), loStart.getY() + 2.0);
                        }
                        PolygonRenderEvent pre = ((EventObjectCache)((Object)idr)).getEventObject(StructureSource.createMarkerLine(ml), PolygonRenderEvent.class);
                        pre.setPoints(loaHotspot);
                        iev.setHotSpot(pre);
                        idr.enableInteraction(iev);
                    }
                    ScriptHandler.callFunction(sh, "afterDrawMarkerLine", ax, ml, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawMarkerLine", ml);
                }
                ++j;
            }
            ++i;
        }
    }

    public final void renderEachAxis(IPrimitiveRenderer ipr, Plot pl, OneAxis ax, int iWhatToDraw) throws ChartException {
        new AxesRenderHelper(this, ipr, pl, ax, iWhatToDraw).renderEachAxis();
    }

    public void set(Chart _cm, PlotComputation _o, Series _se, Axis _ax, SeriesDefinition _sd) {
        super.set(_cm, _o, _se, _sd);
        this.ax = _ax;
    }

    public final boolean isDimension3D() {
        return this.getModel().getDimension() == ChartDimension.THREE_DIMENSIONAL_LITERAL;
    }

    @Override
    public boolean isTransposed() {
        return ((ChartWithAxes)this.getModel()).isTransposed();
    }

    protected int getPrevVisibleSiblingSeriesIndex(int currentIndex) {
        SeriesDefinition sd = null;
        Series se = this.getSeries();
        if (se.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)se.eContainer();
        }
        if (sd != null) {
            int count = 0;
            int idx = sd.getRunTimeSeries().indexOf(se);
            if (idx > 0) {
                int i = idx - 1;
                while (i >= 0) {
                    ++count;
                    if (sd.getRunTimeSeries().get(i).isVisible()) {
                        return currentIndex - count;
                    }
                    --i;
                }
            }
            Axis cax = this.getAxis();
            int iDefintionIndex = cax.getSeriesDefinitions().indexOf((Object)sd);
            int iDefinitionCount = cax.getSeriesDefinitions().size();
            if (iDefinitionCount > 0) {
                int i = iDefintionIndex - 1;
                while (i >= 0) {
                    sd = (SeriesDefinition)cax.getSeriesDefinitions().get(i);
                    int runtimeSeriesCount = sd.getRunTimeSeries().size();
                    int j = runtimeSeriesCount - 1;
                    while (j >= 0) {
                        ++count;
                        if (sd.getRunTimeSeries().get(j).isVisible()) {
                            return currentIndex - count;
                        }
                        --j;
                    }
                    --i;
                }
            }
        }
        return -1;
    }

    public final boolean isLastRuntimeSeriesInAxis() {
        SeriesDefinition sd = null;
        Series se = this.getSeries();
        if (se.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)se.eContainer();
        }
        if (sd != null) {
            Axis cax = this.getAxis();
            int iDefintionIndex = cax.getSeriesDefinitions().indexOf((Object)sd);
            int iDefinitionCount = cax.getSeriesDefinitions().size();
            if (iDefinitionCount > 0 && iDefintionIndex == iDefinitionCount - 1) {
                int iThisSeriesIndex = sd.getRunTimeSeries().indexOf(se);
                int iSeriesCount = sd.getRunTimeSeries().size();
                if (iSeriesCount > 0 && iThisSeriesIndex == iSeriesCount - 1) {
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean isLastRuntimeSeriesInGroup() {
        SeriesDefinition sd = null;
        Series se = this.getSeries();
        if (se.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)se.eContainer();
        }
        if (sd != null) {
            Axis cax = this.getAxis();
            int iDefintionIndex = cax.getSeriesDefinitions().indexOf((Object)sd);
            int iDefinitionCount = cax.getSeriesDefinitions().size();
            if (sd.getRunTimeSeries().size() == 1) {
                if (iDefinitionCount > 0 && iDefintionIndex == iDefinitionCount - 1) {
                    int iThisSeriesIndex = sd.getRunTimeSeries().indexOf(se);
                    int iSeriesCount = sd.getRunTimeSeries().size();
                    if (iSeriesCount > 0 && iThisSeriesIndex == iSeriesCount - 1) {
                        return true;
                    }
                }
            } else if (iDefinitionCount > 0) {
                int iThisSeriesIndex = sd.getRunTimeSeries().indexOf(se);
                int iSeriesCount = sd.getRunTimeSeries().size();
                if (iSeriesCount > 0 && iThisSeriesIndex == iSeriesCount - 1) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected Engine3D get3DEngine() {
        if (this.isDimension3D()) {
            return ((PlotWith3DAxes)this.oComputations).get3DEngine();
        }
        return null;
    }

    @Override
    protected Location getPanningOffset() throws ChartException {
        if (this.isDimension3D()) {
            return ((PlotWith3DAxes)this.oComputations).getPanningOffset();
        }
        return null;
    }

    public final Axis getAxis() {
        return this.ax;
    }

    protected final OneAxis getInternalOrthogonalAxis() {
        AllAxes allAxes = ((PlotWithAxes)this.getComputations()).getAxes();
        if (allAxes.getOverlayCount() == 0) {
            return allAxes.getPrimaryOrthogonal();
        }
        EList<Axis> axesList = ((Axis)this.getAxis().eContainer()).getAssociatedAxes();
        int index = axesList.indexOf((Object)this.getAxis());
        if (index == 0) {
            return allAxes.getPrimaryOrthogonal();
        }
        return allAxes.getOverlay(index - 1);
    }

    protected final OneAxis getInternalBaseAxis() {
        AllAxes allAxes = ((PlotWithAxes)this.getComputations()).getAxes();
        return allAxes.getPrimaryBase();
    }

    protected boolean isShowOutside() {
        return this.getAxis().isPercent() ? false : this.getAxis().getScale().isShowOutside();
    }

    /*
     * Unable to fully structure code
     */
    protected final void handleOutsideDataPoints(IPrimitiveRenderer ipr, SeriesRenderingHints srh, double[] faX, double[] faY, boolean bShowAsTape) {
        scaleOrth = this.getInternalOrthogonalAxis().getScale();
        clipArea = srh.getClientAreaBounds(true);
        boClientArea = AxesRenderer.goFactory.copyOf(clipArea);
        if (bShowAsTape) {
            dSeriesThickness = srh.getSeriesThickness();
            clipArea.delta(-dSeriesThickness, 0.0, 2.0 * dSeriesThickness, dSeriesThickness);
            boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
        }
        this.renderClipping(ipr, clipArea);
        if ((scaleOrth.getType() & 32) == 32) {
            return;
        }
        bHideOutside = this.isShowOutside() == false;
        dpha = srh.getDataPoints();
        isCategory = srh.isCategoryScale();
        bTransposed = this.isTransposed();
        i = 0;
        while (i < dpha.length) {
            block23: {
                block22: {
                    if (isCategory || dpha[i].getBaseValue() != null) break block22;
                    dpha[i].markOutside();
                    break block23;
                }
                iYOutside = 0;
                if (dpha[i].getStackOrthogonalValue() != null) {
                    value = dpha[i].getStackOrthogonalValue();
                    min = Methods.asDouble(scaleOrth.getMinimum());
                    max = Methods.asDouble(scaleOrth.getMaximum());
                    if (value < min) {
                        iYOutside = 1;
                    } else if (value > max) {
                        iYOutside = 2;
                    }
                } else {
                    iYOutside = this.checkEntryByType(scaleOrth, dpha[i].getOrthogonalValue());
                }
                axisBase = this.getInternalBaseAxis();
                iXOutside = 0;
                if (!srh.isCategoryScale()) {
                    iXOutside = this.checkEntryByType(axisBase.getScale(), dpha[i].getBaseValue());
                }
                if (iXOutside <= 0) ** GOTO lbl47
                if (!this.baseIsShowOutside()) {
                    dpha[i].markOutside();
                } else {
                    if (bTransposed) {
                        if (!Double.isNaN(faY[i])) {
                            faY[i] = iXOutside == 1 ? boClientArea.getTop() + boClientArea.getHeight() - 1.0 : boClientArea.getTop() + 1.0;
                        }
                    } else if (!Double.isNaN(faX[i])) {
                        v0 = faX[i] = iXOutside == 1 ? boClientArea.getLeft() + 1.0 : boClientArea.getLeft() + boClientArea.getWidth() - 1.0;
                    }
lbl47:
                    // 5 sources

                    if (iYOutside > 0) {
                        if (bHideOutside) {
                            dpha[i].markOutside();
                        } else if (bTransposed) {
                            if (!Double.isNaN(faX[i])) {
                                faX[i] = iYOutside == 1 ? boClientArea.getLeft() + 1.0 : boClientArea.getLeft() + boClientArea.getWidth() - 1.0;
                            }
                        } else if (!Double.isNaN(faY[i])) {
                            faY[i] = iYOutside == 1 ? boClientArea.getTop() + boClientArea.getHeight() - 1.0 : boClientArea.getTop() + 1.0;
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected final void renderClipping(IPrimitiveRenderer ipr, Bounds boClientArea) {
        boolean bFirstInSequence = this.isFirstVisibleSeries();
        if (!(!bFirstInSequence || this.isDimension3D() || this.isShowOutside() && this.baseIsShowOutside())) {
            ClipRenderEvent clip = new ClipRenderEvent(this);
            Location[] locations = new Location[]{goFactory.createLocation(boClientArea.getLeft(), boClientArea.getTop()), goFactory.createLocation(boClientArea.getLeft(), boClientArea.getTop() + boClientArea.getHeight()), goFactory.createLocation(boClientArea.getLeft() + boClientArea.getWidth(), boClientArea.getTop() + boClientArea.getHeight()), goFactory.createLocation(boClientArea.getLeft() + boClientArea.getWidth(), boClientArea.getTop())};
            clip.setVertices(locations);
            ipr.setClip(clip);
        }
    }

    protected boolean baseIsShowOutside() {
        return this.getInternalBaseAxis().getModelAxis().getScale().isShowOutside();
    }

    protected void restoreClipping(IPrimitiveRenderer ipr) throws ChartException {
        boolean bLastInSequence = this.isLastSeries();
        if (!(!bLastInSequence || this.isDimension3D() || this.isShowOutside() && this.baseIsShowOutside())) {
            this.flushClipping();
            ClipRenderEvent clip = new ClipRenderEvent(this);
            clip.setVertices(null);
            ipr.setClip(clip);
        }
    }

    protected void flushClipping() throws ChartException {
        this.getDeferredCacheManager().flushOptions(39);
    }

    protected final int checkEntryByType(AutoScale scale, Object entry) {
        int iOutside = 0;
        iOutside = entry == null ? (scale.isCategoryScale() ? 0 : 1) : (scale.getMinimum() == null || scale.getMaximum() == null ? 0 : (entry instanceof Number ? this.checkEntryInNumberRange((Number)entry, scale.getMinimum(), scale.getMaximum()) : (entry instanceof CDateTime ? this.checkEntryInDatetimeRange((CDateTime)((Object)entry), scale.getMinimum(), scale.getMaximum()) : this.checkEntryInRange(entry, scale.getMinimum(), scale.getMaximum()))));
        return iOutside;
    }

    protected final int checkEntryInNumberRange(Number entry, Object min, Object max) {
        int iOutside = 0;
        double value = entry.doubleValue();
        double dmin = Methods.asDouble(min);
        double dmax = Methods.asDouble(max);
        if (value < dmin) {
            iOutside = 1;
        } else if (value > dmax) {
            iOutside = 2;
        }
        return iOutside;
    }

    protected final int checkEntryInDatetimeRange(CDateTime entry, Object min, Object max) {
        int iOutside = 0;
        CDateTime cmin = Methods.asDateTime(min);
        CDateTime cmax = Methods.asDateTime(max);
        if (entry.before((Object)cmin)) {
            if (CDateTime.getDifference(entry, cmin) != 0) {
                iOutside = 1;
            }
        } else if (entry.after((Object)cmax) && CDateTime.getDifference(entry, cmax) != 0) {
            iOutside = 2;
        }
        return iOutside;
    }

    protected int checkEntryInRange(Object entry, Object min, Object max) {
        return 0;
    }

    protected void addInteractivity(IPrimitiveRenderer ipr, DataPointHints dph, PrimitiveRenderEvent event) throws ChartException {
        EList<Trigger> elTriggers = this.se.getTriggers();
        if (!elTriggers.isEmpty()) {
            StructureSource iSource = WrappedStructureSource.createSeriesDataPoint(this.se, dph);
            InteractionEvent iev = ((EventObjectCache)((Object)ipr)).getEventObject(iSource, InteractionEvent.class);
            iev.setCursor(this.se.getCursor());
            int t = 0;
            while (t < elTriggers.size()) {
                Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                this.processTrigger(tg, iSource);
                iev.addTrigger(tg);
                ++t;
            }
            if (event instanceof I3DRenderEvent) {
                Location panningOffset = this.getPanningOffset();
                PrimitiveRenderEvent copy = event.copy();
                if (this.get3DEngine().processEvent(copy, panningOffset.getX(), panningOffset.getY()) != null) {
                    iev.setHotSpot(copy);
                    ipr.enableInteraction(iev);
                }
            } else {
                iev.setHotSpot(event);
                ipr.enableInteraction(iev);
            }
        }
    }

    protected final DataPointHints createDummyDataPointHintsForLegendItem() throws ChartException {
        if (this.getSeries() == null) {
            return null;
        }
        return new DataPointHints(null, null, this.getSeries().getSeriesIdentifier(), null, this.getSeries().getDataPoint(), null, null, null, null, -1, null, 0.0, this.rtc);
    }

    @Override
    protected boolean isFirstVisibleSeries() {
        if (ChartUtil.hasMultipleYAxes(this.getModel()) && ((ChartWithAxes)this.getModel()).isStudyLayout()) {
            ArrayList<SeriesDefinition> sdList = new ArrayList<SeriesDefinition>((Collection<SeriesDefinition>)this.ax.getSeriesDefinitions());
            Collections.sort(sdList, zOrderComparatorImpl);
            ArrayList<Series> seList = new ArrayList<Series>();
            for (SeriesDefinition sd : sdList) {
                seList.addAll(sd.getRunTimeSeries());
            }
            BaseRenderer renderer = this.getRenderer(this.iSeriesIndex);
            Series s = renderer.getSeries();
            for (Series series : seList) {
                if (!series.isVisible()) continue;
                return s == series;
            }
        } else {
            if (this.iSeriesIndex == 0) {
                return false;
            }
            int i = 1;
            while (i < this.iSeriesCount) {
                BaseRenderer renderer = this.getRenderer(i);
                if (renderer.getSeries().isVisible()) {
                    return i == this.iSeriesIndex;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    protected boolean isLastSeries() {
        if (ChartUtil.hasMultipleYAxes(this.getModel()) && ((ChartWithAxes)this.getModel()).isStudyLayout()) {
            ArrayList<SeriesDefinition> sdList = new ArrayList<SeriesDefinition>((Collection<SeriesDefinition>)this.ax.getSeriesDefinitions());
            Collections.sort(sdList, zOrderComparatorImpl);
            ArrayList<Series> seList = new ArrayList<Series>();
            for (SeriesDefinition sd : sdList) {
                seList.addAll(sd.getRunTimeSeries());
            }
            BaseRenderer renderer = this.getRenderer(this.iSeriesIndex);
            Series s = renderer.getSeries();
            return s == seList.get(seList.size() - 1);
        }
        if (this.iSeriesIndex == 0) {
            return false;
        }
        return this.iSeriesIndex == this.iSeriesCount - 1;
    }

    private static class FittingCurveHelper {
        private final double[] baseArray;
        private final double[] orthogonalArray;

        private FittingCurveHelper(double[][] sa, int iSize) {
            iSize = Math.min(iSize, sa.length);
            this.baseArray = new double[iSize];
            this.orthogonalArray = new double[iSize];
            int i = 0;
            while (i < iSize) {
                this.baseArray[i] = sa[i][0];
                this.orthogonalArray[i] = sa[i][1];
                ++i;
            }
        }

        public double[] getBaseArray() {
            return this.baseArray;
        }

        public double[] getOrthogonalArray() {
            return this.orthogonalArray;
        }

        public static FittingCurveHelper instance(double[] xArray, double[] yArray, boolean isTransposed) {
            double[][] sa = FittingCurveHelper.sort(xArray, yArray, isTransposed);
            int iSize = FittingCurveHelper.mergeBase(sa);
            return new FittingCurveHelper(sa, iSize);
        }

        private static int mergeBase(double[][] sa) {
            int iLen = sa.length;
            int iDst = 0;
            int iSrc = 0;
            while (iSrc < iLen) {
                int iEq = 1;
                double dOrthTotal = sa[iSrc][1];
                double dBase = sa[iSrc][0];
                while (iSrc + iEq < iLen && sa[iSrc + iEq][0] == dBase) {
                    dOrthTotal += sa[iSrc + iEq][1];
                    ++iEq;
                }
                sa[iDst][1] = dOrthTotal / (double)iEq;
                sa[iDst][0] = dBase;
                ++iDst;
                iSrc += iEq;
            }
            return iDst;
        }

        private static double[][] sort(double[] a, double[] b, boolean isTransposed) {
            double[] baseArray = isTransposed ? b : a;
            double[] orthogonalArray = isTransposed ? a : b;
            double[][] sa = new double[a.length][2];
            int i = 0;
            while (i < a.length) {
                double[] ca = new double[]{baseArray[i], orthogonalArray[i]};
                sa[i] = ca;
                ++i;
            }
            Arrays.sort(sa, new Comparator<double[]>(){

                @Override
                public int compare(double[] l1, double[] l2) {
                    if (l1[0] == l2[0]) {
                        return 0;
                    }
                    if (l1[0] < l2[0]) {
                        return -1;
                    }
                    return 1;
                }
            });
            return sa;
        }
    }
}

