/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.stream;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.stream.StreamID;
import org.eclipse.birt.data.engine.impl.document.stream.StreamReader;
import org.eclipse.birt.data.engine.impl.document.stream.WrapperedRAInputStream;

public class MetaStreamReader
extends StreamReader {
    private static Logger logger = Logger.getLogger(MetaStreamReader.class.getName());

    public MetaStreamReader(DataEngineContext context, StreamID id) throws DataException {
        try {
            this.streamMap = new HashMap();
            this.id = id;
            this.context = context;
            RAInputStream is = context.getInputStream(id.getStartStream(), id.getSubQueryStream(), 100);
            DataInputStream metaIndexStream = new DataInputStream(is);
            while (is.getOffset() != is.length()) {
                int type = IOUtil.readInt(metaIndexStream);
                long offset = IOUtil.readLong(metaIndexStream);
                int size = IOUtil.readInt(metaIndexStream);
                this.streamMap.put(type, new OffsetInfo(offset, size));
            }
            metaIndexStream.close();
        }
        catch (IOException e) {
            throw new DataException(e.getLocalizedMessage());
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public RAInputStream getRAInputStream(int streamType) throws DataException {
        temp = this.streamMap.get(streamType);
        if (temp == null) {
            throw new DataException("data.engine.document.error.cannotLoadStream", DataEngineContext.getPath(this.id.getStartStream(), this.id.getSubQueryStream(), streamType));
        }
        try {
            oi = (OffsetInfo)temp;
            offset = OffsetInfo.access$0(oi);
            size = OffsetInfo.access$1(oi);
            metaStream = new WrapperedRAInputStream(this.context.getInputStream(this.id.getStartStream(), this.id.getSubQueryStream(), this.getCollectionStreamType()), offset, size);
            return metaStream;
        }
        catch (Exception e) {
            log = "Meta Info:\n";
            ** for (o : this.streamMap.keySet())
        }
lbl-1000:
        // 1 sources

        {
            log = String.valueOf(log) + o + ":" + this.streamMap.get(o) + "\n";
            continue;
        }
lbl15:
        // 1 sources

        log = String.valueOf(log) + " Error while load (" + streamType + "):" + temp;
        MetaStreamReader.logger.warning(log);
        throw new DataException(e.getLocalizedMessage(), e);
    }

    protected int getCollectionStreamType() {
        return 99;
    }

    private static class OffsetInfo {
        private long offset;
        private int size;

        public OffsetInfo(long offset, int size) {
            this.offset = offset;
            this.size = size;
        }

        public String toString() {
            return "[" + this.offset + "," + this.size + "]";
        }

        static /* synthetic */ long access$0(OffsetInfo offsetInfo) {
            return offsetInfo.offset;
        }

        static /* synthetic */ int access$1(OffsetInfo offsetInfo) {
            return offsetInfo.size;
        }
    }
}

