/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.cache.Constants;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRowComparator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.BaseAggregationCalculator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.FacttableRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.SortedAggregationRowArray;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class RunningFunctionCalculator
extends BaseAggregationCalculator {
    boolean needMultiplePass;

    RunningFunctionCalculator(AggregationDefinition aggregation, IAggregationResultSet aggrResultSet) throws DataException, IOException {
        super(aggregation, aggrResultSet);
        this.keyLevelIndex = (int[])(aggrResultSet.getAllLevels() != null ? this.getKeyLevelIndexs(aggrResultSet.getAllLevels()) : null);
        this.facttableRow = new FacttableRow(this.getMeasureInfo(), null, null);
        this.needMultiplePass = RunningFunctionCalculator.needMultiplePass(aggregation);
        this.sortTypes = aggregation.getSortTypes();
    }

    private static boolean needMultiplePass(AggregationDefinition aggrDef) throws DataException {
        AggregationFunctionDefinition[] aggregationFunction = aggrDef.getAggregationFunctions();
        if (aggregationFunction != null) {
            IAggrFunction aggregation = AggregationManager.getInstance().getAggregation(aggregationFunction[0].getFunctionName());
            if (aggregation == null) {
                throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.UnsupportedFunction")) + aggregationFunction[0].getFunctionName());
            }
            return aggregation.getNumberOfPasses() > 1;
        }
        return false;
    }

    @Override
    public IAggregationResultSet execute(StopSign stopSign) throws IOException, DataException {
        AggregationResultRowComparator comparator = null;
        if (this.aggregation.getLevels() != null) {
            comparator = new AggregationResultRowComparator(this.getKeyLevelIndexs(this.aggregation.getLevels()), this.sortTypes);
        }
        SortedAggregationRowArray sortedRows = new SortedAggregationRowArray(this.aggrResultSet, this.aggregation.getLevels(), this.sortTypes);
        BufferedStructureArray result = new BufferedStructureArray(AggregationResultRow.getCreator(), Constants.LIST_BUFFER_SIZE);
        if (this.aggrResultSet.length() <= 0) {
            return this.getAggregationResultSet(result);
        }
        IAggregationResultRow lastRow = sortedRows.get(0);
        IAggregationResultRow currentRow = null;
        int lastIndex = 0;
        this.onRow(lastRow);
        if (!this.needMultiplePass) {
            this.addOneResultRow(result, lastRow);
        }
        int i = 1;
        while (!stopSign.isStopped() && i < sortedRows.size()) {
            currentRow = sortedRows.get(i);
            if (comparator != null && comparator.compare(currentRow, lastRow) != 0) {
                if (this.needMultiplePass) {
                    this.secondPass(sortedRows, result, lastIndex, i);
                    lastIndex = i;
                }
                this.createAccumulators();
            }
            this.onRow(currentRow);
            if (!this.needMultiplePass) {
                this.addOneResultRow(result, currentRow);
            }
            lastRow = currentRow;
            ++i;
        }
        if (this.needMultiplePass) {
            this.secondPass(sortedRows, result, lastIndex, sortedRows.size());
        }
        return this.getAggregationResultSet(result);
    }

    private void secondPass(SortedAggregationRowArray sortedRows, IDiskArray result, int startIndex, int endIndex) throws DataException, IOException {
        if (this.accumulators != null) {
            int j = 0;
            while (j < this.accumulators.length) {
                this.accumulators[j].finish();
                this.accumulators[j].start();
                ++j;
            }
        }
        int i = startIndex;
        while (i < endIndex) {
            IAggregationResultRow row = sortedRows.get(i);
            this.onRow(row);
            this.addOneResultRow(result, row);
            ++i;
        }
    }

    private void addOneResultRow(IDiskArray result, IAggregationResultRow lastRow) throws DataException, IOException {
        AggregationResultRow resultRow = this.newAggregationResultRow(lastRow);
        if (this.accumulators != null) {
            int j = 0;
            while (j < this.accumulators.length) {
                resultRow.getAggregationValues()[j] = this.accumulators[j].getValue();
                ++j;
            }
        }
        result.add(resultRow);
    }

    private IAggregationResultSet getAggregationResultSet(IDiskArray result) throws IOException {
        return new AggregationResultSet(this.aggregation, this.aggrResultSet.getAllLevels(), result, this.getKeyNames(), this.getAttributeNames());
    }
}

