/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationResultSetSaveUtil;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.MergedAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.CubeResultSet;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.impl.query.CubeOperationsExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinitionIOUtil;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.IPreparedCubeOperation;
import org.eclipse.birt.data.engine.olap.impl.query.IncrementExecutionHint;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedAddingNestAggregations;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryValidator;
import org.eclipse.birt.data.engine.olap.query.view.DrillOperationExecutor;
import org.eclipse.birt.data.engine.olap.query.view.IQueryExecutor;
import org.eclipse.birt.data.engine.olap.query.view.MirrorOperationExecutor;
import org.eclipse.birt.data.engine.olap.query.view.NoUpdateAggregateFilterHelper;
import org.eclipse.birt.data.engine.olap.query.view.QueryExecutorUtil;
import org.eclipse.birt.data.engine.olap.util.CubeAggrDefn;
import org.eclipse.birt.data.engine.olap.util.CubeNestAggrDefn;
import org.eclipse.birt.data.engine.olap.util.DrillFilterHelper;

public class QueryExecutorV0
implements IQueryExecutor {
    private CubeQueryExecutorHelper cubeQueryExecutorHelper;
    private NoUpdateAggregateFilterHelper noUpdateFilterHelper;

    @Override
    public IResultSet execute(BirtCubeView view, StopSign stopSign, ICube cube, IBindingValueFetcher fetcher) throws IOException, BirtException {
        CubeQueryExecutor executor = view.getCubeQueryExecutor();
        AggregationDefinition[] cube_Aggregation = QueryExecutorUtil.prepareCube(executor.getCubeQueryDefinition(), view.getAggregationRegisterTable().getCalculatedMembersFromQuery(), executor.getScope(), executor.getSession().getEngineContext().getScriptContext());
        if (cube_Aggregation == null || cube_Aggregation.length == 0) {
            return null;
        }
        AggregationDefinition[] drilled_aggregation = DrillFilterHelper.preparedDrillAggregation(executor.getCubeQueryDefinition(), cube_Aggregation);
        int size = cube_Aggregation.length + drilled_aggregation.length;
        AggregationDefinition[] finalAggregation = new AggregationDefinition[size];
        if (drilled_aggregation.length > 0) {
            System.arraycopy(cube_Aggregation, 0, finalAggregation, 0, cube_Aggregation.length);
            System.arraycopy(drilled_aggregation, 0, finalAggregation, cube_Aggregation.length, drilled_aggregation.length);
        } else {
            finalAggregation = cube_Aggregation;
        }
        String cubeName = executor.getCubeQueryDefinition().getName();
        if (cubeName == null || cubeName.trim().length() == 0) {
            throw new DataException("data.olap.query.noCubeBinding");
        }
        CubeQueryValidator.validateCubeQueryDefinition(view, cube);
        this.noUpdateFilterHelper = new NoUpdateAggregateFilterHelper();
        this.cubeQueryExecutorHelper = new CubeQueryExecutorHelper(cube, executor.getComputedMeasureHelper(), fetcher);
        this.cubeQueryExecutorHelper.setCubeQueryExecutor(executor);
        this.cubeQueryExecutorHelper.setMemoryCacheSize(CacheUtil.computeMemoryBufferSize(view.getAppContext()));
        this.cubeQueryExecutorHelper.setAppContext(view.getAppContext());
        this.cubeQueryExecutorHelper.setMaxDataObjectRows(CacheUtil.getMaxRows(view.getAppContext()));
        this.cubeQueryExecutorHelper.addJSFilter(executor.getDimensionFilterEvalHelpers());
        this.cubeQueryExecutorHelper.addSimpleLevelFilter(executor.getdimensionSimpleFilter());
        this.cubeQueryExecutorHelper.addAggrMeasureFilter(executor.getMeasureFilterEvalHelpers());
        this.cubeQueryExecutorHelper.addMeasureFilter(executor.getFacttableBasedFilterHelpers());
        QueryExecutorUtil.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 2);
        QueryExecutorUtil.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 1);
        QueryExecutorUtil.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 3);
        IAggregationResultSet[] rs = null;
        this.cubeQueryExecutorHelper.setBreakHierarchy(executor.getCubeQueryDefinition().getFilterOption() == 0);
        switch (executor.getContext().getMode()) {
            case 1: {
                rs = this.populateRs(view, finalAggregation, this.cubeQueryExecutorHelper, stopSign, true, fetcher);
                rs = this.processOperationOnQuery(executor, view, stopSign, rs, cube_Aggregation, fetcher);
                break;
            }
            case 3: {
                rs = this.populateRs(view, finalAggregation, this.cubeQueryExecutorHelper, stopSign, false, fetcher);
                rs = this.processOperationOnQuery(executor, view, stopSign, rs, cube_Aggregation, fetcher);
                break;
            }
            case 2: {
                if (executor.getCubeQueryDefinition().getQueryResultsID() != null) {
                    rs = AggregationResultSetSaveUtil.load(executor.getCubeQueryDefinition().getQueryResultsID(), executor.getContext().getDocReader(), new VersionManager(executor.getContext()).getVersion(executor.getCubeQueryDefinition().getQueryResultsID()), this.cubeQueryExecutorHelper.getMemoryCacheSize());
                    QueryExecutorUtil.initLoadedAggregationResultSets(rs, finalAggregation);
                    rs = this.processOperationOnQuery(executor, view, stopSign, rs, cube_Aggregation, fetcher);
                    break;
                }
                rs = this.cubeQueryExecutorHelper.execute(finalAggregation, stopSign);
                rs = QueryExecutorUtil.applyFilterOnOperation(view, this.cubeQueryExecutorHelper, executor, finalAggregation, rs, fetcher, stopSign);
                rs = this.noUpdateFilterHelper.applyNoAggrUpdateFilters(executor.getCubeQueryDefinition().getFilters(), executor, rs, cube, fetcher, false);
                MirrorOperationExecutor moe = new MirrorOperationExecutor();
                rs = moe.execute(rs, view, this.cubeQueryExecutorHelper);
                QueryExecutorUtil.validateLimitSetting(view, rs);
                rs = this.processOperationOnQuery(executor, view, stopSign, rs, cube_Aggregation, fetcher);
                break;
            }
            default: {
                String id = executor.getCubeQueryDefinition().getQueryResultsID();
                IncrementExecutionHint ieh = null;
                if (CubeQueryDefinitionIOUtil.existStream(executor.getContext().getDocReader(), id)) {
                    ICubeQueryDefinition savedQuery = CubeQueryDefinitionIOUtil.load(id, executor.getContext());
                    ieh = CubeQueryDefinitionUtil.getIncrementExecutionHint(savedQuery, executor.getCubeQueryDefinition());
                }
                if (!CubeQueryDefinitionIOUtil.existStream(executor.getContext().getDocReader(), id) || ieh == null || !ieh.isNoIncrement() && executor.getCubeQueryDefinition().getCubeOperations().length > 0) {
                    rs = this.cubeQueryExecutorHelper.execute(finalAggregation, stopSign);
                    rs = QueryExecutorUtil.applyFilterOnOperation(view, this.cubeQueryExecutorHelper, executor, finalAggregation, rs, fetcher, stopSign);
                    rs = this.noUpdateFilterHelper.applyNoAggrUpdateFilters(executor.getCubeQueryDefinition().getFilters(), executor, rs, cube, fetcher, false);
                    MirrorOperationExecutor moe = new MirrorOperationExecutor();
                    rs = moe.execute(rs, view, this.cubeQueryExecutorHelper);
                    QueryExecutorUtil.validateLimitSetting(view, rs);
                } else {
                    rs = AggregationResultSetSaveUtil.load(id, executor.getContext().getDocReader(), new VersionManager(executor.getContext()).getVersion(id), this.cubeQueryExecutorHelper.getMemoryCacheSize());
                    QueryExecutorUtil.initLoadedAggregationResultSets(rs, finalAggregation);
                    this.incrementExecute(rs, ieh);
                    if (ieh.getFilters() != null && ieh.getFilters().length > 0) {
                        IFilterDefinition[] filters = ieh.getFilters();
                        ArrayList<IFilterDefinition> finalFilters = new ArrayList<IFilterDefinition>();
                        int j = 0;
                        while (j < filters.length) {
                            finalFilters.add(filters[j]);
                            ++j;
                        }
                        rs = this.noUpdateFilterHelper.applyNoAggrUpdateFilters(finalFilters, executor, rs, cube, fetcher, false);
                    }
                }
                if (executor.getContext().getDocWriter() != null) {
                    if (id == null) {
                        id = executor.getSession().getQueryResultIDUtil().nextID();
                    }
                    CubeQueryDefinitionIOUtil.save(id, executor.getContext(), executor.getCubeQueryDefinition());
                    AggregationResultSetSaveUtil.save(id, rs, executor.getContext().getDocWriter());
                    executor.setQueryResultsId(id);
                }
                rs = this.processOperationOnQuery(executor, view, stopSign, rs, cube_Aggregation, fetcher);
            }
        }
        return new CubeResultSet(rs, view, this.cubeQueryExecutorHelper);
    }

    private IAggregationResultSet[] processOperationOnQuery(CubeQueryExecutor executor, BirtCubeView view, StopSign stopSign, IAggregationResultSet[] resultSet, AggregationDefinition[] aggrDefns, IBindingValueFetcher fetcher) throws DataException, IOException, BirtException {
        IAggregationResultSet[] rs = new IAggregationResultSet[aggrDefns.length];
        System.arraycopy(resultSet, 0, rs, 0, aggrDefns.length);
        IAggregationResultSet[] drillRs = new IAggregationResultSet[resultSet.length - aggrDefns.length];
        System.arraycopy(resultSet, aggrDefns.length, drillRs, 0, drillRs.length);
        CubeOperationsExecutor coe = new CubeOperationsExecutor(view.getCubeQueryDefinition(), view.getPreparedCubeOperations(), view.getCubeQueryExecutor().getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext());
        int rsLenBefore = rs.length;
        rs = coe.execute(rs, stopSign, fetcher);
        int rsLenAfter = rs.length;
        List noAggrUpdateFilters = this.noUpdateFilterHelper.getNoAggrUpdateFilters(executor.getCubeQueryDefinition().getFilters());
        if (noAggrUpdateFilters.size() > 0) {
            int i;
            IAggregationResultSet[] result = null;
            if (rsLenBefore < rsLenAfter) {
                result = new IAggregationResultSet[rsLenAfter - rsLenBefore];
                int i2 = 0;
                while (i2 < result.length) {
                    result[i2] = rs[rsLenBefore + i2];
                    ++i2;
                }
                result = this.noUpdateFilterHelper.applyNoAggrUpdateFilters(noAggrUpdateFilters, executor, result, view.getCube(), fetcher, true);
                i2 = 0;
                while (i2 < result.length) {
                    rs[i2 + rsLenBefore] = result[i2];
                    ++i2;
                }
            } else if (rsLenBefore == rsLenAfter) {
                ArrayList<IAggregationResultSet> mergedResult = new ArrayList<IAggregationResultSet>();
                i = 0;
                while (i < rs.length) {
                    if (rs[i].getAggregationDefinition().getAggregationFunctions() != null && rs[i] instanceof MergedAggregationResultSet) {
                        IAggregationResultSet[] applyResults = this.noUpdateFilterHelper.applyNoAggrUpdateFilters(noAggrUpdateFilters, executor, new IAggregationResultSet[]{rs[i]}, view.getCube(), fetcher, true);
                        rs[i] = applyResults[0];
                        mergedResult.add(rs[i]);
                    }
                    ++i;
                }
                result = mergedResult.toArray(new IAggregationResultSet[0]);
            }
            List<IAggregationResultSet> edgeResultSet = this.noUpdateFilterHelper.populateAndFilterEdgeResultSet(rs, null);
            i = 0;
            while (i < edgeResultSet.size()) {
                int j = 0;
                while (j < result.length) {
                    this.noUpdateFilterHelper.applyJoin(edgeResultSet.get(i), result[j]);
                    ++j;
                }
                ++i;
            }
        }
        if (DrillFilterHelper.containsDrillFilter(view.getCubeQueryDefinition())) {
            IPreparedCubeOperation[] ops = view.getPreparedCubeOperations();
            ArrayList<PreparedAddingNestAggregations> operations = new ArrayList<PreparedAddingNestAggregations>();
            ArrayList<CubeNestAggrDefn> nestedAggr = new ArrayList<CubeNestAggrDefn>();
            ArrayList<AggregationDefinition> aggregations = new ArrayList<AggregationDefinition>();
            int i = 0;
            while (i < ops.length) {
                List<AggregationDefinition> nested_aggregation = ops[i].getAggregationDefintions();
                int k = 0;
                while (k < nested_aggregation.size()) {
                    AggregationDefinition[] drilled_nested_aggregation;
                    AggregationDefinition[] aggregationDefinitionArray = drilled_nested_aggregation = DrillFilterHelper.preparedDrillForNestedAggregation(executor.getCubeQueryDefinition(), new CubeAggrDefn[]{ops[i].getNewCubeAggrDefns()[k]}, new AggregationDefinition[]{nested_aggregation.get(k)});
                    int n = drilled_nested_aggregation.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AggregationDefinition aggregation = aggregationDefinitionArray[n2];
                        CubeNestAggrDefn defn = (CubeNestAggrDefn)ops[i].getNewCubeAggrDefns()[k];
                        nestedAggr.add(new CubeNestAggrDefn(defn.getName(), defn.getBasedExpression(), Arrays.asList(ops[i].getNewCubeAggrDefns()[k]), defn.getAggrName(), defn.getArguments(), defn.getFilter()));
                        aggregations.add(aggregation);
                        ++n2;
                    }
                    ++k;
                }
                if (!nestedAggr.isEmpty()) {
                    PreparedAddingNestAggregations drill_coe = new PreparedAddingNestAggregations();
                    drill_coe.prepare(executor.getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext(), view.getAggregationRegisterTable(), nestedAggr.toArray(new CubeNestAggrDefn[0]), aggregations);
                    operations.add(drill_coe);
                }
                ++i;
            }
            if (!operations.isEmpty()) {
                coe = new CubeOperationsExecutor(view.getCubeQueryDefinition(), operations.toArray(new PreparedAddingNestAggregations[0]), view.getCubeQueryExecutor().getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext());
                drillRs = coe.execute(drillRs, stopSign, fetcher);
            }
            DrillOperationExecutor drillOp = new DrillOperationExecutor();
            rs = drillOp.execute(rs, drillRs, view.getCubeQueryDefinition());
        }
        return rs;
    }

    private void incrementExecute(IAggregationResultSet[] baseResultSets, IncrementExecutionHint ieh) throws DataException, IOException {
        assert (baseResultSets != null && ieh != null);
        this.applyIncrementSorts(baseResultSets);
    }

    private void applyIncrementSorts(IAggregationResultSet[] baseResultSets) throws DataException, IOException {
        int i = 0;
        while (i < baseResultSets.length) {
            if (baseResultSets[i].getAggregationCount() == 0) {
                baseResultSets[i] = QueryExecutorUtil.sortAggregationResultSet(baseResultSets[i]);
            }
            ++i;
        }
        this.cubeQueryExecutorHelper.applyAggrSort(baseResultSets);
    }

    private IAggregationResultSet[] populateRs(BirtCubeView view, AggregationDefinition[] aggrDefns, CubeQueryExecutorHelper cubeQueryExcutorHelper2, StopSign stopSign, boolean saveToRD, IBindingValueFetcher fetcher) throws IOException, BirtException {
        IAggregationResultSet[] rs = null;
        String id = null;
        CubeQueryExecutor executor = view.getCubeQueryExecutor();
        if (executor.getCubeQueryDefinition().getQueryResultsID() == null) {
            if (saveToRD || executor.getCubeQueryDefinition().cacheQueryResults()) {
                id = executor.getSession().getQueryResultIDUtil().nextID();
            }
            rs = this.executeQuery(view, aggrDefns, saveToRD, id, fetcher);
        } else {
            id = executor.getCubeQueryDefinition().getQueryResultsID();
            if (executor.getCubeQueryDefinition().cacheQueryResults()) {
                rs = AggregationResultSetSaveUtil.load(id, new FileArchiveReader(String.valueOf(executor.getSession().getTempDir()) + "Cache"), VersionManager.getLatestVersion(), this.cubeQueryExecutorHelper.getMemoryCacheSize());
                QueryExecutorUtil.initLoadedAggregationResultSets(rs, aggrDefns);
            } else if (executor.getContext().getDocReader() != null && executor.getContext().getMode() != 1) {
                rs = AggregationResultSetSaveUtil.load(executor.getCubeQueryDefinition().getQueryResultsID(), executor.getContext().getDocReader(), new VersionManager(executor.getContext()).getVersion(id), this.cubeQueryExecutorHelper.getMemoryCacheSize());
                QueryExecutorUtil.initLoadedAggregationResultSets(rs, aggrDefns);
            } else {
                rs = this.executeQuery(view, aggrDefns, saveToRD, id, fetcher);
            }
        }
        executor.setQueryResultsId(id);
        return rs;
    }

    private IAggregationResultSet[] executeQuery(BirtCubeView view, AggregationDefinition[] aggrDefns, boolean saveToRD, String queryResutID, IBindingValueFetcher fetcher) throws IOException, BirtException {
        CubeQueryExecutor executor = view.getCubeQueryExecutor();
        IAggregationResultSet[] rs = this.cubeQueryExecutorHelper.execute(aggrDefns, executor.getSession().getStopSign());
        rs = QueryExecutorUtil.applyFilterOnOperation(view, this.cubeQueryExecutorHelper, executor, aggrDefns, rs, fetcher, executor.getSession().getStopSign());
        rs = this.noUpdateFilterHelper.applyNoAggrUpdateFilters(executor.getCubeQueryDefinition().getFilters(), executor, rs, view.getCube(), fetcher, false);
        MirrorOperationExecutor moe = new MirrorOperationExecutor();
        rs = moe.execute(rs, view, this.cubeQueryExecutorHelper);
        QueryExecutorUtil.validateLimitSetting(view, rs);
        if (executor.getCubeQueryDefinition().cacheQueryResults()) {
            File tmpDir = new File(executor.getSession().getTempDir());
            if (!FileSecurity.fileExist(tmpDir) || !FileSecurity.fileIsDirectory(tmpDir)) {
                FileSecurity.fileMakeDirs(tmpDir);
            }
            ArchiveWriter writer = new ArchiveWriter(new ArchiveFile(String.valueOf(executor.getSession().getTempDir()) + "Cache", "rw+"));
            AggregationResultSetSaveUtil.save(queryResutID, rs, writer);
            writer.finish();
        }
        if (saveToRD) {
            CubeQueryDefinitionIOUtil.save(queryResutID, executor.getContext(), executor.getCubeQueryDefinition());
            AggregationResultSetSaveUtil.save(queryResutID, rs, executor.getContext().getDocWriter());
        }
        return rs;
    }

    @Override
    public IResultSet executeSubQuery(IResultSet parentResultSet, BirtCubeView view, int startingColumnLevelIndex, int startingRowLevelIndex) throws IOException {
        return new CubeResultSet(parentResultSet, view, this.cubeQueryExecutorHelper, startingColumnLevelIndex, startingRowLevelIndex);
    }
}

