/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.CompressionMode;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.ppt.util.PPTUtil;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXCanvas;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXPage;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXPageDevice;
import org.eclipse.birt.report.engine.emitter.pptx.SlideWriter;
import org.eclipse.birt.report.engine.emitter.pptx.TableWriter;
import org.eclipse.birt.report.engine.emitter.pptx.TextWriter;
import org.eclipse.birt.report.engine.emitter.pptx.util.PPTXUtil;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Presentation;
import org.eclipse.birt.report.engine.emitter.pptx.writer.SlideMaster;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.IImageArea;
import org.eclipse.birt.report.engine.nLayout.area.ITextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ImageBlockContainer;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PPTXRender
extends PageDeviceRender {
    public static final String OPTION_EDIT_MODE = "org.eclipse.birt.report.emitter.PPTX.editMode";
    public static final String REPORT_FILE = "Report.pptx";
    private final OutputStream out;
    private final String tempFileDir;
    private RenderOption renderOption;
    private boolean needBufferOutput;
    private final ArrayList<ByteArrayOutputStream> bufferedOuptuts = new ArrayList();
    private boolean editMode;
    private boolean isRTL = false;
    private boolean isTextWrap = true;

    public PPTXRender(IEmitterServices services) throws EngineException {
        this.initialize(services);
        this.out = EmitterUtil.getOuputStream(services, REPORT_FILE);
        this.tempFileDir = services.getReportEngine().getConfig().getTempDir();
    }

    public PPTXRender(PPTXRender render, PPTXCanvas canvas) {
        this.initialize(render.services);
        this.out = render.out;
        this.tempFileDir = render.tempFileDir;
        this.scale = render.scale;
        canvas.setScale(this.scale);
        this.currentX = render.currentX;
        this.currentY = render.currentY;
        this.pageDevice = render.pageDevice;
        this.isRTL = render.isRTL;
        this.isTextWrap = render.isTextWrap;
        this.pageGraphic = new PPTXPage(canvas);
    }

    @Override
    public IPageDevice createPageDevice(String title, String author, String subject, String description, IReportContext context, IReportContent report) throws Exception {
        try {
            int compressionMode = this.getCompressionMode(this.renderOption).getValue();
            PPTXPageDevice pageDevice = new PPTXPageDevice(this.out, title, author, description, subject, this.tempFileDir, compressionMode);
            this.isTextWrap = this.renderOption.getBooleanOption("pdfRenderOption.textWrapping", true);
            return pageDevice;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage());
            return null;
        }
    }

    private CompressionMode getCompressionMode(RenderOption renderOption) {
        CompressionMode compressionMode = CompressionMode.BEST_COMPRESSION;
        Object mode = renderOption.getOption("BEST_COMPRESSION");
        if (mode instanceof CompressionMode) {
            compressionMode = (CompressionMode)((Object)mode);
        }
        return compressionMode;
    }

    @Override
    public String getOutputFormat() {
        return "pptx";
    }

    public void initialize(IEmitterServices services) {
        this.services = services;
        this.renderOption = (RenderOption)services.getRenderOption();
        this.reportRunnable = services.getReportRunnable();
        if (this.reportRunnable != null) {
            this.reportDesign = (ReportDesignHandle)this.reportRunnable.getDesignHandle();
            this.isRTL = this.reportDesign.isDirectionRTL();
        }
        this.context = services.getReportContext();
        this.editMode = this.renderOption.getBooleanOption(OPTION_EDIT_MODE, true);
    }

    @Override
    public void visitImage(IImageArea imageArea) {
        PPTXPage page = (PPTXPage)this.pageGraphic;
        page.setLink(PPTUtil.getHyperlink(imageArea, this.services, this.reportRunnable, this.context));
        super.visitImage(imageArea);
        page.setLink(null);
    }

    @Override
    public void visitText(ITextArea textArea) {
        PPTXPage page = (PPTXPage)this.pageGraphic;
        page.setLink(PPTUtil.getHyperlink(textArea, this.services, this.reportRunnable, this.context));
        super.visitText(textArea);
        page.setLink(null);
    }

    @Override
    protected void drawTextAt(ITextArea text, int x, int y, int width, int height, TextStyle textStyle) {
        this.pageGraphic.drawText(text.getLogicalOrderText(), x, y, width, height, textStyle);
    }

    @Override
    public void visitContainer(IContainerArea container) {
        if (container instanceof PageArea) {
            this.newPage(container);
            new SlideWriter(this).writeSlide((PageArea)container);
            this.pageGraphic.dispose();
        } else if (container instanceof TableArea) {
            this.outputTable((TableArea)container);
        } else if (TextWriter.isSingleTextControl(container)) {
            this.outputText((ContainerArea)container);
        } else if (this.needBufferOutput && this.editMode) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.bufferedOuptuts.add(out);
            OOXmlWriter writer = new OOXmlWriter();
            writer.open(out);
            PPTXCanvas canvas = new PPTXCanvas(this.getCanvas(), writer);
            PPTXRender render = new PPTXRender(this, canvas);
            render.visitContainer(container);
            writer.close();
        } else {
            String bmk;
            if (container instanceof ImageBlockContainer && (bmk = container.getBookmark()) != null) {
                Presentation presentation = ((PPTXPage)this.pageGraphic).getCanvas().getPresentation();
                int currentslide = presentation.getCurrentSlideIdx();
                presentation.addBookmark(bmk, currentslide);
            }
            this.startContainer(container);
            this.visitChildren(container);
            this.endContainer(container);
        }
    }

    protected void endclip() {
        this.pageGraphic.endClip();
    }

    private void outputTable(TableArea table) {
        if (!this.editMode) {
            this.visitTable(table);
            return;
        }
        if (!this.needBufferOutput) {
            this.needBufferOutput = true;
            new TableWriter(this).outputTable(table);
            this.needBufferOutput = false;
            while (!this.bufferedOuptuts.isEmpty()) {
                ByteArrayOutputStream output = this.bufferedOuptuts.remove(this.bufferedOuptuts.size() - 1);
                try {
                    this.getCanvas().getWriter().print(output.toString("utf-8"));
                }
                catch (IOException ex) {
                    this.logger.log(Level.WARNING, "failed to output table", ex);
                }
            }
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.bufferedOuptuts.add(out);
            OOXmlWriter writer = new OOXmlWriter();
            writer.open(out);
            PPTXCanvas canvas = new PPTXCanvas(this.getCanvas(), writer);
            PPTXRender render = new PPTXRender(this, canvas);
            table.accept(render);
            writer.close();
        }
    }

    private void outputText(ContainerArea text) {
        if (this.editMode) {
            int x = this.currentX + this.getX(text);
            int y = this.currentY + this.getY(text);
            int width = this.getWidth(text);
            int height = this.getHeight(text);
            TextWriter tw = new TextWriter(this);
            tw.setLink(PPTUtil.getHyperlink(text, this.services, this.reportRunnable, this.context));
            tw.writeTextBlock(x, y, width, height, text);
        } else {
            this.startContainer(text);
            this.visitChildren(text);
            this.endContainer(text);
        }
    }

    @Override
    protected void visitPage(PageArea page) {
        super.visitPage(page);
    }

    protected void visitTable(TableArea table) {
        this.startContainer(table);
        this.visitChildren(table);
        this.endContainer(table);
    }

    protected void visitText(BlockTextArea text) {
        this.startContainer(text);
        this.visitChildren(text);
        this.endContainer(text);
    }

    public void visitTextBuffer(BlockTextArea text) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.bufferedOuptuts.add(out);
        OOXmlWriter writer = new OOXmlWriter();
        writer.open(out);
        PPTXCanvas canvas = new PPTXCanvas(this.getCanvas(), writer);
        PPTXRender render = new PPTXRender(this, canvas);
        int x = this.currentX + this.getX(text);
        int y = this.currentY + this.getY(text);
        int width = this.getWidth(text);
        int height = this.getHeight(text);
        TextWriter tw = new TextWriter(render);
        tw.setNotFirstTextInCell();
        tw.writeTextBlock(x, y, width, height, text);
        writer.close();
    }

    public PPTXPage getGraphic() {
        return (PPTXPage)this.pageGraphic;
    }

    public PPTXCanvas getCanvas() {
        return ((PPTXPage)this.pageGraphic).getCanvas();
    }

    public int getCurrentX() {
        return this.currentX;
    }

    public int getCurrentY() {
        return this.currentY;
    }

    public void setCurrentX(int x) {
        this.currentX = x;
    }

    public void setCurrentY(int y) {
        this.currentY = y;
    }

    public float getScale() {
        return this.scale;
    }

    private String getMasterPageName(PageArea area) {
        if (area.getContent() instanceof PageContent) {
            PageContent pageContent = (PageContent)area.getContent();
            return pageContent.getName();
        }
        return "";
    }

    @Override
    protected void newPage(IContainerArea area) {
        assert (area instanceof PageArea);
        PageArea pageArea = (PageArea)area;
        this.scale = pageArea.getScale();
        int pageHeight = this.getHeight(pageArea);
        int pageWidth = this.getWidth(pageArea);
        try {
            int width = PPTXUtil.convertToPointer(pageWidth);
            int height = PPTXUtil.convertToPointer(pageHeight);
            Presentation presentation = ((PPTXPageDevice)this.pageDevice).getPresentation();
            presentation.setRender(this);
            String masterPageName = this.getMasterPageName(pageArea);
            SlideMaster master = presentation.getSlideMaster(masterPageName);
            if (master == null) {
                master = presentation.createSlideMaster(masterPageName, pageArea);
            }
            this.pageGraphic = new PPTXPage(presentation.createSlide(master, width, height, pageArea));
            ((PPTXPage)this.pageGraphic).getCanvas().setScale(this.scale);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    public boolean isRTL() {
        return this.isRTL;
    }

    public boolean isTextWrap() {
        return this.isTextWrap;
    }
}

