/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GraphicMasterPageDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.IOConstants;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.PageVariableDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.RuleDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;

public class EngineIRWriter
implements IOConstants {
    protected String scriptLanguage = "javascript";

    public void write(OutputStream out, Report design) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        IOUtil.writeLong(dos, 9L);
        IOUtil.writeString(dos, "3.2.23");
        this.writeReport(dos, design);
        dos.flush();
    }

    private void writeReport(DataOutputStream dos, Report design) throws IOException {
        IOUtil.writeShort(dos, (short)9);
        IOUtil.writeShort(dos, (short)248);
        IOUtil.writeString(dos, design.getVersion());
        IOUtil.writeShort(dos, (short)255);
        IOUtil.writeString(dos, design.getLocale());
        IOUtil.writeShort(dos, (short)240);
        this.writeReportStyles(dos, design);
        IOUtil.writeShort(dos, (short)254);
        this.writeExprMap(dos, design.getUserProperties());
        IOUtil.writeShort(dos, (short)245);
        this.writeReportVariable(dos, design);
        IOUtil.writeShort(dos, (short)246);
        Expression onPageStart = design.getOnPageStart();
        this.writeExpression(dos, onPageStart);
        IOUtil.writeShort(dos, (short)247);
        Expression onPageEnd = design.getOnPageEnd();
        this.writeExpression(dos, onPageEnd);
        IOUtil.writeShort(dos, (short)242);
        ReportItemWriter writer = new ReportItemWriter(dos);
        this.writeReportPageSetup(dos, writer, design);
        IOUtil.writeShort(dos, (short)243);
        this.writeReportBodyContent(dos, writer, design);
    }

    private void writeReportStyles(DataOutputStream dos, Report design) throws IOException {
        Map styles = design.getStyles();
        IOUtil.writeInt(dos, styles.size());
        for (Map.Entry entry : styles.entrySet()) {
            String styleName = (String)entry.getKey();
            IStyle style = (IStyle)entry.getValue();
            IOUtil.writeString(dos, styleName);
            style.write(dos);
        }
        String rootStyleName = design.getRootStyleName();
        IOUtil.writeString(dos, rootStyleName);
    }

    private void writeReportVariable(DataOutputStream dos, Report design) throws IOException {
        Collection<PageVariableDesign> vars = design.getPageVariables();
        IOUtil.writeInt(dos, vars.size());
        for (PageVariableDesign var : vars) {
            IOUtil.writeString(dos, var.getName());
            IOUtil.writeString(dos, var.getScope());
            this.writeExpression(dos, var.getDefaultValue());
        }
    }

    private void writeReportPageSetup(DataOutputStream dos, ReportItemWriter writer, Report design) throws IOException {
        PageSetupDesign pageSetup = design.getPageSetup();
        int masterPageCount = pageSetup.getMasterPageCount();
        IOUtil.writeInt(dos, masterPageCount);
        int i = 0;
        while (i < masterPageCount) {
            SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)pageSetup.getMasterPage(i);
            writer.writeMasterPage(masterPage);
            ++i;
        }
    }

    private void writeReportBodyContent(DataOutputStream dos, ReportItemWriter writer, Report design) throws IOException {
        int count = design.getContentCount();
        IOUtil.writeInt(dos, count);
        int i = 0;
        while (i < count) {
            ReportItemDesign item = design.getContent(i);
            writer.write(item);
            ++i;
        }
    }

    protected void writeReportElement(DataOutputStream out, ReportElementDesign design) throws IOException {
        Map<String, Expression> userProperties;
        String javaClass;
        String ext;
        String name;
        long id = design.getID();
        if (id != -1L) {
            IOUtil.writeShort(out, (short)0);
            IOUtil.writeLong(out, id);
        }
        if ((name = design.getName()) != null) {
            IOUtil.writeShort(out, (short)1);
            IOUtil.writeString(out, name);
        }
        if ((ext = design.getExtends()) != null) {
            IOUtil.writeShort(out, (short)2);
            IOUtil.writeString(out, ext);
        }
        if ((javaClass = design.getJavaClass()) != null) {
            IOUtil.writeShort(out, (short)3);
            IOUtil.writeString(out, javaClass);
        }
        if ((userProperties = design.getUserProperties()) != null && !userProperties.isEmpty()) {
            IOUtil.writeShort(out, (short)253);
            this.writeExprMap(out, userProperties);
        }
    }

    protected void writeStyledElement(DataOutputStream out, StyledElementDesign design) throws IOException {
        HighlightDesign highlight;
        MapDesign map;
        this.writeReportElement(out, design);
        String styleClass = design.getStyleName();
        if (styleClass != null) {
            IOUtil.writeShort(out, (short)6);
            IOUtil.writeString(out, styleClass);
        }
        if ((map = design.getMap()) != null) {
            IOUtil.writeShort(out, (short)7);
            this.writeMap(out, map);
        }
        if ((highlight = design.getHighlight()) != null) {
            IOUtil.writeShort(out, (short)8);
            this.writeHighlight(out, highlight);
        }
    }

    protected void writeReportItem(DataOutputStream out, ReportItemDesign design) throws IOException {
        boolean useCachedResult;
        ActionDesign action;
        VisibilityDesign visibility;
        Expression onPageBreakScriptExpr;
        Expression onRenderScriptExpr;
        Expression onCreateScriptExpr;
        Expression toc;
        Expression bookmark;
        DimensionType width;
        DimensionType height;
        DimensionType y;
        this.writeStyledElement(out, design);
        DimensionType x = design.getX();
        if (x != null) {
            IOUtil.writeShort(out, (short)20);
            this.writeDimension(out, x);
        }
        if ((y = design.getY()) != null) {
            IOUtil.writeShort(out, (short)21);
            this.writeDimension(out, y);
        }
        if ((height = design.getHeight()) != null) {
            IOUtil.writeShort(out, (short)22);
            this.writeDimension(out, height);
        }
        if ((width = design.getWidth()) != null) {
            IOUtil.writeShort(out, (short)23);
            this.writeDimension(out, width);
        }
        if ((bookmark = design.getBookmark()) != null) {
            IOUtil.writeShort(out, (short)24);
            this.writeExpression(out, bookmark);
        }
        if ((toc = design.getTOC()) != null) {
            IOUtil.writeShort(out, (short)25);
            this.writeExpression(out, toc);
        }
        if ((onCreateScriptExpr = design.getOnCreate()) != null) {
            IOUtil.writeShort(out, (short)26);
            this.writeExpression(out, onCreateScriptExpr);
        }
        if ((onRenderScriptExpr = design.getOnRender()) != null) {
            IOUtil.writeShort(out, (short)27);
            this.writeExpression(out, onRenderScriptExpr);
        }
        if ((onPageBreakScriptExpr = design.getOnPageBreak()) != null) {
            IOUtil.writeShort(out, (short)28);
            this.writeExpression(out, onPageBreakScriptExpr);
        }
        if ((visibility = design.getVisibility()) != null) {
            IOUtil.writeShort(out, (short)29);
            this.writeVisibility(out, visibility);
        }
        if ((action = design.getAction()) != null) {
            IOUtil.writeShort(out, (short)113);
            this.writeAction(out, action);
        }
        if (useCachedResult = design.useCachedResult()) {
            IOUtil.writeShort(out, (short)230);
            IOUtil.writeBool(out, useCachedResult);
        }
        Expression altText = design.getAltText();
        String altTextKey = design.getAltTextKey();
        if (altText != null || altTextKey != null) {
            IOUtil.writeShort(out, (short)151);
            IOUtil.writeString(out, altTextKey);
            this.writeExpression(out, altText);
        }
    }

    protected void writeMasterPage(DataOutputStream out, MasterPageDesign design) throws IOException {
        String bodyStyleName;
        this.writeStyledElement(out, design);
        String pageType = design.getPageType();
        if (pageType != null) {
            IOUtil.writeShort(out, (short)200);
            IOUtil.writeString(out, pageType);
        }
        DimensionType width = design.getPageWidth();
        DimensionType height = design.getPageHeight();
        IOUtil.writeShort(out, (short)201);
        this.writeDimension(out, width);
        this.writeDimension(out, height);
        DimensionType top = design.getTopMargin();
        DimensionType left = design.getLeftMargin();
        DimensionType bottom = design.getBottomMargin();
        DimensionType right = design.getRightMargin();
        IOUtil.writeShort(out, (short)202);
        this.writeDimension(out, top);
        this.writeDimension(out, left);
        this.writeDimension(out, bottom);
        this.writeDimension(out, right);
        String orientation = design.getOrientation();
        if (orientation != null) {
            IOUtil.writeShort(out, (short)203);
            IOUtil.writeString(out, orientation);
        }
        if ((bodyStyleName = design.getBodyStyleName()) != null) {
            IOUtil.writeShort(out, (short)204);
            IOUtil.writeString(out, bodyStyleName);
        }
    }

    protected void writeSimpleMasterPage(DataOutputStream out, SimpleMasterPageDesign design) throws IOException {
        DimensionType footerHeigh;
        DimensionType headerHeight;
        boolean floatingFooter;
        boolean showFooterOnLast;
        this.writeMasterPage(out, design);
        boolean showHeaderOnFirst = design.isShowHeaderOnFirst();
        if (!showHeaderOnFirst) {
            IOUtil.writeShort(out, (short)210);
            IOUtil.writeBool(out, showHeaderOnFirst);
        }
        if (!(showFooterOnLast = design.isShowFooterOnLast())) {
            IOUtil.writeShort(out, (short)211);
            IOUtil.writeBool(out, showFooterOnLast);
        }
        if (floatingFooter = design.isFloatingFooter()) {
            IOUtil.writeShort(out, (short)212);
            IOUtil.writeBool(out, floatingFooter);
        }
        if ((headerHeight = design.getHeaderHeight()) != null) {
            IOUtil.writeShort(out, (short)213);
            this.writeDimension(out, headerHeight);
        }
        if ((footerHeigh = design.getFooterHeight()) != null) {
            IOUtil.writeShort(out, (short)214);
            this.writeDimension(out, footerHeigh);
        }
    }

    protected void writeGraphicMasterPage(DataOutputStream out, GraphicMasterPageDesign design) throws IOException {
        DimensionType columnSpacing;
        this.writeMasterPage(out, design);
        int columns = design.getColumns();
        if (columns != -1) {
            IOUtil.writeShort(out, (short)70);
            IOUtil.writeInt(out, columns);
        }
        if ((columnSpacing = design.getColumnSpacing()) != null) {
            IOUtil.writeShort(out, (short)220);
            this.writeDimension(out, columnSpacing);
        }
    }

    protected void writeListing(DataOutputStream out, ListingDesign listing) throws IOException {
        this.writeReportItem(out, listing);
        boolean repeatHeader = listing.isRepeatHeader();
        int pageBreakInterval = listing.getPageBreakInterval();
        if (repeatHeader) {
            IOUtil.writeShort(out, (short)31);
            IOUtil.writeBool(out, repeatHeader);
        }
        if (pageBreakInterval != -1) {
            IOUtil.writeShort(out, (short)30);
            IOUtil.writeInt(out, pageBreakInterval);
        }
    }

    protected void writeGroup(DataOutputStream out, GroupDesign group) throws IOException {
        this.writeReportItem(out, group);
        int groupLevel = group.getGroupLevel();
        String pageBreakBefore = group.getPageBreakBefore();
        String pageBreakAfter = group.getPageBreakAfter();
        String pageBreakInside = group.getPageBreakInside();
        boolean hideDetail = group.getHideDetail();
        boolean headerRepeat = group.isHeaderRepeat();
        if (groupLevel != -1) {
            IOUtil.writeShort(out, (short)40);
            IOUtil.writeInt(out, groupLevel);
        }
        if (pageBreakBefore != null) {
            IOUtil.writeShort(out, (short)41);
            IOUtil.writeString(out, pageBreakBefore);
        }
        if (pageBreakAfter != null) {
            IOUtil.writeShort(out, (short)42);
            IOUtil.writeString(out, pageBreakAfter);
        }
        if (pageBreakInside != null) {
            IOUtil.writeShort(out, (short)45);
            IOUtil.writeString(out, pageBreakInside);
        }
        if (headerRepeat) {
            IOUtil.writeShort(out, (short)43);
            IOUtil.writeBool(out, headerRepeat);
        }
        if (hideDetail) {
            IOUtil.writeShort(out, (short)44);
            IOUtil.writeBool(out, hideDetail);
        }
    }

    protected void writeBand(DataOutputStream out, BandDesign band) throws IOException {
        this.writeReportItem(out, band);
        int bandType = band.getBandType();
        if (bandType != -1) {
            IOUtil.writeShort(out, (short)50);
            IOUtil.writeInt(out, bandType);
        }
    }

    protected void writeList(DataOutputStream out, ListItemDesign list) throws IOException {
        this.writeListing(out, list);
    }

    protected void writeListGroup(DataOutputStream out, ListGroupDesign group) throws IOException {
        this.writeGroup(out, group);
    }

    protected void writeListBand(DataOutputStream out, ListBandDesign listBand) throws IOException {
        this.writeBand(out, listBand);
    }

    protected void writeTable(DataOutputStream out, TableItemDesign table) throws IOException {
        String summary;
        this.writeListing(out, table);
        String captionKey = table.getCaptionKey();
        String caption = table.getCaption();
        if (caption != null || captionKey != null) {
            IOUtil.writeShort(out, (short)60);
            IOUtil.writeString(out, captionKey);
            IOUtil.writeString(out, caption);
        }
        if ((summary = table.getSummary()) != null) {
            IOUtil.writeShort(out, (short)71);
            IOUtil.writeString(out, summary);
        }
        int columnCount = table.getColumnCount();
        IOUtil.writeShort(out, (short)70);
        IOUtil.writeInt(out, columnCount);
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        DataOutputStream buffer = new DataOutputStream(bo);
        int i = 0;
        while (i < columnCount) {
            ColumnDesign column = table.getColumn(i);
            bo.reset();
            this.writeColumn(buffer, column);
            buffer.flush();
            IOUtil.writeBytes(out, bo.toByteArray());
            ++i;
        }
    }

    protected void writeTableGroup(DataOutputStream out, TableGroupDesign group) throws IOException {
        this.writeGroup(out, group);
    }

    protected void writeTableBand(DataOutputStream out, TableBandDesign listBand) throws IOException {
        this.writeBand(out, listBand);
    }

    protected void writeGrid(DataOutputStream out, GridItemDesign grid) throws IOException {
        String summary;
        this.writeReportItem(out, grid);
        String captionKey = grid.getCaptionKey();
        String caption = grid.getCaption();
        if (caption != null || captionKey != null) {
            IOUtil.writeShort(out, (short)60);
            IOUtil.writeString(out, captionKey);
            IOUtil.writeString(out, caption);
        }
        if ((summary = grid.getSummary()) != null) {
            IOUtil.writeShort(out, (short)71);
            IOUtil.writeString(out, summary);
        }
        int columnCount = grid.getColumnCount();
        IOUtil.writeShort(out, (short)70);
        IOUtil.writeInt(out, columnCount);
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        DataOutputStream buffer = new DataOutputStream(bo);
        int i = 0;
        while (i < columnCount) {
            ColumnDesign column = grid.getColumn(i);
            bo.reset();
            this.writeColumn(buffer, column);
            buffer.flush();
            IOUtil.writeBytes(out, bo.toByteArray());
            ++i;
        }
    }

    protected void writeColumn(DataOutputStream out, ColumnDesign column) throws IOException {
        boolean hasDataItemsInDetail;
        VisibilityDesign visibility;
        boolean suppressDuplicate;
        DimensionType width;
        this.writeStyledElement(out, column);
        boolean isColumnHeader = column.isColumnHeader();
        if (isColumnHeader) {
            IOUtil.writeShort(out, (short)82);
            IOUtil.writeBool(out, isColumnHeader);
        }
        if ((width = column.getWidth()) != null) {
            IOUtil.writeShort(out, (short)23);
            this.writeDimension(out, width);
        }
        if (suppressDuplicate = column.getSuppressDuplicate()) {
            IOUtil.writeShort(out, (short)80);
            IOUtil.writeBool(out, suppressDuplicate);
        }
        if ((visibility = column.getVisibility()) != null) {
            IOUtil.writeShort(out, (short)29);
            this.writeVisibility(out, visibility);
        }
        if (hasDataItemsInDetail = column.hasDataItemsInDetail()) {
            IOUtil.writeShort(out, (short)81);
            IOUtil.writeBool(out, hasDataItemsInDetail);
        }
    }

    protected void writeRow(DataOutputStream out, RowDesign row) throws IOException {
        boolean repeatable;
        this.writeReportItem(out, row);
        boolean isStartOfGroup = row.isStartOfGroup();
        if (isStartOfGroup) {
            IOUtil.writeShort(out, (short)90);
            IOUtil.writeBool(out, isStartOfGroup);
        }
        if (!(repeatable = row.getRepeatable())) {
            IOUtil.writeShort(out, (short)91);
            IOUtil.writeBool(out, repeatable);
        }
    }

    protected void writeCell(DataOutputStream out, CellDesign cell) throws IOException {
        boolean displayGroupIcon;
        String scope;
        Expression headers;
        String drop;
        int rowSpan;
        int colSpan;
        this.writeReportItem(out, cell);
        int column = cell.getColumn();
        if (column != -1) {
            IOUtil.writeShort(out, (short)100);
            IOUtil.writeInt(out, column);
        }
        if ((colSpan = cell.getColSpan()) != 1) {
            IOUtil.writeShort(out, (short)101);
            IOUtil.writeInt(out, colSpan);
        }
        if ((rowSpan = cell.getRowSpan()) != 1) {
            IOUtil.writeShort(out, (short)102);
            IOUtil.writeInt(out, rowSpan);
        }
        if ((drop = cell.getDrop()) != null) {
            IOUtil.writeShort(out, (short)103);
            IOUtil.writeString(out, drop);
        }
        if ((headers = cell.getHeaders()) != null) {
            IOUtil.writeShort(out, (short)99);
            this.writeExpression(out, headers);
        }
        if ((scope = cell.getScope()) != null) {
            IOUtil.writeShort(out, (short)98);
            IOUtil.writeString(out, scope);
        }
        if (displayGroupIcon = cell.getDisplayGroupIcon()) {
            IOUtil.writeShort(out, (short)104);
            IOUtil.writeBool(out, displayGroupIcon);
        }
        if (cell.hasDiagonalLine()) {
            int antidiagonalNumber;
            int diagonalNumber = cell.getDiagonalNumber();
            if (diagonalNumber > 0) {
                String diagonalColor;
                DimensionType diagonalWidth;
                IOUtil.writeShort(out, (short)105);
                IOUtil.writeInt(out, diagonalNumber);
                String diagonalStyle = cell.getDiagonalStyle();
                if (diagonalStyle != null) {
                    IOUtil.writeShort(out, (short)106);
                    IOUtil.writeString(out, diagonalStyle);
                }
                if ((diagonalWidth = cell.getDiagonalWidth()) != null) {
                    IOUtil.writeShort(out, (short)107);
                    this.writeDimension(out, diagonalWidth);
                }
                if ((diagonalColor = cell.getDiagonalColor()) != null) {
                    IOUtil.writeShort(out, (short)111);
                    IOUtil.writeString(out, diagonalColor);
                }
            }
            if ((antidiagonalNumber = cell.getAntidiagonalNumber()) > 0) {
                String antidiagonalColor;
                DimensionType antidiagonalWidth;
                IOUtil.writeShort(out, (short)108);
                IOUtil.writeInt(out, antidiagonalNumber);
                String antidiagonalStyle = cell.getAntidiagonalStyle();
                if (antidiagonalStyle != null) {
                    IOUtil.writeShort(out, (short)109);
                    IOUtil.writeString(out, antidiagonalStyle);
                }
                if ((antidiagonalWidth = cell.getAntidiagonalWidth()) != null) {
                    IOUtil.writeShort(out, (short)110);
                    this.writeDimension(out, antidiagonalWidth);
                }
                if ((antidiagonalColor = cell.getAntidiagonalColor()) != null) {
                    IOUtil.writeShort(out, (short)112);
                    IOUtil.writeString(out, antidiagonalColor);
                }
            }
        }
    }

    protected void writeFreeForm(DataOutputStream out, FreeFormItemDesign freeForm) throws IOException {
        this.writeReportItem(out, freeForm);
    }

    protected void writeLabel(DataOutputStream out, LabelItemDesign label) throws IOException {
        this.writeReportItem(out, label);
        String text = label.getText();
        String textKey = label.getTextKey();
        String helpText = label.getHelpText();
        String helpTextKey = label.getHelpTextKey();
        if (text != null || textKey != null) {
            IOUtil.writeShort(out, (short)110);
            IOUtil.writeString(out, textKey);
            IOUtil.writeString(out, text);
        }
        if (helpText != null || helpTextKey != null) {
            IOUtil.writeShort(out, (short)111);
            IOUtil.writeString(out, helpTextKey);
            IOUtil.writeString(out, helpText);
        }
    }

    protected void writeExpression(DataOutputStream out, Expression expr) throws IOException {
        if (expr == null) {
            IOUtil.writeBool(out, true);
            return;
        }
        IOUtil.writeBool(out, false);
        int type = expr.getType();
        IOUtil.writeInt(out, type);
        switch (expr.getType()) {
            case 0: {
                Expression.Constant cs = (Expression.Constant)expr;
                IOUtil.writeInt(out, cs.getValueType());
                IOUtil.writeString(out, cs.getScriptText());
                break;
            }
            case 1: {
                Expression.Script sc = (Expression.Script)expr;
                String language = sc.getLanguage();
                if (language == null || this.scriptLanguage.equals(language)) {
                    IOUtil.writeShort(out, (short)251);
                } else {
                    IOUtil.writeShort(out, (short)250);
                    IOUtil.writeString(out, language);
                }
                IOUtil.writeString(out, sc.getScriptText());
                break;
            }
            default: {
                throw new IOException("Error.UnsupportedExprssionType");
            }
        }
    }

    protected void writeData(DataOutputStream out, DataItemDesign data) throws IOException {
        this.writeReportItem(out, data);
        String bindingColumn = data.getBindingColumn();
        String helpText = data.getHelpText();
        String helpTextKey = data.getHelpTextKey();
        boolean suppressDuplicate = data.getSuppressDuplicate();
        if (bindingColumn != null) {
            IOUtil.writeShort(out, (short)121);
            IOUtil.writeString(out, bindingColumn);
        }
        if (helpText != null || helpTextKey != null) {
            IOUtil.writeShort(out, (short)111);
            IOUtil.writeString(out, helpTextKey);
            IOUtil.writeString(out, helpText);
        }
        if (suppressDuplicate) {
            IOUtil.writeShort(out, (short)80);
            IOUtil.writeBool(out, suppressDuplicate);
        }
    }

    protected void writeText(DataOutputStream out, TextItemDesign design) throws IOException {
        boolean hasExpr;
        this.writeReportItem(out, design);
        String textType = design.getTextType();
        String textKey = design.getTextKey();
        String text = design.getText();
        if (textType != null) {
            IOUtil.writeShort(out, (short)130);
            IOUtil.writeString(out, textType);
        }
        if (text != null || textKey != null) {
            IOUtil.writeShort(out, (short)110);
            IOUtil.writeString(out, textKey);
            IOUtil.writeString(out, text);
        }
        if (hasExpr = design.hasExpression()) {
            IOUtil.writeShort(out, (short)249);
            IOUtil.writeBool(out, hasExpr);
        }
    }

    protected void writeDynamicText(DataOutputStream out, DynamicTextItemDesign design) throws IOException {
        this.writeReportItem(out, design);
        String contentType = design.getContentType();
        Expression content = design.getContent();
        if (contentType != null) {
            IOUtil.writeShort(out, (short)140);
            IOUtil.writeString(out, contentType);
        }
        if (content != null) {
            IOUtil.writeShort(out, (short)141);
            this.writeExpression(out, content);
        }
    }

    protected void writeImage(DataOutputStream out, ImageItemDesign image) throws IOException {
        boolean isProportionalScale;
        this.writeReportItem(out, image);
        IOUtil.writeShort(out, (short)150);
        int imageSource = image.getImageSource();
        IOUtil.writeInt(out, imageSource);
        switch (imageSource) {
            case 1: {
                this.writeExpression(out, image.getImageName());
                break;
            }
            case 3: {
                this.writeExpression(out, image.getImageUri());
                break;
            }
            case 0: {
                this.writeExpression(out, image.getImageUri());
                break;
            }
            case 2: {
                this.writeExpression(out, image.getImageExpression());
                this.writeExpression(out, image.getImageFormat());
            }
        }
        boolean isFitToContainer = image.isFitToContainer();
        if (isFitToContainer) {
            IOUtil.writeShort(out, (short)152);
            IOUtil.writeBool(out, true);
        }
        if (isProportionalScale = image.isProportionalScale()) {
            IOUtil.writeShort(out, (short)153);
            IOUtil.writeBool(out, isProportionalScale);
        }
        String helpText = image.getHelpText();
        String helpTextKey = image.getHelpTextKey();
        if (helpText != null || helpTextKey != null) {
            IOUtil.writeShort(out, (short)111);
            IOUtil.writeString(out, helpTextKey);
            IOUtil.writeString(out, helpText);
        }
    }

    protected void writeExtended(DataOutputStream out, ExtendedItemDesign extended) throws IOException {
        this.writeReportItem(out, extended);
    }

    protected void writeAutoText(DataOutputStream out, AutoTextItemDesign design) throws IOException {
        this.writeReportItem(out, design);
        String type = design.getType();
        if (type != null) {
            IOUtil.writeShort(out, (short)160);
            IOUtil.writeString(out, type);
        }
        String text = design.getText();
        String textKey = design.getTextKey();
        if (text != null || textKey != null) {
            IOUtil.writeShort(out, (short)110);
            IOUtil.writeString(out, textKey);
            IOUtil.writeString(out, text);
        }
    }

    protected void writeTemplate(DataOutputStream out, TemplateDesign design) throws IOException {
        this.writeReportItem(out, design);
        String allowedType = design.getAllowedType();
        if (allowedType != null) {
            IOUtil.writeShort(out, (short)170);
            IOUtil.writeString(out, allowedType);
        }
        String promptText = design.getPromptText();
        String promptTextKey = design.getPromptTextKey();
        if (promptText != null || promptTextKey != null) {
            IOUtil.writeShort(out, (short)171);
            IOUtil.writeString(out, promptTextKey);
            IOUtil.writeString(out, promptText);
        }
    }

    protected void writeDimension(DataOutputStream out, DimensionType dimension) throws IOException {
        IOUtil.writeBool(out, dimension != null);
        if (dimension != null) {
            dimension.writeObject(out);
        }
    }

    protected void writeVisibility(DataOutputStream out, VisibilityDesign visibility) throws IOException {
        int ruleCount = visibility.count();
        IOUtil.writeInt(out, ruleCount);
        int i = 0;
        while (i < ruleCount) {
            VisibilityRuleDesign rule = visibility.getRule(i);
            IOUtil.writeString(out, rule.getFormat());
            this.writeExpression(out, rule.getExpression());
            ++i;
        }
    }

    protected void writeMap(DataOutputStream out, MapDesign map) throws IOException {
        int ruleCount = map.getRuleCount();
        IOUtil.writeInt(out, ruleCount);
        int i = 0;
        while (i < ruleCount) {
            MapRuleDesign rule = map.getRule(i);
            this.writeRule(out, rule);
            IOUtil.writeString(out, rule.getDisplayText());
            IOUtil.writeString(out, rule.getDisplayKey());
            ++i;
        }
    }

    private void writeRule(DataOutputStream out, RuleDesign rule) throws IOException {
        this.writeExpression(out, rule.getTestExpression());
        IOUtil.writeString(out, rule.getOperator());
        boolean isValueList = rule.ifValueIsList();
        IOUtil.writeBool(out, isValueList);
        if (isValueList) {
            List<Expression> exprs = rule.getValue1List();
            IOUtil.writeInt(out, exprs.size());
            for (Expression expr : exprs) {
                this.writeExpression(out, expr);
            }
        } else {
            Expression expr1 = rule.getValue1();
            Expression expr2 = rule.getValue2();
            this.writeExpression(out, expr1);
            this.writeExpression(out, expr2);
        }
    }

    protected void writeHighlight(DataOutputStream out, HighlightDesign highlight) throws IOException {
        int ruleCount = highlight.getRuleCount();
        IOUtil.writeInt(out, ruleCount);
        int i = 0;
        while (i < ruleCount) {
            HighlightRuleDesign rule = highlight.getRule(i);
            this.writeRule(out, rule);
            rule.getStyle().write(out);
            ++i;
        }
    }

    protected void writeAction(DataOutputStream out, ActionDesign action) throws IOException {
        int actionType = action.getActionType();
        IOUtil.writeInt(out, actionType);
        switch (actionType) {
            case 2: {
                Expression bookmark = action.getBookmark();
                this.writeExpression(out, bookmark);
                break;
            }
            case 3: {
                DrillThroughActionDesign drillThrough = action.getDrillThrough();
                this.writeDrillThrough(out, drillThrough);
                break;
            }
            case 1: {
                Expression hyperlink = action.getHyperlink();
                this.writeExpression(out, hyperlink);
            }
        }
        String targetWindow = action.getTargetWindow();
        IOUtil.writeString(out, targetWindow);
        String tooltip = action.getTooltip();
        IOUtil.writeString(out, tooltip);
    }

    protected void writeDrillThrough(DataOutputStream out, DrillThroughActionDesign drillThrough) throws IOException {
        Expression reportName = drillThrough.getReportName();
        String fileType = drillThrough.getTargetFileType();
        Map<String, List<Expression>> parameters = drillThrough.getParameters();
        Map search = drillThrough.getSearch();
        String format = drillThrough.getFormat();
        boolean bookmarkType = drillThrough.getBookmarkType();
        Expression bookmark = drillThrough.getBookmark();
        this.writeExpression(out, reportName);
        IOUtil.writeString(out, fileType);
        this.writeDrillThroughExprMap(out, parameters);
        IOUtil.writeMap(out, search);
        IOUtil.writeString(out, format);
        IOUtil.writeBool(out, bookmarkType);
        this.writeExpression(out, bookmark);
    }

    private void writeExprMap(DataOutputStream dos, Map<String, Expression> exprs) throws IOException {
        if (exprs == null) {
            IOUtil.writeInt(dos, 0);
        } else {
            IOUtil.writeInt(dos, exprs.size());
            for (Map.Entry<String, Expression> entry : exprs.entrySet()) {
                String name = entry.getKey();
                Expression expr = entry.getValue();
                IOUtil.writeString(dos, name);
                this.writeExpression(dos, expr);
            }
        }
    }

    private void writeDrillThroughExprMap(DataOutputStream dos, Map<String, List<Expression>> exprs) throws IOException {
        if (exprs == null) {
            IOUtil.writeInt(dos, 0);
        } else {
            IOUtil.writeInt(dos, exprs.size());
            for (Map.Entry<String, List<Expression>> entry : exprs.entrySet()) {
                String name = entry.getKey();
                IOUtil.writeString(dos, name);
                List<Expression> exprList = entry.getValue();
                IOUtil.writeInt(dos, exprList.size());
                for (Expression expr : exprList) {
                    this.writeExpression(dos, expr);
                }
            }
        }
    }

    private class ReportItemWriter
    extends DefaultReportItemVisitorImpl {
        DataOutputStream dos;
        ByteArrayOutputStream bout;
        DataOutputStream bdos;

        ReportItemWriter(DataOutputStream dos) {
            this.dos = dos;
            this.bout = new ByteArrayOutputStream();
            this.bdos = new DataOutputStream(this.bout);
        }

        public void write(ReportItemDesign design) throws IOException {
            Object exception = design.accept(this, null);
            if (exception != null) {
                throw (IOException)exception;
            }
        }

        public void writeMasterPage(SimpleMasterPageDesign masterPage) throws IOException {
            Object exception;
            ReportItemDesign item;
            this.bout.reset();
            EngineIRWriter.this.writeSimpleMasterPage(this.bdos, masterPage);
            this.bdos.flush();
            IOUtil.writeShort(this.dos, (short)2);
            IOUtil.writeBytes(this.dos, this.bout.toByteArray());
            int count = masterPage.getHeaderCount();
            IOUtil.writeInt(this.dos, count);
            int i = 0;
            while (i < count) {
                item = masterPage.getHeader(i);
                exception = item.accept(this, null);
                if (exception != null) {
                    throw (IOException)exception;
                }
                ++i;
            }
            count = masterPage.getFooterCount();
            IOUtil.writeInt(this.dos, count);
            i = 0;
            while (i < count) {
                item = masterPage.getFooter(i);
                exception = item.accept(this, null);
                if (exception != null) {
                    throw (IOException)exception;
                }
                ++i;
            }
        }

        @Override
        public Object visitAutoTextItem(AutoTextItemDesign autoText, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeAutoText(this.bdos, autoText);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)21);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitCell(CellDesign cell, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeCell(this.bdos, cell);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)7);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                int contentCount = cell.getContentCount();
                IOUtil.writeInt(this.dos, contentCount);
                int i = 0;
                while (i < contentCount) {
                    ReportItemDesign content = cell.getContent(i);
                    value = content.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitDataItem(DataItemDesign data, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeData(this.bdos, data);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)16);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitExtendedItem(ExtendedItemDesign item, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeExtended(this.bdos, item);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)20);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                List childrenDesigns = item.getChildren();
                IOUtil.writeInt(this.dos, childrenDesigns.size());
                int i = 0;
                while (i < childrenDesigns.size()) {
                    ((ReportItemDesign)childrenDesigns.get(i)).accept(this, value);
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeFreeForm(this.bdos, container);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)4);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                int contentCount = container.getItemCount();
                IOUtil.writeInt(this.dos, contentCount);
                int i = 0;
                while (i < contentCount) {
                    ReportItemDesign content = container.getItem(i);
                    value = content.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitGridItem(GridItemDesign grid, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeGrid(this.bdos, grid);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)3);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                int rowCount = grid.getRowCount();
                IOUtil.writeInt(this.dos, rowCount);
                int i = 0;
                while (i < rowCount) {
                    RowDesign row = grid.getRow(i);
                    value = ((ReportItemDesign)row).accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitImageItem(ImageItemDesign image, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeImage(this.bdos, image);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)18);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitLabelItem(LabelItemDesign label, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeLabel(this.bdos, label);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)14);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitListBand(ListBandDesign band, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeListBand(this.bdos, band);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)10);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                int count = band.getContentCount();
                IOUtil.writeInt(this.dos, count);
                int i = 0;
                while (i < count) {
                    ReportItemDesign content = band.getContent(i);
                    value = content.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitListGroup(ListGroupDesign group, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeListGroup(this.bdos, group);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)9);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                BandDesign header = group.getHeader();
                IOUtil.writeBool(this.dos, header != null);
                if (header != null && (value = header.accept(this, value)) != null) {
                    return value;
                }
                BandDesign footer = group.getFooter();
                IOUtil.writeBool(this.dos, footer != null);
                if (footer != null && (value = footer.accept(this, value)) != null) {
                    return value;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitListItem(ListItemDesign list, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeList(this.bdos, list);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)8);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                BandDesign header = list.getHeader();
                IOUtil.writeBool(this.dos, header != null);
                if (header != null && (value = header.accept(this, value)) != null) {
                    return value;
                }
                int count = list.getGroupCount();
                IOUtil.writeInt(this.dos, count);
                int i = 0;
                while (i < count) {
                    GroupDesign group = list.getGroup(i);
                    value = group.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
                BandDesign detail = list.getDetail();
                IOUtil.writeBool(this.dos, detail != null);
                if (detail != null && (value = detail.accept(this, value)) != null) {
                    return value;
                }
                BandDesign footer = list.getFooter();
                IOUtil.writeBool(this.dos, footer != null);
                if (footer != null && (value = footer.accept(this, value)) != null) {
                    return value;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitDynamicTextItem(DynamicTextItemDesign multiLine, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeDynamicText(this.bdos, multiLine);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)17);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitRow(RowDesign row, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeRow(this.bdos, row);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)6);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                int count = row.getCellCount();
                IOUtil.writeInt(this.dos, count);
                int i = 0;
                while (i < count) {
                    CellDesign cell = row.getCell(i);
                    value = cell.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitTableBand(TableBandDesign band, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeTableBand(this.bdos, band);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)13);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                int rowCount = band.getRowCount();
                IOUtil.writeInt(this.dos, rowCount);
                int i = 0;
                while (i < rowCount) {
                    RowDesign row = band.getRow(i);
                    value = ((ReportItemDesign)row).accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitTableGroup(TableGroupDesign group, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeTableGroup(this.bdos, group);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)12);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                BandDesign header = group.getHeader();
                IOUtil.writeBool(this.dos, header != null);
                if (header != null && (value = header.accept(this, value)) != null) {
                    return value;
                }
                BandDesign footer = group.getFooter();
                IOUtil.writeBool(this.dos, footer != null);
                if (footer != null && (value = footer.accept(this, value)) != null) {
                    return value;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitTableItem(TableItemDesign table, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeTable(this.bdos, table);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)11);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
                BandDesign header = table.getHeader();
                IOUtil.writeBool(this.dos, header != null);
                if (header != null && (value = header.accept(this, value)) != null) {
                    return value;
                }
                int count = table.getGroupCount();
                IOUtil.writeInt(this.dos, count);
                int i = 0;
                while (i < count) {
                    GroupDesign group = table.getGroup(i);
                    value = group.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
                BandDesign detail = table.getDetail();
                IOUtil.writeBool(this.dos, detail != null);
                if (detail != null && (value = detail.accept(this, value)) != null) {
                    return value;
                }
                BandDesign footer = table.getFooter();
                IOUtil.writeBool(this.dos, footer != null);
                if (footer != null && (value = footer.accept(this, value)) != null) {
                    return value;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitTemplate(TemplateDesign template, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeTemplate(this.bdos, template);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)19);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        @Override
        public Object visitTextItem(TextItemDesign text, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeText(this.bdos, text);
                this.bdos.flush();
                IOUtil.writeShort(this.dos, (short)15);
                IOUtil.writeBytes(this.dos, this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }
    }
}

