/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result.filter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeExpression
extends FilterExpression {
    private static final FilterExpression[] EMPTY_ARRAY = new FilterExpression[0];
    protected List<FilterExpression> m_expressions;

    public CompositeExpression add(FilterExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("null FilterExpression");
        }
        if (this.m_expressions == null) {
            this.m_expressions = new ArrayList<FilterExpression>(2);
        }
        this.m_expressions.add(expression);
        return this;
    }

    public int childCount() {
        return this.m_expressions == null ? 0 : this.m_expressions.size();
    }

    public FilterExpression[] getChildren() {
        if (this.m_expressions == null) {
            return EMPTY_ARRAY;
        }
        return this.m_expressions.toArray(new FilterExpression[this.m_expressions.size()]);
    }

    protected List<FilterExpression> getExpressions() {
        if (this.m_expressions == null) {
            this.m_expressions = new ArrayList<FilterExpression>(2);
        }
        return this.m_expressions;
    }

    @Override
    public void validateSyntax(ValidationContext context) throws OdaException {
        this.validateChildren(context);
    }

    protected abstract void validateChildren(ValidationContext var1) throws OdaException;

    protected void validateChildren(ValidationContext context, boolean validateAll) throws OdaException {
        if (this.m_expressions == null) {
            return;
        }
        OdaException rootEx = null;
        for (FilterExpression childExpr : this.m_expressions) {
            try {
                if (childExpr instanceof CompositeExpression) {
                    ((CompositeExpression)childExpr).validateChildren(context);
                    continue;
                }
                childExpr.validateSyntax(context);
            }
            catch (OdaException ex) {
                if (!validateAll) {
                    throw ex;
                }
                rootEx = ValidatorUtil.addException(rootEx, ex);
            }
        }
        if (rootEx != null) {
            throw rootEx;
        }
    }

    protected void validateMinElements(int minimumChildren) throws OdaException {
        if (this.getExpressions().size() < minimumChildren) {
            throw ValidatorUtil.newFilterExprException(Messages.bind((String)Messages.querySpec_MISSING_COMPOSITE_MIN_CHILDREN, (Object)this.getName(), (Object)minimumChildren), this);
        }
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(this.getName()) + " [");
        if (this.m_expressions == null) {
            buffer.append(this.m_expressions);
        } else if (this.m_expressions.size() == 1) {
            buffer.append("\n     " + this.m_expressions.get(0));
        } else {
            int i = 0;
            for (FilterExpression childExpr : this.m_expressions) {
                buffer.append("\n " + ++i + ": " + childExpr);
            }
        }
        buffer.append("]");
        return buffer.toString();
    }
}

