/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.ParallelListIterable;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import org.eclipse.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;
import org.eclipse.collections.impl.lazy.ReverseIterable;
import org.eclipse.collections.impl.lazy.parallel.list.SynchronizedParallelListIterable;
import org.eclipse.collections.impl.list.mutable.ListAdapter;
import org.eclipse.collections.impl.list.mutable.UnmodifiableMutableList;

public class SynchronizedMutableList<T>
extends AbstractSynchronizedMutableCollection<T>
implements MutableList<T>,
Serializable {
    private static final long serialVersionUID = 2L;

    SynchronizedMutableList(MutableList<T> newCollection) {
        super(newCollection);
    }

    SynchronizedMutableList(MutableList<T> newCollection, Object newLock) {
        super(newCollection, newLock);
    }

    public static <E, L extends List<E>> SynchronizedMutableList<E> of(L list) {
        MutableList mutableList = list instanceof MutableList ? (MutableList)list : ListAdapter.adapt(list);
        return new SynchronizedMutableList(mutableList);
    }

    public static <E, L extends List<E>> SynchronizedMutableList<E> of(L list, Object lock) {
        MutableList mutableList = list instanceof MutableList ? (MutableList)list : ListAdapter.adapt(list);
        return new SynchronizedMutableList(mutableList, lock);
    }

    @Override
    protected MutableList<T> getDelegate() {
        return (MutableList)super.getDelegate();
    }

    public MutableList<T> with(T element) {
        this.add(element);
        return this;
    }

    public MutableList<T> without(T element) {
        this.remove(element);
        return this;
    }

    public MutableList<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    public MutableList<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> clone() {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedMutableList.of(this.getDelegate().clone());
        }
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy<T>(this.getDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection<? extends T> collection) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().addAll(index, collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T set(int index, T element) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getDelegate().set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, T element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getDelegate().remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> subList(int fromIndex, int toIndex) {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedMutableList.of(this.getDelegate().subList(fromIndex, toIndex), this.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return (T)this.getDelegate().get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAll(UnaryOperator<T> operator) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().replaceAll(operator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Comparator<? super T> comparator) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sort(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> getFirstOptional() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().getFirstOptional();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<T> getLastOptional() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().getLastOptional();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().lastIndexOf(o);
        }
    }

    public ListIterator<T> listIterator() {
        return this.getDelegate().listIterator();
    }

    public ListIterator<T> listIterator(int index) {
        return this.getDelegate().listIterator(index);
    }

    public ParallelListIterable<T> asParallel(ExecutorService executorService, int batchSize) {
        return new SynchronizedParallelListIterable(this.getDelegate().asParallel(executorService, batchSize), this.getLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int binarySearch(T key, Comparator<? super T> comparator) {
        Object object = this.getLock();
        synchronized (object) {
            return Collections.binarySearch(this, key, comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int binarySearch(T key) {
        Object object = this.getLock();
        synchronized (object) {
            return Collections.binarySearch(this, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().indexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> distinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().distinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> distinct(HashingStrategy<? super T> hashingStrategy) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().distinct(hashingStrategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableList<T> distinctBy(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().distinctBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().corresponds(other, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(int fromIndex, int toIndex, Procedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEach(fromIndex, toIndex, procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> takeWhile(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().takeWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().forEachWithIndex(fromIndex, toIndex, objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> dropWhile(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().dropWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableList<T> partitionWhile(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().partitionWhile(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detectIndex(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().detectIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int detectLastIndex(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().detectLastIndex(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> take(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().take(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> drop(int count) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().drop(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseForEach(Procedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().reverseForEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverseForEachWithIndex(ObjectIntProcedure<? super T> procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().reverseForEachWithIndex(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThis(Comparator<? super T> comparator) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThis(comparator);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThis();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> MutableList<T> sortThisBy(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisBy(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByInt(IntFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByInt(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByBoolean(BooleanFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByBoolean(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByChar(CharFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByChar(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByByte(ByteFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByByte(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByShort(ShortFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByShort(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByFloat(FloatFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByFloat(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByLong(LongFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByLong(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> sortThisByDouble(DoubleFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().sortThisByDouble(function);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> reverseThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().reverseThis();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> shuffleThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().shuffleThis();
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> shuffleThis(Random rnd) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().shuffleThis(rnd);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyIterable<T> asReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return ReverseIterable.adapt(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> toReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toReversed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableStack<T> toStack() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<T> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    @Override
    public MutableList<T> tap(Procedure<? super T> procedure) {
        return (MutableList)super.tap(procedure);
    }

    @Override
    public MutableList<T> select(Predicate<? super T> predicate) {
        return (MutableList)super.select(predicate);
    }

    @Override
    public <P> MutableList<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableList)super.selectWith(predicate, parameter);
    }

    @Override
    public MutableList<T> reject(Predicate<? super T> predicate) {
        return (MutableList)super.reject(predicate);
    }

    @Override
    public <P> MutableList<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (MutableList)super.rejectWith(predicate, parameter);
    }

    @Override
    public PartitionMutableList<T> partition(Predicate<? super T> predicate) {
        return (PartitionMutableList)super.partition(predicate);
    }

    @Override
    public <P> PartitionMutableList<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return (PartitionMutableList)super.partitionWith(predicate, parameter);
    }

    @Override
    public <S> MutableList<S> selectInstancesOf(Class<S> clazz) {
        return (MutableList)super.selectInstancesOf(clazz);
    }

    public MutableBooleanList collectBoolean(BooleanFunction<? super T> booleanFunction) {
        return (MutableBooleanList)super.collectBoolean(booleanFunction);
    }

    public MutableByteList collectByte(ByteFunction<? super T> byteFunction) {
        return (MutableByteList)super.collectByte(byteFunction);
    }

    public MutableCharList collectChar(CharFunction<? super T> charFunction) {
        return (MutableCharList)super.collectChar(charFunction);
    }

    public MutableDoubleList collectDouble(DoubleFunction<? super T> doubleFunction) {
        return (MutableDoubleList)super.collectDouble(doubleFunction);
    }

    public MutableFloatList collectFloat(FloatFunction<? super T> floatFunction) {
        return (MutableFloatList)super.collectFloat(floatFunction);
    }

    public MutableIntList collectInt(IntFunction<? super T> intFunction) {
        return (MutableIntList)super.collectInt(intFunction);
    }

    public MutableLongList collectLong(LongFunction<? super T> longFunction) {
        return (MutableLongList)super.collectLong(longFunction);
    }

    public MutableShortList collectShort(ShortFunction<? super T> shortFunction) {
        return (MutableShortList)super.collectShort(shortFunction);
    }

    @Override
    public <V> MutableList<V> collect(Function<? super T, ? extends V> function) {
        return (MutableList)super.collect(function);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableList<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectWithIndex(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getDelegate().collectWithIndex(function, target);
        }
    }

    @Override
    public <P, V> MutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return (MutableList)super.collectWith(function, parameter);
    }

    @Override
    public <V> MutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return (MutableList)super.collectIf(predicate, function);
    }

    @Override
    public <V> MutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return (MutableList)super.flatCollect(function);
    }

    @Override
    public <V> MutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return (MutableListMultimap)super.groupBy(function);
    }

    @Override
    public <V> MutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return (MutableListMultimap)super.groupByEach(function);
    }

    @Override
    public <S> MutableList<Pair<T, S>> zip(Iterable<S> that) {
        return (MutableList)super.zip(that);
    }

    @Override
    public MutableList<Pair<T, Integer>> zipWithIndex() {
        return (MutableList)super.zipWithIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return UnmodifiableMutableList.of(this);
        }
    }

    public MutableList<T> asSynchronized() {
        return this;
    }
}

