/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.TextStringBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.ebr.maven.LicenseProcessingUtility;
import org.eclipse.ebr.maven.TemplateHelper;
import org.eclipse.ebr.maven.eclipseip.KnownLicense;

public class AboutFilesUtil
extends LicenseProcessingUtility {
    private static final String REQUIRES_FORCE_DOWNLOAD_MESSAGE = "Please set the forceDownload property to true in order to download it again (eg. '-DforceDownload=true' via command line).";
    private static final String ABOUT_HTML = "about.html";
    private final boolean forceDownload;

    public AboutFilesUtil(Log log, MavenSession mavenSession, boolean force, boolean forceDownload) {
        super(log, mavenSession, force);
        this.forceDownload = forceDownload;
    }

    private void appendAndDownloadLicenseInfo(TextStringBuilder text, File downloadDir, Artifact artifact, List<License> licenses) throws MojoExecutionException {
        boolean first = true;
        Iterator<License> stream = licenses.iterator();
        while (stream.hasNext()) {
            License license = stream.next();
            if (!first && !stream.hasNext()) {
                text.append(" and ");
            } else if (!first && stream.hasNext()) {
                text.append(", ");
            } else {
                first = false;
            }
            String localLicenseFile = this.getLocalLicenseFile(downloadDir, license);
            String url = license.getUrl();
            boolean wroteUrl = false;
            String licenseFileName = null;
            if (localLicenseFile != null) {
                this.getLog().info((CharSequence)String.format("Using local license file (%s) for '%s'.", localLicenseFile, license.getName()));
                licenseFileName = localLicenseFile;
            } else if (this.isPotentialWebUrl(url)) {
                try {
                    URL licenseUrl = this.toUrl(url);
                    text.append("<a href=\"").append(licenseUrl.toExternalForm()).append("\" target=\"_blank\">");
                    wroteUrl = true;
                    try {
                        this.getLog().info((CharSequence)String.format("Downloading license '%s' (%s).", license.getName(), licenseUrl.toExternalForm()));
                        licenseFileName = this.downloadLicenseFile(downloadDir, license, licenseUrl);
                        this.getLog().info((CharSequence)String.format("  -> %s.", licenseFileName));
                    }
                    catch (IOException e) {
                        licenseFileName = null;
                        this.getLog().debug((Throwable)e);
                        this.getLog().warn((CharSequence)String.format("Unable to download license file from '%s'. Please add manually to recipe project. %s", licenseUrl.toExternalForm(), e.getMessage()));
                    }
                }
                catch (MalformedURLException e) {
                    this.getLog().debug((Throwable)e);
                    this.getLog().warn((CharSequence)String.format("Invalid license url '%s' in artifact pom '%s'.", url, artifact.getFile()));
                }
            }
            text.append(StringEscapeUtils.escapeHtml4((String)license.getName()));
            if (wroteUrl) {
                text.append("</a>");
            }
            if (licenseFileName == null) continue;
            text.append(" (<a href=\"").append(licenseFileName).append("\" target=\"_blank\">").append(FilenameUtils.getName((String)licenseFileName)).append("</a>)");
        }
    }

    private void appendIssueTrackingInfo(TextStringBuilder text, Artifact artifact, Model artifactPom) {
        String url = artifactPom.getIssueManagement().getUrl();
        if (this.isPotentialWebUrl(url)) {
            try {
                URL issueTrackingUrl = this.toUrl(url);
                text.append("Bugs or feature requests can be made in the project issue tracking system at ");
                text.append("<a href=\"").append(issueTrackingUrl.toExternalForm()).append("\" target=\"_blank\">");
                text.append(StringEscapeUtils.escapeHtml4((String)this.removeWebProtocols(url)));
                text.append("</a>.");
            }
            catch (MalformedURLException e) {
                this.getLog().debug((Throwable)e);
                this.getLog().warn((CharSequence)String.format("Invalide project issue tracking url '%s' in artifact pom '%s'.", url, artifact.getFile()));
            }
        } else if (StringUtils.isNotBlank((CharSequence)url)) {
            text.append("Bugs or feature requests can be made in the project issue tracking system at ");
            text.append(StringEscapeUtils.escapeHtml4((String)url)).append('.');
        }
    }

    private void appendMailingListInfo(TextStringBuilder text, Artifact artifact, Model artifactPom) {
        boolean first = true;
        Iterator stream = artifactPom.getMailingLists().iterator();
        while (stream.hasNext()) {
            String url;
            MailingList mailingList = (MailingList)stream.next();
            if (!first && !stream.hasNext()) {
                text.append(" or ");
            } else if (!first && stream.hasNext()) {
                text.append(", ");
            } else {
                first = false;
            }
            text.append(StringEscapeUtils.escapeHtml4((String)mailingList.getName()));
            if (StringUtils.isNotBlank((CharSequence)mailingList.getPost())) {
                text.append(" &lt;").append(StringEscapeUtils.escapeHtml4((String)mailingList.getPost())).append("&gt;");
            }
            if (!this.isPotentialWebUrl(url = mailingList.getArchive())) continue;
            try {
                URL archiveUrl = this.toUrl(url);
                text.append(" (<a href=\"").append(archiveUrl.toExternalForm()).append("\" target=\"_blank\">archive</a>)");
            }
            catch (MalformedURLException e) {
                this.getLog().debug((Throwable)e);
                this.getLog().warn((CharSequence)String.format("Invalide mailing list archive url '%s' in artifact pom '%s'.", url, artifact.getFile()));
            }
        }
    }

    private String downloadLicenseFile(File licenseOutputDir, License license, URL licenseUrl) throws IOException {
        String licenseFileName = "about_files/" + this.sanitizeFileName(license.getName()).toUpperCase();
        String existingLicense = this.findExistingLicenseFile(licenseOutputDir, licenseFileName);
        if (existingLicense != null) {
            if (!this.forceDownload) {
                this.getLog().info((CharSequence)String.format("Found existing license file at '%s'. %s", existingLicense, REQUIRES_FORCE_DOWNLOAD_MESSAGE));
                return existingLicense;
            }
            if (this.getMavenSession().isOffline()) {
                this.getLog().warn((CharSequence)String.format("Re-using existing license file at '%s'. Maven is offline.", existingLicense));
                return existingLicense;
            }
        } else if (this.getMavenSession().isOffline()) {
            throw new IOException("Maven is offline.");
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpGet get = new HttpGet(licenseUrl.toExternalForm());
            get.setHeader("Accept", "text/plain,text/html");
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new IOException(String.format("Download failed: %s", response.getStatusLine().toString()));
                }
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new IOException("Download faild. Empty respose.");
                }
                Throwable throwable3 = null;
                Object var15_20 = null;
                try (InputStream is = entity.getContent();){
                    ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                    if (StringUtils.equalsIgnoreCase((CharSequence)contentType.getMimeType(), (CharSequence)"text/plain")) {
                        licenseFileName = String.valueOf(licenseFileName) + ".txt";
                    } else if (StringUtils.equalsIgnoreCase((CharSequence)contentType.getMimeType(), (CharSequence)"text/html")) {
                        licenseFileName = String.valueOf(licenseFileName) + ".html";
                    } else {
                        this.getLog().warn((CharSequence)String.format("Unexpected content type (%s) returned by remote server. Falling back to text/plain.", contentType));
                        licenseFileName = String.valueOf(licenseFileName) + ".txt";
                    }
                    Throwable throwable4 = null;
                    Object var19_26 = null;
                    try (FileOutputStream os = FileUtils.openOutputStream((File)new File(licenseOutputDir, licenseFileName));){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                    catch (Throwable throwable5) {
                        if (throwable4 == null) {
                            throwable4 = throwable5;
                        } else if (throwable4 != throwable5) {
                            throwable4.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable3 == null) {
                        throwable3 = throwable6;
                    } else if (throwable3 != throwable6) {
                        throwable3.addSuppressed(throwable6);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable7) {
                if (throwable2 == null) {
                    throwable2 = throwable7;
                } else if (throwable2 != throwable7) {
                    throwable2.addSuppressed(throwable7);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable8) {
            if (throwable == null) {
                throwable = throwable8;
            } else if (throwable != throwable8) {
                throwable.addSuppressed(throwable8);
            }
            throw throwable;
        }
        return licenseFileName;
    }

    private String findExistingLicenseFile(File licenseOutputDir, String licenseFileName) {
        for (String extension : Arrays.asList(".txt", ".html")) {
            if (!new File(licenseOutputDir, String.valueOf(licenseFileName) + extension).isFile()) continue;
            return String.valueOf(licenseFileName) + extension;
        }
        return null;
    }

    public void generateAboutHtmlFile(SortedMap<Artifact, Model> dependencies, File outputDirectory) throws MojoExecutionException {
        File aboutHtmlFile = new File(outputDirectory, ABOUT_HTML);
        if (aboutHtmlFile.isFile() && !this.isForce()) {
            this.getLog().warn((CharSequence)String.format("Found existing about.html file at '%s'. %s", aboutHtmlFile, "Please set the force property to true in order to update/override it (eg. '-Dforce=true' via command line)."));
            return;
        }
        String aboutHtmlText = this.readAboutHtmlTemplate();
        aboutHtmlText = StringUtils.replaceEach((String)aboutHtmlText, (String[])new String[]{"@DATE@", "@THIRD_PARTY_INFO@"}, (String[])new String[]{DateFormat.getDateInstance(1, Locale.US).format(new Date()), this.getThirdPartyInfo(dependencies, outputDirectory)});
        try {
            FileUtils.writeStringToFile((File)aboutHtmlFile, (String)aboutHtmlText, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Unable to write about.html file '%s'. %s", aboutHtmlFile, e.getMessage()));
        }
    }

    private String getDevelopedByInfo(Artifact artifact, Model artifactPom) {
        TextStringBuilder developedByInfo = new TextStringBuilder();
        if (artifactPom.getOrganization() != null) {
            String url = artifactPom.getOrganization().getUrl();
            boolean wroteUrl = false;
            if (this.isPotentialWebUrl(url)) {
                try {
                    URL organizationUrl = this.toUrl(url);
                    developedByInfo.append("<a href=\"").append(organizationUrl.toExternalForm()).append("\" target=\"_blank\">");
                    wroteUrl = true;
                }
                catch (MalformedURLException e) {
                    this.getLog().debug((Throwable)e);
                    this.getLog().warn((CharSequence)String.format("Invalide organization url '%s' in artifact pom '%s'.", url, artifact.getFile()));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)artifactPom.getOrganization().getName())) {
                developedByInfo.append(StringEscapeUtils.escapeHtml4((String)artifactPom.getOrganization().getName()));
            } else if (StringUtils.isNotBlank((CharSequence)url)) {
                developedByInfo.append(StringEscapeUtils.escapeHtml4((String)this.removeWebProtocols(url)));
            }
            if (wroteUrl) {
                developedByInfo.append("</a>");
            }
        }
        if (developedByInfo.isEmpty()) {
            if (!artifactPom.getDevelopers().isEmpty()) {
                this.appendDeveloperInfo(developedByInfo, artifactPom);
            } else {
                this.getLog().warn((CharSequence)String.format("Neither organization nor developer information is available for artifact '%s:%s:%s'. Please fill in manually.", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
                developedByInfo.append("someone");
            }
        }
        return developedByInfo.toString();
    }

    private String getLicenseInfo(Artifact resolvedPomArtifact, Model artifactPom, File resourcesDir) throws MojoExecutionException {
        TextStringBuilder licenseInfo = new TextStringBuilder();
        KnownLicense knownLicense = this.getLicense(resolvedPomArtifact);
        List<License> licenses = artifactPom.getLicenses();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Collecting license information...");
            this.getLog().debug((CharSequence)("  known license: " + knownLicense));
            if (licenses != null && !licenses.isEmpty()) {
                for (License license : licenses) {
                    this.getLog().debug((CharSequence)String.format("    pom license: %s (%s)", license.getName(), license.getUrl()));
                }
            } else {
                this.getLog().debug((CharSequence)"    pom license: none");
            }
        }
        if (knownLicense != null && this.isDualOrMoreLicensed(licenses)) {
            this.getLog().debug((CharSequence)("Detected dual license ... electing to use package under: " + knownLicense));
            licenseInfo.append("Though this package is dually licensed, the Eclipse Foundation elects to use the package under the ");
            this.appendAndDownloadLicenseInfo(licenseInfo, resourcesDir, resolvedPomArtifact, Arrays.asList(knownLicense.toMavenLicense()));
            licenseInfo.append(" license.");
        } else if (knownLicense != null || !licenses.isEmpty()) {
            if (knownLicense != null) {
                this.getLog().debug((CharSequence)("Overruling pom license with known license " + knownLicense));
                licenses = Arrays.asList(knownLicense.toMavenLicense());
            }
            licenseInfo.append(StringEscapeUtils.escapeHtml4((String)artifactPom.getName())).append(" is provided to you under the terms and conditions of the ");
            this.appendAndDownloadLicenseInfo(licenseInfo, resourcesDir, resolvedPomArtifact, licenses);
            if (licenses.size() == 1) {
                licenseInfo.append(" license.");
            } else {
                licenseInfo.append(" licenses.");
            }
        } else {
            this.getLog().warn((CharSequence)String.format("No licensing information found for artifact %s:%s:%s. Please fill in information in about.html manually!", artifactPom.getGroupId(), artifactPom.getArtifactId(), artifactPom.getVersion()));
            licenseInfo.append(StringEscapeUtils.escapeHtml4((String)artifactPom.getName())).append(" is distributed without licensing information.");
            if (!artifactPom.getDevelopers().isEmpty()) {
                licenseInfo.append("Please contact the ");
                if (artifactPom.getDevelopers().size() == 1) {
                    licenseInfo.append("developer ");
                } else {
                    licenseInfo.append("developers ");
                }
                this.appendDeveloperInfo(licenseInfo, artifactPom);
                licenseInfo.append(" for further information");
            }
        }
        return licenseInfo.toString();
    }

    private String getLocalLicenseFile(File licenseOutputDir, License license) throws MojoExecutionException {
        String localLicenseFile = this.getLicenseFile(license.getName());
        if (localLicenseFile == null) {
            return null;
        }
        String licenseFileName = "about_files/" + localLicenseFile;
        File licenseFile = new File(licenseOutputDir, licenseFileName);
        this.getLog().debug((CharSequence)String.format("Searching for existing local license file '%s' at '%s'.", licenseFileName, licenseFile));
        if (!licenseFile.isFile()) {
            throw new MojoExecutionException(String.format("Local license file '%s' configured for license '%s' not found at '%s'.", localLicenseFile, license.getName(), licenseFileName));
        }
        return licenseFileName;
    }

    private String getOriginInfo(Artifact artifact, Model artifactPom) {
        TextStringBuilder originInfo = new TextStringBuilder();
        String url = artifactPom.getUrl();
        if (this.isPotentialWebUrl(url)) {
            try {
                URL organizationUrl = this.toUrl(url);
                originInfo.append(StringEscapeUtils.escapeHtml4((String)artifactPom.getName())).append(" including its source is available from ");
                originInfo.append("<a href=\"").append(organizationUrl.toExternalForm()).append("\" target=\"_blank\">");
                originInfo.append(StringEscapeUtils.escapeHtml4((String)this.removeWebProtocols(url)));
                originInfo.append("</a>.");
            }
            catch (MalformedURLException e) {
                this.getLog().debug((Throwable)e);
                this.getLog().warn((CharSequence)String.format("Invalide project url '%s' in artifact pom '%s'.", url, artifact.getFile()));
            }
        } else if (StringUtils.isNotBlank((CharSequence)url)) {
            originInfo.append(StringEscapeUtils.escapeHtml4((String)artifactPom.getName())).append(" including its source is available from ");
            originInfo.append(StringEscapeUtils.escapeHtml4((String)url)).append('.');
        }
        if (originInfo.isEmpty()) {
            this.getLog().warn((CharSequence)String.format("No project origin information is available for artifact '%s:%s:%s'. Please fill in manually.", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
            originInfo.append(StringEscapeUtils.escapeHtml4((String)artifactPom.getName())).append(" is available from Maven as ");
            originInfo.append(StringEscapeUtils.escapeHtml4((String)artifact.getGroupId())).append(':').append(StringEscapeUtils.escapeHtml4((String)artifact.getArtifactId())).append(':').append(StringEscapeUtils.escapeHtml4((String)artifact.getVersion())).append('.');
        }
        if (artifactPom.getIssueManagement() != null) {
            originInfo.append(' ');
            this.appendIssueTrackingInfo(originInfo, artifact, artifactPom);
        }
        if (!artifactPom.getMailingLists().isEmpty()) {
            originInfo.append(" The following");
            if (artifactPom.getMailingLists().size() == 1) {
                originInfo.append(" mailing list");
            } else {
                originInfo.append(" mailing lists");
            }
            originInfo.append(" can be used to communicate with the project communities: ");
            this.appendMailingListInfo(originInfo, artifact, artifactPom);
            originInfo.append(".");
        }
        return originInfo.toString();
    }

    private String getThirdPartyInfo(SortedMap<Artifact, Model> dependencies, File outputDirectory) throws MojoExecutionException {
        TextStringBuilder thirdPartyInfoText = new TextStringBuilder();
        for (Map.Entry<Artifact, Model> entry : dependencies.entrySet()) {
            String thirdPartyInfo = this.readThirdPartyHtmlTemplate();
            Artifact artifact = entry.getKey();
            Model artifactPom = entry.getValue();
            thirdPartyInfo = StringUtils.replaceEach((String)thirdPartyInfo, (String[])new String[]{"@DEPENDENCY_HEADLINE@", "@DEPENDENCY_BY@", "@DEPENDENCY_NAME@", "@DEPENDENCY_LICENSING@", "@DEPENDENCY_ORIGIN@"}, (String[])new String[]{StringEscapeUtils.escapeHtml4((String)artifactPom.getName()), this.getDevelopedByInfo(artifact, artifactPom), StringEscapeUtils.escapeHtml4((String)artifactPom.getName()), this.getLicenseInfo(artifact, artifactPom, outputDirectory), this.getOriginInfo(artifact, artifactPom)});
            thirdPartyInfoText.append(thirdPartyInfo);
        }
        return thirdPartyInfoText.toString();
    }

    private String readAboutHtmlTemplate() throws MojoExecutionException {
        try {
            return IOUtils.toString((InputStream)TemplateHelper.getTemplate("recipe-about.html"), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Error reading about.html template: %s", e.getMessage()));
        }
    }

    private String readThirdPartyHtmlTemplate() throws MojoExecutionException {
        try {
            return IOUtils.toString((InputStream)TemplateHelper.getTemplate("recipe-about-3rdparty.html"), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Error reading 3rd party info template: %s", e.getMessage()));
        }
    }

    private String sanitizeFileName(String name) {
        TextStringBuilder result = new TextStringBuilder();
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.') {
                result.append(c);
            } else {
                result.append('_');
            }
            ++n2;
        }
        return result.toString();
    }
}

