/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.felix.bundleplugin.ManifestPlugin;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.util.AbstractScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.ebr.maven.DependencyUtil;
import org.eclipse.ebr.maven.shared.BundleUtil;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="bundle", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class BundleMojo
extends ManifestPlugin {
    private static final String CLASSIFIER_SOURCES = "sources";
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true, required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected String buildDirectory;
    @Parameter(defaultValue="${project.build.directory}/dependency-bin", readonly=true, required=true)
    protected String dependenciesDirectory;
    @Parameter(defaultValue="${project.build.directory}/dependency-src", readonly=true, required=true)
    protected String dependenciesSourcesDirectory;
    @Parameter(property="includeProjectResourceDir", defaultValue="true")
    protected boolean includeProjectResourceDir;
    @Parameter(property="unpackDependencies", defaultValue="true")
    protected boolean unpackDependencies;
    @Parameter(property="stripVersion", defaultValue="false")
    protected boolean stripVersion;
    @Parameter(property="excludeDotFolderFromBundleClasspath", defaultValue="false")
    protected boolean excludeDotFolderFromBundleClasspath;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private RuntimeInformation mavenRuntimeInformation;
    @Parameter
    protected Map<String, String> bndInstructions = new LinkedHashMap<String, String>();
    @Parameter
    protected String includes;
    @Parameter
    protected String excludes;
    @Parameter(defaultValue="${excludeDependencies}")
    protected String excludeDependencies;
    @Parameter(defaultValue="${project.build.finalName}", alias="jarName", required=true)
    protected String finalName;
    @Parameter
    private final MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter
    private final MavenArchiveConfiguration sourceArchive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${buildQualifier}")
    protected String qualifier;
    @Parameter(defaultValue="none", property="signingServiceType")
    protected String signingServiceType;
    @Parameter(defaultValue="1.0.0-SNAPSHOT", property="ebr-tycho-extras-plugin.version", required=true)
    protected String ebrTychoExtrasPluginVersionFallback;
    @Parameter(defaultValue="1.2.0", property="tycho-plugin.version", required=true)
    protected String tychoPluginVersionFallback;
    @Parameter(defaultValue="1.2.0", property="tycho-extras-plugin.version", required=true)
    protected String tychoExtrasPluginVersionFallback;
    @Parameter(defaultValue="3.1.0", property="maven-resource-plugin.version", required=true)
    protected String mavenResourcesPluginVersionFallback;
    @Parameter(defaultValue="3.1.1", property="maven-dependency-plugin.version", required=true)
    protected String mavenDependencyPluginVersionFallback;
    @Parameter(defaultValue="1.1.5", property="cbi-plugin.version", required=true)
    protected String cbiPluginVersionFallback;

    static boolean isRecipeProject(MavenProject project) {
        return "eclipse-bundle-recipe".equals(project.getPackaging());
    }

    private File assembleJar(String jarName, File manifest, File directory, MavenArchiveConfiguration archiveConfiguration) throws MojoExecutionException {
        try {
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(new JarArchiver());
            File jarFile = new File(this.buildDirectory, jarName);
            if (jarFile.exists()) {
                FileUtils.forceDelete((File)jarFile);
            }
            archiver.getArchiver().addFileSet(this.getFileSet(directory));
            if (manifest.exists()) {
                archiveConfiguration.setManifestFile(manifest);
            }
            archiver.setOutputFile(jarFile);
            if (!archiveConfiguration.isForced()) {
                this.getLog().warn((CharSequence)"ignoring unsupported archive forced = false parameter.");
                archiveConfiguration.setForced(true);
            }
            archiver.createArchive(this.session, this.project, archiveConfiguration);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling JAR " + jarName + ": " + e.getMessage(), e);
        }
    }

    private void assembleP2Repository() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Assembling p2 repository...");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.eclipse.ebr"), (String)MojoExecutor.artifactId((String)"ebr-tycho-extras-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.eclipse.ebr", "ebr-tycho-extras-plugin", this.ebrTychoExtrasPluginVersionFallback))), (String)MojoExecutor.goal((String)"assemble-bundle-p2-repository"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    private void buildBundle(Set<Artifact> dependencies) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Gathering dependencies");
        this.executeMavenDependenciesPluginForGatheringBinaryDependencies(dependencies);
        this.getLog().info((CharSequence)"Merging collected dependencies");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.apache.maven.plugins", "maven-resources-plugin", this.mavenResourcesPluginVersionFallback))), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"outputDirectory", (String)"${project.build.outputDirectory}"), MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)this.dependenciesDirectory)})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        this.getLog().info((CharSequence)"Generating OSGi MANIFEST.MF");
        try {
            this.setOutputDirectory(this.outputDirectory);
            this.setBuildDirectory(this.buildDirectory);
            this.manifestLocation = new File(this.outputDirectory, "META-INF");
            ((ManifestPlugin)this).excludeDependencies = this.excludeDependencies;
            if (this.bndInstructions.containsKey("Bundle-SymbolicName") && !StringUtils.equals((CharSequence)this.project.getArtifactId(), (CharSequence)this.bndInstructions.get("Bundle-SymbolicName"))) {
                throw new MojoExecutionException("Plug-in configuration is wrong! The Bundle-SymbolicName must match the project's artifact id but it doesn't. Please correct the value in bndInstructions.");
            }
            this.initializeBndInstruction("Bundle-SymbolicName", this.project.getArtifactId());
            this.initializeBndInstruction("Bundle-Version", this.getExpandedVersion());
            this.initializeBndInstruction("Bundle-Name", this.project.getName());
            this.initializeBndInstruction("-snapshot", this.qualifier);
            if (!this.unpackDependencies) {
                this.initializeBndInstruction("Bundle-ClassPath", this.getBundleClassPathHeaderPopulatedWithDependencyJars());
            }
            this.execute(this.bndInstructions, this.getClasspath(this.project));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating Bundle manifest: " + e.getMessage(), e);
        }
        this.getLog().debug((CharSequence)"Generating OSGi bundle jar...");
        File pluginFile = this.createPluginJar();
        this.project.getArtifact().setFile(pluginFile);
    }

    private void buildSourceBundle(Set<Artifact> dependencies) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Gathering sources");
        List<MojoExecutor.Element> unpackConfigurationSource = this.getDependenciesUnpackConfiguration(this.dependenciesSourcesDirectory, dependencies, CLASSIFIER_SOURCES);
        try {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.apache.maven.plugins", "maven-dependency-plugin", this.mavenDependencyPluginVersionFallback))), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])unpackConfigurationSource.toArray(new MojoExecutor.Element[unpackConfigurationSource.size()])), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        }
        catch (MojoExecutionException e) {
            this.getLog().warn((CharSequence)"Unable to resolve source jar; skipping source bundle");
            this.getLog().debug((Throwable)e);
            return;
        }
        if (this.includeProjectResourceDir) {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-resources-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.apache.maven.plugins", "maven-resources-plugin", this.mavenResourcesPluginVersionFallback))), (String)MojoExecutor.goal((String)"copy-resources"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"outputDirectory", (String)"${project.build.directory}/dependency-src"), MojoExecutor.element((String)"resources", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)"${project.basedir}/src/main/resources")}), MojoExecutor.element((String)"resource", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"directory", (String)"${project.basedir}/src/main/java")})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        }
        this.getLog().debug((CharSequence)"Generating OSGi bundle jar...");
        File sourceBundleFile = this.createSourcesJar();
        this.projectHelper.attachArtifact(this.project, "java-source", CLASSIFIER_SOURCES, sourceBundleFile);
    }

    private File createPluginJar() throws MojoExecutionException {
        return this.assembleJar(String.valueOf(this.finalName) + ".jar", this.generateFinalBundleManifest(), this.outputDirectory, this.archive);
    }

    private File createSourcesJar() throws MojoExecutionException {
        this.sourceArchive.setAddMavenDescriptor(false);
        return this.assembleJar(String.valueOf(this.finalName) + "-sources.jar", this.generateSourceBundleManifest(), new File(this.dependenciesSourcesDirectory), this.sourceArchive);
    }

    private String detectPluginVersion(String groupId, String artifactId, String fallbackVersion) {
        List plugins = this.project.getPluginManagement().getPlugins();
        for (Plugin plugin : plugins) {
            if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
            this.getLog().debug((CharSequence)("Using managed version " + plugin.getVersion() + " for plugin " + groupId + ":" + artifactId + "."));
            return plugin.getVersion();
        }
        this.getLog().warn((CharSequence)String.format("No version defined in the efective model for plugin %s:%s. Please consider defining one in the pluginManagement section. Falling back to version \"%s\"", groupId, artifactId, fallbackVersion));
        return fallbackVersion;
    }

    public void execute() throws MojoExecutionException {
        if (!BundleMojo.isRecipeProject(this.project)) {
            this.getLog().debug((CharSequence)String.format("Skipping execution for project with packaging type \"%s\"", this.project.getPackaging()));
            return;
        }
        if (!this.mavenRuntimeInformation.isMavenVersion("[3.3.9,)")) {
            throw new MojoExecutionException("The minimum required Maven version is 3.3.9. Please update your Maven installation!");
        }
        Set<Artifact> dependencies = this.getDependenciesToInclude();
        this.buildBundle(dependencies);
        this.buildSourceBundle(dependencies);
        this.packAndSignBundle();
        this.publishP2Metadata();
        this.assembleP2Repository();
    }

    private void executeMavenDependenciesPluginForGatheringBinaryDependencies(Set<Artifact> dependencies) throws MojoExecutionException {
        if (this.unpackDependencies) {
            List<MojoExecutor.Element> unpackConfiguration = this.getDependenciesUnpackConfiguration(this.dependenciesDirectory, dependencies, null);
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.apache.maven.plugins", "maven-dependency-plugin", this.mavenDependencyPluginVersionFallback))), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])unpackConfiguration.toArray(new MojoExecutor.Element[unpackConfiguration.size()])), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        } else {
            String outputDirectory = this.dependenciesDirectory.concat("/lib");
            List<MojoExecutor.Element> copyConfiguration = this.getDependenciesCopyConfiguration(outputDirectory, dependencies, null);
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.apache.maven.plugins", "maven-dependency-plugin", this.mavenDependencyPluginVersionFallback))), (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])copyConfiguration.toArray(new MojoExecutor.Element[copyConfiguration.size()])), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        }
    }

    private File generateFinalBundleManifest() throws MojoExecutionException {
        try {
            Manifest mf;
            File mfile = new File(this.outputDirectory, "META-INF/MANIFEST.MF");
            try (FileInputStream is = new FileInputStream(mfile);){
                mf = new Manifest(is);
            }
            Attributes attributes = mf.getMainAttributes();
            if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
                attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            }
            attributes.putValue("Created-By", "Eclipse Bundle Recipe Maven Plug-in");
            String expandedVersion = this.getExpandedVersion();
            attributes.putValue("Bundle-Version", expandedVersion);
            mfile = this.getFinalBundleManifestFile();
            mfile.getParentFile().mkdirs();
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mfile));){
                mf.write(os);
            }
            return mfile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating bundle manifest: " + e.getMessage(), e);
        }
    }

    private void generateSourceBundleL10nFile() throws IOException {
        Manifest bundleManifest;
        try (FileInputStream is = new FileInputStream(this.getFinalBundleManifestFile());){
            bundleManifest = new Manifest(is);
        }
        Properties l10nProps = this.readL10nProps(bundleManifest);
        String bundleName = this.getL10nResolvedValue(bundleManifest, "Bundle-Name", l10nProps);
        if (bundleName == null) {
            this.getLog().warn((CharSequence)("Bundle-Name header not found in " + this.getFinalBundleManifestFile() + ", fallback to Bundle-SymbolicName for source bundle"));
            bundleName = this.getSourceBundleSymbolicName();
        }
        String sourceBundleName = String.valueOf(bundleName) + " Source";
        String bundleVendor = this.getL10nResolvedValue(bundleManifest, "Bundle-Vendor", l10nProps);
        if (bundleVendor == null) {
            this.getLog().warn((CharSequence)("Bundle-Vendor header not found in " + this.getFinalBundleManifestFile() + ", fallback to 'unknown' for source bundle"));
            bundleVendor = "unknown";
        }
        File l10nOutputDir = new File(this.dependenciesSourcesDirectory);
        Properties sourceL10nProps = new Properties();
        sourceL10nProps.setProperty("bundleName", sourceBundleName);
        sourceL10nProps.setProperty("bundleVendor", bundleVendor);
        File l10nPropsFile = new File(l10nOutputDir, "OSGI-INF/l10n/bundle.properties");
        l10nPropsFile.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(l10nPropsFile);
            sourceL10nProps.store(out, "Source Bundle Localization");
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((OutputStream)out);
    }

    private File generateSourceBundleManifest() throws MojoExecutionException {
        try {
            this.generateSourceBundleL10nFile();
            Manifest mf = new Manifest();
            Attributes attributes = mf.getMainAttributes();
            if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
                attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            }
            String expandedVersion = this.getExpandedVersion();
            attributes.putValue("Bundle-Version", expandedVersion);
            attributes.putValue("Bundle-ManifestVersion", "2");
            attributes.putValue("Bundle-SymbolicName", this.getSourceBundleSymbolicName());
            attributes.putValue("Bundle-Name", "%bundleName");
            attributes.putValue("Bundle-Vendor", "%bundleVendor");
            attributes.putValue("Eclipse-SourceBundle", String.valueOf(this.project.getArtifactId()) + ";version=\"" + expandedVersion + "\";roots:=\".\"");
            attributes.putValue("Created-By", "Eclipse Bundle Recipe Maven Plug-in");
            File mfile = this.getSourceBundleManifestFile();
            mfile.getParentFile().mkdirs();
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mfile));){
                mf.write(os);
            }
            return mfile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating source bundle manifest: " + e.getMessage(), e);
        }
    }

    private MojoExecutor.Element getArtifactItems(Set<Artifact> dependencies, String classifier) {
        ArrayList<MojoExecutor.Element> artifactItems = new ArrayList<MojoExecutor.Element>();
        for (Artifact artifact : dependencies) {
            if (classifier != null) {
                artifactItems.add(MojoExecutor.element((String)"artifactItem", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"groupId", (String)artifact.getGroupId()), MojoExecutor.element((String)"artifactId", (String)artifact.getArtifactId()), MojoExecutor.element((String)"version", (String)artifact.getVersion()), MojoExecutor.element((String)"classifier", (String)classifier)}));
                continue;
            }
            artifactItems.add(MojoExecutor.element((String)"artifactItem", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"groupId", (String)artifact.getGroupId()), MojoExecutor.element((String)"artifactId", (String)artifact.getArtifactId()), MojoExecutor.element((String)"version", (String)artifact.getVersion()), MojoExecutor.element((String)"classifier", (String)artifact.getClassifier())}));
        }
        return MojoExecutor.element((String)"artifactItems", (MojoExecutor.Element[])artifactItems.toArray(new MojoExecutor.Element[artifactItems.size()]));
    }

    private String getBundleClassPathHeaderPopulatedWithDependencyJars() throws MojoExecutionException {
        if (this.excludeDotFolderFromBundleClasspath) {
            return this.getDependenciesJarFilesFromLibFolderAsCommaSeparatedString();
        }
        return ".,".concat(this.getDependenciesJarFilesFromLibFolderAsCommaSeparatedString());
    }

    private String getBundleVersion() {
        return BundleUtil.getBundleVersion((String)this.project.getVersion());
    }

    private List<MojoExecutor.Element> getDependenciesCopyConfiguration(String outputDirectory, Set<Artifact> dependencies, String classifier) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> copyConfiguration = new ArrayList<MojoExecutor.Element>();
        copyConfiguration.add(MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)outputDirectory));
        copyConfiguration.add(MojoExecutor.element((String)MojoExecutor.name((String)"stripVersion"), (String)String.valueOf(this.stripVersion)));
        copyConfiguration.add(this.getArtifactItems(dependencies, classifier));
        return copyConfiguration;
    }

    private String getDependenciesJarFilesFromLibFolderAsCommaSeparatedString() throws MojoExecutionException {
        File libDirectory = Paths.get(this.dependenciesDirectory, new String[0]).resolve("lib").toFile();
        if (!libDirectory.isDirectory()) {
            throw new MojoExecutionException(String.format("Folder '%s' does not exists. It seems no dependencies were downloaded at all.", libDirectory));
        }
        String[] jars = libDirectory.list((f, s) -> s.toLowerCase().endsWith(".jar"));
        if (jars == null || jars.length == 0) {
            throw new MojoExecutionException(String.format("No jar files found in folder '%s'. Please verify that dependencies are specified and downloaded successfully.", libDirectory));
        }
        return Stream.of(jars).sorted().map(jar -> "lib/".concat((String)jar)).collect(Collectors.joining(","));
    }

    private Set<Artifact> getDependenciesToInclude() {
        DependencyUtil dependencyUtil = new DependencyUtil(this.getLog(), this.session);
        dependencyUtil.initializeExcludeDependencies(this.excludeDependencies);
        return dependencyUtil.getDependenciesToInclude(this.project);
    }

    private List<MojoExecutor.Element> getDependenciesUnpackConfiguration(String outputDirectory, Set<Artifact> dependencies, String classifier) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> unpackConfiguration = new ArrayList<MojoExecutor.Element>();
        unpackConfiguration.add(MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)outputDirectory));
        if (this.excludes != null) {
            unpackConfiguration.add(MojoExecutor.element((String)MojoExecutor.name((String)"excludes"), (String)this.excludes));
        }
        if (this.includes != null) {
            unpackConfiguration.add(MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (String)this.includes));
        }
        unpackConfiguration.add(this.getArtifactItems(dependencies, classifier));
        return unpackConfiguration;
    }

    private String getExpandedVersion() {
        return BundleUtil.getExpandedVersion((String)this.getBundleVersion(), (String)this.qualifier);
    }

    private FileSet getFileSet(File basedir) {
        DefaultFileSet fileSet = new DefaultFileSet();
        fileSet.setDirectory(basedir);
        fileSet.setExcludes(AbstractScanner.DEFAULTEXCLUDES);
        return fileSet;
    }

    private File getFinalBundleManifestFile() {
        return new File(this.buildDirectory, "MANIFEST.MF");
    }

    private String getL10nResolvedValue(Manifest manifest, String manifestHeaderKey, Properties l10nProps) {
        String value = manifest.getMainAttributes().getValue(manifestHeaderKey);
        if (value == null || !value.startsWith("%")) {
            return value;
        }
        if (l10nProps == null) {
            return null;
        }
        String key = value.substring(1).trim();
        return l10nProps.getProperty(key);
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    private File getSourceBundleManifestFile() {
        return new File(this.buildDirectory, "MANIFEST-SRC.MF");
    }

    private String getSourceBundleSymbolicName() {
        return BundleUtil.getSourceBundleSymbolicName((MavenProject)this.project);
    }

    private void initializeBndInstruction(String key, String value) {
        if (StringUtils.isBlank((CharSequence)this.bndInstructions.get(key))) {
            this.bndInstructions.put(key, value);
        }
    }

    private void packAndSignBundle() throws MojoExecutionException {
        if (!"eclipse".equalsIgnoreCase(this.signingServiceType)) {
            this.getLog().debug((CharSequence)"Skipping pack and signing. Set signing service type to 'eclipse' in order to enable signing using Eclipse.org CBI signing plug-in..");
            return;
        }
        this.getLog().info((CharSequence)"Packing and signing bundle");
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.eclipse.tycho.extras"), (String)MojoExecutor.artifactId((String)"tycho-pack200a-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.eclipse.tycho.extras", "tycho-pack200a-plugin", this.tychoExtrasPluginVersionFallback))), (String)MojoExecutor.goal((String)"normalize"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"supportedProjectTypes", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"supportedProjectType", (String)"eclipse-bundle-recipe")})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.eclipse.cbi.maven.plugins"), (String)MojoExecutor.artifactId((String)"eclipse-jarsigner-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.eclipse.cbi.maven.plugins", "eclipse-jarsigner-plugin", this.cbiPluginVersionFallback))), (String)MojoExecutor.goal((String)"sign"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.eclipse.tycho.extras"), (String)MojoExecutor.artifactId((String)"tycho-pack200b-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.eclipse.tycho.extras", "tycho-pack200a-plugin", this.tychoExtrasPluginVersionFallback))), (String)MojoExecutor.goal((String)"pack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"supportedProjectTypes", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"supportedProjectType", (String)"eclipse-bundle-recipe")})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    private void publishP2Metadata() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Publishing p2 metadata...");
        try {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.eclipse.tycho"), (String)MojoExecutor.artifactId((String)"tycho-p2-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.eclipse.tycho", "tycho-p2-plugin", this.tychoPluginVersionFallback))), (String)MojoExecutor.goal((String)"p2-metadata"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"supportedProjectTypes", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"supportedProjectType", (String)"eclipse-bundle-recipe")})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        }
        catch (MojoExecutionException e) {
            String[] trace;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof IllegalArgumentException && StringUtils.isBlank((CharSequence)rootCause.getMessage()) && (trace = ExceptionUtils.getRootCauseStackTrace((Throwable)e)).length > 1 && trace[1].indexOf("P2GeneratorImpl.getCanonicalArtifact") > 0) {
                this.getLog().debug((Throwable)e);
                throw new MojoExecutionException("The generated bundle manifest is broken. Unfortunately, the error is hard to discover (see http://eclip.se/428950). Try running Maven with '-Dosgi.logfile=/tmp/tycho-eclipse.log' to get a log file of the embedded Equinox OSGi framework.");
            }
            throw new MojoExecutionException(String.format("Unable to generate p2 metadata. Please check the generated bundle manifest and any bnd instructions. Try running Maven with '-Dosgi.logfile=/tmp/tycho-eclipse.log' to get a log file of the embedded Equinox OSGi framework. %s", e.getMessage()), (Exception)((Object)e));
        }
    }

    private Properties readL10nProps(Manifest manifest) throws IOException {
        File l10nPropsFile;
        String bundleL10nBase = manifest.getMainAttributes().getValue("Bundle-Localization");
        if (bundleL10nBase == null) {
            bundleL10nBase = "OSGI-INF/l10n/bundle";
        }
        if (!(l10nPropsFile = new File(this.outputDirectory, String.valueOf(bundleL10nBase) + ".properties")).isFile()) {
            this.getLog().warn((CharSequence)("Bundle localization file " + l10nPropsFile + " not found."));
            return null;
        }
        Properties l10nProps = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(l10nPropsFile);
            l10nProps.load(in);
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((InputStream)in);
        return l10nProps;
    }
}

