/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.utils.properties.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.eclipse.ebr.maven.AboutFilesUtil;
import org.eclipse.ebr.maven.ModelUtil;
import org.eclipse.ebr.maven.OsgiBndUtil;
import org.eclipse.ebr.maven.TemplateHelper;

@Mojo(name="create-recipe", requiresProject=false)
public class CreateRecipeMojo
extends AbstractMojo {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private static final String DOT_PROJECT = ".project";
    private static final String POM_XML = "pom.xml";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private RepositoryMetadataManager repositoryMetadataManager;
    @Component
    private ModelBuilder modelBuilder;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(property="groupId", required=true)
    private String groupId;
    @Parameter(property="artifactId", required=true)
    private String artifactId;
    @Parameter(property="version", defaultValue="RELEASE")
    private String artifactVersion;
    private ArtifactVersion version;
    @Parameter(property="classifier", defaultValue="")
    private String classifier;
    @Parameter(property="bundleSymbolicName", required=true)
    private String bundleSymbolicName;
    @Parameter(property="bundleVendor", defaultValue="Eclipse EBR Maven Plug-In")
    private String bundleVendor;
    @Parameter(defaultValue=".", property="baseDir")
    private File baseDir;
    @Parameter(property="recipeDirectoryName")
    private String recipeDirectoryName;
    @Parameter(defaultValue="false", property="force")
    private boolean force;
    @Parameter(property="license")
    private String license;
    protected MavenXpp3Reader modelReader = new MavenXpp3Reader();
    protected MavenXpp3Writer modelWriter = new MavenXpp3Writer();

    private Model buildEffectiveModel(File parentPomFile) throws MojoExecutionException {
        return this.getModelUtil().buildEffectiveModel(parentPomFile);
    }

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Searching for parent pom.xml.");
        File parentPomFile = this.findParentPom();
        if (!parentPomFile.isFile()) {
            throw new MojoExecutionException(String.format("No parent pom.xml found at '%s'.", parentPomFile.getAbsolutePath()));
        }
        Model parentPom = this.buildEffectiveModel(parentPomFile);
        Artifact resolvedPomArtifact = this.resolveArtifactPom();
        Model artifactPom = this.buildEffectiveModel(resolvedPomArtifact.getFile());
        this.logDependencies(artifactPom, resolvedPomArtifact);
        Model recipePom = this.getRecipePom(parentPom, resolvedPomArtifact, artifactPom);
        File projectDir = this.getProjectDir(recipePom);
        this.getLog().info((CharSequence)"Generating Eclipse .project file.");
        this.generateEclipseProjectFile(projectDir);
        this.getLog().info((CharSequence)"Generating recipe POM.");
        this.writeRecipePom(parentPomFile, recipePom, projectDir);
        this.getLog().info((CharSequence)"Generating recipe bundle.properties.");
        File resourcesDir = new File(projectDir, "src/main/resources");
        this.generateBundleL10nFile(recipePom, resourcesDir);
        this.getLog().info((CharSequence)"Generating recipe osgi.bnd.");
        this.generateOsgiBndFile(recipePom, projectDir, this.getCompileTimeDependencies(artifactPom));
        this.getLog().info((CharSequence)"Generating recipe about.html.");
        this.generateAboutHtmlFile(resolvedPomArtifact, artifactPom, recipePom, resourcesDir);
    }

    private File findParentPom() {
        this.getLog().debug((CharSequence)("Using base dir: " + this.baseDir.getAbsolutePath()));
        return new File(this.baseDir, POM_XML);
    }

    private void generateAboutHtmlFile(Artifact resolvedPomArtifact, Model artifactPom, Model recipePom, File resourcesDir) throws MojoExecutionException {
        TreeMap<Artifact, Model> dependencies = new TreeMap<Artifact, Model>();
        dependencies.put(resolvedPomArtifact, artifactPom);
        AboutFilesUtil aboutFilesUtil = new AboutFilesUtil(this.getLog(), this.mavenSession, this.force, true);
        if (this.license != null) {
            aboutFilesUtil.setLicense(resolvedPomArtifact, this.license);
        }
        aboutFilesUtil.generateAboutHtmlFile(dependencies, resourcesDir);
    }

    private void generateBundleL10nFile(Model recipePom, File l10nOutputDir) throws MojoExecutionException {
        File l10nPropsFile = new File(l10nOutputDir, "OSGI-INF/l10n/bundle.properties");
        if (l10nPropsFile.isFile() && !this.force) {
            this.getLog().warn((CharSequence)String.format("Found existing bundle localization file at '%s'. %s", l10nPropsFile, "Please set the force property to true in order to update/override it (eg. '-Dforce=true' via command line)."));
            return;
        }
        Properties l10nProps = new Properties();
        l10nProps.put("bundleName", recipePom.getName() != null ? recipePom.getName() : recipePom.getArtifactId());
        l10nProps.put("bundleVendor", this.bundleVendor);
        l10nProps.setHeader(Arrays.asList("# Bundle Localization"));
        try {
            FileUtils.forceMkdir((File)l10nPropsFile.getParentFile());
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Unable to create directory '%s'. %s", l10nPropsFile.getParentFile(), e.getMessage()));
        }
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(l10nPropsFile);
                l10nProps.save((OutputStream)out);
            }
            catch (IOException e) {
                this.getLog().debug((Throwable)e);
                throw new MojoExecutionException(String.format("Unable to write bundle localization file '%s'. %s", l10nPropsFile, e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close((OutputStream)out);
    }

    private void generateEclipseProjectFile(File projectDir) throws MojoExecutionException {
        File eclipseProjectFile = new File(projectDir, DOT_PROJECT);
        if (eclipseProjectFile.isFile() && !this.force) {
            this.getLog().warn((CharSequence)String.format("Found existing .project file at '%s'. %s", eclipseProjectFile, "Please set the force property to true in order to update/override it (eg. '-Dforce=true' via command line)."));
            return;
        }
        String eclipseProjectFileText = this.readEclipseProjectFileTemplate();
        eclipseProjectFileText = StringUtils.replaceEach((String)eclipseProjectFileText, (String[])new String[]{"@RECIPE_PROJECT_NAME@"}, (String[])new String[]{projectDir.getName()});
        try {
            FileUtils.writeStringToFile((File)eclipseProjectFile, (String)eclipseProjectFileText, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Unable to write .project file '%s'. %s", eclipseProjectFile, e.getMessage()));
        }
    }

    private void generateOsgiBndFile(Model recipePom, File projectDir, Collection<Dependency> compileTimeDependencies) throws MojoExecutionException {
        OsgiBndUtil osgiBndUtil = new OsgiBndUtil(this.getLog(), this.mavenSession, this.force);
        osgiBndUtil.generateOsgiBndFile(projectDir, compileTimeDependencies);
    }

    private Collection<Dependency> getCompileTimeDependencies(Model artifactPom) {
        return Collections2.filter((Collection)artifactPom.getDependencies(), (Predicate)new Predicate<Dependency>(){

            public boolean apply(Dependency input) {
                return input != null && (Objects.equals(input.getScope(), "compile") || Objects.equals(input.getScope(), "provided"));
            }
        });
    }

    private ModelUtil getModelUtil() {
        return new ModelUtil(this.getLog(), this.mavenSession, this.repositorySystem, this.repositoryMetadataManager, this.modelBuilder, this.remoteRepositories);
    }

    private File getProjectDir(Model recipePom) throws MojoExecutionException {
        File projectDir = this.recipeDirectoryName != null ? new File(this.baseDir, this.recipeDirectoryName) : new File(this.baseDir, String.valueOf(recipePom.getArtifactId()) + "_" + StringUtils.removeEnd((String)recipePom.getVersion(), (String)SNAPSHOT_SUFFIX));
        this.getLog().debug((CharSequence)("Using project directory: " + projectDir));
        try {
            FileUtils.forceMkdir((File)projectDir);
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Unable to create recipe project directory '%s'. %s", projectDir, e.getMessage()));
        }
        return projectDir;
    }

    private Model getRecipePom(Model parentPom, Artifact resolvedPomArtifact, Model artifactPom) throws MojoExecutionException {
        Model recipePom = this.readPomTemplate();
        recipePom.setParent(new Parent());
        recipePom.getParent().setGroupId(parentPom.getGroupId());
        recipePom.getParent().setArtifactId(parentPom.getArtifactId());
        recipePom.getParent().setVersion(parentPom.getVersion());
        recipePom.setArtifactId(this.bundleSymbolicName);
        String version = this.getRecipePomVersion();
        recipePom.setVersion(version);
        recipePom.setName(artifactPom.getName());
        Dependency dependency = new Dependency();
        dependency.setGroupId(artifactPom.getGroupId());
        dependency.setArtifactId(artifactPom.getArtifactId());
        dependency.setVersion(artifactPom.getVersion());
        if (this.classifier != null && !this.classifier.isEmpty()) {
            dependency.setClassifier(this.classifier);
        }
        recipePom.setDependencies(Arrays.asList(dependency));
        return recipePom;
    }

    private String getRecipePomVersion() {
        String version = String.format("%d.%d.%d%s", this.version.getMajorVersion(), this.version.getMinorVersion(), this.version.getIncrementalVersion(), SNAPSHOT_SUFFIX);
        this.getLog().debug((CharSequence)("Using recipe pom.xml version: " + version));
        return version;
    }

    private void logDependencies(Model artifactPom, Artifact resolvedPomArtifact) {
        List artifactDependencies = artifactPom.getDependencies();
        if (!artifactDependencies.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Dependency trail for " + resolvedPomArtifact));
                this.getLog().debug((CharSequence)StringUtils.join((Iterable)resolvedPomArtifact.getDependencyTrail(), (String)System.lineSeparator()));
                this.getLog().debug((CharSequence)"------------");
            }
            this.getLog().info((CharSequence)String.format("The following dependencies are defined for artifact %s:%s:%s. Please consider creating recipes for them as well.", artifactPom.getGroupId(), artifactPom.getArtifactId(), artifactPom.getVersion()));
            for (Dependency artifactDependency : artifactPom.getDependencies()) {
                this.getLog().info((CharSequence)String.format("   %s:%s:%s (scope %s)", artifactDependency.getGroupId(), artifactDependency.getArtifactId(), artifactDependency.getVersion(), artifactDependency.getScope()));
            }
        }
    }

    private String readEclipseProjectFileTemplate() throws MojoExecutionException {
        try {
            return IOUtils.toString((InputStream)TemplateHelper.getTemplate("recipe.project"), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Error reading .project template: %s", e.getMessage()));
        }
    }

    private Model readPomTemplate() throws MojoExecutionException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)TemplateHelper.getTemplate("recipe-pom.xml"));){
                return this.modelReader.read((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Error reading pom.xml template: %s", e.getMessage()));
        }
    }

    private Artifact resolveArtifactPom() throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Resolving POM for artifact %s:%s:%s.", this.groupId, this.artifactId, this.artifactVersion));
        ArtifactVersion resolvedVersion = this.getModelUtil().resolveArtifactVersion(this.groupId, this.artifactId, this.artifactVersion);
        if (StringUtils.equals((CharSequence)"RELEASE", (CharSequence)this.artifactVersion) || StringUtils.isBlank((CharSequence)this.artifactVersion) || StringUtils.equals((CharSequence)"LATEST", (CharSequence)this.artifactVersion)) {
            this.version = resolvedVersion;
            this.getLog().info((CharSequence)String.format("   Using verson %s.", this.version));
        } else {
            this.version = new DefaultArtifactVersion(this.artifactVersion);
            if (resolvedVersion.compareTo((Object)this.version) > 0) {
                this.getLog().info((CharSequence)String.format("   Using verson %s. The latest available release is %s.", this.version, resolvedVersion));
            }
        }
        return this.getModelUtil().resolveArtifactPom(this.groupId, this.artifactId, this.version.toString());
    }

    private void writePom(File file, Model model) throws MojoExecutionException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                this.modelWriter.write((Writer)writer, model);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Error writing '%s': %s", file.getAbsolutePath(), e.getMessage()));
        }
    }

    private void writeRecipePom(File parentPomFile, Model recipePom, File projectDir) throws MojoExecutionException {
        File recipePomFile = new File(projectDir, POM_XML);
        if (recipePomFile.isFile() && !this.force) {
            this.getLog().warn((CharSequence)String.format("Recipe pom.xml already exists at '%s'. %s", recipePomFile.getAbsolutePath(), "Please set the force property to true in order to update/override it (eg. '-Dforce=true' via command line)."));
            return;
        }
        this.writePom(recipePomFile, recipePom);
    }
}

