/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.ebr.maven.shared.BaseUtility;

public class DependencyUtil
extends BaseUtility {
    private Set<String> excludedArtifactIds;

    public DependencyUtil(Log log, MavenSession mavenSession) {
        super(log, mavenSession);
    }

    public Set<Artifact> getDependenciesToInclude(MavenProject project) {
        this.getLog().debug((CharSequence)"Computing direct dependencies to include");
        LinkedHashSet<Artifact> dependencies = new LinkedHashSet<Artifact>(project.getDependencyArtifacts());
        Set excludedArtifactIds = (Set)Preconditions.checkNotNull(this.excludedArtifactIds, (Object)"programming error: list of dependencies not initialized");
        Iterator stream = dependencies.iterator();
        while (stream.hasNext()) {
            Artifact artifact = (Artifact)stream.next();
            if (this.isAllowedDependency(artifact, excludedArtifactIds)) continue;
            stream.remove();
        }
        return dependencies;
    }

    public void initializeExcludeDependencies(String excludeDependencies) {
        this.excludedArtifactIds = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)excludeDependencies)) {
            String[] tokens;
            String[] stringArray = tokens = StringUtils.split((String)excludeDependencies, (char)',');
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                this.excludedArtifactIds.add(t.trim());
                ++n2;
            }
        }
    }

    private boolean isAllowedDependency(Artifact artifact, Set<String> excludedArtifactIds) {
        if (excludedArtifactIds.contains(artifact.getArtifactId())) {
            this.getLog().debug((CharSequence)String.format("Dependency '%s' excluded per configuration.", artifact.getArtifactId()));
            return false;
        }
        if (!artifact.getArtifactHandler().isAddedToClasspath()) {
            this.getLog().debug((CharSequence)String.format("Dependency '%s' not part of classpath.", artifact.getArtifactId()));
            return false;
        }
        if (!StringUtils.equals((CharSequence)artifact.getScope(), (CharSequence)"compile")) {
            this.getLog().debug((CharSequence)String.format("Dependency '%s' scope is not COMPILE.", artifact.getArtifactId()));
            return false;
        }
        this.getLog().debug((CharSequence)String.format("Dependency '%s' allowed.", artifact.getArtifactId()));
        return true;
    }
}

