/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.ebr.maven.AboutFilesUtil;
import org.eclipse.ebr.maven.BundleMojo;
import org.eclipse.ebr.maven.DependencyUtil;
import org.eclipse.ebr.maven.EclipseIpLogUtil;
import org.eclipse.ebr.maven.LicenseProcessingUtility;
import org.eclipse.ebr.maven.ModelUtil;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="eclipse-ip-info", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class EclipseIpInfoMojo
extends AbstractMojo {
    private static final String CLASSIFIER_SOURCES = "sources";
    @Parameter(defaultValue="${project.build.directory}/sources-for-eclipse-ipzilla", readonly=true, required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession mavenSession;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private RepositoryMetadataManager repositoryMetadataManager;
    @Component
    private ModelBuilder modelBuilder;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${excludeDependencies}")
    protected String excludeDependencies;
    @Parameter(defaultValue="2.6", property="maven-resource-plugin.version", required=true)
    protected String mavenResourcesPluginVersion = "2.6";
    @Parameter(defaultValue="2.8", property="maven-dependency-plugin.version", required=true)
    protected String mavenDependencyPluginVersion = "2.8";
    @Parameter(defaultValue="3.1.1", property="maven-dependency-plugin.version", required=true)
    protected String mavenDependencyPluginVersionFallback;
    @Parameter(defaultValue="false", property="force")
    private boolean force;
    @Parameter(defaultValue="false", property="forceDownload")
    private boolean forceDownload;
    @Parameter(defaultValue="true", property="failBuildIfIpLogIsIncomplete")
    private boolean failBuildIfIpLogIsIncomplete;
    @Parameter(property="submitCqsToProject")
    protected String submitCqsToProject;
    @Parameter(property="cqCryptography")
    protected String cqCryptography;
    @Parameter
    protected String includes;
    @Parameter
    protected String excludes;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Parameter
    protected Map<String, String> licenseMappings = new LinkedHashMap<String, String>();
    @Parameter
    protected Map<String, String> localLicenseFiles = new LinkedHashMap<String, String>();

    private void collectSources(Set<Artifact> dependencies) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Gathering sources archives");
        List<MojoExecutor.Element> unpackConfigurationSource = this.getDependenciesUnpackConfiguration(this.outputDirectory, dependencies, CLASSIFIER_SOURCES);
        try {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)this.detectPluginVersion("org.apache.maven.plugins", "maven-dependency-plugin", this.mavenDependencyPluginVersionFallback))), (String)MojoExecutor.goal((String)"unpack"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])unpackConfigurationSource.toArray(new MojoExecutor.Element[unpackConfigurationSource.size()])), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        }
        catch (MojoExecutionException e) {
            this.getLog().warn((CharSequence)"Unable to resolve source jar; skipping Eclipse IP information");
            this.getLog().debug((Throwable)e);
            return;
        }
        List<MojoExecutor.Element> copyConfigurationSource = this.getCopyConfiguration(this.outputDirectory.getAbsolutePath(), dependencies, CLASSIFIER_SOURCES);
        try {
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)this.mavenDependencyPluginVersion)), (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])copyConfigurationSource.toArray(new MojoExecutor.Element[copyConfigurationSource.size()])), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        }
        catch (MojoExecutionException e) {
            this.getLog().warn((CharSequence)"Unable to resolve source jar; skipping Eclipse IP information");
            this.getLog().debug((Throwable)e);
            return;
        }
        File[] fileArray = this.outputDirectory.listFiles(f -> f.getAbsolutePath().endsWith(".jar"));
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String absolutePath = file.getAbsolutePath();
            File newFile = new File(String.valueOf(StringUtils.removeEnd((String)absolutePath, (String)".jar")) + ".zip");
            this.getLog().debug((CharSequence)String.format("Renaming '%s' to '%s'.", file.getName(), newFile.getName()));
            file.renameTo(newFile);
            ++n2;
        }
    }

    private String detectPluginVersion(String groupId, String artifactId, String fallbackVersion) {
        List plugins = this.project.getPluginManagement().getPlugins();
        for (Plugin plugin : plugins) {
            if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
            this.getLog().debug((CharSequence)("Using managed version " + plugin.getVersion() + " for plugin " + groupId + ":" + artifactId + "."));
            return plugin.getVersion();
        }
        this.getLog().warn((CharSequence)String.format("No version defined in the efective model for plugin %s:%s. Please consider defining one in the pluginManagement section. Falling back to version \"%s\"", groupId, artifactId, fallbackVersion));
        return fallbackVersion;
    }

    private void discoverLicenseFromExistingIpLog(Set<Artifact> dependencies) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Discovering license information from existing ip_log.xml");
        EclipseIpLogUtil ipLogUtil = new EclipseIpLogUtil(this.getLog(), this.mavenSession, this.settings, this.force);
        String licenseName = ipLogUtil.getLicenseNameFromIpLogXmlFile(this.getIpLogXmlDirectory());
        if (!Strings.isNullOrEmpty((String)licenseName)) {
            for (Artifact artifact : dependencies) {
                if (this.licenseMappings.containsKey(artifact.getArtifactId())) continue;
                this.getLog().info((CharSequence)String.format("Discovered license '%s' for artifact %s:%s:%s.", licenseName, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
                this.licenseMappings.put(artifact.getArtifactId(), licenseName);
            }
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!BundleMojo.isRecipeProject(this.project)) {
            this.getLog().debug((CharSequence)String.format("Skipping execution for project with packaging type \"%s\"", this.project.getPackaging()));
            return;
        }
        Set<Artifact> dependencies = this.getDependenciesToInclude();
        this.discoverLicenseFromExistingIpLog(dependencies);
        this.collectSources(dependencies);
        this.refreshAboutFiles(dependencies);
        this.refreshIpLog(dependencies);
    }

    private List<MojoExecutor.Element> getCopyConfiguration(String outputDirectory, Set<Artifact> dependencies, String classifier) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> copyConfiguration = new ArrayList<MojoExecutor.Element>();
        copyConfiguration.add(MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)outputDirectory));
        ArrayList<MojoExecutor.Element> artifactItems = new ArrayList<MojoExecutor.Element>();
        for (Artifact artifact : dependencies) {
            if (classifier != null) {
                artifactItems.add(MojoExecutor.element((String)"artifactItem", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"groupId", (String)artifact.getGroupId()), MojoExecutor.element((String)"artifactId", (String)artifact.getArtifactId()), MojoExecutor.element((String)"version", (String)artifact.getVersion()), MojoExecutor.element((String)"classifier", (String)classifier)}));
                continue;
            }
            artifactItems.add(MojoExecutor.element((String)"artifactItem", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"groupId", (String)artifact.getGroupId()), MojoExecutor.element((String)"artifactId", (String)artifact.getArtifactId()), MojoExecutor.element((String)"version", (String)artifact.getVersion())}));
        }
        copyConfiguration.add(MojoExecutor.element((String)"artifactItems", (MojoExecutor.Element[])artifactItems.toArray(new MojoExecutor.Element[artifactItems.size()])));
        return copyConfiguration;
    }

    private Set<Artifact> getDependenciesToInclude() {
        DependencyUtil dependencyUtil = new DependencyUtil(this.getLog(), this.mavenSession);
        dependencyUtil.initializeExcludeDependencies(this.excludeDependencies);
        return dependencyUtil.getDependenciesToInclude(this.project);
    }

    private MojoExecutor.Element getDependenciesUnpackArtifactItems(Set<Artifact> dependencies, String classifier, File outputDirectory) {
        ArrayList<MojoExecutor.Element> artifactItems = new ArrayList<MojoExecutor.Element>();
        for (Artifact artifact : dependencies) {
            artifactItems.add(MojoExecutor.element((String)"artifactItem", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"groupId", (String)artifact.getGroupId()), MojoExecutor.element((String)"artifactId", (String)artifact.getArtifactId()), MojoExecutor.element((String)"version", (String)artifact.getVersion()), MojoExecutor.element((String)"classifier", (String)classifier), MojoExecutor.element((String)"outputDirectory", (String)this.getOutputDirectoryForFilteredDependencySources(outputDirectory, artifact).getAbsolutePath())}));
        }
        return MojoExecutor.element((String)"artifactItems", (MojoExecutor.Element[])artifactItems.toArray(new MojoExecutor.Element[artifactItems.size()]));
    }

    private List<MojoExecutor.Element> getDependenciesUnpackConfiguration(File outputDirectory, Set<Artifact> dependencies, String classifier) throws MojoExecutionException {
        ArrayList<MojoExecutor.Element> unpackConfiguration = new ArrayList<MojoExecutor.Element>();
        unpackConfiguration.add(MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)outputDirectory.getAbsolutePath()));
        if (this.excludes != null) {
            unpackConfiguration.add(MojoExecutor.element((String)MojoExecutor.name((String)"excludes"), (String)this.excludes));
        }
        if (this.includes != null) {
            unpackConfiguration.add(MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (String)this.includes));
        }
        unpackConfiguration.add(this.getDependenciesUnpackArtifactItems(dependencies, classifier, outputDirectory));
        return unpackConfiguration;
    }

    private File getIpLogXmlDirectory() throws MojoExecutionException {
        return new File(this.getProjectDir(), "src/eclipse");
    }

    private ModelUtil getModelUtil() {
        return new ModelUtil(this.getLog(), this.mavenSession, this.repositorySystem, this.repositoryMetadataManager, this.modelBuilder, this.remoteRepositories);
    }

    private File getOutputDirectoryForFilteredDependencySources(File outputDirectory, Artifact dependency) {
        return new File(outputDirectory, String.format("%s-%s-sources-filtered", dependency.getArtifactId(), dependency.getVersion()));
    }

    private File getProjectDir() throws MojoExecutionException {
        File projectDir = this.project.getBasedir();
        if (projectDir == null) {
            throw new MojoExecutionException("Unable to determine project directory for project: " + this.project);
        }
        return projectDir;
    }

    private void populateLicenseInformation(LicenseProcessingUtility licenseProcessingUtility, Set<Artifact> dependencies) throws MojoExecutionException {
        for (Artifact artifact : dependencies) {
            String license = this.licenseMappings.get(artifact.getArtifactId());
            this.getLog().debug((CharSequence)String.format("License mapping for artifact %s:%s:%s: %s", license, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), license));
            if (license == null) continue;
            licenseProcessingUtility.setLicense(artifact, license);
        }
        for (Map.Entry entry : this.localLicenseFiles.entrySet()) {
            licenseProcessingUtility.setLicenseFile((String)entry.getValue(), (String)entry.getKey());
        }
    }

    private void refreshAboutFiles(Set<Artifact> dependencies) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Refreshing about files and about.html");
        SortedMap<Artifact, Model> effectiveModels = this.getModelUtil().buildEffectiveModels(dependencies);
        AboutFilesUtil aboutFilesUtil = new AboutFilesUtil(this.getLog(), this.mavenSession, this.force, this.forceDownload);
        this.populateLicenseInformation(aboutFilesUtil, dependencies);
        File resourcesDir = new File(this.getProjectDir(), "src/main/resources");
        aboutFilesUtil.generateAboutHtmlFile(effectiveModels, resourcesDir);
    }

    private void refreshIpLog(Set<Artifact> dependencies) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Refreshing ip_log.xml");
        SortedMap<Artifact, Model> effectiveModels = this.getModelUtil().buildEffectiveModels(dependencies);
        EclipseIpLogUtil ipLogUtil = new EclipseIpLogUtil(this.getLog(), this.mavenSession, this.settings, this.force);
        this.populateLicenseInformation(ipLogUtil, dependencies);
        if (this.submitCqsToProject != null) {
            ipLogUtil.enableSubmissionOfCqs(this.submitCqsToProject, this.cqCryptography, this.settings, this.settingsDecrypter, this.outputDirectory);
        }
        Model recipePom = this.getModelUtil().buildEffectiveModel(this.project.getFile());
        File eclipseDir = this.getIpLogXmlDirectory();
        File ipLogXmlFile = ipLogUtil.generateIpLogXmlFile(recipePom, effectiveModels, eclipseDir);
        ipLogUtil.verifyIpLogXmlFile(eclipseDir, this.failBuildIfIpLogIsIncomplete);
        this.projectHelper.attachArtifact(this.project, "xml", "ip_log", ipLogXmlFile);
    }
}

