/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.TextStringBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.ebr.maven.LicenseProcessingUtility;
import org.eclipse.ebr.maven.eclipseip.KnownLicense;
import org.eclipse.ebr.maven.eclipseip.KnownLicenses;
import org.osgi.framework.Version;

public class EclipseIpLogUtil
extends LicenseProcessingUtility {
    private static final String PORTAL_PHP = "https://dev.eclipse.org/portal/myfoundation/portal/portal.php";
    private static final String DISPATCH_PHP = "https://dev.eclipse.org/portal/myfoundation/portal/dispatch.php";
    private static final String IP_LOG_XML = "ip_log.xml";
    private Server server;
    private String projectId;
    private String cqCryptography;
    private File outputDirectory;

    public EclipseIpLogUtil(Log log, MavenSession mavenSession, Settings settings, boolean force) {
        super(log, mavenSession, force);
    }

    private void appenLegalInfo(Xpp3Dom project, Artifact artifact, Model artifactPom, Map<String, String> existingCqs, Map<String, Xpp3Dom> existingLicenses) {
        Xpp3Dom legal = new Xpp3Dom("legal");
        project.addChild(legal);
        Xpp3Dom ipzilla = new Xpp3Dom("ipzilla");
        String artifactFileName = artifact.getFile().getName();
        ipzilla.setAttribute("bug_id", Strings.nullToEmpty((String)existingCqs.get(artifactFileName)));
        legal.addChild(ipzilla);
        Xpp3Dom license = new Xpp3Dom("license");
        legal.addChild(license);
        KnownLicense knownLicense = this.getLicense(artifact, artifactPom, existingLicenses);
        if (knownLicense != null) {
            this.createChild(license, "name", knownLicense.getName());
            this.createChild(license, "reference", Strings.nullToEmpty((String)knownLicense.getUrl()));
        } else {
            this.getLog().warn((CharSequence)String.format("No licensing information found for artifact %s:%s:%s. Please fill in information in ip_log.xml manually!", artifactPom.getGroupId(), artifactPom.getArtifactId(), artifactPom.getVersion()));
        }
        this.createChild(legal, "package", artifactFileName);
    }

    private void collectExistingCqsAndLicenses(Xpp3Dom existingIpLog, Map<String, String> existingCqs, Map<String, Xpp3Dom> existingLicenses) {
        Xpp3Dom[] projects = existingIpLog.getChildren("project");
        if (projects != null) {
            Xpp3Dom[] xpp3DomArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom project = xpp3DomArray[n2];
                Xpp3Dom[] legals = project.getChildren("legal");
                if (legals != null) {
                    Xpp3Dom[] xpp3DomArray2 = legals;
                    int n3 = legals.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Xpp3Dom legal = xpp3DomArray2[n4];
                        String cqId = this.getCqId(legal);
                        String artifactFileName = this.getPackageValue(legal);
                        if (artifactFileName != null && cqId != null) {
                            existingCqs.put(artifactFileName, cqId);
                        }
                        Xpp3Dom license = legal.getChild("license");
                        if (artifactFileName != null && license != null) {
                            existingLicenses.put(artifactFileName, license);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void createChild(Xpp3Dom parent, String name, String value) {
        if (value == null) {
            return;
        }
        Xpp3Dom element = new Xpp3Dom(name);
        element.setValue(value);
        parent.addChild(element);
    }

    private String createCq(CloseableHttpClient httpclient, Artifact artifact, Model artifactPom, Map<String, Xpp3Dom> existingLicenses) throws URISyntaxException, MojoExecutionException, IOException {
        URIBuilder postUri = new URIBuilder(DISPATCH_PHP);
        postUri.addParameter("id", "portal/contribution_questionnaire.contribution_questionnaire_reuse." + this.projectId + "!reuse");
        postUri.addParameter("action", "submit");
        HttpPost httpPost = new HttpPost(postUri.build());
        httpPost.addHeader("Referer", PORTAL_PHP);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("name", this.getCqName(artifact, artifactPom)));
        nvps.add(new BasicNameValuePair("version", artifact.getVersion()));
        nvps.add(new BasicNameValuePair("description", this.getCqDescription(artifact, artifactPom)));
        nvps.add(new BasicNameValuePair("cryptography", Strings.nullToEmpty((String)this.getCqCryptography(artifact, artifactPom))));
        nvps.add(new BasicNameValuePair("projecturl", Strings.nullToEmpty((String)this.getCqProjectUrl(artifact, artifactPom))));
        nvps.add(new BasicNameValuePair("sourceurl", Strings.nullToEmpty((String)this.getCqSourceUrl(artifact, artifactPom))));
        nvps.add(new BasicNameValuePair("license", this.getCqLicense(artifact, artifactPom, existingLicenses)));
        nvps.add(new BasicNameValuePair("otherlicense", ""));
        nvps.add(new BasicNameValuePair("sourcebinary", "sourceandbinary"));
        nvps.add(new BasicNameValuePair("modifiedcode", "unmodified"));
        nvps.add(new BasicNameValuePair("apachehosted", this.getCqApacheHosted(artifact, artifactPom)));
        nvps.add(new BasicNameValuePair("codeagreement", this.getCqCodeAgreement(artifact, artifactPom)));
        nvps.add(new BasicNameValuePair("stateid", "not_existing"));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        if (this.getLog().isDebugEnabled()) {
            for (NameValuePair nameValuePair : nvps) {
                this.getLog().debug((CharSequence)("   " + nameValuePair.getName() + "=" + nameValuePair.getValue()));
            }
        }
        String string = this.executeRequest(httpclient, httpPost, String.valueOf(StringUtils.removeEnd((String)artifact.getFile().getName(), (String)".jar")) + "-ipzilla-response.html");
        int cqUrlIndex = string.indexOf("https://dev.eclipse.org/ipzilla/show_bug.cgi?id=");
        TextStringBuilder cqId = new TextStringBuilder();
        int i = cqUrlIndex + "https://dev.eclipse.org/ipzilla/show_bug.cgi?id=".length();
        while (i < string.length()) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) break;
            cqId.append(c);
            ++i;
        }
        try {
            int cqNumber = Integer.parseInt(cqId.toString());
            if (cqNumber > 0) {
                return String.valueOf(cqNumber);
            }
        }
        catch (NumberFormatException e) {
            this.getLog().error((CharSequence)String.format("Error parsing extracted CQ number '%s'. %s", cqId, e.getMessage()), (Throwable)e);
        }
        throw new MojoExecutionException("Unable to extract CQ number from response. Please check response and IPzilla!");
    }

    public void enableSubmissionOfCqs(String projectId, String cqCryptography, Settings settings, SettingsDecrypter settingsDecrypter, File outputDirectory) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Enabling automatic submission of CQs to portal.eclipse.org");
        if (projectId.toLowerCase().equals("tools.orbit")) {
            throw new MojoExecutionException("It's not allowed to submit 3rd party CQs directly to Orbit. Please submit it to any other project and create an ATO ('Add To Orbit') CQ using the portal.");
        }
        if (Strings.isNullOrEmpty((String)cqCryptography)) {
            throw new MojoExecutionException("Please specify property 'cqCryptography' indicating whether this library implements/distributes cryptography and explain what.");
        }
        this.server = this.getServer("portal.eclipse.org", settings, settingsDecrypter);
        if (this.server == null) {
            throw new MojoExecutionException("Unable to enable automatic CQ submission. Please configure a server with id 'portal.eclipse.org' in the Maven settings and specify username and password.");
        }
        this.projectId = projectId;
        this.cqCryptography = cqCryptography;
        this.outputDirectory = outputDirectory;
    }

    private String executeRequest(CloseableHttpClient httpclient, HttpPost httpPost, String responseHtmlFileName) throws IOException, ClientProtocolException, MojoExecutionException {
        this.getLog().debug((CharSequence)(" >" + httpPost.getURI()));
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);){
            String responseHtml;
            block6: {
                this.getLog().debug((CharSequence)(" <" + response.getStatusLine()));
                HttpEntity entity = response.getEntity();
                responseHtml = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consume((HttpEntity)entity);
                try {
                    File responseHtmlFile = new File(this.outputDirectory, responseHtmlFileName);
                    FileUtils.writeStringToFile((File)responseHtmlFile, (String)responseHtml, (Charset)StandardCharsets.UTF_8);
                    this.getLog().debug((CharSequence)String.format("  (response written to '%s')", responseHtmlFile.getAbsolutePath()));
                }
                catch (Exception exception) {
                    if (!this.getLog().isDebugEnabled()) break block6;
                    this.getLog().debug((CharSequence)"---------------------------------");
                    this.getLog().debug((CharSequence)responseHtml);
                    this.getLog().debug((CharSequence)"---------------------------------");
                }
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new MojoExecutionException("Eclipse Portal returned: " + response.getStatusLine());
            }
            String string = responseHtml;
            return string;
        }
    }

    public File generateIpLogXmlFile(Model recipePom, SortedMap<Artifact, Model> dependencies, File outputDirectory) throws MojoExecutionException {
        File iplogXmlFile = new File(outputDirectory, IP_LOG_XML);
        if (iplogXmlFile.isFile() && !this.isForce()) {
            this.getLog().warn((CharSequence)String.format("Found existing ip_log.xml file at '%s'. %s", iplogXmlFile, "Please set the force property to true in order to update/override it (eg. '-Dforce=true' via command line)."));
            return iplogXmlFile;
        }
        Xpp3Dom existingIpLog = this.readExistingIpLog(iplogXmlFile);
        HashMap<String, String> existingCqs = new HashMap<String, String>();
        HashMap<String, Xpp3Dom> existingLicenses = new HashMap<String, Xpp3Dom>();
        if (existingIpLog != null) {
            this.collectExistingCqsAndLicenses(existingIpLog, existingCqs, existingLicenses);
        }
        this.logOrCreateMissingCqs(dependencies, existingCqs, existingLicenses);
        Xpp3Dom ipLogXmlDom = this.getIpLogXml(recipePom, dependencies, existingIpLog, existingCqs, existingLicenses);
        try {
            FileUtils.writeStringToFile((File)iplogXmlFile, (String)ipLogXmlDom.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Unable to write ip_log.xml file '%s'. %s", iplogXmlFile, e.getMessage()));
        }
        return iplogXmlFile;
    }

    private Xpp3Dom[] getContact(Xpp3Dom existingIpLog) {
        if (existingIpLog == null) {
            return null;
        }
        Xpp3Dom project = existingIpLog.getChild("project");
        if (project != null) {
            return project.getChildren("contact");
        }
        return null;
    }

    private String getCqApacheHosted(Artifact artifact, Model artifactPom) {
        String url = artifactPom.getUrl();
        if (url != null && url.toLowerCase().indexOf("apache.org") > -1) {
            return url;
        }
        return "No";
    }

    private String getCqCodeAgreement(Artifact artifact, Model artifactPom) {
        if (artifactPom.getOrganization() != null) {
            if (artifactPom.getOrganization().getName() != null) {
                return artifactPom.getOrganization().getName();
            }
            if (artifactPom.getOrganization().getUrl() != null) {
                return artifactPom.getOrganization().getUrl();
            }
        }
        return "Unknown";
    }

    private String getCqCryptography(Artifact artifact, Model artifactPom) {
        return this.cqCryptography;
    }

    private String getCqDescription(Artifact artifact, Model artifactPom) {
        List mailingLists;
        TextStringBuilder description = new TextStringBuilder();
        if (artifactPom.getDescription() != null) {
            description.append(artifactPom.getDescription()).appendNewLine().appendNewLine();
        }
        description.append("Maven Information").appendNewLine();
        description.append("-----------------").appendNewLine();
        description.append("     Group Id: ").append(artifact.getGroupId()).appendNewLine();
        description.append("  Artifact Id: ").append(artifact.getArtifactId()).appendNewLine();
        description.append("      Version: ").append(artifact.getVersion()).appendNewLine();
        description.append("         File: ").append(artifact.getFile().getName()).appendNewLine();
        if (artifactPom.getOrganization() != null) {
            description.append(" Organisation: ");
            if (artifactPom.getOrganization().getName() != null) {
                description.append(artifactPom.getOrganization().getName()).append(" ");
            }
            if (artifactPom.getOrganization().getUrl() != null) {
                description.append(artifactPom.getOrganization().getUrl());
            }
            description.appendNewLine();
        }
        if ((mailingLists = artifactPom.getMailingLists()) != null) {
            for (MailingList mailingList : mailingLists) {
                description.append(" Mailing List: ").append(mailingList.getName()).append(" ").append(mailingList.getPost()).appendNewLine();
            }
        }
        return description.toString();
    }

    private String getCqId(Xpp3Dom legal) {
        Xpp3Dom ipzilla = legal.getChild("ipzilla");
        if (ipzilla != null) {
            return ipzilla.getAttribute("bug_id");
        }
        ipzilla = legal.getChild("clearlydefined");
        if (ipzilla != null) {
            return ipzilla.getAttribute("url");
        }
        return null;
    }

    private String getCqLicense(Artifact artifact, Model artifactPom, Map<String, Xpp3Dom> existingLicenses) throws MojoExecutionException {
        KnownLicense license = this.getLicense(artifact, artifactPom, existingLicenses);
        if (license == null) {
            this.getLog().error((CharSequence)String.format("No known license configured for artifact %s:%s:%s.", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
            this.logKnownLicenses();
            throw new MojoExecutionException(String.format("Please configure a known license for artifact %s.", artifact.getArtifactId()));
        }
        return license.getName();
    }

    private String getCqName(Artifact artifact, Model artifactPom) {
        return String.format("%s (%s)", artifactPom.getName(), artifact.getFile().getName());
    }

    private String getCqProjectUrl(Artifact artifact, Model artifactPom) {
        return artifactPom.getUrl();
    }

    private String getCqSourceUrl(Artifact artifact, Model artifactPom) {
        Scm scm = artifactPom.getScm();
        if (scm != null) {
            return scm.getUrl();
        }
        return null;
    }

    private Xpp3Dom getIpLogXml(Model recipePom, SortedMap<Artifact, Model> dependencies, Xpp3Dom existingIpLog, Map<String, String> existingCqs, Map<String, Xpp3Dom> existingLicenses) {
        Xpp3Dom contact;
        Xpp3Dom ipLog = new Xpp3Dom("ip_log");
        ipLog.setAttribute("version", "1.0");
        Xpp3Dom project = new Xpp3Dom("project");
        project.setAttribute("id", recipePom.getArtifactId());
        project.setAttribute("version", this.getProjectVersion(recipePom, existingIpLog));
        project.setAttribute("status", "done");
        ipLog.addChild(project);
        Xpp3Dom info = new Xpp3Dom("info");
        this.createChild(info, "name", this.getProjectName(recipePom, existingIpLog));
        this.createChild(info, "origin", this.getProjectOrigin(recipePom, existingIpLog));
        this.createChild(info, "reference", this.getProjectReference(recipePom, existingIpLog));
        this.createChild(info, "repository", Strings.nullToEmpty((String)this.getProjectRepository(recipePom, existingIpLog)));
        this.createChild(info, "location", Strings.nullToEmpty((String)this.getProjectLocation(recipePom, existingIpLog)));
        this.createChild(info, "tag", this.getProjectTag(recipePom, existingIpLog));
        project.addChild(info);
        Xpp3Dom[] existingContacts = this.getContact(existingIpLog);
        if (existingContacts != null && existingContacts.length > 0) {
            Xpp3Dom[] xpp3DomArray = existingContacts;
            int n = existingContacts.length;
            int n2 = 0;
            while (n2 < n) {
                contact = xpp3DomArray[n2];
                project.addChild(contact);
                ++n2;
            }
        } else {
            contact = new Xpp3Dom("contact");
            this.createChild(contact, "name", "");
            this.createChild(contact, "email", "");
            this.createChild(contact, "company", "");
            project.addChild(contact);
        }
        Xpp3Dom existingNotes = this.getNotes(existingIpLog);
        if (existingNotes != null) {
            project.addChild(existingNotes);
        }
        for (Map.Entry<Artifact, Model> dependency : dependencies.entrySet()) {
            this.appenLegalInfo(project, dependency.getKey(), dependency.getValue(), existingCqs, existingLicenses);
        }
        return ipLog;
    }

    private KnownLicense getLicense(Artifact artifact, Model artifactPom, Map<String, Xpp3Dom> existingLicenses) {
        KnownLicense knownLicense = this.getLicense(artifact);
        if (knownLicense != null) {
            this.getLog().debug((CharSequence)String.format("Found configures license '%s' for artifact %s.", knownLicense.getName(), artifact.getArtifactId()));
            return knownLicense;
        }
        Xpp3Dom existingLicense = existingLicenses.get(artifact.getFile().getName());
        if (existingLicense != null && existingLicense.getChild("name") != null && (knownLicense = KnownLicenses.getInstance().getByName(existingLicense.getChild("name").getValue())) != null) {
            this.getLog().debug((CharSequence)String.format("Found exact license '%s' match based on existing ip_log.xml for artifact %s.", knownLicense.getName(), artifact.getArtifactId()));
            return knownLicense;
        }
        List licenses = artifactPom.getLicenses();
        if (licenses != null && !licenses.isEmpty()) {
            for (License license : licenses) {
                knownLicense = this.getSimilarLicense(license);
                if (knownLicense != null) {
                    this.getLog().warn((CharSequence)String.format("Detected '%s' for artifact license '%s (%s)'. Please verify the license correctness and consider configuring a static mapping for reproducible results.", knownLicense.getName(), license.getName(), license.getUrl()));
                    return knownLicense;
                }
                this.getLog().debug((CharSequence)String.format("Found no license similar to '%s (%s)' for artifact %s.", license.getName(), license.getUrl(), artifact.getArtifactId()));
            }
        }
        return null;
    }

    public String getLicenseNameFromIpLogXmlFile(File outputDirectory) throws MojoExecutionException {
        File iplogXmlFile = new File(outputDirectory, IP_LOG_XML);
        Xpp3Dom existingIpLog = this.readExistingIpLog(iplogXmlFile);
        if (existingIpLog == null || !iplogXmlFile.isFile()) {
            this.getLog().debug((CharSequence)String.format("Unable to read license info: No ip_log.xml file found at '%s'", iplogXmlFile));
            return null;
        }
        Xpp3Dom[] projects = existingIpLog.getChildren("project");
        if (projects == null || projects.length == 0) {
            this.getLog().debug((CharSequence)"Unable to read license info: Missing project information in ip_log.xml");
            return null;
        }
        if (projects.length != 1) {
            this.getLog().debug((CharSequence)"Unable to read license info: Too many 'project' elements. Only one 'project' element is expected in the ip_log.xml.");
            return null;
        }
        Xpp3Dom[] legals = projects[0].getChildren("legal");
        if (legals == null || legals.length == 0) {
            this.getLog().debug((CharSequence)"Unable to read license info: Missing legal information in ip_log.xml");
            return null;
        }
        if (legals.length != 1) {
            this.getLog().debug((CharSequence)"Unable to read license info: Too many 'legal' elements. Only one 'legal' element is expected in the ip_log.xml.");
            return null;
        }
        Xpp3Dom[] licenses = legals[0].getChildren("license");
        if (licenses == null || licenses.length == 0) {
            this.getLog().debug((CharSequence)"Unable to read license info: Incomplete legal information in ip_log.xml. Element 'license' with license information is required!");
            return null;
        }
        if (licenses.length != 1) {
            this.getLog().debug((CharSequence)"Unable to read license info: Too many 'license' elements. Only one 'license' element is expected in the ip_log.xml.");
            return null;
        }
        Xpp3Dom name = licenses[0].getChild("name");
        if (name == null || Strings.isNullOrEmpty((String)name.getValue())) {
            this.getLog().debug((CharSequence)"Unable to read license info: Incomplete license information in ip_log.xml. Element 'name' is required and must not be empty!");
            return null;
        }
        return name.getValue();
    }

    private Xpp3Dom getNotes(Xpp3Dom existingIpLog) {
        if (existingIpLog == null) {
            return null;
        }
        Xpp3Dom project = existingIpLog.getChild("project");
        if (project != null) {
            return project.getChild("notes");
        }
        return null;
    }

    private String getPackageValue(Xpp3Dom legal) {
        Xpp3Dom legalPackage = legal.getChild("package");
        if (legalPackage != null) {
            return legalPackage.getValue();
        }
        return null;
    }

    private String getProjectAttribute(Xpp3Dom existingIpLog, String name) {
        if (existingIpLog == null) {
            return null;
        }
        Xpp3Dom project = existingIpLog.getChild("project");
        if (project != null) {
            return project.getAttribute(name);
        }
        return null;
    }

    private String getProjectInfo(Xpp3Dom existingIpLog, String name) {
        Xpp3Dom child;
        Xpp3Dom info;
        if (existingIpLog == null) {
            return null;
        }
        Xpp3Dom project = existingIpLog.getChild("project");
        if (project != null && (info = project.getChild("info")) != null && (child = info.getChild(name)) != null) {
            return child.getValue();
        }
        return null;
    }

    private String getProjectLocation(Model recipePom, Xpp3Dom existingIpLog) {
        String url;
        String existingValue = this.getProjectInfo(existingIpLog, "location");
        if (existingValue != null) {
            return existingValue;
        }
        Scm scm = recipePom.getScm();
        if (scm != null && (url = this.getScmUrl(scm)) != null) {
            int lastIndexOf = StringUtils.lastIndexOf((CharSequence)url, (CharSequence)".git");
            if (lastIndexOf >= 0) {
                return StringUtils.removeStart((String)url.substring(lastIndexOf + 4), (String)"/");
            }
            return url;
        }
        return null;
    }

    private String getProjectName(Model recipePom, Xpp3Dom existingIpLog) {
        String existingValue = this.getProjectInfo(existingIpLog, "name");
        if (existingValue != null) {
            return existingValue;
        }
        return recipePom.getName();
    }

    private String getProjectOrigin(Model recipePom, Xpp3Dom existingIpLog) {
        String existingValue = this.getProjectInfo(existingIpLog, "origin");
        if (existingValue != null) {
            return existingValue;
        }
        TextStringBuilder developedByInfo = new TextStringBuilder();
        if (recipePom.getOrganization() != null) {
            if (StringUtils.isNotBlank((CharSequence)recipePom.getOrganization().getName())) {
                developedByInfo.append(StringEscapeUtils.escapeHtml4((String)recipePom.getOrganization().getName()));
            } else if (StringUtils.isNotBlank((CharSequence)recipePom.getOrganization().getUrl())) {
                developedByInfo.append(StringEscapeUtils.escapeHtml4((String)this.removeWebProtocols(recipePom.getOrganization().getUrl())));
            }
        }
        if (developedByInfo.isEmpty() && !recipePom.getDevelopers().isEmpty()) {
            this.appendDeveloperInfo(developedByInfo, recipePom);
        }
        if (developedByInfo.isEmpty()) {
            return null;
        }
        return developedByInfo.toString();
    }

    private String getProjectReference(Model recipePom, Xpp3Dom existingIpLog) {
        String existingValue = this.getProjectInfo(existingIpLog, "reference");
        if (existingValue != null) {
            return existingValue;
        }
        return recipePom.getUrl();
    }

    private String getProjectRepository(Model recipePom, Xpp3Dom existingIpLog) {
        String url;
        String existingValue = this.getProjectInfo(existingIpLog, "repository");
        if (existingValue != null) {
            return existingValue;
        }
        Scm scm = recipePom.getScm();
        if (scm != null && (url = this.getScmUrl(scm)) != null) {
            int lastIndexOf = StringUtils.lastIndexOf((CharSequence)url, (CharSequence)".git");
            if (lastIndexOf >= 0) {
                return url.substring(0, lastIndexOf + 4);
            }
            return url;
        }
        return null;
    }

    private String getProjectTag(Model recipePom, Xpp3Dom existingIpLog) {
        return this.getProjectInfo(existingIpLog, "tag");
    }

    private String getProjectVersion(Model recipePom, Xpp3Dom existingIpLog) {
        String existingValue = this.getProjectAttribute(existingIpLog, "version");
        if (existingValue != null) {
            return existingValue;
        }
        Version version = Version.parseVersion((String)StringUtils.removeEnd((String)recipePom.getVersion(), (String)"-SNAPSHOT"));
        return String.format("%d.%d.%d", version.getMajor(), version.getMinor(), version.getMicro());
    }

    private String getScmUrl(Scm scm) {
        String url = scm.getDeveloperConnection();
        if (url == null) {
            url = scm.getConnection();
        }
        if (url == null) {
            url = scm.getUrl();
        }
        return url;
    }

    private Server getServer(String serverId, Settings settings, SettingsDecrypter settingsDecrypter) {
        for (Server server : settings.getServers()) {
            if (!StringUtils.equals((CharSequence)server.getId(), (CharSequence)serverId)) continue;
            DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
            SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
            server = result.getServer();
            for (SettingsProblem problem : result.getProblems()) {
                this.getLog().warn((CharSequence)problem.getMessage(), (Throwable)problem.getException());
            }
            return server;
        }
        return null;
    }

    private boolean isValidCqId(String cqId) {
        Integer parsedCqId = Ints.tryParse((String)cqId);
        if (parsedCqId != null && parsedCqId > 0) {
            return true;
        }
        try {
            new URL(cqId).toURI();
            return true;
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return false;
        }
    }

    private void loginToPortal(CloseableHttpClient httpclient, Server server) throws IOException, MojoExecutionException, URISyntaxException {
        URIBuilder postUri = new URIBuilder(PORTAL_PHP);
        HttpPost httpPost = new HttpPost(postUri.build());
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("user", server.getUsername()));
        nvps.add(new BasicNameValuePair("password", server.getPassword()));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        this.executeRequest(httpclient, httpPost, "portal-login-response.html");
    }

    private void logOrCreateMissingCqs(SortedMap<Artifact, Model> dependencies, Map<String, String> existingCqs, Map<String, Xpp3Dom> existingLicenses) throws MojoExecutionException {
        CloseableHttpClient httpclient = null;
        try {
            try {
                if (this.server != null && this.projectId != null) {
                    httpclient = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
                    this.loginToPortal(httpclient, this.server);
                }
                for (Map.Entry<Artifact, Model> dependency : dependencies.entrySet()) {
                    Artifact artifact = dependency.getKey();
                    String artifactFileName = artifact.getFile().getName();
                    String existingCq = existingCqs.get(artifactFileName);
                    if (existingCq != null && !existingCq.trim().isEmpty()) continue;
                    if (httpclient != null) {
                        this.getLog().info((CharSequence)String.format("Creating CQ for artifact %s:%s:%s.", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
                        String cqId = this.createCq(httpclient, artifact, dependency.getValue(), existingLicenses);
                        existingCqs.put(artifactFileName, cqId);
                        this.getLog().info((CharSequence)String.format("Created CQ %s for %s (artifact %s:%s:%s).", cqId, artifactFileName, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
                        continue;
                    }
                    this.getLog().warn((CharSequence)String.format("Missing CQ for %s (artifact %s:%s:%s). Please visit portal.eclipse.org and file a CQ with IPzilla!", artifactFileName, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
                }
            }
            catch (IOException | URISyntaxException e) {
                this.getLog().debug((Throwable)e);
                throw new MojoExecutionException("An error occured communicating with the Eclipse Portal: " + e.getMessage());
            }
        }
        finally {
            if (httpclient != null) {
                try {
                    httpclient.close();
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)"Ignored exception during close.", (Throwable)e);
                }
            }
        }
    }

    private void logWarningOrFailBuild(boolean failBuildIfIpLogIsIncomplete, String messageFormat, Object ... arguments) throws MojoFailureException {
        if (failBuildIfIpLogIsIncomplete) {
            throw new MojoFailureException(String.format(messageFormat, arguments));
        }
        this.getLog().warn((CharSequence)String.format(messageFormat, arguments));
    }

    private Xpp3Dom readExistingIpLog(File iplogXmlFile) throws MojoExecutionException {
        Xpp3Dom existingIpLog;
        block12: {
            if (iplogXmlFile.isFile()) {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (FileInputStream is = FileUtils.openInputStream((File)iplogXmlFile);){
                        existingIpLog = Xpp3DomBuilder.build((InputStream)is, (String)StandardCharsets.UTF_8.name());
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | XmlPullParserException e) {
                    this.getLog().debug(e);
                    throw new MojoExecutionException(String.format("Unable to read ip_log.xml file '%s'. %s", iplogXmlFile, e.getMessage()));
                }
            }
            existingIpLog = null;
        }
        return existingIpLog;
    }

    public void verifyIpLogXmlFile(File outputDirectory, boolean failIfIpLogIsIncomplete) throws MojoFailureException, MojoExecutionException {
        int n;
        int n2;
        Xpp3Dom[] xpp3DomArray;
        Xpp3Dom[] projects;
        File iplogXmlFile = new File(outputDirectory, IP_LOG_XML);
        Xpp3Dom existingIpLog = this.readExistingIpLog(iplogXmlFile);
        if (existingIpLog == null || !iplogXmlFile.isFile()) {
            this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Verification failed: No ip_log.xml file found at '%s'", iplogXmlFile);
        }
        if ((projects = existingIpLog.getChildren("project")) == null || projects.length == 0) {
            this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Missing project information in ip_log.xml.", new Object[0]);
        } else if (projects.length != 1) {
            this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Too many 'project' elements. Only one 'project' element is expected in the ip_log.xml.", new Object[0]);
        }
        Xpp3Dom[] contacts = this.getContact(existingIpLog);
        if (contacts == null || contacts.length == 0) {
            this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Missing contact information in ip_log.xml.", new Object[0]);
        } else {
            xpp3DomArray = contacts;
            n2 = contacts.length;
            n = 0;
            while (n < n2) {
                Xpp3Dom email;
                Xpp3Dom contact = xpp3DomArray[n];
                Xpp3Dom name = contact.getChild("name");
                if (name == null || Strings.isNullOrEmpty((String)name.getValue())) {
                    this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Incomplete contact information in ip_log.xml. Element 'name' is required and must not be empty!", new Object[0]);
                }
                if ((email = contact.getChild("email")) == null || Strings.isNullOrEmpty((String)email.getValue())) {
                    this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Incomplete contact information in ip_log.xml. Element 'email' is required and must not be empty!", new Object[0]);
                }
                ++n;
            }
        }
        xpp3DomArray = projects;
        n2 = projects.length;
        n = 0;
        while (n < n2) {
            Xpp3Dom project = xpp3DomArray[n];
            Xpp3Dom[] legals = project.getChildren("legal");
            if (legals == null || legals.length == 0) {
                this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Missing legal information in ip_log.xml.", new Object[0]);
            } else {
                Xpp3Dom[] xpp3DomArray2 = legals;
                int n3 = legals.length;
                int n4 = 0;
                while (n4 < n3) {
                    Xpp3Dom[] licenses;
                    Xpp3Dom legal = xpp3DomArray2[n4];
                    String cqId = this.getCqId(legal);
                    if (Strings.isNullOrEmpty((String)cqId)) {
                        this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Incomplete legal information in ip_log.xml. Reference to IP information is required!", new Object[0]);
                    }
                    if (!this.isValidCqId(cqId)) {
                        this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Incomplete legal information in ip_log.xml. The referenced IP information is invalid!", new Object[0]);
                    }
                    if ((licenses = legal.getChildren("license")) == null || licenses.length == 0) {
                        this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Incomplete legal information in ip_log.xml. Element 'license' with license information is required!", new Object[0]);
                    } else {
                        Xpp3Dom[] xpp3DomArray3 = licenses;
                        int n5 = licenses.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Xpp3Dom reference;
                            Xpp3Dom license = xpp3DomArray3[n6];
                            Xpp3Dom name = license.getChild("name");
                            if (name == null || Strings.isNullOrEmpty((String)name.getValue())) {
                                this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Incomplete license information in ip_log.xml. Element 'name' is required and must not be empty!", new Object[0]);
                            }
                            if ((reference = license.getChild("reference")) == null || Strings.isNullOrEmpty((String)reference.getValue())) {
                                this.logWarningOrFailBuild(failIfIpLogIsIncomplete, "Incomplete license information in ip_log.xml. Element 'reference' is required and must not be empty!", new Object[0]);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n;
        }
    }
}

