/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven;

import com.google.common.base.Joiner;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.TextStringBuilder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.ebr.maven.eclipseip.KnownLicense;
import org.eclipse.ebr.maven.eclipseip.KnownLicenses;
import org.eclipse.ebr.maven.shared.BaseUtility;

public abstract class LicenseProcessingUtility
extends BaseUtility {
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private final Map<String, KnownLicense> licensesByArtifact = new HashMap<String, KnownLicense>();
    private final Map<String, String> licenseFilesByLicenseName = new HashMap<String, String>();

    public LicenseProcessingUtility(Log log, MavenSession mavenSession, boolean force) {
        super(log, mavenSession);
        this.setForce(force);
    }

    protected void appendDeveloperInfo(TextStringBuilder text, Model artifactPom) {
        boolean first = true;
        Iterator stream = artifactPom.getDevelopers().iterator();
        while (stream.hasNext()) {
            Developer developer = (Developer)stream.next();
            if (!first && !stream.hasNext()) {
                text.append(" and ");
            } else if (!first && stream.hasNext()) {
                text.append(", ");
            } else {
                first = false;
            }
            text.append(StringEscapeUtils.escapeHtml4((String)developer.getName())).append(" &lt;").append(StringEscapeUtils.escapeHtml4((String)developer.getEmail())).append("&gt;");
            if (!StringUtils.isNotBlank((CharSequence)developer.getOrganization())) continue;
            text.append(" (").append(StringEscapeUtils.escapeHtml4((String)developer.getOrganization())).append(")");
        }
    }

    private KnownLicense findKnownLicense(String license) throws MojoExecutionException {
        KnownLicense l = KnownLicenses.getInstance().getByName(license);
        if (l != null) {
            return l;
        }
        Set<KnownLicense> similarLicenses = KnownLicenses.getInstance().findSimilarLicensesByName(license);
        if (similarLicenses.size() == 1) {
            return similarLicenses.iterator().next();
        }
        if (similarLicenses.size() > 1) {
            this.getLog().error((CharSequence)String.format("Multiple known licenses found for '%s': %s", license, Joiner.on((String)", ").join(similarLicenses)));
        }
        this.getLog().error((CharSequence)String.format("Unable to map license '%s' to a known license.", license));
        this.logKnownLicenses();
        throw new MojoExecutionException(String.format("Invalid license '%s'. Please select one that is known in the Eclipse Foundation IP database.", license));
    }

    private String getArtifactKey(Artifact artifact) {
        return String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId();
    }

    public KnownLicense getLicense(Artifact artifact) {
        return this.licensesByArtifact.get(this.getArtifactKey(artifact));
    }

    public String getLicenseFile(String license) {
        return this.licenseFilesByLicenseName.get(license);
    }

    public KnownLicense getSimilarLicense(License pomLicense) {
        KnownLicense license = null;
        if (pomLicense.getName() != null) {
            license = KnownLicenses.getInstance().getByName(pomLicense.getName());
        }
        if (license == null && pomLicense.getUrl() != null) {
            license = KnownLicenses.getInstance().findByUrl(pomLicense.getUrl());
        }
        if (license == null && pomLicense.getName() != null) {
            Set<KnownLicense> similarLicenses = KnownLicenses.getInstance().findSimilarLicensesByName(pomLicense.getName());
            if (similarLicenses.size() == 1) {
                return similarLicenses.iterator().next();
            }
            if (similarLicenses.size() > 1) {
                this.getLog().warn((CharSequence)String.format("Multiple known licenses found for '%s': %s", license, Joiner.on((String)", ").join(similarLicenses)));
            }
        }
        return license;
    }

    protected boolean isDualOrMoreLicensed(List<License> licenses) {
        if (licenses.size() > 1) {
            return true;
        }
        if (licenses.size() == 1) {
            return KnownLicenses.getInstance().isDualLicense(licenses.get(0));
        }
        return false;
    }

    protected boolean isPotentialWebUrl(String url) {
        return url != null && (StringUtils.startsWithAny((CharSequence)url.toLowerCase(), (CharSequence[])new CharSequence[]{HTTP_PREFIX, HTTPS_PREFIX}) || StringUtils.indexOf((CharSequence)url, (int)58) == -1);
    }

    protected void logKnownLicenses() {
        this.getLog().error((CharSequence)"Know licenses are:");
        for (String name : KnownLicenses.getInstance().getAllLicenseNames()) {
            this.getLog().error((CharSequence)("  - " + name));
        }
    }

    protected String removeWebProtocols(String url) {
        return StringUtils.removeStart((String)StringUtils.removeStart((String)url, (String)HTTPS_PREFIX), (String)HTTP_PREFIX);
    }

    public void setLicense(Artifact artifact, String license) throws MojoExecutionException {
        this.getLog().debug((CharSequence)String.format("Using license '%s' for artifact %s:%s:%s", license, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        KnownLicense knownLicense = this.findKnownLicense(license);
        this.getLog().debug((CharSequence)String.format("Found known license '%s' for license '%s'", knownLicense, license));
        this.licensesByArtifact.put(this.getArtifactKey(artifact), knownLicense);
    }

    public void setLicenseFile(String license, String licenseFileName) throws MojoExecutionException {
        this.getLog().debug((CharSequence)String.format("Using local license file '%s' for license named '%s'", licenseFileName, license));
        this.licenseFilesByLicenseName.put(license, licenseFileName);
    }

    protected URL toUrl(String url) throws MalformedURLException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            try {
                return this.toUrl(HTTP_PREFIX + url);
            }
            catch (MalformedURLException malformedURLException) {
                throw e;
            }
        }
    }
}

