/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.repository.RepositorySystem;

public class MavenModelResolver
implements ModelResolver {
    private final Map<String, ArtifactRepository> repositoryById = new LinkedHashMap<String, ArtifactRepository>();
    private final RepositorySystem repositorySystem;
    private final Log log;

    public MavenModelResolver(Collection<ArtifactRepository> repositories, RepositorySystem repositorySystem, Log log) {
        this.repositorySystem = repositorySystem;
        this.log = log;
        for (ArtifactRepository repository : repositories) {
            this.putRepository(repository, false);
        }
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        try {
            this.putRepository(this.repositorySystem.buildArtifactRepository(repository), replace);
        }
        catch (org.apache.maven.artifact.InvalidRepositoryException e) {
            throw new InvalidRepositoryException(e.getMessage(), repository, (Throwable)e);
        }
    }

    public Log getLog() {
        return this.log;
    }

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public ModelResolver newCopy() {
        return new MavenModelResolver(this.repositoryById.values(), this.getRepositorySystem(), this.getLog());
    }

    private void putRepository(ArtifactRepository repository, boolean replace) {
        if (replace || !this.repositoryById.containsKey(repository.getId())) {
            this.repositoryById.put(repository.getId(), repository);
        }
    }

    public void resetRepositories() {
        this.getLog().debug((CharSequence)"Clearing repositories.");
        this.repositoryById.clear();
    }

    public Artifact resolveArtifactPom(String groupId, String artifactId, String version) throws UnresolvableModelException {
        this.getLog().debug((CharSequence)String.format("Resolving POM for artifact %s:%s:%s.", groupId, artifactId, version));
        Artifact requestedArtifact = this.repositorySystem.createArtifact(groupId, artifactId, version, "pom");
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(requestedArtifact);
        request.setRemoteRepositories(new ArrayList<ArtifactRepository>(this.repositoryById.values()));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Request: " + request));
        }
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Result: " + result));
        }
        if (result.getArtifacts().isEmpty()) {
            throw new UnresolvableModelException(String.format("No POM found for artifact %s:%s:%s.", groupId, artifactId, version), groupId, artifactId, version);
        }
        if (result.getArtifacts().size() > 1) {
            throw new UnresolvableModelException(String.format("More than one POM found for artifact %s:%s:%s. This is unexpected. Please re-try with a more specific version or report this error.", groupId, artifactId, version), groupId, artifactId, version);
        }
        return (Artifact)result.getArtifacts().iterator().next();
    }

    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        this.getLog().debug((CharSequence)String.format("Resolving model for artifact %s:%s:%s.", groupId, artifactId, version));
        return new FileModelSource(this.resolveArtifactPom(groupId, artifactId, version).getFile());
    }
}

