/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.repository.RepositorySystem;
import org.eclipse.ebr.maven.MavenModelResolver;
import org.eclipse.ebr.maven.shared.BaseUtility;

public class ModelUtil
extends BaseUtility {
    private final ModelBuilder modelBuilder;
    private final RepositorySystem repositorySystem;
    private final RepositoryMetadataManager repositoryMetadataManager;
    private final List<ArtifactRepository> remoteRepositories;

    public ModelUtil(Log log, MavenSession mavenSession, RepositorySystem repositorySystem, RepositoryMetadataManager repositoryMetadataManager, ModelBuilder modelBuilder, List<ArtifactRepository> remoteRepositories) {
        super(log, mavenSession);
        this.repositorySystem = repositorySystem;
        this.repositoryMetadataManager = repositoryMetadataManager;
        this.modelBuilder = modelBuilder;
        this.remoteRepositories = remoteRepositories;
    }

    public Model buildEffectiveModel(Artifact artifact) throws MojoExecutionException {
        return this.buildEffectiveModel(this.resolveArtifactPom(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion().toString()).getFile());
    }

    public Model buildEffectiveModel(File pomFile) throws MojoExecutionException {
        ModelBuildingResult result;
        this.getLog().debug((CharSequence)String.format("Building effective model for pom '%s'.", pomFile));
        DefaultModelBuildingRequest request = new DefaultModelBuildingRequest();
        request.setModelResolver((ModelResolver)this.getModelResolver());
        request.setPomFile(pomFile);
        request.setValidationLevel(0);
        request.setProcessPlugins(false);
        request.setTwoPhaseBuilding(false);
        request.setUserProperties(this.getMavenSession().getUserProperties());
        request.setSystemProperties(this.getMavenSession().getSystemProperties());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Request: " + request));
        }
        try {
            result = this.modelBuilder.build((ModelBuildingRequest)request);
        }
        catch (ModelBuildingException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Unable to build model for pom '%s'. %s", pomFile, e.getMessage()));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Result: " + result));
        }
        return result.getEffectiveModel();
    }

    public SortedMap<Artifact, Model> buildEffectiveModels(Set<Artifact> artifacts) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Building effective POM models");
        TreeMap<Artifact, Model> result = new TreeMap<Artifact, Model>();
        for (Artifact artifact : artifacts) {
            result.put(artifact, this.buildEffectiveModel(artifact));
        }
        return result;
    }

    void configureRepositoryRequest(RepositoryRequest request) throws MojoExecutionException {
        request.setLocalRepository(this.getMavenSession().getLocalRepository());
        if (!this.getMavenSession().isOffline()) {
            try {
                request.setRemoteRepositories(this.getRepositories(false));
            }
            catch (InvalidRepositoryException e) {
                this.getLog().debug((Throwable)e);
                throw new MojoExecutionException(String.format("Unable to create the default remote repository. Please verify the Maven configuration. %s", e.getMessage()));
            }
        }
        request.setOffline(this.getMavenSession().isOffline());
        request.setForceUpdate("always".equals(this.getMavenSession().getRepositorySession().getUpdatePolicy()));
    }

    public ModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }

    public MavenModelResolver getModelResolver() throws MojoExecutionException {
        if (!this.getMavenSession().isOffline()) {
            try {
                return new MavenModelResolver(this.getRepositories(true), this.getRepositorySystem(), this.getLog());
            }
            catch (InvalidRepositoryException e) {
                this.getLog().debug((Throwable)e);
                throw new MojoExecutionException(String.format("Unable to create the default remote repository. Please verify the Maven configuration. %s", e.getMessage()));
            }
        }
        this.getLog().debug((CharSequence)"Using local repository in offline mode!");
        return new MavenModelResolver(Arrays.asList(this.getMavenSession().getLocalRepository()), this.getRepositorySystem(), this.getLog());
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories != null ? this.remoteRepositories : Collections.emptyList();
    }

    private List<ArtifactRepository> getRepositories(boolean includeLocal) throws InvalidRepositoryException {
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        if (includeLocal) {
            repositories.add(this.getMavenSession().getLocalRepository());
        }
        repositories.addAll(this.getRemoteRepositories());
        repositories.add(this.getRepositorySystem().createDefaultRemoteRepository());
        this.getLog().debug((CharSequence)String.format("Using repositories: %s", repositories.stream().map(r -> Strings.nullToEmpty((String)r.getId())).distinct().collect(Collectors.joining(", "))));
        return repositories;
    }

    public RepositoryMetadataManager getRepositoryMetadataManager() {
        return this.repositoryMetadataManager;
    }

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public Artifact resolveArtifactPom(String groupId, String artifactId, String artifactVersion) throws MojoExecutionException {
        this.getLog().debug((CharSequence)String.format("Resolving POM for artifact %s:%s:%s.", groupId, artifactId, artifactVersion));
        try {
            return this.getModelResolver().resolveArtifactPom(groupId, artifactId, artifactVersion);
        }
        catch (UnresolvableModelException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Unable to resolve POM for artifact %s:%s:%s. %s", groupId, artifactId, artifactVersion, e.getMessage()));
        }
    }

    public ArtifactVersion resolveArtifactVersion(String groupId, String artifactId, String artifactVersion) throws MojoExecutionException {
        this.getLog().debug((CharSequence)String.format("Reading version metadata for artifact %s:%s.", groupId, artifactId));
        DefaultRepositoryRequest request = new DefaultRepositoryRequest();
        this.configureRepositoryRequest((RepositoryRequest)request);
        Artifact artifact = this.repositorySystem.createArtifact(groupId, artifactId, "[0,)", null, "pom");
        try {
            ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(artifact);
            this.getRepositoryMetadataManager().resolve((RepositoryMetadata)metadata, (RepositoryRequest)request);
            Metadata repositoryMetadata = (Metadata)Preconditions.checkNotNull((Object)metadata.getMetadata(), (Object)"No repository metadata loaded.");
            if (StringUtils.equals((CharSequence)"LATEST", (CharSequence)artifactVersion)) {
                Versioning metadataVersions = (Versioning)Preconditions.checkNotNull((Object)repositoryMetadata.getVersioning(), (Object)"No versioning information available in repository metadata.");
                this.getLog().debug((CharSequence)String.format("Resolving '%s' to latest version.", artifactVersion));
                return new DefaultArtifactVersion(metadataVersions.getLatest());
            }
            if (StringUtils.equals((CharSequence)"RELEASE", (CharSequence)artifactVersion) || StringUtils.isBlank((CharSequence)artifactVersion)) {
                Versioning metadataVersions = (Versioning)Preconditions.checkNotNull((Object)repositoryMetadata.getVersioning(), (Object)"No versioning information available in repository metadata.");
                this.getLog().debug((CharSequence)String.format("Resolving '%s' to release version.", artifactVersion));
                return new DefaultArtifactVersion(metadataVersions.getRelease());
            }
            this.getLog().debug((CharSequence)String.format("Resolving '%s' to version.", artifactVersion));
            return new DefaultArtifactVersion(artifactVersion);
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Unable to retrieve available versions for artifact %s:%s:%s. %s", groupId, artifactId, artifactVersion, e.getMessage()));
        }
    }
}

