/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.TextStringBuilder;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.ebr.maven.TemplateHelper;
import org.eclipse.ebr.maven.shared.BaseUtility;

public class OsgiBndUtil
extends BaseUtility {
    private static final String OSGI_BND = "osgi.bnd";

    public OsgiBndUtil(Log log, MavenSession mavenSession, boolean force) {
        super(log, mavenSession);
        this.setForce(force);
    }

    public void generateOsgiBndFile(File outputDirectory, Collection<Dependency> compileTimeDependencies) throws MojoExecutionException {
        File osgiBndFile = new File(outputDirectory, OSGI_BND);
        if (osgiBndFile.isFile() && !this.isForce()) {
            this.getLog().warn((CharSequence)String.format("Found existing osgi.bnd file at '%s'. %s", osgiBndFile, "Please set the force property to true in order to update/override it (eg. '-Dforce=true' via command line)."));
            return;
        }
        String osgiBndText = this.readOsgiBndTemplate();
        osgiBndText = StringUtils.replaceEach((String)osgiBndText, (String[])new String[]{"@VERSION_VARIABLES@"}, (String[])new String[]{this.getVersionDeclarations(compileTimeDependencies)});
        try {
            FileUtils.writeStringToFile((File)osgiBndFile, (String)osgiBndText, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Unable to write osgi.bnd file '%s'. %s", osgiBndFile, e.getMessage()));
        }
    }

    private String getVersionDeclarations(Collection<Dependency> dependencies) {
        TextStringBuilder declarations = new TextStringBuilder();
        declarations.append("package-version=${version;===;${Bundle-Version}}");
        for (Dependency dependency : dependencies) {
            declarations.appendNewLine();
            declarations.append(String.format("%s=${range;[===,+);%s}", this.getVersionRangeVariableName(dependency), dependency.getVersion()));
            declarations.append(String.format("%s=${version;===;%s}", this.getVersionVariableName(dependency), dependency.getVersion()));
        }
        return declarations.toString();
    }

    private String getVersionRangeVariableName(Dependency dependency) {
        return String.format("%s-version-range", dependency.getArtifactId());
    }

    private String getVersionVariableName(Dependency dependency) {
        return String.format("%s-version", dependency.getArtifactId());
    }

    private String readOsgiBndTemplate() throws MojoExecutionException {
        try {
            return IOUtils.toString((InputStream)TemplateHelper.getTemplate("recipe-osgi.bnd"), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(String.format("Error reading osgi.bnd template: %s", e.getMessage()));
        }
    }
}

