/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven.eclipseip;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.model.License;

public class KnownLicense {
    private final String name;
    private LinkedHashSet<String> knownUrls;
    private Set<String> alternateNames;

    public KnownLicense(String name) {
        this.name = name;
    }

    public Set<String> getAlternateNames() {
        if (this.alternateNames == null) {
            this.alternateNames = new HashSet<String>();
        }
        return this.alternateNames;
    }

    public Set<String> getKnownUrls() {
        if (this.knownUrls == null) {
            this.knownUrls = new LinkedHashSet();
        }
        return this.knownUrls;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.getKnownUrls().size() > 0 ? this.getKnownUrls().iterator().next() : "";
    }

    public void setAlternateNames(String ... names) {
        if (names != null) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.getAlternateNames().add(name);
                ++n2;
            }
        }
    }

    public License toMavenLicense() {
        License l = new License();
        l.setName(this.getName());
        if (this.knownUrls != null && this.knownUrls.size() >= 1) {
            l.setUrl((String)this.knownUrls.iterator().next());
        }
        return l;
    }

    public String toString() {
        if (this.knownUrls != null && this.knownUrls.size() >= 1) {
            return String.valueOf(this.name) + " (" + (String)this.knownUrls.iterator().next() + ")";
        }
        return this.name;
    }
}

