/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebr.maven.eclipseip;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.JaroWinklerDistance;
import org.apache.maven.model.License;
import org.eclipse.ebr.maven.eclipseip.KnownLicense;

public class KnownLicenses {
    private static final KnownLicenses instance = new KnownLicenses();
    private final Map<String, KnownLicense> licensesByName = new HashMap<String, KnownLicense>();

    public static KnownLicenses getInstance() {
        return instance;
    }

    private KnownLicenses() {
        this.addLicense("Apache Software License 1.1", "http://www.apache.org/licenses/LICENSE-1.1").setAlternateNames("Apache License, Version 1.0");
        this.addLicense("Custom license based on Apache Software License 1.1", "(see about_files)");
        this.addLicense("Apache License, 2.0", "http://www.apache.org/licenses/LICENSE-2.0.txt", "http://www.apache.org/licenses/LICENSE-2.0", "http://www.apache.org/licenses/LICENSE-2.0.html", "http://opensource.org/licenses/Apache-2.0");
        this.addLicense("New BSD license", "http://opensource.org/licenses/BSD-3-Clause").setAlternateNames("The BSD 3-Clause License", "BSD New", "New BSD");
        this.addLicense("Common Development and Distribution License", "https://glassfish.java.net/public/CDDLv1.0.html", "http://opensource.org/licenses/CDDL-1.0").setAlternateNames("CDDL");
        this.addLicense("Common Public License 1.0", "http://opensource.org/licenses/cpl1.0.php", "http://www.ibm.com/developerworks/library/os-cpl.html").setAlternateNames("CPL");
        this.addLicense("Eclipse Public License", "http://www.eclipse.org/legal/epl-v10.html").setAlternateNames("EPL");
        this.addLicense("MIT license", "http://opensource.org/licenses/MIT");
        this.addLicense("Mozilla Public License 1.0 (MPL)", "https://www.mozilla.org/MPL/1.0/");
        this.addLicense("Mozilla Public License 1.1 (MPL)", "https://www.mozilla.org/MPL/1.1/");
        this.addLicense("Mozilla Public License 2.0 (MPL)", "https://www.mozilla.org/MPL/2.0/");
        this.addLicense("Public Domain", "https://creativecommons.org/publicdomain/zero/1.0/");
        this.addLicense("SUN Industry Standards Source License 1.2", "http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html").setAlternateNames("SISSL-1.2");
        this.addLicense("Java Cup License (MIT Style)", "http://www2.cs.tum.edu/projekte/cup/licence.php");
    }

    private KnownLicense addLicense(String name, String ... knownUrls) {
        KnownLicense l = new KnownLicense(name);
        if (knownUrls != null) {
            String[] stringArray = knownUrls;
            int n = knownUrls.length;
            int n2 = 0;
            while (n2 < n) {
                String url = stringArray[n2];
                l.getKnownUrls().add(url);
                ++n2;
            }
        }
        this.licensesByName.put(name, l);
        return l;
    }

    public KnownLicense findByUrl(String url) {
        for (KnownLicense l : this.licensesByName.values()) {
            for (String knownUrl : l.getKnownUrls()) {
                JaroWinklerDistance jaroWinklerDistance = new JaroWinklerDistance();
                if (!(jaroWinklerDistance.apply((CharSequence)url, (CharSequence)knownUrl) >= 0.99)) continue;
                return l;
            }
        }
        return null;
    }

    public Set<KnownLicense> findSimilarLicensesByName(String name) {
        HashSet<KnownLicense> similarLicenses = new HashSet<KnownLicense>();
        for (KnownLicense l : this.licensesByName.values()) {
            if (this.isSimilar(name, l.getName())) {
                similarLicenses.add(l);
                continue;
            }
            for (String alternateName : l.getAlternateNames()) {
                if (!this.isSimilar(name, alternateName)) continue;
                similarLicenses.add(l);
            }
        }
        return similarLicenses;
    }

    public SortedSet<String> getAllLicenseNames() {
        return new TreeSet<String>(this.licensesByName.keySet());
    }

    public KnownLicense getByName(String name) {
        return this.licensesByName.get(name);
    }

    public boolean isDualLicense(License license) {
        String upperCaseLicenseName = StringUtils.upperCase((String)license.getName());
        return StringUtils.containsAny((CharSequence)upperCaseLicenseName, (CharSequence)"GPL") && StringUtils.containsAny((CharSequence)upperCaseLicenseName, (CharSequence)"CDDL");
    }

    private boolean isSimilar(String name, String alternateName) {
        double distance = new JaroWinklerDistance().apply((CharSequence)name, (CharSequence)alternateName);
        return distance >= 0.9;
    }
}

