/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.query.CapabilityQuery;
import org.eclipse.equinox.p2.cudf.query.Collector;
import org.eclipse.equinox.p2.cudf.solver.OptimizationFunction;
import org.sat4j.pb.tools.WeightedObject;

public class P2OptimizationFunction
extends OptimizationFunction {
    @Override
    public List createOptimizationFunction(InstallableUnit metaIu) {
        BigInteger POWER;
        ArrayList<WeightedObject> weightedObjects = new ArrayList<WeightedObject>();
        Set s = this.slice.entrySet();
        BigInteger maxWeight = POWER = BigInteger.valueOf(2L);
        for (Map.Entry entry : s) {
            HashMap conflictingEntries = (HashMap)entry.getValue();
            if (conflictingEntries.size() == 1) continue;
            ArrayList toSort = new ArrayList(conflictingEntries.values());
            Collections.sort(toSort, Collections.reverseOrder());
            BigInteger weight = POWER;
            int count = toSort.size();
            for (int i = 0; i < count; ++i) {
                InstallableUnit iu;
                weightedObjects.add(WeightedObject.newWO((Object)iu, (BigInteger)((iu = (InstallableUnit)toSort.get(i)).isInstalled() ? BigInteger.ONE : weight)));
                weight = weight.multiply(POWER);
            }
            if (weight.compareTo(maxWeight) <= 0) continue;
            maxWeight = weight;
        }
        maxWeight = maxWeight.multiply(POWER);
        maxWeight = maxWeight.multiply(POWER);
        BigInteger optionalWeight = maxWeight.negate();
        long countOptional = 1L;
        ArrayList requestedPatches = new ArrayList();
        IRequiredCapability[] reqs = metaIu.getRequiredCapabilities();
        for (int j = 0; j < reqs.length; ++j) {
            if (!reqs[j].isOptional()) continue;
            Collector matches = this.picker.query(new CapabilityQuery(reqs[j]), new Collector(), null);
            Iterator iterator = matches.iterator();
            while (iterator.hasNext()) {
                InstallableUnit match = (InstallableUnit)iterator.next();
                weightedObjects.add(WeightedObject.newWO((Object)match, (BigInteger)optionalWeight));
            }
        }
        BigInteger patchWeight = maxWeight.multiply(POWER).multiply(BigInteger.valueOf(countOptional)).negate();
        Iterator iterator = requestedPatches.iterator();
        while (iterator.hasNext()) {
            weightedObjects.add(WeightedObject.newWO(iterator.next(), (BigInteger)patchWeight));
        }
        if (!weightedObjects.isEmpty()) {
            return weightedObjects;
        }
        return null;
    }

    @Override
    public String getName() {
        return "p2";
    }

    @Override
    public void printSolutionValue() {
    }
}

