/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.equinox.p2.cudf.Log;
import org.eclipse.equinox.p2.cudf.Options;
import org.eclipse.equinox.p2.cudf.Parser;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.solver.ProfileChangeRequest;
import org.eclipse.equinox.p2.cudf.solver.SimplePlanner;
import org.eclipse.equinox.p2.cudf.solver.SolverConfiguration;

public class Main {
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.cudf";
    private static final String VERBOSE = "-verbose";
    private static final String OBJECTIVE = "-obj";
    private static final String TIMEOUT = "-timeout";
    private static final String SORT = "-sort";
    private static final String EXPLAIN = "-explain";
    private static final String ENCODING = "-encoding";
    protected static transient Thread shutdownHook = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (planner != null) {
                if (Main.options.encoding) {
                    out.println(planner.getSolver().toString());
                    PrintWriter outMapping = null;
                    try {
                        String mappingFilename = Main.options.output == null ? "stdout.mapping" : Main.options.output + ".mapping";
                        outMapping = new PrintWriter(new FileWriter(mappingFilename));
                        Map mapping = planner.getMappingToDomain();
                        Set entries = mapping.entrySet();
                        for (Map.Entry entry : entries) {
                            outMapping.println(entry.getKey() + "=" + entry.getValue());
                        }
                    }
                    catch (IOException e) {
                        System.out.println("# cannot write mapping: " + e.getMessage());
                    }
                    finally {
                        if (outMapping != null) {
                            outMapping.close();
                        }
                    }
                } else {
                    planner.stopSolver();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    long end = System.currentTimeMillis();
                    Log.println("Solving done (" + (double)(end - begin) / 1000.0 + "s).");
                    Collection col = planner.getBestSolutionFoundSoFar();
                    if (col == null) {
                        Main.printFail("Cannot find a solution");
                        if (Main.options.explain) {
                            out.println(planner.getExplanation());
                        }
                    } else if (col.isEmpty()) {
                        System.out.println("# There is nothing to install ????");
                        out.println("# There is nothing to install ....");
                    } else {
                        if (planner.isSolutionOptimal()) {
                            System.out.println("# The solution found IS optimal");
                        } else {
                            System.out.println("# WARNING: The solution found MIGHT NOT BE optimal");
                        }
                        Main.printSolution(col, options);
                    }
                    if (Main.options.output != null) {
                        out.close();
                    }
                }
            }
        }
    };
    static PrintStream out;
    static SimplePlanner planner;
    static Options options;
    static long begin;

    private static final void usage() {
        System.out.println("Usage: p2cudf [flags] inputFile [outputFile]");
        System.out.println("-obj paranoid|trendy|<user defined>   The objective function to be used to resolve the problem.");
        System.out.println("                                      Users can define their own: -new,-changed,-notuptodate,-unsat_recommends,-removed,-sum(installedsize)");
        System.out.println("-timeout <number>(c|s)                The time out after which the solver will stop. e.g. 10s stops after 10 seconds, 10c stops after 10 conflicts. Default is set to 200c for p2 and 2000c for other objective functions.");
        System.out.println("-sort                                 Sort the output.");
        System.out.println("-explain                              Provides one reason of the inability to fulfill the request");
        System.out.println("-verbose                              Display details on the platform, internal SAT solver and steps reached");
    }

    public static Options processArguments(String[] args) {
        Options result = new Options();
        if (args == null) {
            return result;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase(VERBOSE)) {
                result.verbose = true;
                continue;
            }
            if (args[i].equalsIgnoreCase(ENCODING)) {
                throw new IllegalArgumentException("Encoding not available for lexico solving");
            }
            if (args[i].equalsIgnoreCase(EXPLAIN)) {
                result.explain = true;
                continue;
            }
            if (args[i].equalsIgnoreCase(OBJECTIVE)) {
                result.objective = args[++i];
                if ("paranoid".equalsIgnoreCase(result.objective)) {
                    result.objective = "-removed,-changed";
                    continue;
                }
                if (!"trendy".equalsIgnoreCase(result.objective)) continue;
                result.objective = "-removed,-notuptodate,-unsat_recommends,-new";
                continue;
            }
            if (args[i].equalsIgnoreCase(TIMEOUT)) {
                if (args[i + 1].startsWith("-")) {
                    Main.printFail("--timeout should be followed by a time in seconds or a number of conflicts.");
                    System.exit(1);
                }
                result.timeout = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase(SORT)) {
                result.sort = true;
                continue;
            }
            if (result.input == null) {
                result.input = new File(args[i]);
                continue;
            }
            result.output = new File(args[i]);
        }
        return result;
    }

    private static boolean validateOptions(Options theOptions) {
        boolean error = false;
        if (theOptions.input == null || !theOptions.input.exists()) {
            Main.printFail("Missing input file.");
            error = true;
        }
        if (!(theOptions.timeout == null || theOptions.timeout.equals("default") || theOptions.timeout.endsWith("c") || theOptions.timeout.endsWith("s"))) {
            Main.printFail("Timeout should be either <number>s (100s) or <number>c (100c)");
            error = true;
        }
        return error;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Main.usage();
            return;
        }
        options = Main.processArguments(args);
        if (Main.validateOptions(options)) {
            System.exit(1);
        }
        Log.verbose = Main.options.verbose;
        Main.logOptions(options);
        Main.logVmDetails();
        if (Main.options.output != null) {
            try {
                out = new PrintStream(new FileOutputStream(Main.options.output));
            }
            catch (FileNotFoundException e) {
                Main.printFail("Output file does not exist.");
                System.exit(1);
            }
        }
        try {
            Main.invokeSolver(Main.parseCUDF(Main.options.input), new SolverConfiguration(Main.options.objective, Main.options.timeout, Main.options.verbose, Main.options.explain, Main.options.encoding));
        }
        catch (Exception ex) {
            Main.printFail(ex.getMessage());
        }
        System.exit(0);
    }

    private static void logOptions(Options theOptions) {
        if (!theOptions.verbose) {
            return;
        }
        Log.println("Solver launched on " + new Date());
        Log.println("Using input file " + theOptions.input.getAbsolutePath());
        Log.println("Using output file " + (theOptions.output == null ? "STDOUT" : theOptions.output.getAbsolutePath()));
        Log.println("Objective function " + theOptions.objective);
        Log.println("Timeout " + theOptions.timeout);
    }

    private static void logVmDetails() {
        Properties prop = System.getProperties();
        String[] infoskeys = new String[]{"java.runtime.name", "java.vm.name", "java.vm.version", "java.vm.vendor", "sun.arch.data.model", "java.version", "os.name", "os.version", "os.arch"};
        for (int i = 0; i < infoskeys.length; ++i) {
            String key = infoskeys[i];
            Log.println(key + (key.length() < 14 ? "\t\t" : "\t") + prop.getProperty(key));
        }
        Runtime runtime = Runtime.getRuntime();
        Log.println("Free memory \t\t" + runtime.freeMemory());
        Log.println("Max memory \t\t" + runtime.maxMemory());
        Log.println("Total memory \t\t" + runtime.totalMemory());
        Log.println("Number of processors \t" + runtime.availableProcessors());
    }

    static void printFail(String message) {
        out.println("FAIL");
        out.println(message);
    }

    private static Object invokeSolver(ProfileChangeRequest request, SolverConfiguration configuration) {
        Log.println("Solving ...");
        begin = System.currentTimeMillis();
        planner = new SimplePlanner();
        Object result = planner.getSolutionFor(request, configuration);
        return result;
    }

    private static ProfileChangeRequest parseCUDF(File file) {
        Log.println("Parsing ...");
        long myBegin = System.currentTimeMillis();
        String sumpProperty = Main.extractSumProperty(Main.options.objective);
        ProfileChangeRequest result = new Parser().parse(file, Main.options.objective.contains("recommend"), sumpProperty);
        long myEnd = System.currentTimeMillis();
        Log.println("Parsing done (" + (double)(myEnd - myBegin) / 1000.0 + "s).");
        return result;
    }

    private static String extractSumProperty(String objectiveFunction) {
        String[] criteria;
        for (String criterion : criteria = objectiveFunction.split(",")) {
            if (!criterion.contains("sum")) continue;
            return Options.extractSumProperty(criterion);
        }
        return null;
    }

    static void printSolution(Collection state, Options theOptions) {
        if (theOptions.sort) {
            ArrayList tmp = new ArrayList(state);
            Collections.sort(tmp);
            state = tmp;
        }
        Log.println("Solution contains:" + state.size());
        for (InstallableUnit iu : state) {
            out.println("package: " + iu.getId());
            out.println("version: " + iu.getVersion().getMajor());
            out.println("installed: " + iu.isInstalled());
            out.println();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        out = System.out;
    }
}

