/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.equinox.p2.cudf.Log;
import org.eclipse.equinox.p2.cudf.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.metadata.NotRequirement;
import org.eclipse.equinox.p2.cudf.metadata.ORRequirement;
import org.eclipse.equinox.p2.cudf.metadata.ProvidedCapability;
import org.eclipse.equinox.p2.cudf.metadata.RequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.Version;
import org.eclipse.equinox.p2.cudf.metadata.VersionRange;
import org.eclipse.equinox.p2.cudf.query.CapabilityQuery;
import org.eclipse.equinox.p2.cudf.query.Collector;
import org.eclipse.equinox.p2.cudf.query.QueryableArray;
import org.eclipse.equinox.p2.cudf.solver.ProfileChangeRequest;

public class Parser {
    private static final boolean FORCE_QUERY = true;
    private static final boolean DEBUG = false;
    private static final boolean TIMING = true;
    private InstallableUnit currentIU = null;
    private ProfileChangeRequest currentRequest = null;
    private List allIUs = new ArrayList();
    private QueryableArray query = null;
    private List preInstalled = new ArrayList(10000);
    private List keepRequests = new ArrayList();
    private List currentKeepRequests = new ArrayList();

    public ProfileChangeRequest parse(File file) {
        return this.parse(file, false, null);
    }

    public ProfileChangeRequest parse(File file, boolean includeRecommends, String sumProperty) {
        try {
            return this.parse(new FileInputStream(file), includeRecommends, sumProperty);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ProfileChangeRequest parse(InputStream stream) {
        return this.parse(stream, false, null);
    }

    public ProfileChangeRequest parse(InputStream stream, String sumProperty) {
        return this.parse(stream, false, sumProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfileChangeRequest parse(InputStream stream, boolean includeRecommends, String sumProperty) {
        long start = System.currentTimeMillis();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            String next = reader.readLine();
            while (true) {
                String line = next;
                next = reader.readLine();
                while (next != null && next.length() > 1 && next.charAt(0) == ' ') {
                    line = line + next.substring(1);
                    next = reader.readLine();
                }
                if (line == null) {
                    this.validateAndAddIU();
                    break;
                }
                if (line.trim().length() == 0) {
                    this.validateAndAddIU();
                    continue;
                }
                if (line.startsWith("#") || line.startsWith("preamble: ") || line.startsWith("property: ") || line.startsWith("univ-checksum: ")) continue;
                if (line.startsWith("request:")) {
                    this.handleRequest(line);
                    continue;
                }
                if (line.startsWith("install: ")) {
                    this.handleInstall(line);
                    continue;
                }
                if (line.startsWith("upgrade: ")) {
                    this.handleUpgrade(line);
                    continue;
                }
                if (line.startsWith("remove: ")) {
                    this.handleRemove(line);
                    continue;
                }
                if (line.startsWith("package: ")) {
                    this.handlePackage(line);
                    continue;
                }
                if (line.startsWith("version: ")) {
                    this.handleVersion(line);
                    continue;
                }
                if (line.startsWith("installed: ")) {
                    this.handleInstalled(line);
                    continue;
                }
                if (line.startsWith("depends: ")) {
                    this.handleDepends(line);
                    continue;
                }
                if (line.startsWith("conflicts: ")) {
                    this.handleConflicts(line);
                    continue;
                }
                if (line.startsWith("provides: ")) {
                    this.handleProvides(line);
                    continue;
                }
                if (line.startsWith("expected: ")) {
                    this.handleExpected(line);
                    continue;
                }
                if (line.startsWith("recommends: ") && includeRecommends) {
                    this.handleRecommends(line);
                    continue;
                }
                if (line.startsWith("keep: ")) {
                    this.handleKeep(line);
                    continue;
                }
                if (sumProperty == null || !line.startsWith(sumProperty + ":")) continue;
                this.handleSumProperty(line, sumProperty);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        Log.println("Time to parse:" + (System.currentTimeMillis() - start));
        if (this.query == null) {
            this.initializeQueryableArray();
        }
        if (this.currentRequest == null) {
            this.currentRequest = new ProfileChangeRequest(this.query);
        }
        this.debug(this.currentRequest);
        return this.currentRequest;
    }

    private void handleSumProperty(String line, String sumProperty) {
        String value = line.substring(sumProperty.length() + 1).trim();
        try {
            this.currentIU.setSumProperty(Long.valueOf(value));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("The value \"" + value + "\" of property \"" + sumProperty + "\" cannot be summed up");
        }
    }

    private void handleKeep(String line) {
        if ((line = line.substring("keep: ".length())).contains("version")) {
            this.currentKeepRequests.add(new RequiredCapability(this.currentIU.getId(), new VersionRange(this.currentIU.getVersion()), false));
            return;
        }
        if (line.contains("package")) {
            this.currentKeepRequests.add(new RequiredCapability(this.currentIU.getId(), VersionRange.emptyRange, false));
            return;
        }
        if (line.contains("none")) {
            return;
        }
        if (line.contains("feature")) {
            IProvidedCapability[] caps = this.currentIU.getProvidedCapabilities();
            for (int i = 0; i < caps.length; ++i) {
                if (caps[i].getName().equals(this.currentIU.getId())) continue;
                this.currentKeepRequests.add(new RequiredCapability(caps[i].getName(), caps[i].getVersion(), false));
            }
        }
    }

    private void handleExpected(String line) {
        this.currentRequest.setExpected(Integer.decode(line.substring("expected: ".length()).trim()));
    }

    private void validateAndAddIU() {
        if (this.currentIU == null) {
            return;
        }
        if (this.currentIU.getId() == null) {
            throw new IllegalStateException("Malformed 'package' stanza. No package element found.");
        }
        if (this.currentIU.getVersion() == null) {
            throw new IllegalStateException("Malformed 'package' stanza. Package " + this.currentIU.getId() + " does not have a version.");
        }
        if (this.currentIU.getProvidedCapabilities().length == 0) {
            this.currentIU.setCapabilities(new IProvidedCapability[]{new ProvidedCapability(this.currentIU.getId(), new VersionRange(this.currentIU.getVersion(), true, this.currentIU.getVersion(), true))});
        }
        if (this.currentIU.isInstalled()) {
            this.keepRequests.addAll(this.currentKeepRequests);
        }
        this.allIUs.add(this.currentIU);
        this.currentIU = null;
        this.currentKeepRequests.clear();
    }

    private void handleInstalled(String line) {
        String value = line.substring("installed: ".length());
        this.currentIU.setInstalled(Boolean.valueOf(value));
        if (this.currentIU.isInstalled()) {
            this.preInstalled.add(new RequiredCapability(this.currentIU.getId(), new VersionRange(this.currentIU.getVersion()), true));
        }
    }

    private void handleInstall(String line) {
        line = line.substring("install: ".length());
        List installRequest = this.createRequires(line, true, false, true);
        Iterator iterator = installRequest.iterator();
        while (iterator.hasNext()) {
            this.currentRequest.addInstallableUnit((IRequiredCapability)iterator.next());
        }
    }

    private void handleRequest(String line) {
        this.initializeQueryableArray();
        this.currentRequest = new ProfileChangeRequest(this.query);
        this.currentRequest.setPreInstalledIUs(this.preInstalled);
        this.currentRequest.setContrainstFromKeep(this.keepRequests);
    }

    private void handleRemove(String line) {
        line = line.substring("remove: ".length());
        List removeRequest = this.createRequires(line, true, false, true);
        Iterator iterator = removeRequest.iterator();
        while (iterator.hasNext()) {
            this.currentRequest.removeInstallableUnit((IRequiredCapability)iterator.next());
        }
    }

    private void initializeQueryableArray() {
        this.query = new QueryableArray(this.allIUs.toArray(new InstallableUnit[this.allIUs.size()]));
    }

    private void handleUpgrade(String line) {
        line = line.substring("upgrade: ".length());
        List updateRequest = this.createRequires(line, true, false, true);
        for (IRequiredCapability requirement : updateRequest) {
            this.currentRequest.upgradeInstallableUnit(requirement);
            this.currentRequest.upgradeInstallableUnit(new RequiredCapability(requirement.getName(), VersionRange.emptyRange, 1));
            if ((requirement = this.getHighestInstalledVersion(requirement)) == null) continue;
            this.currentRequest.upgradeInstallableUnit(requirement);
        }
    }

    private IRequiredCapability getHighestInstalledVersion(IRequiredCapability req) {
        Version highestVersion = null;
        Collector c = this.query.query(new CapabilityQuery(req), new Collector(), null);
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            InstallableUnit candidate = (InstallableUnit)iterator.next();
            if (!candidate.isInstalled()) continue;
            if (candidate.getId().equals(req.getName())) {
                if (highestVersion != null && candidate.getVersion().getMajor() <= highestVersion.getMajor()) continue;
                highestVersion = candidate.getVersion();
                continue;
            }
            IProvidedCapability[] prov = candidate.getProvidedCapabilities();
            for (int i = 0; i < prov.length; ++i) {
                if (prov[i].getVersion().equals(VersionRange.emptyRange) || !prov[i].getName().equals(req.getName()) || highestVersion != null && prov[i].getVersion().getMinimum().getMajor() <= highestVersion.getMajor()) continue;
                highestVersion = prov[i].getVersion().getMinimum();
            }
        }
        if (highestVersion == null) {
            return null;
        }
        return new RequiredCapability(req.getName(), new VersionRange(highestVersion, true, Version.maxVersion, true));
    }

    private void handleVersion(String line) {
        this.currentIU.setVersion(new Version(this.cudfPosintToInt(line.substring("version: ".length()))));
    }

    private String cudfPosintToInt(String posint) {
        if (posint.startsWith("+")) {
            return posint.substring(1).trim();
        }
        return posint.trim();
    }

    private void handleDepends(String line) {
        this.mergeRequirements(this.createRequires(line.substring("depends: ".length()), true, false, true));
    }

    private void handleRecommends(String line) {
        this.mergeRequirements(this.createRequires(line.substring("recommends: ".length()), true, true, true));
    }

    private void handleConflicts(String line) {
        List reqs = this.createRequires(line.substring("conflicts: ".length()), false, false, false);
        ArrayList<NotRequirement> conflicts = new ArrayList<NotRequirement>();
        for (IRequiredCapability req : reqs) {
            if (this.currentIU.getId().equals(req.getName()) && req.getRange().equals(VersionRange.emptyRange)) {
                this.currentIU.setSingleton(true);
                continue;
            }
            conflicts.add(new NotRequirement(req));
        }
        this.mergeRequirements(conflicts);
    }

    private void mergeRequirements(List requirements) {
        if (this.currentIU.getRequiredCapabilities() != null) {
            IRequiredCapability[] current = this.currentIU.getRequiredCapabilities();
            for (int i = 0; i < current.length; ++i) {
                requirements.add(current[i]);
            }
        }
        this.currentIU.setRequiredCapabilities(requirements.toArray(new IRequiredCapability[requirements.size()]));
    }

    private List createPackageList(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, ",");
        ArrayList<Tuple> result = new ArrayList<Tuple>(tokenizer.countTokens());
        while (tokenizer.hasMoreElements()) {
            result.add(new Tuple(tokenizer.nextToken()));
        }
        return result;
    }

    private List createRequires(String line, boolean expandNotEquals, boolean optional, boolean dependency) {
        ArrayList<Object> ands = new ArrayList<Object>();
        StringTokenizer s = new StringTokenizer(line, ",");
        while (s.hasMoreElements()) {
            StringTokenizer subTokenizer = new StringTokenizer(s.nextToken(), "|");
            if (subTokenizer.countTokens() == 1) {
                String subtoken = subTokenizer.nextToken().trim();
                if ("true!".equals(subtoken)) {
                    if (dependency) continue;
                    throw new RuntimeException("Cannot have true! in a conflict!!!!!");
                }
                if ("false!".equals(subtoken)) {
                    if (!dependency) continue;
                    throw new RuntimeException("Cannot have false! in a dependency!!!!!");
                }
                Object o = this.createRequire(subtoken, expandNotEquals, optional);
                if (o instanceof IRequiredCapability) {
                    ands.add(o);
                    continue;
                }
                ands.addAll((Collection)o);
                continue;
            }
            IRequiredCapability[] ors = new RequiredCapability[subTokenizer.countTokens()];
            int i = 0;
            while (subTokenizer.hasMoreElements()) {
                ors[i++] = (IRequiredCapability)this.createRequire(subTokenizer.nextToken(), expandNotEquals, optional);
            }
            ands.add(new ORRequirement(ors, optional));
        }
        return ands;
    }

    private Object createRequire(String nextToken, boolean expandNotEquals, boolean optional) {
        StringTokenizer expressionTokens = new StringTokenizer(nextToken.trim(), ">=!<", true);
        int tokenCount = expressionTokens.countTokens();
        if (tokenCount == 1) {
            return new RequiredCapability(expressionTokens.nextToken().trim(), VersionRange.emptyRange, optional);
        }
        if (tokenCount == 3) {
            return new RequiredCapability(expressionTokens.nextToken().trim(), this.createRange3(expressionTokens.nextToken(), expressionTokens.nextToken()), optional);
        }
        if (tokenCount == 4) {
            String id = expressionTokens.nextToken().trim();
            String signFirstChar = expressionTokens.nextToken();
            expressionTokens.nextToken();
            String version = expressionTokens.nextToken().trim();
            if (!"!".equals(signFirstChar)) {
                return new RequiredCapability(id, this.createRange4(signFirstChar, version), optional);
            }
            if (expandNotEquals) {
                return new ORRequirement(new IRequiredCapability[]{new RequiredCapability(id, this.createRange3("<", version), optional), new RequiredCapability(id, this.createRange3(">", version), optional)}, optional);
            }
            ArrayList<RequiredCapability> res = new ArrayList<RequiredCapability>(2);
            res.add(new RequiredCapability(id, this.createRange3("<", version), optional));
            res.add(new RequiredCapability(id, this.createRange3(">", version), optional));
            return res;
        }
        return null;
    }

    private VersionRange createRange3(String sign, String versionAsString) {
        int version = Integer.decode(this.cudfPosintToInt(versionAsString));
        if (">".equals(sign = sign.trim())) {
            return new VersionRange(new Version(version), false, Version.maxVersion, false);
        }
        if ("<".equals(sign)) {
            return new VersionRange(Version.emptyVersion, false, new Version(version), false);
        }
        if ("=".equals(sign)) {
            return new VersionRange(new Version(version));
        }
        throw new IllegalArgumentException(sign);
    }

    private VersionRange createRange4(String sign, String versionAsString) {
        int version = Integer.decode(this.cudfPosintToInt(versionAsString));
        if (">".equals(sign)) {
            return new VersionRange(new Version(version), true, Version.maxVersion, false);
        }
        if ("<".equals(sign)) {
            return new VersionRange(Version.emptyVersion, false, new Version(version), true);
        }
        return null;
    }

    private IProvidedCapability createProvidedCapability(Tuple tuple) {
        Set extraData = tuple.extraData;
        if (extraData == null) {
            return new ProvidedCapability(tuple.name, this.createVersionRange(tuple.operator, tuple.version));
        }
        if (extraData.size() == 1) {
            return new ProvidedCapability(tuple.name, this.createVersionRange(tuple, (Tuple)extraData.iterator().next()));
        }
        return new ProvidedCapability(tuple.name, this.createVersionRange(tuple.operator, tuple.version));
    }

    private VersionRange createVersionRange(Tuple t1, Tuple t2) {
        Version two;
        Version one = Version.parseVersion(t1.version);
        if (one.compareTo(two = Version.parseVersion(t2.version)) < 0) {
            return new VersionRange(one, this.include(t1.operator), two, this.include(t2.operator));
        }
        if (one.compareTo(two) == 0) {
            return new VersionRange(one, this.include(t1.operator), one, this.include(t1.operator));
        }
        if (one.compareTo(two) > 0) {
            return new VersionRange(two, this.include(t2.operator), one, this.include(t1.operator));
        }
        return null;
    }

    private boolean include(String operator) {
        return "=".equals(operator) || "<=".equals(operator) || ">=".equals(operator);
    }

    private VersionRange createVersionRange(String operator, String number) {
        if (operator == null || number == null) {
            return VersionRange.emptyRange;
        }
        if ("=".equals(operator)) {
            return new VersionRange('[' + number + ',' + number + ']');
        }
        if ("<".equals(operator)) {
            return new VersionRange("[0," + number + ')');
        }
        if (">".equals(operator)) {
            return new VersionRange('(' + number + ',' + Integer.MAX_VALUE + ']');
        }
        if ("<=".equals(operator)) {
            return new VersionRange("[0," + number + ']');
        }
        if (">=".equals(operator)) {
            return new VersionRange('[' + number + ',' + Integer.MAX_VALUE + ']');
        }
        return VersionRange.emptyRange;
    }

    private void handlePackage(String readLine) {
        this.currentIU = new InstallableUnit();
        this.currentIU.setId(readLine.substring("package: ".length()));
    }

    private void handleProvides(String line) {
        line = line.substring("provides: ".length());
        List pkgs = this.createPackageList(line);
        IProvidedCapability[] providedCapabilities = new ProvidedCapability[pkgs.size() + 1];
        int i = 0;
        Iterator iter = pkgs.iterator();
        while (iter.hasNext()) {
            providedCapabilities[i++] = this.createProvidedCapability((Tuple)iter.next());
        }
        providedCapabilities[i++] = new ProvidedCapability(this.currentIU.getId(), new VersionRange(this.currentIU.getVersion(), true, this.currentIU.getVersion(), true));
        this.currentIU.setCapabilities(providedCapabilities);
    }

    private void debug(ProfileChangeRequest request) {
    }

    private void debug(InstallableUnit unit) {
    }

    class Tuple {
        String name;
        String version;
        String operator;
        Set extraData;

        Tuple(String line) {
            String[] tuple = new String[3];
            int i = 0;
            StringTokenizer iter = new StringTokenizer(line, " \t");
            while (iter.hasMoreTokens()) {
                tuple[i] = iter.nextToken();
                ++i;
            }
            this.name = tuple[0];
            this.operator = tuple[1];
            this.version = tuple[2];
        }
    }
}

