/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.solver.Messages;
import org.eclipse.osgi.util.NLS;

public abstract class Explanation
implements Comparable {
    public static final int MISSING_REQUIREMENT = 1;
    public static final Explanation OPTIONAL_REQUIREMENT = new Explanation(){

        @Override
        public int orderValue() {
            return 6;
        }

        public String toString() {
            return Messages.Explanation_optionalDependency;
        }
    };
    public static final int VIOLATED_SINGLETON_CONSTRAINT = 2;

    protected Explanation() {
    }

    public int compareTo(Object arg0) {
        Explanation exp = (Explanation)arg0;
        if (this.orderValue() == exp.orderValue()) {
            return this.toString().compareTo(exp.toString());
        }
        return this.orderValue() - exp.orderValue();
    }

    protected abstract int orderValue();

    public int shortAnswer() {
        throw new UnsupportedOperationException();
    }

    public IStatus toStatus() {
        return new Status(4, "org.eclipse.equinox.p2.cudf", this.toString());
    }

    protected String getUserReadableName(InstallableUnit iu) {
        if (iu == null) {
            return "";
        }
        String result = this.getLocalized(iu);
        if (result == null) {
            return iu.toString();
        }
        return result + ' ' + iu.getVersion() + " (" + iu.toString() + ')';
    }

    private String getLocalized(InstallableUnit iu) {
        return iu.getId();
    }

    public static class Singleton
    extends Explanation {
        public final InstallableUnit[] ius;

        public Singleton(InstallableUnit[] ius) {
            this.ius = ius;
        }

        @Override
        public int orderValue() {
            return 4;
        }

        @Override
        public int shortAnswer() {
            return 2;
        }

        @Override
        public IStatus toStatus() {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.cudf", 1, NLS.bind(Messages.Explanation_singleton, ""), null);
            for (int i = 0; i < this.ius.length; ++i) {
                result.add(new Status(4, "org.eclipse.equinox.p2.cudf", this.getUserReadableName(this.ius[i])));
            }
            return result;
        }

        public String toString() {
            return NLS.bind(Messages.Explanation_singleton, Arrays.asList(this.ius));
        }
    }

    public static class MissingIU
    extends Explanation {
        public final InstallableUnit iu;
        public final IRequiredCapability req;

        public MissingIU(InstallableUnit iu, IRequiredCapability req) {
            this.iu = iu;
            this.req = req;
        }

        @Override
        public int orderValue() {
            return 3;
        }

        @Override
        public int shortAnswer() {
            return 1;
        }

        public String toString() {
            return NLS.bind(Messages.Explanation_missingRequired, this.iu, this.req);
        }

        @Override
        public IStatus toStatus() {
            return new Status(4, "org.eclipse.equinox.p2.cudf", NLS.bind(Messages.Explanation_missingRequired, this.getUserReadableName(this.iu), this.req));
        }
    }

    public static class IUToInstall
    extends Explanation {
        public final InstallableUnit iu;

        public IUToInstall(InstallableUnit iu) {
            this.iu = iu;
        }

        @Override
        public int orderValue() {
            return 1;
        }

        public String toString() {
            return NLS.bind(Messages.Explanation_toInstall, this.iu);
        }

        @Override
        public IStatus toStatus() {
            return new Status(4, "org.eclipse.equinox.p2.cudf", NLS.bind(Messages.Explanation_toInstall, this.getUserReadableName(this.iu)));
        }
    }

    public static class IUInstalled
    extends Explanation {
        public final InstallableUnit iu;

        public IUInstalled(InstallableUnit iu) {
            this.iu = iu;
        }

        @Override
        public int orderValue() {
            return 2;
        }

        public String toString() {
            return NLS.bind(Messages.Explanation_alreadyInstalled, this.iu);
        }

        @Override
        public IStatus toStatus() {
            return new Status(4, "org.eclipse.equinox.p2.cudf", NLS.bind(Messages.Explanation_alreadyInstalled, this.getUserReadableName(this.iu)));
        }
    }

    public static class HardRequirement
    extends Explanation {
        public final InstallableUnit iu;
        public final IRequiredCapability req;

        public HardRequirement(InstallableUnit iu, IRequiredCapability req) {
            this.iu = iu;
            this.req = req;
        }

        @Override
        public int orderValue() {
            return 5;
        }

        @Override
        public IStatus toStatus() {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.cudf", 1, Messages.Explanation_unsatisfied, null);
            result.add(new Status(4, "org.eclipse.equinox.p2.cudf", NLS.bind(Messages.Explanation_from, this.getUserReadableName(this.iu))));
            result.add(new Status(4, "org.eclipse.equinox.p2.cudf", NLS.bind(Messages.Explanation_to, this.req)));
            return result;
        }

        public String toString() {
            return NLS.bind(Messages.Explanation_hardDependency, this.iu, this.req);
        }
    }
}

