/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.equinox.p2.cudf.metadata.InstallableUnit;
import org.eclipse.equinox.p2.cudf.solver.OptimizationFunction;

public class ParanoidOptimizationFunction
extends OptimizationFunction {
    private static final Log log = LogFactory.getLog(ParanoidOptimizationFunction.class);

    @Override
    public List createOptimizationFunction(InstallableUnit metaIu) {
        ArrayList weightedObjects = new ArrayList();
        BigInteger weight = BigInteger.valueOf(this.slice.size() + 1);
        this.removed(weightedObjects, weight, metaIu);
        this.changed(weightedObjects, BigInteger.ONE, metaIu);
        if (!weightedObjects.isEmpty()) {
            return weightedObjects;
        }
        return null;
    }

    @Override
    public String getName() {
        return "misc 2010 paranoid";
    }

    @Override
    public void printSolutionValue() {
        Object var;
        int i;
        int removed = 0;
        int changed = 0;
        ArrayList proof = new ArrayList();
        for (i = 0; i < this.removalVariables.size(); ++i) {
            var = this.removalVariables.get(i);
            if (!this.dependencyHelper.getBooleanValueFor(var)) continue;
            ++removed;
            proof.add(var);
        }
        for (i = 0; i < this.changeVariables.size(); ++i) {
            var = this.changeVariables.get(i);
            if (!this.dependencyHelper.getBooleanValueFor(var)) continue;
            ++changed;
            proof.add(var);
        }
        log.info("# Paranoid criteria value: -" + removed + ", -" + changed);
        log.info("# Proof: " + proof);
    }
}

