/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.solver;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.p2.cudf.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.NotRequirement;
import org.eclipse.equinox.p2.cudf.metadata.RequiredCapability;
import org.eclipse.equinox.p2.cudf.metadata.VersionRange;
import org.eclipse.equinox.p2.cudf.query.QueryableArray;

public class ProfileChangeRequest {
    private QueryableArray initialState;
    private ArrayList iusToRemove = new ArrayList(10);
    private ArrayList iusToAdd = new ArrayList(10);
    private ArrayList iusToUpdate = new ArrayList(10);
    private List iusPreInstalled = new ArrayList(1);
    private List constraintsFromKeep = new ArrayList(1);
    private int expected = -10;

    public ProfileChangeRequest(QueryableArray initialState) {
        this.initialState = initialState;
    }

    public void setPreInstalledIUs(List list) {
        this.iusPreInstalled = list;
    }

    public void setContrainstFromKeep(List constraints) {
        this.constraintsFromKeep = constraints;
    }

    public void addInstallableUnit(IRequiredCapability req) {
        this.iusToAdd.add(req);
    }

    public void removeInstallableUnit(IRequiredCapability toUninstall) {
        this.iusToRemove.add(new NotRequirement(toUninstall));
    }

    public void upgradeInstallableUnit(IRequiredCapability toUpgrade) {
        this.iusToUpdate.add(toUpgrade);
    }

    public ArrayList getAllRequests() {
        ArrayList result = new ArrayList(this.iusToAdd.size() + this.iusToRemove.size() + this.iusToUpdate.size() + this.iusPreInstalled.size());
        result.addAll(this.constraintsFromKeep);
        result.addAll(this.iusToAdd);
        result.addAll(this.iusToRemove);
        result.addAll(this.iusToUpdate);
        result.addAll(this.iusPreInstalled);
        return result;
    }

    public QueryableArray getInitialState() {
        return this.initialState;
    }

    public int getExpected() {
        return this.expected;
    }

    public void setExpected(int expected) {
        this.expected = expected;
    }

    public void purge() {
        this.iusPreInstalled = null;
        this.iusToAdd = null;
        this.iusToRemove = null;
        this.iusToUpdate = null;
        this.initialState = null;
    }

    public List getExtraRequirements() {
        ArrayList<RequiredCapability> result = new ArrayList<RequiredCapability>(this.iusPreInstalled.size());
        for (IRequiredCapability type : this.iusPreInstalled) {
            result.add(new RequiredCapability(type.getName(), VersionRange.emptyRange, false));
        }
        return result;
    }
}

