/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.core;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.sat4j.specs.ISolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ASolverFactory<T extends ISolver>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public String[] solverNames() {
        ArrayList<String> l = new ArrayList<String>();
        Method[] solvers = this.getClass().getDeclaredMethods();
        int i = 0;
        while (i < solvers.length) {
            if (solvers[i].getParameterTypes().length == 0 && solvers[i].getName().startsWith("new")) {
                l.add(solvers[i].getName().substring(3));
            }
            ++i;
        }
        String[] names = new String[l.size()];
        l.toArray(names);
        return names;
    }

    public T createSolverByName(String solvername) {
        try {
            Class[] paramtypes = new Class[]{};
            Method m = this.getClass().getMethod(new StringBuffer("new").append(solvername).toString(), paramtypes);
            return (T)((ISolver)m.invoke(null, null));
        }
        catch (SecurityException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (NoSuchMethodException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (InvocationTargetException e) {
            System.err.println(e.getLocalizedMessage());
        }
        return null;
    }

    public abstract T defaultSolver();

    public abstract T lightSolver();
}

