/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.SolverFactory;
import org.sat4j.pb.reader.OPBReader2007;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.GateTranslator;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoBitsAdderDecorator
extends SolverDecorator<IPBSolver>
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction objfct;
    private final GateTranslator gator;
    private final IPBSolver solver;
    private IVecInt bitsLiterals;
    private IVecInt fixedLiterals;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.PseudoBitsAdderDecorator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PseudoBitsAdderDecorator(IPBSolver solver) {
        super(solver);
        this.gator = new GateTranslator(solver);
        this.solver = solver;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objf) {
        this.objfct = objf;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        if (this.objfct == null) {
            return this.gator.isSatisfiable(assumps);
        }
        System.out.println("c Original number of variables and constraints");
        System.out.println(new StringBuffer("c #vars: ").append(this.gator.nVars()).append(" #constraints: ").append(this.gator.nConstraints()).toString());
        this.bitsLiterals = new VecInt();
        System.out.println("c Creating optimization constraints ....");
        try {
            this.gator.optimisationFunction(this.objfct.getVars(), this.objfct.getCoeffs(), this.bitsLiterals);
        }
        catch (ContradictionException contradictionException) {
            return false;
        }
        System.out.println(new StringBuffer("c ... done. ").append(this.bitsLiterals).toString());
        System.out.println("c New number of variables and constraints");
        System.out.println(new StringBuffer("c #vars: ").append(this.gator.nVars()).append(" #constraints: ").append(this.gator.nConstraints()).toString());
        this.fixedLiterals = new VecInt(this.bitsLiterals.size());
        VecInt nAssumpts = new VecInt(assumps.size() + this.bitsLiterals.size());
        int litIndex = this.bitsLiterals.size() - 1;
        while (litIndex >= 0) {
            assumps.copyTo(nAssumpts);
            this.fixedLiterals.copyTo(nAssumpts);
            nAssumpts.push(-this.bitsLiterals.get(litIndex));
            int j = litIndex - 1;
            while (j >= 0) {
                nAssumpts.push(this.bitsLiterals.get(j));
                --j;
            }
            System.out.println(new StringBuffer("c assumptions ").append(nAssumpts).toString());
            boolean result = this.gator.isSatisfiable(nAssumpts, true);
            if (result) {
                this.fixedLiterals.push(-this.bitsLiterals.get(litIndex--));
                BigInteger value = this.objfct.calculateDegree(this.gator);
                System.out.println(new StringBuffer("o ").append(value).toString());
                System.out.println(new StringBuffer("c current objective value with fixed lits ").append(this.fixedLiterals).toString());
            } else {
                this.fixedLiterals.push(this.bitsLiterals.get(litIndex--));
                System.out.println(new StringBuffer("c unsat. fixed lits ").append(this.fixedLiterals).toString());
            }
            nAssumpts.clear();
        }
        if (!$assertionsDisabled && this.fixedLiterals.size() != this.bitsLiterals.size()) {
            throw new AssertionError();
        }
        assumps.copyTo(nAssumpts);
        this.fixedLiterals.copyTo(nAssumpts);
        return this.gator.isSatisfiable(nAssumpts);
    }

    public static void main(String[] args) {
        PseudoBitsAdderDecorator decorator = new PseudoBitsAdderDecorator(SolverFactory.newDefault());
        decorator.setVerbose(false);
        OPBReader2007 reader = new OPBReader2007(decorator);
        long begin = System.currentTimeMillis();
        try {
            IProblem problem = reader.parseInstance(args[0]);
            if (problem.isSatisfiable()) {
                System.out.println("s OPTIMUM FOUND");
                System.out.println(new StringBuffer("v ").append(reader.decode(problem.model())).toString());
                if (decorator.objfct != null) {
                    System.out.println(new StringBuffer("c objective function=").append(decorator.objfct.calculateDegree(decorator.gator)).toString());
                }
            } else {
                System.out.println("s UNSAT");
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParseFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            System.out.println("s UNSAT");
            System.out.println("c trivial inconsistency");
        }
        catch (TimeoutException timeoutException) {
            System.out.println("s UNKNOWN");
        }
        long end = System.currentTimeMillis();
        System.out.println(new StringBuffer("c Total wall clock time: ").append((double)(end - begin) / 1000.0).append(" seconds").toString());
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt lits, IVec<BigInteger> coeffs, boolean moreThan, BigInteger d) throws ContradictionException {
        return this.solver.addPseudoBoolean(lits, coeffs, moreThan, d);
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.objfct;
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVecInt coeffs, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, IVec<BigInteger> coeffs, BigInteger degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVecInt coeffs, int weight) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addExactly(IVecInt literals, IVec<BigInteger> coeffs, BigInteger weight) throws ContradictionException {
        throw new UnsupportedOperationException();
    }
}

