/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.IPBConstructor;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MaxWatchPb;
import org.sat4j.pb.constraints.pb.MaxWatchPbLong;
import org.sat4j.specs.ContradictionException;

public class MaxLongWatchPBConstructor
implements IPBConstructor {
    public Constr constructLearntPB(ILits voc, IDataStructurePB dspb) {
        if (dspb.isLongSufficient()) {
            return MaxWatchPbLong.normalizedWatchPbNew(voc, dspb);
        }
        return MaxWatchPb.normalizedWatchPbNew(voc, dspb);
    }

    public Constr constructPB(UnitPropagationListener solver, ILits voc, int[] theLits, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        if (MaxLongWatchPBConstructor.isLongSufficient(coefs, degree)) {
            return MaxWatchPbLong.normalizedMaxWatchPbNew(solver, voc, theLits, coefs, degree);
        }
        return MaxWatchPb.normalizedMaxWatchPbNew(solver, voc, theLits, coefs, degree);
    }

    public static boolean isLongSufficient(BigInteger[] coefs, BigInteger degree) {
        BigInteger somCoefs = BigInteger.ZERO;
        int i = 0;
        while (somCoefs.bitLength() < 64 && i < coefs.length) {
            somCoefs = somCoefs.add(coefs[i]);
            ++i;
        }
        return somCoefs.bitLength() < 64;
    }
}

