/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPbLong;
import org.sat4j.specs.ContradictionException;

public class MinWatchPbLong
extends WatchPbLong {
    private static final long serialVersionUID = 1L;
    protected long watchCumul = 0L;
    protected boolean[] watched;
    protected int[] watching;
    protected int watchingCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.MinWatchPbLong");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected MinWatchPbLong(ILits voc, IDataStructurePB mpb) {
        super(mpb);
        this.voc = voc;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected MinWatchPbLong(ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree) {
        super(lits, coefs, degree);
        this.voc = voc;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected void computeWatches() throws ContradictionException {
        if (!$assertionsDisabled && this.watchCumul != 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchingCount != 0) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < this.lits.length && this.watchCumul - this.coefs[0] < this.degree) {
            if (!this.voc.isFalsified(this.lits[i])) {
                this.voc.watch(this.lits[i] ^ 1, this);
                this.watching[this.watchingCount++] = i;
                this.watched[i] = true;
                this.watchCumul += this.coefs[i];
            }
            ++i;
        }
        if (this.learnt) {
            this.watchMoreForLearntConstraint();
        }
        if (this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
    }

    private void watchMoreForLearntConstraint() {
        int free = 1;
        while (this.watchCumul - this.coefs[0] < this.degree && free > 0) {
            free = 0;
            int maxlevel = -1;
            int maxi = -1;
            int i = 0;
            while (i < this.lits.length) {
                if (this.voc.isFalsified(this.lits[i]) && !this.watched[i]) {
                    ++free;
                    int level = this.voc.getLevel(this.lits[i]);
                    if (level > maxlevel) {
                        maxi = i;
                        maxlevel = level;
                    }
                }
                ++i;
            }
            if (free <= 0) continue;
            if (!$assertionsDisabled && maxi < 0) {
                throw new AssertionError();
            }
            this.voc.watch(this.lits[maxi] ^ 1, this);
            this.watching[this.watchingCount++] = maxi;
            this.watched[maxi] = true;
            this.watchCumul += this.coefs[maxi];
            if (!$assertionsDisabled && --free < 0) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && this.lits.length != 1 && this.watchingCount <= 1) {
            throw new AssertionError();
        }
    }

    protected void computePropagation(UnitPropagationListener s) throws ContradictionException {
        int ind = 0;
        while (ind < this.lits.length && this.watchCumul - this.coefs[this.watching[ind]] < this.degree) {
            if (this.voc.isUnassigned(this.lits[ind]) && !s.enqueue(this.lits[ind], this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++ind;
        }
    }

    public static MinWatchPbLong normalizedMinWatchPbNew(UnitPropagationListener s, ILits voc, int[] lits, BigInteger[] coefs, BigInteger degree) throws ContradictionException {
        MinWatchPbLong outclause = new MinWatchPbLong(voc, lits, coefs, degree);
        if (outclause.degree <= 0L) {
            return null;
        }
        outclause.computeWatches();
        outclause.computePropagation(s);
        return outclause;
    }

    protected int nbOfWatched() {
        int retour = 0;
        int ind = 0;
        while (ind < this.watched.length) {
            int i = 0;
            while (i < this.watchingCount) {
                if (this.watching[i] == ind && !$assertionsDisabled && !this.watched[ind]) {
                    throw new AssertionError();
                }
                ++i;
            }
            retour += this.watched[ind] ? 1 : 0;
            ++ind;
        }
        return retour;
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchingCount <= 1) {
            throw new AssertionError();
        }
        int pIndiceWatching = 0;
        while (pIndiceWatching < this.watchingCount && (this.lits[this.watching[pIndiceWatching]] ^ 1) != p) {
            ++pIndiceWatching;
        }
        int pIndice = this.watching[pIndiceWatching];
        if (!$assertionsDisabled && p != (this.lits[pIndice] ^ 1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.watched[pIndice]) {
            throw new AssertionError();
        }
        long maxCoef = this.maximalCoefficient(pIndice);
        maxCoef = this.updateWatched(maxCoef, pIndice);
        long upWatchCumul = this.watchCumul - this.coefs[pIndice];
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        if (upWatchCumul < this.degree) {
            this.voc.watch(p, this);
            if (!$assertionsDisabled && !this.watched[pIndice]) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        if (upWatchCumul < this.degree + maxCoef) {
            if (!$assertionsDisabled && this.watchingCount == 0) {
                throw new AssertionError();
            }
            long limit = upWatchCumul - this.degree;
            int i = 0;
            while (i < this.watchingCount) {
                if (limit < this.coefs[this.watching[i]] && i != pIndiceWatching && !this.voc.isSatisfied(this.lits[this.watching[i]]) && !s.enqueue(this.lits[this.watching[i]], this)) {
                    this.voc.watch(p, this);
                    if (!$assertionsDisabled && this.isSatisfiable()) {
                        throw new AssertionError();
                    }
                    return false;
                }
                ++i;
            }
            this.voc.undos(p).push(this);
        }
        this.watched[pIndice] = false;
        this.watchCumul = upWatchCumul;
        this.watching[pIndiceWatching] = this.watching[--this.watchingCount];
        if (!$assertionsDisabled && this.watchingCount == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove(UnitPropagationListener upl) {
        int i = 0;
        while (i < this.watchingCount) {
            this.voc.watches(this.lits[this.watching[i]] ^ 1).remove(this);
            this.watched[this.watching[i]] = false;
            ++i;
        }
        this.watchingCount = 0;
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
    }

    public void undo(int p) {
        this.voc.watch(p, this);
        int pIndice = 0;
        while ((this.lits[pIndice] ^ 1) != p) {
            ++pIndice;
        }
        if (!$assertionsDisabled && pIndice >= this.lits.length) {
            throw new AssertionError();
        }
        this.watchCumul += this.coefs[pIndice];
        if (!$assertionsDisabled && this.watchingCount != this.nbOfWatched()) {
            throw new AssertionError();
        }
        this.watched[pIndice] = true;
        this.watching[this.watchingCount++] = pIndice;
        if (!$assertionsDisabled && this.watchingCount != this.nbOfWatched()) {
            throw new AssertionError();
        }
    }

    public static WatchPbLong normalizedWatchPbNew(ILits voc, IDataStructurePB mpb) {
        return new MinWatchPbLong(voc, mpb);
    }

    protected long maximalCoefficient(int pIndice) {
        long maxCoef = 0L;
        int i = 0;
        while (i < this.watchingCount) {
            if (this.coefs[this.watching[i]] > maxCoef && this.watching[i] != pIndice) {
                maxCoef = this.coefs[this.watching[i]];
            }
            ++i;
        }
        if (!$assertionsDisabled && !this.learnt && maxCoef == 0L) {
            throw new AssertionError();
        }
        return maxCoef;
    }

    protected long updateWatched(long mc, int pIndice) {
        long maxCoef = mc;
        if (this.watchingCount < this.size()) {
            long upWatchCumul = this.watchCumul - this.coefs[pIndice];
            long degreePlusMaxCoef = this.degree + maxCoef;
            int ind = 0;
            while (ind < this.lits.length) {
                if (upWatchCumul >= degreePlusMaxCoef) break;
                if (!this.voc.isFalsified(this.lits[ind]) && !this.watched[ind]) {
                    upWatchCumul += this.coefs[ind];
                    this.watched[ind] = true;
                    if (!$assertionsDisabled && this.watchingCount >= this.size()) {
                        throw new AssertionError();
                    }
                    this.watching[this.watchingCount++] = ind;
                    this.voc.watch(this.lits[ind] ^ 1, this);
                    if (this.coefs[ind] > maxCoef) {
                        maxCoef = this.coefs[ind];
                        degreePlusMaxCoef = this.degree + maxCoef;
                    }
                }
                ++ind;
            }
            this.watchCumul = upWatchCumul + this.coefs[pIndice];
        }
        return maxCoef;
    }
}

