/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;
import org.sat4j.tools.xplain.DeletionStrategy;
import org.sat4j.tools.xplain.Explainer;
import org.sat4j.tools.xplain.MinimizationStrategy;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighLevelXplain<T extends ISolver>
extends SolverDecorator<T>
implements Explainer {
    protected Map<Integer, Integer> constrs = new HashMap<Integer, Integer>();
    protected IVecInt assump;
    private int lastCreatedVar;
    private boolean pooledVarId = false;
    private MinimizationStrategy xplainStrategy = new DeletionStrategy();
    private final Map<Integer, Integer> highLevelToVar = new HashMap<Integer, Integer>();
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.tools.xplain.HighLevelXplain");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public HighLevelXplain(T solver) {
        super(solver);
    }

    public IConstr addClause(IVecInt literals, int desc) throws ContradictionException {
        if (desc == 0) {
            return this.addClause(literals);
        }
        Integer hlvar = this.highLevelToVar.get(new Integer(desc));
        if (hlvar == null) {
            hlvar = new Integer(this.createNewVar(literals));
            this.highLevelToVar.put(new Integer(desc), hlvar);
            this.constrs.put(hlvar, new Integer(desc));
        }
        literals.push(hlvar);
        IConstr constr = super.addClause(literals);
        return constr;
    }

    protected int createNewVar(IVecInt literals) {
        if (this.pooledVarId) {
            this.pooledVarId = false;
            return this.lastCreatedVar;
        }
        this.lastCreatedVar = this.nextFreeVarId(true);
        return this.lastCreatedVar;
    }

    protected void discardLastestVar() {
        this.pooledVarId = true;
    }

    @Override
    public IConstr addAtLeast(IVecInt literals, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstr addAtMost(IVecInt literals, int degree) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    private IVecInt explanationKeys() throws TimeoutException {
        if (!$assertionsDisabled && this.isSatisfiable(this.assump)) {
            throw new AssertionError();
        }
        Object solver = this.decorated();
        if (solver instanceof SolverDecorator) {
            solver = ((SolverDecorator)solver).decorated();
        }
        return this.xplainStrategy.explain((ISolver)solver, this.constrs, this.assump);
    }

    @Override
    public int[] minimalExplanation() throws TimeoutException {
        Collection<Integer> components = this.explain();
        int[] model = new int[components.size()];
        int i = 0;
        for (int c : components) {
            model[i++] = c;
        }
        Arrays.sort(model);
        return model;
    }

    public Collection<Integer> explain() throws TimeoutException {
        IVecInt keys = this.explanationKeys();
        HashSet<Integer> explanation = new HashSet<Integer>(keys.size());
        IteratorInt it = keys.iterator();
        while (it.hasNext()) {
            explanation.add(this.constrs.get(new Integer(it.next())));
        }
        return explanation;
    }

    public void cancelExplanation() {
        this.xplainStrategy.cancelExplanationComputation();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt extraVariables = new VecInt();
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.findModel(extraVariables);
    }

    @Override
    public int[] findModel(IVecInt assumps) throws TimeoutException {
        this.assump = assumps;
        VecInt extraVariables = new VecInt();
        assumps.copyTo(extraVariables);
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.findModel(extraVariables);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt extraVariables = new VecInt();
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.isSatisfiable(extraVariables);
    }

    @Override
    public boolean isSatisfiable(boolean global) throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt extraVariables = new VecInt();
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.isSatisfiable(extraVariables, global);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        this.assump = assumps;
        VecInt extraVariables = new VecInt();
        assumps.copyTo(extraVariables);
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.isSatisfiable(extraVariables);
    }

    @Override
    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        this.assump = assumps;
        VecInt extraVariables = new VecInt();
        assumps.copyTo(extraVariables);
        for (Integer p : this.constrs.keySet()) {
            extraVariables.push(-p.intValue());
        }
        return super.isSatisfiable(extraVariables, global);
    }

    @Override
    public int[] model() {
        int[] fullmodel = super.model();
        if (fullmodel == null) {
            return null;
        }
        int[] model = new int[fullmodel.length - this.constrs.size()];
        int j = 0;
        int i = 0;
        while (i < fullmodel.length) {
            if (this.constrs.get(new Integer(Math.abs(fullmodel[i]))) == null) {
                model[j++] = fullmodel[i];
            }
            ++i;
        }
        return model;
    }

    @Override
    public String toString(String prefix) {
        System.out.println(new StringBuffer(String.valueOf(prefix)).append("High Level Explanation (MUS) enabled solver").toString());
        System.out.println(new StringBuffer(String.valueOf(prefix)).append(this.xplainStrategy).toString());
        return super.toString(prefix);
    }

    @Override
    public void setMinimizationStrategy(MinimizationStrategy strategy) {
        this.xplainStrategy = strategy;
    }
}

